/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.client.metadata.MetadataResult;
import org.teiid.client.metadata.ResultsMetadataConstants;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.dqp.internal.process.ClientState;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.PreparedPlan;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.message.RequestID;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.symbol.WindowFunction;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ReferenceCollectorVisitor;
import org.teiid.query.tempdata.TempTableStore;

public class MetaDataProcessor {
    public static final String XML_COLUMN_NAME = "xml";
    private DQPCore requestManager;
    private QueryMetadataInterface metadata;
    private SessionAwareCache<PreparedPlan> planCache;
    private String vdbName;
    private String vdbVersion;
    private RequestID requestID;
    private boolean labelAsName;
    private boolean useJDBCDefaultPrecision = true;

    public MetaDataProcessor(DQPCore requestManager, SessionAwareCache<PreparedPlan> planCache, String vdbName, Object vdbVersion) {
        this.requestManager = requestManager;
        this.planCache = planCache;
        this.vdbName = vdbName;
        this.vdbVersion = vdbVersion.toString();
    }

    MetadataResult processMessage(RequestID requestId, DQPWorkContext workContext, String preparedSql, boolean allowDoubleQuotedVariable) throws TeiidComponentException, TeiidProcessingException {
        ClientState state;
        RequestWorkItem workItem;
        block5: {
            this.requestID = requestId;
            this.metadata = (QueryMetadataInterface)workContext.getVDB().getAttachment(QueryMetadataInterface.class);
            workItem = null;
            try {
                workItem = this.requestManager.getRequestWorkItem(this.requestID);
            }
            catch (TeiidProcessingException e) {
                if (preparedSql != null) break block5;
                throw e;
            }
        }
        TempTableStore tempTableStore = null;
        if (this.requestManager != null && (state = this.requestManager.getClientState(workContext.getSessionId(), false)) != null) {
            tempTableStore = state.sessionTables;
        }
        if (tempTableStore != null) {
            this.metadata = new TempMetadataAdapter(this.metadata, tempTableStore.getMetadataStore());
        }
        if (workItem != null) {
            return this.getMetadataForCommand(workItem.getOriginalCommand());
        }
        return this.obtainMetadataForPreparedSql(preparedSql, workContext, allowDoubleQuotedVariable);
    }

    private MetadataResult getMetadataForCommand(Command originalCommand) throws TeiidComponentException {
        Map[] columnMetadata = null;
        switch (originalCommand.getType()) {
            case 1: {
                if (originalCommand instanceof Query) {
                    if (((Query)originalCommand).getInto() != null) break;
                    columnMetadata = this.createProjectedSymbolMetadata(originalCommand);
                    break;
                }
                columnMetadata = this.createProjectedSymbolMetadata(originalCommand);
                break;
            }
            case 6: {
                columnMetadata = this.createProjectedSymbolMetadata(originalCommand);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 12: {
                break;
            }
            default: {
                if (!originalCommand.returnsResultSet()) break;
                columnMetadata = this.createProjectedSymbolMetadata(originalCommand);
            }
        }
        Map<Reference, String> paramMap = Collections.emptyMap();
        if (originalCommand instanceof StoredProcedure) {
            StoredProcedure sp = (StoredProcedure)originalCommand;
            paramMap = new HashMap();
            Collection<SPParameter> params = sp.getParameters();
            for (SPParameter spParameter : params) {
                if (spParameter.getParameterType() != 3 && spParameter.getParameterType() != 1 && spParameter.getParameterType() != 4) continue;
                Expression ex = spParameter.getExpression();
                if (ex instanceof Function && FunctionLibrary.isConvert((Function)ex)) {
                    ex = ((Function)ex).getArg(0);
                }
                if (!(ex instanceof Reference)) continue;
                paramMap.put((Reference)ex, spParameter.getParameterSymbol().getShortName());
            }
        }
        List<Reference> params = ReferenceCollectorVisitor.getReferences(originalCommand);
        Map[] paramMetadata = new Map[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            Reference param = params.get(i);
            paramMetadata[i] = this.getDefaultColumn(null, (String)paramMap.get(param), param.getType());
        }
        return new MetadataResult(columnMetadata, paramMetadata);
    }

    public static void updateMetadataAcrossBranches(SetQuery originalCommand, List<Column> columns, QueryMetadataInterface metadata) throws TeiidComponentException {
        String empty = "";
        MetaDataProcessor mdp = new MetaDataProcessor(null, null, empty, empty);
        mdp.metadata = metadata;
        mdp.useJDBCDefaultPrecision = false;
        Map<Integer, Object>[] metadataMaps = mdp.createProjectedSymbolMetadata(originalCommand);
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            Map<Integer, Object> metadataMap = metadataMaps[i];
            Integer val = (Integer)metadataMap.get(ResultsMetadataConstants.PRECISION);
            if (val != null) {
                column.setPrecision(val.intValue());
                column.setLength(val.intValue());
            }
            if ((val = (Integer)metadataMap.get(ResultsMetadataConstants.SCALE)) == null) continue;
            column.setScale(val.intValue());
        }
    }

    private Map<Integer, Object>[] createProjectedSymbolMetadata(Command originalCommand) throws TeiidComponentException {
        TempMetadataStore tempMetadata = originalCommand.getTemporaryMetadata();
        if (tempMetadata != null && tempMetadata.getData().size() > 0) {
            TempMetadataAdapter tempFacade = new TempMetadataAdapter(this.metadata, tempMetadata);
            this.metadata = tempFacade;
        }
        List<Expression> projectedSymbols = originalCommand.getProjectedSymbols();
        Map[] columnMetadata = new Map[projectedSymbols.size()];
        Iterator<Expression> symbolIter = projectedSymbols.iterator();
        int i = 0;
        while (symbolIter.hasNext()) {
            Expression symbol = symbolIter.next();
            String shortColumnName = Symbol.getShortName(Symbol.getOutputName(symbol));
            symbol = SymbolMap.getExpression(symbol);
            try {
                columnMetadata[i] = this.createColumnMetadata(shortColumnName, symbol);
            }
            catch (QueryMetadataException e) {
                throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30559, (Throwable)((Object)e));
            }
            ++i;
        }
        if (originalCommand instanceof SetQuery) {
            SetQuery setQuery = (SetQuery)originalCommand;
            if (!(setQuery.getLeftQuery() instanceof Query)) {
                Map<Integer, Object>[] leftResult = this.createProjectedSymbolMetadata(setQuery.getLeftQuery());
                for (int i2 = 0; i2 < leftResult.length; ++i2) {
                    this.setCombinedMax(columnMetadata, leftResult, i2, ResultsMetadataConstants.PRECISION);
                    this.setCombinedMax(columnMetadata, leftResult, i2, ResultsMetadataConstants.SCALE);
                }
            }
            if (setQuery.getOperation() == SetQuery.Operation.UNION) {
                Map<Integer, Object>[] rightResult = this.createProjectedSymbolMetadata(setQuery.getRightQuery());
                for (int i3 = 0; i3 < rightResult.length; ++i3) {
                    this.setCombinedMax(columnMetadata, rightResult, i3, ResultsMetadataConstants.PRECISION);
                    this.setCombinedMax(columnMetadata, rightResult, i3, ResultsMetadataConstants.SCALE);
                }
            }
            return columnMetadata;
        }
        return columnMetadata;
    }

    private void setCombinedMax(Map<Integer, Object>[] leftResult, Map<Integer, Object>[] rightResult, int i, int key) {
        Integer lval = (Integer)leftResult[i].get(key);
        Integer rval = (Integer)rightResult[i].get(key);
        if (lval != null && rval != null) {
            leftResult[i].put(key, Math.max(lval, rval));
        }
    }

    private MetadataResult obtainMetadataForPreparedSql(String sql, DQPWorkContext workContext, boolean isDoubleQuotedVariablesAllowed) throws QueryParserException, QueryResolverException, TeiidComponentException {
        Command command = null;
        ParseInfo info = new ParseInfo();
        info.ansiQuotedIdentifiers = isDoubleQuotedVariablesAllowed;
        SessionAwareCache.CacheID id = new SessionAwareCache.CacheID(workContext, info, sql);
        PreparedPlan plan = this.planCache.get(id);
        if (plan != null) {
            command = plan.getCommand();
        } else {
            command = QueryParser.getQueryParser().parseCommand(sql, info);
            QueryResolver.resolveCommand(command, this.metadata);
        }
        return this.getMetadataForCommand(command);
    }

    public static void setColumnMetadata(Column column, Expression symbol, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        String empty = "";
        MetaDataProcessor mdp = new MetaDataProcessor(null, null, empty, empty);
        mdp.metadata = metadata;
        mdp.useJDBCDefaultPrecision = false;
        Map<Integer, Object> metadataMap = mdp.createColumnMetadata(empty, symbol);
        column.setCaseSensitive(Boolean.TRUE.equals(metadataMap.get(ResultsMetadataConstants.CASE_SENSITIVE)));
        column.setCurrency(Boolean.TRUE.equals(metadataMap.get(ResultsMetadataConstants.CURRENCY)));
        Object nullable = metadataMap.get(ResultsMetadataConstants.NULLABLE);
        if (nullable == ResultsMetadataConstants.NULL_TYPES.NOT_NULL) {
            column.setNullType(BaseColumn.NullType.No_Nulls);
        } else if (nullable == ResultsMetadataConstants.NULL_TYPES.NULLABLE) {
            column.setNullType(BaseColumn.NullType.Nullable);
        }
        Integer val = (Integer)metadataMap.get(ResultsMetadataConstants.PRECISION);
        if (val != null) {
            column.setPrecision(val.intValue());
            column.setLength(val.intValue());
        }
        if ((val = (Integer)metadataMap.get(ResultsMetadataConstants.RADIX)) != null) {
            column.setRadix(val.intValue());
        }
        if ((val = (Integer)metadataMap.get(ResultsMetadataConstants.SCALE)) != null) {
            column.setScale(val.intValue());
        }
        column.setSigned(Boolean.TRUE.equals(metadataMap.get(ResultsMetadataConstants.SIGNED)));
    }

    private Map<Integer, Object> createColumnMetadata(String label, Expression symbol) throws QueryMetadataException, TeiidComponentException {
        if (symbol instanceof ElementSymbol) {
            return this.createElementMetadata(label, (ElementSymbol)symbol);
        }
        if ((symbol = SymbolMap.getExpression(symbol)) instanceof AggregateSymbol) {
            return this.createAggregateMetadata(label, (AggregateSymbol)symbol);
        }
        if (symbol instanceof WindowFunction) {
            return this.createAggregateMetadata(label, ((WindowFunction)symbol).getFunction());
        }
        return this.createTypedMetadata(label, symbol);
    }

    private Map<Integer, Object> createElementMetadata(String label, ElementSymbol symbol) throws QueryMetadataException, TeiidComponentException {
        Object elementID = symbol.getMetadataID();
        HashMap<Integer, Object> column = new HashMap<Integer, Object>();
        column.put(ResultsMetadataConstants.AUTO_INCREMENTING, this.metadata.elementSupports(elementID, 8));
        column.put(ResultsMetadataConstants.CASE_SENSITIVE, this.metadata.elementSupports(elementID, 9));
        column.put(ResultsMetadataConstants.CURRENCY, Boolean.FALSE);
        Class<?> type = symbol.getType();
        column.put(ResultsMetadataConstants.DATA_TYPE, DataTypeManager.getDataTypeName(type));
        column.put(ResultsMetadataConstants.ELEMENT_LABEL, label);
        column.put(ResultsMetadataConstants.ELEMENT_NAME, this.labelAsName ? label : this.metadata.getName(elementID));
        GroupSymbol group = symbol.getGroupSymbol();
        if (group == null || group.getMetadataID() == null) {
            column.put(ResultsMetadataConstants.GROUP_NAME, null);
        } else {
            column.put(ResultsMetadataConstants.GROUP_NAME, this.metadata.getFullName(group.getMetadataID()));
        }
        boolean allowsNull = this.metadata.elementSupports(elementID, 4);
        boolean unknown = this.metadata.elementSupports(elementID, 10);
        Integer nullable = null;
        nullable = unknown ? ResultsMetadataConstants.NULL_TYPES.UNKNOWN : (allowsNull ? ResultsMetadataConstants.NULL_TYPES.NULLABLE : ResultsMetadataConstants.NULL_TYPES.NOT_NULL);
        column.put(ResultsMetadataConstants.NULLABLE, nullable);
        column.put(ResultsMetadataConstants.RADIX, new Integer(this.metadata.getRadix(elementID)));
        column.put(ResultsMetadataConstants.SCALE, new Integer(this.metadata.getScale(elementID)));
        int precision = this.getColumnPrecision(type, elementID);
        column.put(ResultsMetadataConstants.PRECISION, new Integer(precision));
        column.put(ResultsMetadataConstants.DISPLAY_SIZE, this.getColumnDisplaySize(precision, type, elementID));
        boolean comparable = this.metadata.elementSupports(elementID, 2);
        boolean likable = this.metadata.elementSupports(elementID, 1);
        Integer searchable = null;
        searchable = comparable ? (likable ? ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE : ResultsMetadataConstants.SEARCH_TYPES.ALLEXCEPTLIKE) : (likable ? ResultsMetadataConstants.SEARCH_TYPES.LIKE_ONLY : ResultsMetadataConstants.SEARCH_TYPES.UNSEARCHABLE);
        column.put(ResultsMetadataConstants.SEARCHABLE, searchable);
        column.put(ResultsMetadataConstants.SIGNED, this.metadata.elementSupports(elementID, 11));
        column.put(ResultsMetadataConstants.VIRTUAL_DATABASE_NAME, this.vdbName);
        column.put(ResultsMetadataConstants.VIRTUAL_DATABASE_VERSION, this.vdbVersion);
        column.put(ResultsMetadataConstants.WRITABLE, new Boolean(this.metadata.elementSupports(elementID, 5)));
        return column;
    }

    private Map<Integer, Object> createAggregateMetadata(String shortColumnName, AggregateSymbol symbol) throws QueryMetadataException, TeiidComponentException {
        Expression expression;
        AggregateSymbol.Type function = symbol.getAggregateFunction();
        if ((function == AggregateSymbol.Type.MIN || function == AggregateSymbol.Type.MAX) && (expression = symbol.getArg(0)) instanceof ElementSymbol) {
            return this.createColumnMetadata(shortColumnName, expression);
        }
        return this.createTypedMetadata(shortColumnName, symbol);
    }

    private Map<Integer, Object> createTypedMetadata(String shortColumnName, Expression symbol) {
        Map<Integer, Object> result = this.getDefaultColumn(null, shortColumnName, symbol.getType());
        if (symbol instanceof Constant) {
            Constant c = (Constant)symbol;
            Object value = c.getValue();
            if (value instanceof String) {
                int length = ((String)value).length();
                result.put(ResultsMetadataConstants.PRECISION, length);
                result.put(ResultsMetadataConstants.DISPLAY_SIZE, length);
            } else if (value instanceof byte[]) {
                int length = ((byte[])value).length;
                result.put(ResultsMetadataConstants.PRECISION, length);
            } else if (value instanceof BigDecimal) {
                BigDecimal val = (BigDecimal)value;
                result.put(ResultsMetadataConstants.PRECISION, val.precision());
                result.put(ResultsMetadataConstants.DISPLAY_SIZE, val.precision() + 1);
                result.put(ResultsMetadataConstants.SCALE, val.scale());
            } else if (value instanceof BigInteger) {
                BigInteger val = (BigInteger)value;
                int precision = new BigDecimal(val).precision();
                result.put(ResultsMetadataConstants.PRECISION, precision);
                result.put(ResultsMetadataConstants.DISPLAY_SIZE, precision + 1);
            } else if (value == null && symbol.getType() == DataTypeManager.DefaultDataClasses.STRING) {
                result.put(ResultsMetadataConstants.PRECISION, 1);
                result.put(ResultsMetadataConstants.DISPLAY_SIZE, 1);
            }
        }
        return result;
    }

    private int getColumnPrecision(Class<?> dataType, Object elementID) throws QueryMetadataException, TeiidComponentException {
        if (!Number.class.isAssignableFrom(dataType)) {
            int length = this.metadata.getElementLength(elementID);
            if (length > 0) {
                return length;
            }
        } else {
            int precision = this.metadata.getPrecision(elementID);
            if (precision > 0) {
                return precision;
            }
        }
        if (this.useJDBCDefaultPrecision) {
            return JDBCSQLTypeInfo.getDefaultPrecision(dataType);
        }
        return 0;
    }

    private Integer getColumnDisplaySize(int precision, Class<?> dataType, Object elementID) throws QueryMetadataException, TeiidComponentException {
        int length;
        if (elementID != null && dataType.equals(DataTypeManager.DefaultDataClasses.STRING)) {
            int length2 = this.metadata.getElementLength(elementID);
            if (length2 > 0) {
                return new Integer(length2);
            }
        } else if (Number.class.isAssignableFrom(dataType)) {
            if (precision > 0) {
                int displayLength = precision;
                displayLength = precision + 1;
                if (dataType.equals(DataTypeManager.DefaultDataClasses.FLOAT) || dataType.equals(DataTypeManager.DefaultDataClasses.DOUBLE) || dataType.equals(DataTypeManager.DefaultDataClasses.BIG_DECIMAL)) {
                    ++displayLength;
                }
                return new Integer(displayLength);
            }
        } else if (elementID != null && (dataType.equals(DataTypeManager.DefaultDataClasses.CLOB) || dataType.equals(DataTypeManager.DefaultDataClasses.BLOB) || dataType.equals(DataTypeManager.DefaultDataClasses.OBJECT)) && (length = this.metadata.getElementLength(elementID)) > 0) {
            return new Integer(length);
        }
        return JDBCSQLTypeInfo.getMaxDisplaySize(dataType);
    }

    public Map<Integer, Object> getDefaultColumn(String tableName, String columnName, Class<?> javaType) {
        return this.getDefaultColumn(tableName, columnName, columnName, javaType);
    }

    public Map<Integer, Object> getDefaultColumn(String tableName, String columnName, String columnLabel, Class<?> javaType) {
        HashMap<Integer, Object> column = new HashMap<Integer, Object>();
        column.put(ResultsMetadataConstants.VIRTUAL_DATABASE_NAME, this.vdbName);
        column.put(ResultsMetadataConstants.VIRTUAL_DATABASE_VERSION, this.vdbVersion);
        column.put(ResultsMetadataConstants.GROUP_NAME, tableName);
        column.put(ResultsMetadataConstants.ELEMENT_NAME, this.labelAsName ? columnLabel : columnName);
        column.put(ResultsMetadataConstants.ELEMENT_LABEL, columnLabel);
        column.put(ResultsMetadataConstants.AUTO_INCREMENTING, Boolean.FALSE);
        column.put(ResultsMetadataConstants.CASE_SENSITIVE, Boolean.TRUE);
        column.put(ResultsMetadataConstants.NULLABLE, ResultsMetadataConstants.NULL_TYPES.NULLABLE);
        column.put(ResultsMetadataConstants.SEARCHABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE);
        column.put(ResultsMetadataConstants.WRITABLE, Boolean.TRUE);
        column.put(ResultsMetadataConstants.CURRENCY, Boolean.FALSE);
        column.put(ResultsMetadataConstants.DATA_TYPE, DataTypeManager.getDataTypeName(javaType));
        column.put(ResultsMetadataConstants.RADIX, JDBCSQLTypeInfo.DEFAULT_RADIX);
        column.put(ResultsMetadataConstants.SIGNED, Boolean.TRUE);
        if (this.useJDBCDefaultPrecision) {
            column.put(ResultsMetadataConstants.PRECISION, JDBCSQLTypeInfo.getDefaultPrecision(javaType));
            column.put(ResultsMetadataConstants.SCALE, JDBCSQLTypeInfo.DEFAULT_SCALE);
        }
        column.put(ResultsMetadataConstants.DISPLAY_SIZE, JDBCSQLTypeInfo.getMaxDisplaySize(javaType));
        return column;
    }
}

