/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.teiid.CommandContext;
import org.teiid.UserDefinedAggregate;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.logging.LogManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.MetadataException;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.UDFSource;
import org.teiid.query.parser.SQLParserUtil;

public class FunctionTree {
    private static final Integer DESCRIPTOR_KEY = -1;
    private Map<String, Set<FunctionMethod>> categories = new TreeMap<String, Set<FunctionMethod>>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, List<FunctionMethod>> functionsByName = new TreeMap<String, List<FunctionMethod>>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, FunctionMethod> functionsByUuid = new TreeMap<String, FunctionMethod>(String.CASE_INSENSITIVE_ORDER);
    private String schemaName;
    private Set<FunctionMethod> allFunctions = new HashSet<FunctionMethod>();
    private int idCount;
    private Map<String, Map<Object, Object>> treeRoot = new TreeMap<String, Map<Object, Object>>(String.CASE_INSENSITIVE_ORDER);
    private boolean validateClass;

    public FunctionTree(String name, FunctionMetadataSource source) {
        this(name, source, false);
    }

    public FunctionTree(String name, FunctionMetadataSource source, boolean validateClass) {
        this.schemaName = name;
        this.validateClass = validateClass;
        boolean system = "SYS".equalsIgnoreCase(name) || "SYSADMIN".equalsIgnoreCase(name);
        Collection<FunctionMethod> functions = source.getFunctionMethods();
        for (FunctionMethod method : functions) {
            if (!this.containsIndistinguishableFunction(method)) {
                this.addFunction(name, source, method, system);
                continue;
            }
            if ("SYS".equalsIgnoreCase(name)) continue;
            LogManager.logWarning((String)"org.teiid.PLANNER.FUNCTION_TREE", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30011, new Object[]{method}));
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Map<String, FunctionMethod> getFunctionsByUuid() {
        return this.functionsByUuid;
    }

    private boolean containsIndistinguishableFunction(FunctionMethod method) {
        return this.allFunctions.contains(method);
    }

    Collection<String> getCategories() {
        return this.categories.keySet();
    }

    Set<FunctionMethod> getFunctionsInCategory(String name) {
        Set<FunctionMethod> names = this.categories.get(name);
        if (names == null) {
            return Collections.emptySet();
        }
        return names;
    }

    List<FunctionMethod> findFunctionMethods(String name, int args) {
        ArrayList<FunctionMethod> allMatches = new ArrayList<FunctionMethod>();
        List<FunctionMethod> methods = this.functionsByName.get(name);
        if (methods == null || methods.size() == 0) {
            return allMatches;
        }
        for (FunctionMethod functionMethod : methods) {
            if (functionMethod.getInputParameterCount() != args && (!functionMethod.isVarArgs() || args < functionMethod.getInputParameterCount() - 1)) continue;
            allMatches.add(functionMethod);
        }
        return allMatches;
    }

    public FunctionDescriptor addFunction(String schema, FunctionMetadataSource source, FunctionMethod method, boolean system) {
        String categoryKey = method.getCategory();
        if (categoryKey == null) {
            method.setCategory("Miscellaneous");
            categoryKey = "Miscellaneous";
        }
        this.setUuid((AbstractMetadataRecord)method);
        Set<FunctionMethod> functions = this.categories.get(categoryKey);
        if (functions == null) {
            functions = new HashSet<FunctionMethod>();
            this.categories.put(categoryKey, functions);
        }
        String methodName = schema + '.' + method.getName();
        List inputParams = method.getInputParameters();
        Class[] types = null;
        if (inputParams != null) {
            types = new Class[inputParams.size()];
            for (int i = 0; i < inputParams.size(); ++i) {
                Class clazz;
                String typeName = ((FunctionParameter)inputParams.get(i)).getRuntimeType();
                types[i] = clazz = DataTypeManager.getDataTypeClass((String)typeName);
                this.setUuid((AbstractMetadataRecord)inputParams.get(i));
            }
        } else {
            types = new Class[]{};
        }
        this.setUuid((AbstractMetadataRecord)method.getOutputParameter());
        FunctionDescriptor descriptor = this.createFunctionDescriptor(source, method, types, system);
        descriptor.setSchema(schema);
        functions.add(method);
        this.functionsByUuid.put(method.getUUID(), method);
        while (true) {
            List<FunctionMethod> knownMethods;
            if ((knownMethods = this.functionsByName.get(methodName)) == null) {
                knownMethods = new ArrayList<FunctionMethod>();
                this.functionsByName.put(methodName, knownMethods);
            }
            knownMethods.add(method);
            Map<Object, Object> node = this.treeRoot.get(methodName);
            if (node == null) {
                node = new HashMap<Object, Object>(2);
                this.treeRoot.put(methodName, node);
            }
            for (int pathIndex = 0; pathIndex < types.length; ++pathIndex) {
                Class pathPart = types[pathIndex];
                HashMap<Object, Object> children = (HashMap<Object, Object>)node.get(pathPart);
                if (children == null) {
                    children = new HashMap<Object, Object>(2);
                    node.put(pathPart, children);
                }
                if (method.isVarArgs() && pathIndex == types.length - 1) {
                    node.put(DESCRIPTOR_KEY, descriptor);
                    HashMap<Integer, FunctionDescriptor> alternate = new HashMap<Integer, FunctionDescriptor>(2);
                    alternate.put(DESCRIPTOR_KEY, descriptor);
                    node.put(DataTypeManager.getArrayType((Class)pathPart), alternate);
                }
                node = children;
            }
            if (method.isVarArgs()) {
                node.put(types[types.length - 1], node);
            }
            node.put(DESCRIPTOR_KEY, descriptor);
            int index = methodName.indexOf(46);
            if (index == -1) break;
            methodName = methodName.substring(index + 1);
        }
        this.allFunctions.add(method);
        return descriptor;
    }

    private void setUuid(AbstractMetadataRecord method) {
        if (!method.isUUIDSet()) {
            int lsb = 0;
            lsb = method.getParent() != null ? method.getParent().getUUID().hashCode() : "SYS".hashCode();
            lsb = 31 * lsb + method.getName().hashCode();
            String uuid = "tsid:" + MetadataFactory.hex((long)lsb, (int)16) + "-" + MetadataFactory.hex((long)this.idCount++, (int)8);
            method.setUUID(uuid);
        }
    }

    private FunctionDescriptor createFunctionDescriptor(FunctionMetadataSource source, FunctionMethod method, Class<?>[] types, boolean system) {
        FunctionParameter outputParam = method.getOutputParameter();
        Class outputType = null;
        if (outputParam != null) {
            outputType = DataTypeManager.getDataTypeClass((String)outputParam.getRuntimeType());
        }
        ArrayList inputTypes = new ArrayList(Arrays.asList(types));
        boolean hasWrappedArg = false;
        if (!system) {
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != DataTypeManager.DefaultDataClasses.VARBINARY) continue;
                hasWrappedArg = true;
                inputTypes.set(i, byte[].class);
            }
        }
        if (method.isVarArgs()) {
            inputTypes.set(inputTypes.size() - 1, DataTypeManager.getArrayType((Class)((Class)inputTypes.get(inputTypes.size() - 1))));
        }
        Method invocationMethod = method.getMethod();
        boolean requiresContext = false;
        if (this.validateClass && (method.getPushdown() == FunctionMethod.PushDown.CAN_PUSHDOWN || method.getPushdown() == FunctionMethod.PushDown.CANNOT_PUSHDOWN)) {
            if (invocationMethod == null) {
                if (method.getInvocationClass() == null || method.getInvocationMethod() == null) {
                    throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31123, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31123, new Object[]{method.getName()}));
                }
                try {
                    Class<?> methodClass = source.getInvocationClass(method.getInvocationClass());
                    ReflectionHelper helper = new ReflectionHelper(methodClass);
                    try {
                        invocationMethod = helper.findBestMethodWithSignature(method.getInvocationMethod(), inputTypes);
                    }
                    catch (NoSuchMethodException e) {
                        inputTypes.add(0, org.teiid.query.util.CommandContext.class);
                        invocationMethod = helper.findBestMethodWithSignature(method.getInvocationMethod(), inputTypes);
                        requiresContext = true;
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID30387, (Throwable)e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30387, new Object[]{method.getName(), method.getInvocationClass()}));
                }
                catch (NoSuchMethodException e) {
                    throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID30388, (Throwable)e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30388, new Object[]{method, method.getInvocationClass(), method.getInvocationMethod()}));
                }
                catch (Exception e) {
                    throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID30389, (Throwable)e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30389, new Object[]{method, method.getInvocationClass(), method.getInvocationMethod()}));
                }
            } else {
                boolean bl = requiresContext = invocationMethod.getParameterTypes().length > 0 && CommandContext.class.isAssignableFrom(invocationMethod.getParameterTypes()[0]);
            }
            if (invocationMethod != null) {
                Class<?> methodReturn = invocationMethod.getReturnType();
                if (method.getAggregateAttributes() == null && methodReturn.equals(Void.TYPE)) {
                    throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID30390, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30390, new Object[]{method.getName(), invocationMethod}));
                }
                int modifiers = invocationMethod.getModifiers();
                if (!Modifier.isPublic(modifiers)) {
                    throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID30391, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30391, new Object[]{method.getName(), invocationMethod}));
                }
                if (!Modifier.isStatic(modifiers)) {
                    if (method.getAggregateAttributes() == null) {
                        throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID30392, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30392, new Object[]{method.getName(), invocationMethod}));
                    }
                } else if (method.getAggregateAttributes() != null) {
                    throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID30600, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30600, new Object[]{method.getName(), invocationMethod}));
                }
                if (method.getAggregateAttributes() != null && !UserDefinedAggregate.class.isAssignableFrom(invocationMethod.getDeclaringClass())) {
                    throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID30601, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30601, new Object[]{method.getName(), method.getInvocationClass(), UserDefinedAggregate.class.getName()}));
                }
                try {
                    invocationMethod.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                method.setMethod(invocationMethod);
            }
        }
        FunctionDescriptor result = new FunctionDescriptor(method, types, outputType, invocationMethod, requiresContext, source.getClassLoader());
        if (this.validateClass && method.getAggregateAttributes() != null && (method.getPushdown() == FunctionMethod.PushDown.CAN_PUSHDOWN || method.getPushdown() == FunctionMethod.PushDown.CANNOT_PUSHDOWN)) {
            try {
                result.newInstance();
            }
            catch (FunctionExecutionException e) {
                throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID30387, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30387, new Object[]{method.getName(), method.getInvocationClass()}));
            }
        }
        result.setHasWrappedArgs(hasWrappedArg);
        return result;
    }

    FunctionDescriptor getFunction(String name, Class<?>[] argTypes) {
        Map node = this.treeRoot.get(name);
        if (node == null) {
            return null;
        }
        for (int i = 0; i < argTypes.length; ++i) {
            Map nextNode = (Map)node.get(argTypes[i]);
            if (nextNode == null) {
                if (argTypes[i].isArray()) {
                    nextNode = (Map)node.get(DataTypeManager.DefaultDataClasses.OBJECT);
                }
                if (nextNode == null) {
                    return null;
                }
            }
            node = nextNode;
        }
        if (node.containsKey(DESCRIPTOR_KEY)) {
            return (FunctionDescriptor)node.get(DESCRIPTOR_KEY);
        }
        return null;
    }

    public static FunctionTree getFunctionProcedures(Schema schema) {
        UDFSource dummySource = new UDFSource(Collections.EMPTY_LIST);
        FunctionTree ft = null;
        for (Procedure p : schema.getProcedures().values()) {
            if (!p.isFunction() || p.getQueryPlan() == null) continue;
            if (ft == null) {
                ft = new FunctionTree(schema.getName(), dummySource, false);
            }
            FunctionMethod fm = SQLParserUtil.createFunctionMethod(p);
            FunctionDescriptor fd = ft.addFunction(schema.getName(), dummySource, fm, false);
            fd.setProcedure(p);
        }
        return ft;
    }

    public boolean hasFunctionWithName(String name) {
        return this.functionsByName.containsKey(name);
    }
}

