/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Stack;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.FileStoreInputStreamFactory;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.BaseClobType;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.JsonType;
import org.teiid.core.types.Streamable;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.json.simple.ContentHandler;
import org.teiid.json.simple.JSONParser;
import org.teiid.json.simple.ParseException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.TeiidFunction;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.util.CommandContext;

public class JSONFunctionMethods {
    private static final ContentHandler validatingContentHandler = new ContentHandler(){

        @Override
        public boolean startObjectEntry(String key) throws ParseException, IOException {
            return true;
        }

        @Override
        public boolean startObject() throws ParseException, IOException {
            return true;
        }

        @Override
        public void startJSON() throws ParseException, IOException {
        }

        @Override
        public boolean startArray() throws ParseException, IOException {
            return true;
        }

        @Override
        public boolean primitive(Object value) throws ParseException, IOException {
            return true;
        }

        @Override
        public boolean endObjectEntry() throws ParseException, IOException {
            return true;
        }

        @Override
        public boolean endObject() throws ParseException, IOException {
            return true;
        }

        @Override
        public void endJSON() throws ParseException, IOException {
        }

        @Override
        public boolean endArray() throws ParseException, IOException {
            return true;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TeiidFunction(category="JSON")
    public static JsonType jsonParse(ClobType val, boolean wellformed) throws SQLException, IOException, ParseException {
        Reader r = null;
        if (val.getType() == ClobType.Type.JSON) {
            return new JsonType((Clob)val.getReference());
        }
        if (!wellformed) {
            r = val.getCharacterStream();
        }
        try {
            if (!wellformed) {
                JSONParser parser = new JSONParser();
                parser.parse(r, validatingContentHandler);
            }
            JsonType jsonType = new JsonType((Clob)val.getReference());
            return jsonType;
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TeiidFunction(category="JSON")
    public static JsonType jsonParse(BlobType val, boolean wellformed) throws SQLException, IOException, ParseException {
        try (InputStreamReader r = XMLSystemFunctions.getJsonReader((Blob)val);){
            if (!wellformed) {
                JSONParser parser = new JSONParser();
                parser.parse(r, validatingContentHandler);
            }
            ClobImpl clobImpl = new ClobImpl();
            clobImpl.setStreamFactory((InputStreamFactory)new InputStreamFactory.BlobInputStreamFactory((Blob)val.getReference()));
            clobImpl.setEncoding(r.getEncoding());
            JsonType jsonType = new JsonType((Clob)clobImpl);
            return jsonType;
        }
    }

    @TeiidFunction(category="JSON")
    public static JsonType jsonArray(CommandContext context, Object ... vals) throws TeiidProcessingException, BlockedException, TeiidComponentException {
        if (vals == null) {
            return null;
        }
        return Evaluator.jsonArray(context, null, vals, null, null, null);
    }

    public static class JSONBuilder {
        private Writer writer;
        private FileStoreInputStreamFactory fsisf;
        private FileStore fs;
        private Stack<Integer> position = new Stack();

        public JSONBuilder(BufferManager bm) {
            this.fs = bm.createFileStore("json");
            this.fsisf = new FileStoreInputStreamFactory(this.fs, "UTF-8");
            this.writer = this.fsisf.getWriter();
        }

        public void start(boolean array) throws TeiidProcessingException {
            this.position.push(0);
            try {
                if (array) {
                    this.writer.append('[');
                } else {
                    this.writer.append('{');
                }
            }
            catch (IOException e) {
                this.remove();
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30438, (Throwable)e);
            }
        }

        public void addValue(Object object) throws TeiidProcessingException {
            this.addValue(null, object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addValue(String key, Object object) throws TeiidProcessingException {
            block13: {
                try {
                    this.startValue(key);
                    if (object == null) {
                        this.writer.append("null");
                        break block13;
                    }
                    if (object instanceof BaseClobType) {
                        if (object instanceof JsonType) {
                            try (Reader r = ((JsonType)object).getCharacterStream();){
                                ObjectConverterUtil.write((Writer)this.writer, (Reader)r, (int)-1, (boolean)false);
                                break block13;
                            }
                        }
                        ClobType clob = (ClobType)object;
                        this.writer.append('\"');
                        JSONParser.escape(clob.getCharSequence(), this.writer);
                        this.writer.append('\"');
                        break block13;
                    }
                    if (object instanceof Boolean) {
                        this.writer.append(object.toString());
                    } else if (object instanceof Number) {
                        this.writer.write(object.toString());
                    } else {
                        this.writer.append('\"');
                        String text = (String)DataTypeManager.transformValue((Object)object, (Class)DataTypeManager.DefaultDataClasses.STRING);
                        JSONParser.escape(text, this.writer);
                        this.writer.append('\"');
                    }
                }
                catch (IOException e) {
                    this.remove();
                    throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30438, (Throwable)e);
                }
                catch (SQLException e) {
                    this.remove();
                    throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30438, (Throwable)e);
                }
            }
        }

        public void startValue(String key) throws TeiidProcessingException {
            try {
                if (this.position.peek() != 0) {
                    this.writer.append(',');
                }
                this.position.add(this.position.pop() + 1);
                if (key != null) {
                    this.writer.append('\"');
                    JSONParser.escape(key, this.writer);
                    this.writer.append('\"');
                    this.writer.append(":");
                }
            }
            catch (IOException e) {
                this.remove();
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30438, (Throwable)e);
            }
        }

        public Writer getWriter() {
            return this.writer;
        }

        public JsonType close(CommandContext cc) throws TeiidProcessingException {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                this.remove();
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30442, (Throwable)e);
            }
            if (this.fsisf.getStorageMode() == InputStreamFactory.StorageMode.MEMORY) {
                byte[] bytes = this.fsisf.getMemoryBytes();
                this.fsisf.free();
                JsonType result = new JsonType((Clob)new ClobImpl(new String(bytes, Streamable.CHARSET)));
                return result;
            }
            JsonType result = new JsonType((Clob)new ClobImpl((InputStreamFactory)this.fsisf, -1L));
            if (cc != null) {
                cc.addCreatedLob(this.fsisf);
            }
            return result;
        }

        public void remove() {
            this.fs.remove();
        }

        public void end(boolean array) throws TeiidProcessingException {
            this.position.pop();
            try {
                if (array) {
                    this.writer.append(']');
                } else {
                    this.writer.append('}');
                }
            }
            catch (IOException e) {
                this.remove();
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30442, (Throwable)e);
            }
        }
    }
}

