/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.connector.DataPlugin;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.DataWrapper;
import org.teiid.metadata.Database;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.DuplicateRecordException;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.Grant;
import org.teiid.metadata.MetadataException;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.NamespaceContainer;
import org.teiid.metadata.ParseException;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Role;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Server;
import org.teiid.metadata.Table;
import org.teiid.metadata.Trigger;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.StoredProcedureInfo;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.OptionsUtil;
import org.teiid.query.parser.SQLParserUtil;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.vdb.runtime.VDBKey;

public abstract class DatabaseStore {
    private ConcurrentHashMap<VDBKey, Database> databases = new ConcurrentHashMap();
    private Database currentDatabase;
    protected Schema currentSchema;
    private ReentrantLock lock = new ReentrantLock();
    protected int count;
    private boolean persist;
    private Mode mode = Mode.ANY;
    private boolean seenOther;
    private boolean strict;

    public abstract Map<String, Datatype> getRuntimeTypes();

    public void startEditing(boolean persist) {
        if (this.persist) {
            throw new IllegalStateException();
        }
        this.lock.lock();
        this.persist = persist;
        this.mode = Mode.ANY;
        this.strict = false;
        this.seenOther = false;
    }

    public void stopEditing() throws MetadataException {
        this.currentDatabase = null;
        this.currentSchema = null;
        this.persist = false;
        this.lock.unlock();
    }

    public Schema getSchema(String schemaName) {
        this.verifyDatabaseExists();
        return this.currentDatabase.getSchema(schemaName);
    }

    public Server getServer(String serverName) {
        this.verifyDatabaseExists();
        return this.currentDatabase.getServer(serverName);
    }

    public void databaseCreated(Database db) {
        if (!this.assertInEditMode(Mode.DATABASE_STRUCTURE)) {
            return;
        }
        this.assertGrant(Grant.Permission.Privilege.CREATE, Database.ResourceType.DATABASE, (AbstractMetadataRecord)db);
        Database database = this.databases.get(this.vdbKey(db));
        if (database != null) {
            throw new DuplicateRecordException((BundleUtil.Event)QueryPlugin.Event.TEIID31232, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31232, new Object[]{db.getName()}));
        }
        if (this.currentDatabase != null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31242, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31242, new Object[0]));
        }
        db.getMetadataStore().addDataTypes(this.getRuntimeTypes());
        this.databases.put(this.vdbKey(db), db);
    }

    private VDBKey vdbKey(Database db) {
        return new VDBKey(db.getName(), db.getVersion());
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    protected boolean assertInEditMode(Mode current) {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31219, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31219, new Object[0]));
        }
        if (this.mode == current || this.mode == Mode.ANY || current == Mode.ANY) {
            if (this.seenOther) {
                throw new MetadataException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31257, new Object[]{current}));
            }
            return true;
        }
        switch (this.mode) {
            case DATABASE_STRUCTURE: {
                if (current != Mode.DOMAIN) break;
                if (this.seenOther) {
                    throw new MetadataException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31257, new Object[]{current}));
                }
                return true;
            }
            case SCHEMA: {
                if (this.strict) break;
                return false;
            }
        }
        if (this.strict) {
            throw new MetadataException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31258, new Object[]{this.mode}));
        }
        this.seenOther = true;
        return false;
    }

    public void databaseSwitched(String dbName, String version) {
        if (!this.assertInEditMode(Mode.DATABASE_STRUCTURE)) {
            return;
        }
        Database db = this.databases.get(new VDBKey(dbName, version));
        if (db == null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31231, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31231, new Object[]{dbName, version}));
        }
        if (this.currentDatabase != null && !this.currentDatabase.equals((Object)db)) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31242, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31242, new Object[0]));
        }
        this.currentDatabase = db;
    }

    protected boolean shouldValidateDatabaseBeforeDeploy() {
        return true;
    }

    public void schemaCreated(Schema schema, List<String> serverNames) {
        if (!this.assertInEditMode(Mode.DATABASE_STRUCTURE)) {
            return;
        }
        this.assertGrant(Grant.Permission.Privilege.CREATE, Database.ResourceType.SCHEMA, (AbstractMetadataRecord)schema);
        this.verifyDatabaseExists();
        this.setUUID(this.currentDatabase.getName(), this.currentDatabase.getVersion(), schema);
        this.currentDatabase.addSchema(schema);
        if (schema.isPhysical()) {
            for (String serverName : serverNames) {
                Server server = this.verifyServerExists(serverName);
                schema.addServer(server);
            }
        } else if (!serverNames.isEmpty()) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31236, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31236, new Object[]{schema.getName()}));
        }
    }

    public void schemaDropped(String schemaName, Boolean virtual) {
        if (!this.assertInEditMode(Mode.DATABASE_STRUCTURE)) {
            return;
        }
        Schema s = this.verifySchemaExists(schemaName);
        if (virtual != null && virtual == false ^ s.isPhysical()) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31273, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31273, new Object[]{s.getName()}));
        }
        this.assertGrant(Grant.Permission.Privilege.DROP, Database.ResourceType.SCHEMA, (AbstractMetadataRecord)s);
        this.currentDatabase.removeSchema(schemaName);
        if (this.currentSchema != null && this.currentSchema.getName().equalsIgnoreCase(schemaName)) {
            this.currentSchema = null;
        }
    }

    protected FunctionMethod verifyFunctionExists(String functionName) {
        this.verifyDatabaseExists();
        Schema schema = this.getCurrentSchema();
        for (FunctionMethod fm : schema.getFunctions().values()) {
            if (!fm.getName().equalsIgnoreCase(functionName)) continue;
            return fm;
        }
        throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31240, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31240, new Object[]{functionName, this.currentDatabase.getName()}));
    }

    protected Schema verifySchemaExists(String schemaName) {
        this.verifyDatabaseExists();
        Schema schema = this.currentDatabase.getSchema(schemaName);
        if (schema == null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31234, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31234, new Object[]{schemaName, this.currentDatabase.getName()}));
        }
        return schema;
    }

    protected Server verifyServerExists(String serverName) {
        this.verifyDatabaseExists();
        Server server = this.currentDatabase.getServer(serverName);
        if (server == null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31220, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31220, new Object[]{serverName, this.currentDatabase.getName()}));
        }
        return server;
    }

    protected void verifyDatabaseExists() {
        if (this.currentDatabase == null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31233, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31233, new Object[0]));
        }
    }

    protected void verifyCurrentDatabaseIsNotSame(String dbName, String version) {
        if (this.currentDatabase == null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31233, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31233, new Object[0]));
        }
        if (this.currentDatabase.getName().equalsIgnoreCase(dbName) && this.currentDatabase.getVersion().equalsIgnoreCase(version)) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31227, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31227, new Object[]{dbName, version}));
        }
    }

    public void schemaSwitched(String schemaName) {
        Schema schema = this.verifySchemaExists(schemaName);
        if (!this.assertInEditMode(Mode.SCHEMA)) {
            return;
        }
        this.currentSchema = schema;
    }

    public void dataWrapperCreated(DataWrapper wrapper) {
        if (!this.assertInEditMode(Mode.DATABASE_STRUCTURE)) {
            return;
        }
        this.assertGrant(Grant.Permission.Privilege.CREATE, Database.ResourceType.DATAWRAPPER, (AbstractMetadataRecord)wrapper);
        this.verifyDatabaseExists();
        this.currentDatabase.addDataWrapper(wrapper);
    }

    public void dataWrapperDropped(String wrapperName) {
        if (!this.assertInEditMode(Mode.DATABASE_STRUCTURE)) {
            return;
        }
        this.verifyDatabaseExists();
        this.verifyDataWrapperExists(wrapperName);
        this.assertGrant(Grant.Permission.Privilege.DROP, Database.ResourceType.DATAWRAPPER, (AbstractMetadataRecord)this.currentDatabase.getDataWrapper(wrapperName));
        for (Server s : this.currentDatabase.getServers()) {
            if (!s.getDataWrapper().equalsIgnoreCase(wrapperName)) continue;
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31225, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31225, new Object[]{wrapperName, s.getName()}));
        }
        this.currentDatabase.removeDataWrapper(wrapperName);
    }

    public void serverCreated(Server server) {
        if (!this.assertInEditMode(Mode.DATABASE_STRUCTURE)) {
            return;
        }
        this.verifyDatabaseExists();
        this.verifyDataWrapperExists(server.getDataWrapper());
        this.assertGrant(Grant.Permission.Privilege.CREATE, Database.ResourceType.SERVER, (AbstractMetadataRecord)server);
        this.currentDatabase.addServer(server);
    }

    private boolean verifyDataWrapperExists(String dataWrapperName) {
        if (this.currentDatabase.getDataWrapper(dataWrapperName) == null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31247, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31247, new Object[]{dataWrapperName}));
        }
        return true;
    }

    public void serverDropped(String serverName) {
        if (!this.assertInEditMode(Mode.DATABASE_STRUCTURE)) {
            return;
        }
        this.verifyDatabaseExists();
        this.verifyServerExists(serverName);
        this.assertGrant(Grant.Permission.Privilege.DROP, Database.ResourceType.SERVER, (AbstractMetadataRecord)this.currentDatabase.getServer(serverName));
        for (Schema s : this.currentDatabase.getSchemas()) {
            for (Server server : s.getServers()) {
                if (!server.getName().equalsIgnoreCase(serverName)) continue;
                throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31224, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31224, new Object[]{serverName, s.getName()}));
            }
        }
        this.currentDatabase.removeServer(serverName);
    }

    protected Schema getCurrentSchema() {
        if (this.currentSchema == null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31235, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31235, new Object[0]));
        }
        return this.currentSchema;
    }

    protected Database getCurrentDatabase() {
        if (this.currentDatabase == null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31246, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31246, new Object[0]));
        }
        return this.currentDatabase;
    }

    public Database getDatabase(String dbName, String version) {
        VDBKey key = new VDBKey(dbName, version);
        return this.databases.get(key);
    }

    public List<Database> getDatabases() {
        return new ArrayList<Database>(this.databases.values());
    }

    public void tableCreated(Table table) {
        if (!this.assertInEditMode(Mode.SCHEMA)) {
            return;
        }
        this.assertGrant(Grant.Permission.Privilege.CREATE, Database.ResourceType.TABLE, (AbstractMetadataRecord)table);
        Schema s = this.getCurrentSchema();
        this.setUUID(s.getUUID(), (AbstractMetadataRecord)table);
        if (table.isVirtual() && table.getSelectTransformation() == null && table.getTableType() != Table.Type.TemporaryTable) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31272, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31272, new Object[]{table.getFullName()}));
        }
        s.addTable(table);
    }

    public void setViewDefinition(String tableName, String definition) {
        if (!this.assertInEditMode(Mode.SCHEMA)) {
            return;
        }
        Table table = (Table)this.getSchemaRecord(tableName, Database.ResourceType.TABLE);
        if (!table.isVirtual()) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31238, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31238, new Object[]{table.getFullName()}));
        }
        this.assertGrant(Grant.Permission.Privilege.ALTER, Database.ResourceType.TABLE, (AbstractMetadataRecord)table);
        table.setSelectTransformation(definition);
    }

    public void modifyTableName(String name, Database.ResourceType type, String newName) {
        if (!this.assertInEditMode(Mode.SCHEMA)) {
            return;
        }
        Table table = (Table)this.getSchemaRecord(name, type);
        this.assertGrant(Grant.Permission.Privilege.ALTER, Database.ResourceType.TABLE, (AbstractMetadataRecord)table);
        Schema s = (Schema)table.getParent();
        if (s.getTable(newName) != null) {
            throw new DuplicateRecordException((BundleUtil.Event)DataPlugin.Event.TEIID60013, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60013, new Object[]{newName}));
        }
        s.getTables().remove(table.getName());
        table.setName(newName);
        s.getTables().put(newName, table);
    }

    public void removeColumn(String objectName, Database.ResourceType type, String childName) {
        if (!this.assertInEditMode(Mode.SCHEMA)) {
            return;
        }
        Table table = (Table)this.getSchemaRecord(objectName, type);
        this.assertGrant(Grant.Permission.Privilege.ALTER, Database.ResourceType.TABLE, (AbstractMetadataRecord)table);
        Column column = table.getColumnByName(childName);
        if (column == null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31223, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31223, new Object[]{childName}));
        }
        table.removeColumn(column);
    }

    public void tableDropped(String tableName, boolean globalTemp, boolean view) {
        if (!this.assertInEditMode(Mode.SCHEMA)) {
            return;
        }
        Table table = (Table)this.getSchemaRecord(tableName, Database.ResourceType.TABLE);
        this.assertGrant(Grant.Permission.Privilege.DROP, Database.ResourceType.TABLE, (AbstractMetadataRecord)table);
        if (!(globalTemp ^ table.getTableType() != Table.Type.TemporaryTable)) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31273, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31273, new Object[]{table.getFullName()}));
        }
        if (view ^ table.isVirtual()) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31273, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31273, new Object[]{table.getFullName()}));
        }
        Schema s = (Schema)table.getParent();
        s.removeTable(tableName);
    }

    public void procedureCreated(Procedure procedure) {
        if (!this.assertInEditMode(Mode.SCHEMA)) {
            return;
        }
        this.assertGrant(Grant.Permission.Privilege.CREATE, Database.ResourceType.PROCEDURE, (AbstractMetadataRecord)procedure);
        Schema s = this.getCurrentSchema();
        this.setUUID(s.getUUID(), (AbstractMetadataRecord)procedure);
        for (ProcedureParameter param : procedure.getParameters()) {
            this.setUUID(s.getUUID(), (AbstractMetadataRecord)param);
        }
        if (procedure.getResultSet() != null) {
            this.setUUID(s.getUUID(), (AbstractMetadataRecord)procedure.getResultSet());
        }
        s.addProcedure(procedure);
    }

    public void setProcedureDefinition(String procedureName, String definition) {
        if (!this.assertInEditMode(Mode.SCHEMA)) {
            return;
        }
        Procedure procedure = (Procedure)this.getSchemaRecord(procedureName, Database.ResourceType.PROCEDURE);
        this.assertGrant(Grant.Permission.Privilege.ALTER, Database.ResourceType.PROCEDURE, (AbstractMetadataRecord)procedure);
        if (!procedure.isVirtual()) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31238, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31238, new Object[]{procedure.getFullName()}));
        }
        procedure.setQueryPlan(definition);
    }

    public void procedureDropped(String procedureName, Boolean virtual) {
        if (!this.assertInEditMode(Mode.SCHEMA)) {
            return;
        }
        Procedure procedure = (Procedure)this.getSchemaRecord(procedureName, Database.ResourceType.PROCEDURE);
        if (virtual != null && virtual ^ procedure.isVirtual()) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31273, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31273, new Object[]{procedure.getFullName()}));
        }
        this.assertGrant(Grant.Permission.Privilege.DROP, Database.ResourceType.PROCEDURE, (AbstractMetadataRecord)procedure);
        Schema s = procedure.getParent();
        s.removeProcedure(procedureName);
    }

    public void functionCreated(FunctionMethod function) {
        if (!this.assertInEditMode(Mode.SCHEMA)) {
            return;
        }
        this.assertGrant(Grant.Permission.Privilege.CREATE, Database.ResourceType.FUNCTION, (AbstractMetadataRecord)function);
        Schema s = this.getCurrentSchema();
        this.setUUID(s.getUUID(), (AbstractMetadataRecord)function);
        for (FunctionParameter param : function.getInputParameters()) {
            this.setUUID(s.getUUID(), (AbstractMetadataRecord)param);
        }
        this.setUUID(s.getUUID(), (AbstractMetadataRecord)function.getOutputParameter());
        s.addFunction(function);
    }

    public void functionDropped(String functionName, Boolean virtual) {
        if (!this.assertInEditMode(Mode.SCHEMA)) {
            return;
        }
        FunctionMethod fm = this.verifyFunctionExists(functionName);
        this.assertGrant(Grant.Permission.Privilege.DROP, Database.ResourceType.FUNCTION, (AbstractMetadataRecord)fm);
        Schema s = this.getCurrentSchema();
        s.removeFunctions(functionName);
    }

    public void setTableTriggerPlan(String triggerName, String tableName, Table.TriggerEvent event, String triggerDefinition, boolean isAfter) {
        if (!this.assertInEditMode(Mode.SCHEMA)) {
            return;
        }
        Table table = (Table)this.getSchemaRecord(tableName, Database.ResourceType.TABLE);
        if (table == null) {
            throw new MetadataException(QueryPlugin.Util.getString("SQLParser.group_doesnot_exist", new Object[]{tableName}));
        }
        this.assertGrant(Grant.Permission.Privilege.ALTER, Database.ResourceType.TABLE, (AbstractMetadataRecord)table);
        if (!table.isVirtual()) {
            if (!isAfter) {
                throw new MetadataException(QueryPlugin.Util.getString("SQLParser.not_view", new Object[]{tableName}));
            }
            if (triggerName == null) {
                throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31213, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31213, new Object[0]));
            }
            if (table.getTriggers().containsKey(triggerName)) {
                throw new DuplicateRecordException((BundleUtil.Event)QueryPlugin.Event.TEIID31212, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31212, new Object[]{triggerName, table.getFullName()}));
            }
            Trigger t = new Trigger();
            t.setName(triggerName);
            t.setEvent(event);
            t.setPlan(triggerDefinition);
            table.getTriggers().put(triggerName, t);
            return;
        }
        if (isAfter) {
            throw new MetadataException(QueryPlugin.Util.getString("SQLParser.view_not_allowed", new Object[]{tableName}));
        }
        if (event.equals((Object)Table.TriggerEvent.INSERT)) {
            table.setInsertPlan(triggerDefinition);
        } else if (event.equals((Object)Table.TriggerEvent.UPDATE)) {
            table.setUpdatePlan(triggerDefinition);
        } else if (event.equals((Object)Table.TriggerEvent.DELETE)) {
            table.setDeletePlan(triggerDefinition);
        }
    }

    public void enableTableTriggerPlan(String tableName, Table.TriggerEvent event, boolean enable) {
        if (!this.assertInEditMode(Mode.SCHEMA)) {
            return;
        }
        Table table = (Table)this.getSchemaRecord(tableName, Database.ResourceType.TABLE);
        if (table == null || !table.isVirtual()) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31244, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31244, new Object[]{tableName}));
        }
        this.assertGrant(Grant.Permission.Privilege.ALTER, Database.ResourceType.TABLE, (AbstractMetadataRecord)table);
        switch (event) {
            case DELETE: {
                table.setDeletePlanEnabled(enable);
                break;
            }
            case INSERT: {
                table.setInsertPlanEnabled(enable);
                break;
            }
            case UPDATE: {
                table.setUpdatePlanEnabled(enable);
                break;
            }
        }
    }

    public void createNameSpace(String prefix, String uri) {
        if (!this.assertInEditMode(Mode.ANY)) {
            return;
        }
        this.getCurrentDatabase().addNamespace(prefix, uri);
    }

    public void createDomain(String name, String baseType, Integer length, Integer scale, boolean notNull) {
        if (!this.assertInEditMode(Mode.DOMAIN)) {
            return;
        }
        Datatype dt = this.getCurrentDatabase().addDomain(name, baseType, length, scale, notNull);
        this.setUUID(this.getCurrentDatabase().getUUID(), (AbstractMetadataRecord)dt);
    }

    public Map<String, String> getNameSpaces() {
        return this.getCurrentDatabase().getNamespaces();
    }

    public void addOrSetOption(String recordName, Database.ResourceType type, String key, String value, boolean reload) {
        if (!this.assertInEditMode(Mode.SCHEMA)) {
            return;
        }
        key = this.getCurrentDatabase().resolveNamespaceInPropertyKey(key);
        AbstractMetadataRecord record = this.getSchemaRecord(recordName, type);
        record.setProperty(key, value);
        OptionsUtil.setOptions(record);
    }

    public AbstractMetadataRecord getSchemaRecord(String name, Database.ResourceType type) {
        TransformationMetadata qmi = this.getTransformationMetadata();
        try {
            switch (type) {
                case TABLE: {
                    GroupSymbol gs = new GroupSymbol(name);
                    ResolverUtil.resolveGroup(gs, qmi);
                    return (Table)gs.getMetadataID();
                }
                case PROCEDURE: {
                    StoredProcedureInfo sp = qmi.getStoredProcedureInfoForProcedure(name);
                    return (Procedure)sp.getProcedureID();
                }
                case DATABASE: {
                    return this.getCurrentDatabase();
                }
                case SCHEMA: {
                    Schema schema = qmi.getModelID(name);
                    if (schema == null) {
                        throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31234, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31234, new Object[]{name, this.getCurrentDatabase().getName()}));
                    }
                    return schema;
                }
                case SERVER: {
                    Server server = this.getCurrentDatabase().getServer(name);
                    if (server == null) {
                        throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31220, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31220, new Object[]{name, this.getCurrentDatabase().getName()}));
                    }
                    return server;
                }
                case DATAWRAPPER: {
                    DataWrapper dw = this.getCurrentDatabase().getDataWrapper(name);
                    if (dw == null) {
                        throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31247, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31247, new Object[]{name, this.getCurrentDatabase().getName()}));
                    }
                    return dw;
                }
            }
            throw new AssertionError();
        }
        catch (TeiidComponentException e) {
            throw new MetadataException((Throwable)e);
        }
        catch (QueryResolverException e) {
            throw new MetadataException((Throwable)((Object)e));
        }
    }

    protected TransformationMetadata getTransformationMetadata() {
        throw new IllegalStateException("TransformationMetadata not yet available");
    }

    public void removeOption(String recordName, Database.ResourceType type, String key) {
        if (!this.assertInEditMode(Mode.SCHEMA)) {
            return;
        }
        key = this.getCurrentDatabase().resolveNamespaceInPropertyKey(key);
        AbstractMetadataRecord record = this.getSchemaRecord(recordName, type);
        OptionsUtil.removeOption(record, key);
    }

    public void addOrSetOption(String recordName, Database.ResourceType type, String childName, Database.ResourceType childType, String key, String value, boolean reload) {
        if (!this.assertInEditMode(Mode.SCHEMA)) {
            return;
        }
        key = this.getCurrentDatabase().resolveNamespaceInPropertyKey(key);
        AbstractMetadataRecord record = this.getSchemaRecord(recordName, type);
        if (record instanceof Table) {
            Column c = ((Table)record).getColumnByName(childName);
            if (c == null) {
                throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31248, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31248, new Object[]{childName, recordName}));
            }
            c.setProperty(key, value);
            OptionsUtil.setOptions((AbstractMetadataRecord)c);
        } else if (record instanceof Procedure) {
            ProcedureParameter p = ((Procedure)record).getParameterByName(childName);
            if (p == null) {
                throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31249, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31249, new Object[]{childName, recordName}));
            }
            p.setProperty(key, value);
            OptionsUtil.setOptions((AbstractMetadataRecord)p);
        }
    }

    public void removeOption(String recordName, Database.ResourceType type, String childName, Database.ResourceType childType, String key) {
        if (!this.assertInEditMode(Mode.SCHEMA)) {
            return;
        }
        key = this.getCurrentDatabase().resolveNamespaceInPropertyKey(key);
        AbstractMetadataRecord record = this.getSchemaRecord(recordName, type);
        if (record instanceof Table) {
            Column c = ((Table)record).getColumnByName(childName);
            if (c == null) {
                throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31248, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31248, new Object[]{childName, recordName}));
            }
            OptionsUtil.removeOption((AbstractMetadataRecord)c, key);
        } else if (record instanceof Procedure) {
            ProcedureParameter p = ((Procedure)record).getParameterByName(childName);
            if (p == null) {
                throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31249, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31249, new Object[]{childName, recordName}));
            }
            OptionsUtil.removeOption((AbstractMetadataRecord)p, key);
        }
    }

    public void importSchema(String schemaName, String serverType, String serverName, String foreignSchemaName, List<String> includeTables, List<String> excludeTables, Map<String, String> properties) {
        throw new MetadataException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31221, new Object[0]));
    }

    public void importDatabase(String dbName, String version, boolean importPolicies) {
        throw new MetadataException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31226, new Object[0]));
    }

    protected Role verifyRoleExists(String roleName) {
        this.verifyDatabaseExists();
        Role role = this.currentDatabase.getRole(roleName);
        if (role == null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31222, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31222, new Object[]{roleName, this.currentDatabase.getName()}));
        }
        return role;
    }

    public void roleCreated(Role role) {
        if (!this.assertInEditMode(Mode.DATABASE_STRUCTURE)) {
            return;
        }
        this.verifyDatabaseExists();
        this.assertGrant(Grant.Permission.Privilege.CREATE, Database.ResourceType.ROLE, (AbstractMetadataRecord)role);
        this.currentDatabase.addRole(role);
    }

    public void roleDropped(String roleName) {
        if (!this.assertInEditMode(Mode.DATABASE_STRUCTURE)) {
            return;
        }
        Role role = this.verifyRoleExists(roleName);
        this.assertGrant(Grant.Permission.Privilege.DROP, Database.ResourceType.ROLE, (AbstractMetadataRecord)role);
        this.currentDatabase.removeRole(roleName);
    }

    public void grantCreated(Grant grant) {
        if (!this.assertInEditMode(Mode.SCHEMA)) {
            return;
        }
        this.verifyDatabaseExists();
        this.verifyRoleExists(grant.getRole());
        this.assertGrant(Grant.Permission.Privilege.CREATE, Database.ResourceType.GRANT, (AbstractMetadataRecord)grant);
        for (Grant.Permission p : grant.getPermissions()) {
            if (p.getResourceType() != Database.ResourceType.LANGUAGE) continue;
        }
        this.currentDatabase.addGrant(grant);
    }

    public void grantRevoked(Grant grant) {
        if (!this.assertInEditMode(Mode.SCHEMA)) {
            return;
        }
        this.verifyDatabaseExists();
        this.verifyRoleExists(grant.getRole());
        this.assertGrant(Grant.Permission.Privilege.DROP, Database.ResourceType.GRANT, (AbstractMetadataRecord)grant);
        for (Grant.Permission p : grant.getPermissions()) {
            if (p.getResourceType() != Database.ResourceType.LANGUAGE) continue;
        }
        this.currentDatabase.revokeGrant(grant);
    }

    public void renameBaseColumn(String objectName, Database.ResourceType type, String oldName, String newName) {
        if (!this.assertInEditMode(Mode.SCHEMA)) {
            return;
        }
        MetadataFactory factory = DatabaseStore.createMF(this);
        switch (type) {
            case TABLE: {
                Table table = (Table)this.getSchemaRecord(objectName, type);
                this.assertGrant(Grant.Permission.Privilege.ALTER, Database.ResourceType.TABLE, (AbstractMetadataRecord)table);
                factory.renameColumn(oldName, newName, (ColumnSet)table);
                break;
            }
            case PROCEDURE: {
                Procedure proc = (Procedure)this.getSchemaRecord(objectName, type);
                this.assertGrant(Grant.Permission.Privilege.ALTER, Database.ResourceType.PROCEDURE, (AbstractMetadataRecord)proc);
                factory.renameParameter(oldName, newName, proc);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid type");
            }
        }
    }

    public void alterBaseColumn(String objectName, Database.ResourceType type, String childName, SQLParserUtil.ParsedDataType datatype, boolean autoIncrement, boolean notNull) {
        MetadataFactory factory = DatabaseStore.createMF(this);
        Column column = null;
        if (type == Database.ResourceType.TABLE) {
            Table table = (Table)this.getSchemaRecord(objectName, type);
            this.assertGrant(Grant.Permission.Privilege.ALTER, Database.ResourceType.TABLE, (AbstractMetadataRecord)table);
            column = table.getColumnByName(childName);
            if (column == null) {
                throw new ParseException(QueryPlugin.Util.getString("SQLParser.no_table_column_found", new Object[]{childName, table.getName()}));
            }
        } else {
            Procedure proc = (Procedure)this.getSchemaRecord(objectName, type);
            this.assertGrant(Grant.Permission.Privilege.ALTER, Database.ResourceType.PROCEDURE, (AbstractMetadataRecord)proc);
            column = proc.getParameterByName(childName);
            if (column == null) {
                throw new ParseException(QueryPlugin.Util.getString("SQLParser.no_proc_column_found", new Object[]{childName, proc.getName()}));
            }
        }
        MetadataFactory.setDataType((String)datatype.getType(), (BaseColumn)column, (Map)factory.getDataTypes(), (boolean)notNull);
        SQLParserUtil.setTypeInfo(datatype, (BaseColumn)column);
        if (notNull) {
            column.setNullType(BaseColumn.NullType.No_Nulls);
        }
        if (type == Database.ResourceType.TABLE) {
            column.setAutoIncremented(autoIncrement);
        }
    }

    public static MetadataFactory createMF(DatabaseStore events, Schema schema, boolean useSchema, Properties modelProperties) {
        MetadataFactory mf = new MetadataFactory(events.getCurrentDatabase().getName(), (Object)events.getCurrentDatabase().getVersion(), schema == null ? "undefined" : schema.getName(), (Map)events.getCurrentDatabase().getMetadataStore().getDatatypes(), modelProperties, null);
        Map<String, String> nss = events.getNameSpaces();
        for (String key : nss.keySet()) {
            mf.addNamespace(key, nss.get(key));
        }
        if (useSchema && schema != null) {
            mf.setSchema(schema);
        }
        return mf;
    }

    public static MetadataFactory createMF(DatabaseStore events) {
        return DatabaseStore.createMF(events, events.currentSchema, false, new Properties());
    }

    private void setUUID(String prefix, AbstractMetadataRecord record) {
        if (record.getUUID() != null && !record.getUUID().startsWith("tid:")) {
            return;
        }
        int lsb = 0;
        if (record.getParent() != null) {
            lsb = record.getParent().getUUID().hashCode();
        }
        lsb = 31 * lsb + record.getName().hashCode();
        String uuid = prefix + "-" + MetadataFactory.hex((long)lsb, (int)8) + "-" + MetadataFactory.hex((long)this.count++, (int)8);
        record.setUUID(uuid);
    }

    private long longHash(String s, long h) {
        if (s == null) {
            return h;
        }
        for (int i = 0; i < s.length(); ++i) {
            h = 31L * h + (long)s.charAt(i);
        }
        return h;
    }

    private void setUUID(String vdbName, String vdbVersion, Schema schema) {
        long msb = this.longHash(vdbName, 0L);
        try {
            int val = Integer.parseInt(vdbVersion);
            msb = 31L * msb + (long)val;
        }
        catch (NumberFormatException e) {
            msb = 31L * msb + (long)this.currentDatabase.getVersion().hashCode();
        }
        msb = this.longHash(schema.getName(), msb);
        schema.setUUID("tid:" + MetadataFactory.hex((long)msb, (int)12));
    }

    private void assertGrant(Grant.Permission.Privilege allowence, Database.ResourceType type, AbstractMetadataRecord record) {
    }

    public Table getTableForCreateColumn(String objectName, Database.ResourceType type) {
        if (!this.assertInEditMode(Mode.SCHEMA)) {
            return new Table();
        }
        Table table = (Table)this.getSchemaRecord(objectName, type);
        this.assertGrant(Grant.Permission.Privilege.ALTER, Database.ResourceType.TABLE, (AbstractMetadataRecord)table);
        return table;
    }

    public NamespaceContainer getCurrentNamespaceContainer() {
        return this.getCurrentDatabase().getNamespaceContainer();
    }

    public static enum Mode {
        ANY,
        DOMAIN,
        SCHEMA,
        DATABASE_STRUCTURE;

    }
}

