/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.process.MetaDataProcessor;
import org.teiid.logging.LogManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.metadata.Trigger;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.metadata.FunctionMetadataValidator;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.MaterializationMetadataRepository;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.report.ActivityReport;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.navigator.PreOrPostOrderNavigator;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.sql.visitor.ReferenceCollectorVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.validator.ValidationVisitor;
import org.teiid.query.validator.Validator;
import org.teiid.query.validator.ValidatorFailure;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.translator.CacheDirective;
import org.teiid.translator.TranslatorException;

public class MetadataValidator {
    public static final String UNTYPED = "teiid_internal:untyped";
    private Map<String, Datatype> typeMap;
    private QueryParser parser;

    public MetadataValidator(Map<String, Datatype> typeMap, QueryParser parser) {
        this.typeMap = typeMap;
        this.parser = parser;
    }

    public MetadataValidator() {
        this.typeMap = SystemMetadata.getInstance().getRuntimeTypeMap();
        this.parser = QueryParser.getQueryParser();
    }

    public ValidatorReport validate(VDBMetaData vdb, MetadataStore store) {
        ValidatorReport report = new ValidatorReport();
        if (store != null && !store.getSchemaList().isEmpty()) {
            new SourceModelArtifacts().execute(vdb, store, report, this);
            new CrossSchemaResolver().execute(vdb, store, report, this);
            new ResolveQueryPlans().execute(vdb, store, report, this);
            new MinimalMetadata().execute(vdb, store, report, this);
            new MatViewPropertiesValidator().execute(vdb, store, report, this);
        }
        return report;
    }

    public void log(ValidatorReport report, ModelMetaData model, String msg) {
        this.log(report, model, ModelMetaData.Message.Severity.ERROR, msg);
    }

    public void log(ValidatorReport report, ModelMetaData model, ModelMetaData.Message.Severity severity, String msg) {
        model.addRuntimeMessage(severity, msg);
        int messageLevel = 3;
        if (severity == ModelMetaData.Message.Severity.ERROR) {
            report.handleValidationError(msg);
        } else {
            messageLevel = 4;
        }
        LogManager.log((int)messageLevel, (String)"org.teiid.PLANNER.RESOLVER", (Object)msg);
    }

    private void validate(VDBMetaData vdb, ModelMetaData model, AbstractMetadataRecord record, ValidatorReport report, QueryMetadataInterface metadata, MetadataFactory mf) {
        ValidatorReport resolverReport = null;
        try {
            if (record instanceof Procedure) {
                Procedure p = (Procedure)record;
                Command command = this.parser.parseProcedure(p.getQueryPlan(), false);
                this.validateNoReferences(command, report, model);
                QueryResolver.resolveCommand(command, new GroupSymbol(p.getFullName()), 6, metadata, false);
                resolverReport = Validator.validate(command, metadata);
                MetadataValidator.determineDependencies((AbstractMetadataRecord)p, command);
            } else if (record instanceof Table) {
                CacheHint cacheHint;
                Table t = (Table)record;
                GroupSymbol symbol = new GroupSymbol(t.getFullName());
                ResolverUtil.resolveGroup(symbol, metadata);
                String selectTransformation = t.getSelectTransformation();
                QueryNode node = null;
                if (t.isVirtual()) {
                    QueryCommand command = (QueryCommand)this.parser.parseCommand(selectTransformation);
                    this.validateNoReferences(command, report, model);
                    QueryResolver.resolveCommand(command, metadata);
                    resolverReport = Validator.validate(command, metadata);
                    if (!resolverReport.hasItems()) {
                        List<Expression> symbols = command.getProjectedSymbols();
                        if (t.getColumns() == null || t.getColumns().isEmpty()) {
                            for (Expression column : symbols) {
                                try {
                                    this.addColumn(column, t, mf, metadata);
                                }
                                catch (TranslatorException e) {
                                    this.log(report, model, e.getMessage());
                                }
                            }
                            if (command instanceof SetQuery) {
                                MetaDataProcessor.updateMetadataAcrossBranches((SetQuery)command, t.getColumns(), metadata);
                            }
                        } else {
                            for (int i = 0; i < t.getColumns().size(); ++i) {
                                Column c = (Column)t.getColumns().get(i);
                                if (!Boolean.valueOf(c.getProperty(UNTYPED, false)).booleanValue() || symbols.size() <= i) continue;
                                Expression projected = symbols.get(i);
                                MetadataFactory.setDataType((String)DataTypeManager.getDataTypeName(projected.getType()), (BaseColumn)c, (Map)mf.getDataTypes(), (boolean)false);
                                this.copyExpressionMetadata(projected, metadata, c);
                            }
                        }
                    }
                    node = QueryResolver.resolveView(symbol, new QueryNode(selectTransformation), "SELECT", metadata, true);
                    if (t.getColumns() != null && !t.getColumns().isEmpty()) {
                        MetadataValidator.determineDependencies((AbstractMetadataRecord)t, command);
                        if (t.getInsertPlan() != null && t.isInsertPlanEnabled()) {
                            this.validateUpdatePlan(model, report, metadata, t, t.getInsertPlan(), 2);
                        }
                        if (t.getUpdatePlan() != null && t.isUpdatePlanEnabled()) {
                            this.validateUpdatePlan(model, report, metadata, t, t.getUpdatePlan(), 3);
                        }
                        if (t.getDeletePlan() != null && t.isDeletePlanEnabled()) {
                            this.validateUpdatePlan(model, report, metadata, t, t.getDeletePlan(), 4);
                        }
                    }
                }
                boolean addCacheHint = false;
                if (t.isVirtual() && t.isMaterialized() && t.getMaterializedTable() == null) {
                    List fbis = t.getFunctionBasedIndexes();
                    List<GroupSymbol> groups = Arrays.asList(symbol);
                    if (fbis != null && !fbis.isEmpty()) {
                        for (KeyRecord fbi : fbis) {
                            for (int j = 0; j < fbi.getColumns().size(); ++j) {
                                Column c = (Column)fbi.getColumns().get(j);
                                if (c.getParent() != fbi) continue;
                                String exprString = c.getNameInSource();
                                try {
                                    Expression ex = this.parser.parseExpression(exprString);
                                    this.validateNoReferences(ex, report, model);
                                    ResolverVisitor.resolveLanguageObject(ex, groups, metadata);
                                    if (!ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(ex).isEmpty()) {
                                        this.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31114, new Object[]{exprString, fbi.getFullName()}));
                                    }
                                    EvaluatableVisitor ev = new EvaluatableVisitor();
                                    PreOrPostOrderNavigator.doVisit(ex, ev, true);
                                    if (ev.getDeterminismLevel().compareTo((Enum)FunctionMethod.Determinism.VDB_DETERMINISTIC) >= 0) continue;
                                    this.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31115, new Object[]{exprString, fbi.getFullName()}));
                                    continue;
                                }
                                catch (QueryResolverException e) {
                                    this.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31116, new Object[]{exprString, fbi.getFullName(), e.getMessage()}));
                                }
                            }
                        }
                    }
                } else {
                    addCacheHint = true;
                }
                if (node != null && t.isMaterialized() && (cacheHint = node.getCommand().getCacheHint()) != null && cacheHint.getScope() != null && cacheHint.getScope() != CacheDirective.Scope.VDB) {
                    this.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31116, new Object[]{t.getFullName()}));
                }
                if (node != null && addCacheHint && t.isMaterialized()) {
                    cacheHint = node.getCommand().getCacheHint();
                    Long ttl = -1L;
                    if (cacheHint != null) {
                        if (cacheHint.getTtl() != null && t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_TTL", false) == null) {
                            ttl = cacheHint.getTtl();
                            t.setProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_TTL", String.valueOf(ttl));
                        }
                        if (cacheHint.getUpdatable() != null && t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_UPDATABLE", false) == null) {
                            t.setProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_UPDATABLE", String.valueOf(cacheHint.getUpdatable()));
                        }
                        if (cacheHint.getPrefersMemory() != null && t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_PREFER_MEMORY", false) == null) {
                            t.setProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_PREFER_MEMORY", String.valueOf(cacheHint.getPrefersMemory()));
                        }
                        if (cacheHint.getScope() != null && t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_SHARE_SCOPE", false) == null) {
                            this.log(report, model, ModelMetaData.Message.Severity.WARNING, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31252, new Object[]{t.getName(), cacheHint.getScope().name()}));
                            t.setProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_SHARE_SCOPE", MaterializationMetadataRepository.Scope.IMPORTED.name());
                        }
                    }
                }
            }
            this.processReport(model, record, report, resolverReport);
        }
        catch (TeiidException e) {
            this.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31080, new Object[]{record.getFullName(), e.getMessage()}));
        }
    }

    public static void determineDependencies(AbstractMetadataRecord p, Command command) {
        LinkedHashSet<AbstractMetadataRecord> values = new LinkedHashSet<AbstractMetadataRecord>();
        MetadataValidator.collectDependencies(command, values);
        p.setIncomingObjects(new ArrayList<AbstractMetadataRecord>(values));
        if (p instanceof Table) {
            Table t = (Table)p;
            for (int i = 0; i < t.getColumns().size(); ++i) {
                LinkedHashSet<AbstractMetadataRecord> columnValues = new LinkedHashSet<AbstractMetadataRecord>();
                Column c = (Column)t.getColumns().get(i);
                c.setIncomingObjects(columnValues);
                MetadataValidator.determineDependencies(command, c, i, columnValues);
            }
        } else if (p instanceof Procedure) {
            final Procedure proc = (Procedure)p;
            if (proc.getResultSet() == null) {
                return;
            }
            CreateProcedureCommand cpc = (CreateProcedureCommand)command;
            Block b = cpc.getBlock();
            PreOrderNavigator.doVisit(b, new LanguageVisitor(){

                @Override
                public void visit(CommandStatement obj) {
                    if (!obj.isReturnable() || obj.getCommand() instanceof DynamicCommand || !obj.getCommand().returnsResultSet()) {
                        return;
                    }
                    for (int i = 0; i < proc.getResultSet().getColumns().size(); ++i) {
                        Column c = (Column)proc.getResultSet().getColumns().get(i);
                        LinkedHashSet columnValues = null;
                        if (c.getIncomingObjects() instanceof LinkedHashSet) {
                            columnValues = (LinkedHashSet)c.getIncomingObjects();
                        } else {
                            columnValues = new LinkedHashSet();
                            c.setIncomingObjects(columnValues);
                        }
                        MetadataValidator.determineDependencies(obj.getCommand(), c, i, columnValues);
                    }
                }
            });
        }
    }

    private static void collectDependencies(LanguageObject lo, LinkedHashSet<AbstractMetadataRecord> values) {
        Collection<GroupSymbol> groups = GroupCollectorVisitor.getGroupsIgnoreInlineViews(lo, true);
        for (GroupSymbol group : groups) {
            Object mid = group.getMetadataID();
            if (mid instanceof TempMetadataID) {
                mid = ((TempMetadataID)mid).getOriginalMetadataID();
            }
            if (!(mid instanceof AbstractMetadataRecord)) continue;
            values.add((AbstractMetadataRecord)mid);
        }
        Collection<ElementSymbol> elems = ElementCollectorVisitor.getElements(lo, true, true);
        for (ElementSymbol elem : elems) {
            Object mid = elem.getMetadataID();
            if (mid instanceof TempMetadataAdapter) {
                mid = ((TempMetadataID)mid).getOriginalMetadataID();
            }
            if (!(mid instanceof AbstractMetadataRecord)) continue;
            values.add((AbstractMetadataRecord)mid);
        }
    }

    private static void determineDependencies(Command command, Column c, int index, LinkedHashSet<AbstractMetadataRecord> columnValues) {
        if (command instanceof Query || command instanceof StoredProcedure) {
            Expression ex = command.getProjectedSymbols().get(index);
            MetadataValidator.collectDependencies(ex, columnValues);
        } else if (command instanceof SetQuery) {
            MetadataValidator.determineDependencies(((SetQuery)command).getLeftQuery(), c, index, columnValues);
            MetadataValidator.determineDependencies(((SetQuery)command).getRightQuery(), c, index, columnValues);
        }
    }

    private static Table findTableByName(MetadataStore store, String name) {
        Table table = null;
        int index = name.indexOf(46);
        if (index == -1) {
            Schema schema;
            Iterator iterator = store.getSchemaList().iterator();
            while (iterator.hasNext() && (table = (schema = (Schema)iterator.next()).getTable(name)) == null) {
            }
        } else {
            String schemaName = name.substring(0, index);
            Schema schema = store.getSchema(schemaName);
            if (schema != null) {
                table = schema.getTable(name.substring(index + 1));
            }
        }
        return table;
    }

    private void validateUpdatePlan(ModelMetaData model, ValidatorReport report, QueryMetadataInterface metadata, Table t, String plan, int type) throws QueryParserException, QueryResolverException, TeiidComponentException {
        Command command = this.parser.parseProcedure(plan, true);
        this.validateNoReferences(command, report, model);
        QueryResolver.resolveCommand(command, new GroupSymbol(t.getFullName()), type, metadata, false);
        ValidatorReport resolverReport = Validator.validate(command, metadata);
        this.processReport(model, (AbstractMetadataRecord)t, report, resolverReport);
    }

    private void validateNoReferences(LanguageObject lo, ValidatorReport report, ModelMetaData model) {
        if (!ReferenceCollectorVisitor.getReferences(lo).isEmpty()) {
            this.log(report, model, ModelMetaData.Message.Severity.ERROR, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30491, new Object[0]) + ": " + lo);
        }
    }

    private void processReport(ModelMetaData model, AbstractMetadataRecord record, ValidatorReport report, ValidatorReport resolverReport) {
        if (resolverReport != null && resolverReport.hasItems()) {
            for (ValidatorFailure v : resolverReport.getItems()) {
                this.log(report, model, v.getStatus() == ValidatorFailure.Status.ERROR ? ModelMetaData.Message.Severity.ERROR : ModelMetaData.Message.Severity.WARNING, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31080, new Object[]{record.getFullName(), v.getMessage()}));
            }
        }
    }

    private Column addColumn(Expression toCopy, Table table, MetadataFactory mf, QueryMetadataInterface metadata) throws TranslatorException, QueryMetadataException, TeiidComponentException {
        String name = Symbol.getShortName(toCopy);
        Class<?> type = toCopy.getType();
        if (type == null) {
            throw new TranslatorException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31086, new Object[]{name, table.getFullName()}));
        }
        Column column = mf.addColumn(name, DataTypeManager.getDataTypeName(type), (ColumnSet)table);
        column.setUpdatable(table.supportsUpdate());
        this.copyExpressionMetadata(toCopy, metadata, column);
        return column;
    }

    private void copyExpressionMetadata(Expression toCopy, QueryMetadataInterface metadata, Column column) throws QueryMetadataException, TeiidComponentException {
        Object mid;
        toCopy = SymbolMap.getExpression(toCopy);
        boolean metadataSet = false;
        if (toCopy instanceof ElementSymbol && (mid = ((ElementSymbol)toCopy).getMetadataID()) instanceof Column) {
            metadataSet = true;
            Column other = (Column)mid;
            column.setCaseSensitive(other.isCaseSensitive());
            column.setCharOctetLength(other.getCharOctetLength());
            column.setCurrency(other.isCurrency());
            column.setFixedLength(other.isFixedLength());
            column.setFormat(other.getFormat());
            column.setLength(other.getLength());
            column.setNullType(other.getNullType());
            column.setPrecision(other.getPrecision());
            column.setRadix(other.getRadix());
            column.setScale(other.getScale());
            column.setSigned(other.isSigned());
        }
        if (!metadataSet) {
            MetaDataProcessor.setColumnMetadata(column, toCopy, metadata);
        }
    }

    static class CrossSchemaResolver
    implements MetadataRule {
        CrossSchemaResolver() {
        }

        private boolean keyMatches(List<String> names, KeyRecord record) {
            if (names.size() != record.getColumns().size()) {
                return false;
            }
            TreeSet<String> keyNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            for (Column c : record.getColumns()) {
                keyNames.add(c.getName());
            }
            for (int i = 0; i < names.size(); ++i) {
                if (keyNames.contains(names.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public void execute(VDBMetaData vdb, MetadataStore store, ValidatorReport report, MetadataValidator metadataValidator) {
            for (Schema schema : store.getSchemaList()) {
                if (vdb.getImportedModels().contains(schema.getName())) continue;
                ModelMetaData model = vdb.getModel(schema.getName());
                for (Table t : schema.getTables().values()) {
                    if (t.isVirtual() && t.isMaterialized() && t.getMaterializedTable() != null) {
                        String matTableName = t.getMaterializedTable().getFullName();
                        int index = matTableName.indexOf(46);
                        if (index == -1) {
                            metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31088, new Object[]{matTableName, t.getFullName()}));
                        } else {
                            String schemaName = matTableName.substring(0, index);
                            Schema matSchema = store.getSchema(schemaName);
                            if (matSchema == null) {
                                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31089, new Object[]{schemaName, matTableName, t.getFullName()}));
                            } else {
                                Table matTable = matSchema.getTable(matTableName.substring(index + 1));
                                if (matTable == null) {
                                    metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31090, new Object[]{matTableName.substring(index + 1), schemaName, t.getFullName()}));
                                } else {
                                    t.setMaterializedTable(matTable);
                                }
                            }
                        }
                        String stageTable = t.getProperty("{http://www.teiid.org/ext/relational/2012}MATERIALIZED_STAGE_TABLE", false);
                        if (stageTable != null) {
                            Table materializedStageTable = MetadataValidator.findTableByName(store, stageTable);
                            if (materializedStageTable == null) {
                                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31192, new Object[]{t.getFullName(), "{http://www.teiid.org/ext/relational/2012}MATERIALIZED_STAGE_TABLE", stageTable}));
                            } else {
                                t.setMaterializedStageTable(materializedStageTable);
                            }
                        }
                    }
                    for (KeyRecord record : t.getAllKeys()) {
                        if (record.getColumns() != null && !record.getColumns().isEmpty()) continue;
                        metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31149, new Object[]{t.getFullName(), record.getName()}));
                    }
                    List fks = t.getForeignKeys();
                    if (fks == null || fks.isEmpty()) continue;
                    for (ForeignKey fk : fks) {
                        String referenceTableName = fk.getReferenceTableName();
                        Table referenceTable = null;
                        if (fk.getReferenceKey() == null) {
                            if (referenceTableName == null) {
                                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31091, new Object[]{t.getFullName()}));
                                continue;
                            }
                            referenceTable = schema.getTable(referenceTableName);
                        } else {
                            referenceTableName = ((Table)fk.getReferenceKey().getParent()).getFullName();
                        }
                        String referenceSchemaName = schema.getName();
                        int index = referenceTableName.indexOf(46);
                        if (referenceTable == null) {
                            if (index != -1) {
                                referenceSchemaName = referenceTableName.substring(0, index);
                                Schema referenceSchema = store.getSchema(referenceSchemaName);
                                if (referenceSchema == null) {
                                    metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31093, new Object[]{referenceSchemaName, t.getFullName()}));
                                    continue;
                                }
                                referenceTable = referenceSchema.getTable(referenceTableName.substring(index + 1));
                            }
                            if (referenceTable == null) {
                                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31092, new Object[]{t.getFullName(), referenceTableName.substring(index + 1), referenceSchemaName}));
                                continue;
                            }
                        }
                        KeyRecord uniqueKey = null;
                        ArrayList<String> referenceColumns = fk.getReferenceColumns();
                        if (fk.getReferenceKey() != null) {
                            List cols = fk.getReferenceKey().getColumns();
                            referenceColumns = new ArrayList<String>();
                            Iterator iterator = cols.iterator();
                            while (iterator.hasNext()) {
                                Column col = (Column)iterator.next();
                                referenceColumns.add(col.getName());
                            }
                        }
                        if (referenceColumns == null || referenceColumns.isEmpty()) {
                            if (referenceTable.getPrimaryKey() == null) {
                                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31094, new Object[]{t.getFullName(), referenceTableName.substring(index + 1), referenceSchemaName}));
                            } else {
                                uniqueKey = referenceTable.getPrimaryKey();
                            }
                        } else {
                            for (KeyRecord record : referenceTable.getUniqueKeys()) {
                                if (!this.keyMatches(referenceColumns, record)) continue;
                                uniqueKey = record;
                                break;
                            }
                            if (uniqueKey == null && referenceTable.getPrimaryKey() != null && this.keyMatches(referenceColumns, referenceTable.getPrimaryKey())) {
                                uniqueKey = referenceTable.getPrimaryKey();
                            }
                            if (uniqueKey != null && referenceColumns.size() > 1) {
                                boolean correct = false;
                                for (int i = 0; i < referenceColumns.size(); ++i) {
                                    String keyCol;
                                    String ref = (String)referenceColumns.get(i);
                                    if (ref.equalsIgnoreCase(keyCol = ((Column)uniqueKey.getColumns().get(i)).getName())) continue;
                                    correct = true;
                                }
                                if (correct) {
                                    TreeMap<String, Integer> keyNames = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
                                    for (Column c : uniqueKey.getColumns()) {
                                        keyNames.put(c.getName(), keyNames.size());
                                    }
                                    TreeMap reorderedCols = new TreeMap();
                                    for (int i = 0; i < referenceColumns.size(); ++i) {
                                        int keyIndex = (Integer)keyNames.get(referenceColumns.get(i));
                                        reorderedCols.put(keyIndex, fk.getColumns().get(i));
                                    }
                                    fk.setColumns(new ArrayList(reorderedCols.values()));
                                }
                            }
                        }
                        if (uniqueKey == null) {
                            metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31095, new Object[]{t.getFullName(), referenceTableName.substring(index + 1), referenceSchemaName, referenceColumns}));
                            continue;
                        }
                        fk.setReferenceKey(uniqueKey);
                    }
                }
            }
        }
    }

    static class MatViewPropertiesValidator
    implements MetadataRule {
        MatViewPropertiesValidator() {
        }

        @Override
        public void execute(VDBMetaData vdb, MetadataStore store, ValidatorReport report, MetadataValidator metadataValidator) {
            for (Schema schema : store.getSchemaList()) {
                if (vdb.getImportedModels().contains(schema.getName())) continue;
                ModelMetaData model = vdb.getModel(schema.getName());
                for (Table t : schema.getTables().values()) {
                    String updatable;
                    if (!t.isVirtual() || !t.isMaterialized()) continue;
                    String pollingExpression = t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_POLLING_QUERY", false);
                    this.pollingQueryValidation(vdb, report, metadataValidator, model, t, pollingExpression, "{http://www.teiid.org/ext/relational/2012}MATVIEW_POLLING_QUERY");
                    if (t.getMaterializedTable() != null) {
                        String manage;
                        Table statusTable;
                        String stalenessString;
                        Table matTable = t.getMaterializedTable();
                        Table stageTable = t.getMaterializedStageTable();
                        t.setProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_OWNER_VDB_NAME", vdb.getName());
                        t.setProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_OWNER_VDB_VERSION", vdb.getVersion());
                        String beforeScript = t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_BEFORE_LOAD_SCRIPT", false);
                        String afterScript = t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_AFTER_LOAD_SCRIPT", false);
                        if (beforeScript == null || afterScript == null) {
                            metadataValidator.log(report, model, ModelMetaData.Message.Severity.WARNING, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31155, new Object[]{t.getFullName()}));
                        }
                        String matViewLoadNumberColumn = t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_LOADNUMBER_COLUMN", false);
                        this.verifyTableColumns(model, report, metadataValidator, t, matTable, matViewLoadNumberColumn);
                        if (stageTable != null) {
                            this.verifyTableColumns(model, report, metadataValidator, t, stageTable, matViewLoadNumberColumn);
                        }
                        if (matViewLoadNumberColumn != null) {
                            Column column = matTable.getColumnByName(matViewLoadNumberColumn);
                            if (column == null) {
                                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31218, new Object[]{t.getFullName(), matTable.getFullName(), matViewLoadNumberColumn}));
                                continue;
                            }
                            if (!column.getRuntimeType().equalsIgnoreCase("long")) {
                                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31215, new Object[]{t.getFullName(), matTable.getFullName(), matViewLoadNumberColumn, column.getRuntimeType()}));
                                continue;
                            }
                        }
                        String status = t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_STATUS_TABLE", false);
                        String loadScript = t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_LOAD_SCRIPT", false);
                        if (status == null) {
                            status = model.getPropertyValue("{http://www.teiid.org/ext/relational/2012}MATVIEW_STATUS_TABLE");
                            if (status == null && (status = vdb.getPropertyValue("{http://www.teiid.org/ext/relational/2012}MATVIEW_STATUS_TABLE")) == null) {
                                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31154, new Object[]{t.getFullName()}));
                                continue;
                            }
                            t.setProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_STATUS_TABLE", status);
                        }
                        if (matViewLoadNumberColumn == null && stageTable == null && loadScript == null) {
                            metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31216, new Object[]{t.getFullName()}));
                            continue;
                        }
                        String scope = t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_SHARE_SCOPE", false);
                        if (scope != null && !scope.equalsIgnoreCase(MaterializationMetadataRepository.Scope.IMPORTED.name()) && !scope.equalsIgnoreCase(MaterializationMetadataRepository.Scope.FULL.name())) {
                            metadataValidator.log(report, model, ModelMetaData.Message.Severity.WARNING, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31253, new Object[]{t.getFullName(), scope}));
                            t.setProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_SHARE_SCOPE", MaterializationMetadataRepository.Scope.IMPORTED.name());
                        }
                        if ((stalenessString = t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_MAX_STALENESS_PCT", false)) != null) {
                            final HashSet ids = new HashSet();
                            this.listPhysicalTables(t.getIncomingObjects(), new TableFilter(){

                                @Override
                                public void accept(Table physicalTable) {
                                    ids.add(physicalTable);
                                }
                            });
                            for (Table physicalTable : ids) {
                                this.addLazyMatViewTrigger(vdb, t, physicalTable, Table.TriggerEvent.INSERT);
                                this.addLazyMatViewTrigger(vdb, t, physicalTable, Table.TriggerEvent.UPDATE);
                                this.addLazyMatViewTrigger(vdb, t, physicalTable, Table.TriggerEvent.DELETE);
                            }
                        }
                        if ((statusTable = MetadataValidator.findTableByName(store, status)) == null) {
                            metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31197, new Object[]{t.getFullName(), status}));
                            continue;
                        }
                        TreeMap<String, Class> statusTypeMap = new TreeMap<String, Class>(String.CASE_INSENSITIVE_ORDER);
                        statusTypeMap.put("VDBNAME", DataTypeManager.DefaultDataClasses.STRING);
                        statusTypeMap.put("VDBVERSION", DataTypeManager.DefaultDataClasses.STRING);
                        statusTypeMap.put("SCHEMANAME", DataTypeManager.DefaultDataClasses.STRING);
                        statusTypeMap.put("NAME", DataTypeManager.DefaultDataClasses.STRING);
                        statusTypeMap.put("TARGETSCHEMANAME", DataTypeManager.DefaultDataClasses.STRING);
                        statusTypeMap.put("TARGETNAME", DataTypeManager.DefaultDataClasses.STRING);
                        statusTypeMap.put("VALID", DataTypeManager.DefaultDataClasses.BOOLEAN);
                        statusTypeMap.put("LOADSTATE", DataTypeManager.DefaultDataClasses.STRING);
                        statusTypeMap.put("CARDINALITY", DataTypeManager.DefaultDataClasses.LONG);
                        statusTypeMap.put("UPDATED", DataTypeManager.DefaultDataClasses.TIMESTAMP);
                        statusTypeMap.put("LOADNUMBER", DataTypeManager.DefaultDataClasses.LONG);
                        statusTypeMap.put("NODENAME", DataTypeManager.DefaultDataClasses.STRING);
                        statusTypeMap.put("STALECOUNT", DataTypeManager.DefaultDataClasses.LONG);
                        List statusColumns = statusTable.getColumns();
                        for (int i = 0; i < statusColumns.size(); ++i) {
                            Class type;
                            String name = ((Column)statusColumns.get(i)).getName();
                            Class expectedType = (Class)statusTypeMap.remove(name);
                            if (expectedType == null || (type = ((Column)statusColumns.get(i)).getJavaType()) == expectedType) continue;
                            metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31195, new Object[]{t.getName(), statusTable.getFullName(), name, type, expectedType}));
                        }
                        if (!statusTypeMap.isEmpty()) {
                            metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31196, new Object[]{t.getName(), statusTable.getFullName(), statusTypeMap.keySet()}));
                        }
                        if (Boolean.valueOf(manage = t.getProperty("{http://www.teiid.org/ext/relational/2012}ALLOW_MATVIEW_MANAGEMENT", false)).booleanValue()) {
                            this.loadScriptsValidation(vdb, report, metadataValidator, model, t, t.getProperty("{http://www.teiid.org/ext/relational/2012}ON_VDB_START_SCRIPT", false), "ON_VDB_START_SCRIPT");
                            this.loadScriptsValidation(vdb, report, metadataValidator, model, t, t.getProperty("{http://www.teiid.org/ext/relational/2012}ON_VDB_DROP_SCRIPT", false), "ON_VDB_DROP_SCRIPT");
                        }
                        this.loadScriptsValidation(vdb, report, metadataValidator, model, t, t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_BEFORE_LOAD_SCRIPT", false), "MATVIEW_BEFORE_LOAD_SCRIPT");
                        this.loadScriptsValidation(vdb, report, metadataValidator, model, t, t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_LOAD_SCRIPT", false), "MATVIEW_LOAD_SCRIPT");
                        this.loadScriptsValidation(vdb, report, metadataValidator, model, t, t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_AFTER_LOAD_SCRIPT", false), "MATVIEW_AFTER_LOAD_SCRIPT");
                        continue;
                    }
                    String manage = t.getProperty("{http://www.teiid.org/ext/relational/2012}ALLOW_MATVIEW_MANAGEMENT", false);
                    if (!Boolean.valueOf(manage).booleanValue() || (updatable = t.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_UPDATABLE", false)) != null && Boolean.parseBoolean(updatable)) continue;
                    metadataValidator.log(report, model, ModelMetaData.Message.Severity.WARNING, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31217, new Object[]{t.getFullName()}));
                }
            }
        }

        private void listPhysicalTables(Collection<AbstractMetadataRecord> records, TableFilter tableFilter) {
            for (AbstractMetadataRecord record : records) {
                Procedure proc;
                if (record instanceof Table) {
                    Table table = (Table)record;
                    if (table.isPhysical()) {
                        tableFilter.accept(table);
                        continue;
                    }
                    this.listPhysicalTables(table.getIncomingObjects(), tableFilter);
                    continue;
                }
                if (!(record instanceof Procedure) || !(proc = (Procedure)record).isVirtual()) continue;
                this.listPhysicalTables(proc.getIncomingObjects(), tableFilter);
            }
        }

        private void addLazyMatViewTrigger(VDBMetaData vdb, Table t, Table st, Table.TriggerEvent event) {
            String name = "ON_" + st.getName() + "_" + event.name() + "_FOR_" + t.getName() + "_FOR_LAZY_SNAPSHOT";
            String plan = "FOR EACH ROW\nBEGIN ATOMIC\nEXECUTE SYSADMIN.updateStaleCount(schemaName=>'" + ((Schema)t.getParent()).getName() + "', viewName=>'" + t.getName() + "');\nEND\n";
            Trigger trigger = new Trigger();
            trigger.setName(name);
            trigger.setEvent(event);
            trigger.setPlan(plan);
            trigger.setAfter(true);
            trigger.setProperty("TEIID_GENERATED", "true");
            st.getTriggers().put(name, trigger);
            LogManager.logDetail((String)"org.teiid.PROCESSOR.MATVIEWS", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31256, new Object[]{st.getName(), t.getName()}));
        }

        private void loadScriptsValidation(VDBMetaData vdb, ValidatorReport report, MetadataValidator metadataValidator, ModelMetaData model, Table matView, String script, String option) {
            if (script == null) {
                return;
            }
            QueryMetadataInterface metadata = (QueryMetadataInterface)vdb.getAttachment(QueryMetadataInterface.class);
            QueryParser queryParser = QueryParser.getQueryParser();
            try {
                Command command = queryParser.parseCommand(script);
                if (command instanceof CreateProcedureCommand) {
                    ((CreateProcedureCommand)command).setResultSetColumns(Collections.EMPTY_LIST);
                }
                QueryResolver.resolveCommand(command, metadata);
                ValidationVisitor visitor = new ValidationVisitor();
                ValidatorReport subReport = Validator.validate(command, metadata, visitor);
                metadataValidator.processReport(model, (AbstractMetadataRecord)matView, report, subReport);
            }
            catch (QueryParserException | QueryResolverException | TeiidComponentException e) {
                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31198, new Object[]{matView.getFullName(), option, script, e}));
            }
        }

        private void pollingQueryValidation(VDBMetaData vdb, ValidatorReport report, MetadataValidator metadataValidator, ModelMetaData model, Table matView, String query, String option) {
            if (query == null) {
                return;
            }
            QueryMetadataInterface metadata = (QueryMetadataInterface)vdb.getAttachment(QueryMetadataInterface.class);
            QueryParser queryParser = QueryParser.getQueryParser();
            try {
                Command command = queryParser.parseCommand(query);
                QueryResolver.resolveCommand(command, metadata);
                ValidationVisitor visitor = new ValidationVisitor();
                ValidatorReport subReport = Validator.validate(command, metadata, visitor);
                metadataValidator.processReport(model, (AbstractMetadataRecord)matView, report, subReport);
                if (command.getResultSetColumns().size() != 1 || command.getResultSetColumns().get(0).getType() != DataTypeManager.DefaultDataClasses.TIMESTAMP) {
                    throw new QueryResolverException("Expected 1 timestampe result column");
                }
            }
            catch (QueryParserException | QueryResolverException | TeiidComponentException e) {
                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31269, new Object[]{matView.getFullName(), option, query, e}));
            }
        }

        private void verifyTableColumns(ModelMetaData model, ValidatorReport report, MetadataValidator metadataValidator, Table view, Table matView, String ignoreColumnOnMatView) {
            List columns = view.getColumns();
            for (int i = 0; i < columns.size(); ++i) {
                Column column = (Column)columns.get(i);
                Column matViewColumn = matView.getColumnByName(column.getName());
                if (matViewColumn == null) {
                    metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31193, new Object[]{column.getName(), matView.getFullName(), view.getFullName()}));
                    continue;
                }
                if (column.getDatatypeUUID().equals(matViewColumn.getDatatypeUUID())) continue;
                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31194, new Object[]{matViewColumn.getName(), matView.getFullName(), column.getName(), view.getFullName()}));
            }
        }

        static interface TableFilter {
            public void accept(Table var1);
        }
    }

    static class ResolveQueryPlans
    implements MetadataRule {
        ResolveQueryPlans() {
        }

        @Override
        public void execute(VDBMetaData vdb, MetadataStore store, ValidatorReport report, MetadataValidator metadataValidator) {
            QueryMetadataInterface metadata = (QueryMetadataInterface)vdb.getAttachment(QueryMetadataInterface.class);
            metadata = new TempMetadataAdapter(metadata, new TempMetadataStore());
            for (Schema schema : store.getSchemaList()) {
                if (vdb.getImportedModels().contains(schema.getName())) continue;
                ModelMetaData model = vdb.getModel(schema.getName());
                MetadataFactory mf = new MetadataFactory(vdb.getName(), vdb.getVersion(), metadataValidator.typeMap, model){

                    protected void setUUID(AbstractMetadataRecord record) {
                        if (this.count >= 0) {
                            this.count = Integer.MIN_VALUE;
                        }
                        super.setUUID(record);
                    }
                };
                for (AbstractMetadataRecord record : schema.getResolvingOrder()) {
                    Procedure p;
                    if (record instanceof Table) {
                        Table t = (Table)record;
                        if (t.getTableType() == Table.Type.Document || t.getTableType() == Table.Type.XmlMappingClass || t.getTableType() == Table.Type.XmlStagingTable || t.getTableType() == Table.Type.TemporaryTable) continue;
                        if (t.isVirtual()) {
                            if (t.getSelectTransformation() == null) {
                                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31079, new Object[]{t.getFullName(), model.getName()}));
                                continue;
                            }
                            metadataValidator.validate(vdb, model, (AbstractMetadataRecord)t, report, metadata, mf);
                            continue;
                        }
                        for (Trigger tr : t.getTriggers().values()) {
                            int commandType = 2;
                            if (tr.getEvent() == Table.TriggerEvent.DELETE) {
                                commandType = 4;
                            } else if (tr.getEvent() == Table.TriggerEvent.UPDATE) {
                                commandType = 3;
                            }
                            try {
                                metadataValidator.validateUpdatePlan(model, report, metadata, t, tr.getPlan(), commandType);
                            }
                            catch (TeiidException e) {
                                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31080, new Object[]{record.getFullName(), e.getMessage()}));
                            }
                        }
                        continue;
                    }
                    if (!(record instanceof Procedure) || !(p = (Procedure)record).isVirtual()) continue;
                    if (p.getQueryPlan() == null) {
                        metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31081, new Object[]{p.getFullName(), model.getName()}));
                        continue;
                    }
                    metadataValidator.validate(vdb, model, (AbstractMetadataRecord)p, report, metadata, mf);
                }
            }
        }
    }

    static class SourceModelArtifacts
    implements MetadataRule {
        SourceModelArtifacts() {
        }

        @Override
        public void execute(VDBMetaData vdb, MetadataStore store, ValidatorReport report, MetadataValidator metadataValidator) {
            for (Schema schema : store.getSchemaList()) {
                if (vdb.getImportedModels().contains(schema.getName())) continue;
                ModelMetaData model = vdb.getModel(schema.getName());
                for (Table t : schema.getTables().values()) {
                    if (!t.isPhysical() || model.isSource()) continue;
                    metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31075, new Object[]{t.getFullName(), model.getName()}));
                }
                HashSet<String> names = new HashSet<String>();
                for (Procedure p : schema.getProcedures().values()) {
                    boolean hasReturn = false;
                    names.clear();
                    for (int i = 0; i < p.getParameters().size(); ++i) {
                        ProcedureParameter param = (ProcedureParameter)p.getParameters().get(i);
                        if (param.isVarArg() && param != p.getParameters().get(p.getParameters().size() - 1)) {
                            for (int j = i + 1; j < p.getParameters().size(); ++j) {
                                ProcedureParameter param1 = (ProcedureParameter)p.getParameters().get(j);
                                if (param1.getType() != ProcedureParameter.Type.In && param1.getType() != ProcedureParameter.Type.InOut || !param1.isVarArg() && (param1.getNullType() == BaseColumn.NullType.Nullable || param1.getDefaultValue() != null)) continue;
                                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31112, new Object[]{p.getFullName()}));
                            }
                        }
                        if (param.getType() == ProcedureParameter.Type.ReturnValue) {
                            if (hasReturn) {
                                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31107, new Object[]{p.getFullName()}));
                            }
                            hasReturn = true;
                        } else if (p.isFunction() && param.getType() != ProcedureParameter.Type.In) {
                            metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31165, new Object[]{p.getFullName(), param.getFullName()}));
                        }
                        if (names.add(param.getName())) continue;
                        metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31106, new Object[]{p.getFullName(), param.getFullName()}));
                    }
                    if (!p.isVirtual() && !model.isSource()) {
                        metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31077, new Object[]{p.getFullName(), model.getName()}));
                    }
                    if (!p.isFunction()) continue;
                    if (!hasReturn) {
                        metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31166, new Object[]{p.getFullName()}));
                    }
                    if (!p.isVirtual() || p.getQueryPlan() != null) continue;
                    metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31167, new Object[]{p.getFullName()}));
                }
                for (FunctionMethod func : schema.getFunctions().values()) {
                    for (FunctionParameter param : func.getInputParameters()) {
                        if (!param.isVarArg() || param == func.getInputParameters().get(func.getInputParameterCount() - 1)) continue;
                        metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31112, new Object[]{func.getFullName()}));
                    }
                    if (!func.getPushdown().equals((Object)FunctionMethod.PushDown.MUST_PUSHDOWN) || model.isSource()) continue;
                    metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31078, new Object[]{func.getFullName(), model.getName()}));
                }
            }
        }
    }

    static class MinimalMetadata
    implements MetadataRule {
        MinimalMetadata() {
        }

        @Override
        public void execute(VDBMetaData vdb, MetadataStore store, ValidatorReport report, MetadataValidator metadataValidator) {
            for (Schema schema : store.getSchemaList()) {
                if (vdb.getImportedModels().contains(schema.getName())) continue;
                ModelMetaData model = vdb.getModel(schema.getName());
                if (schema.getTables().isEmpty() && schema.getProcedures().isEmpty() && schema.getFunctions().isEmpty()) {
                    metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31070, new Object[]{model.getName()}));
                }
                for (Table t : schema.getTables().values()) {
                    if (t.getColumns() == null || t.getColumns().size() == 0) {
                        metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31071, new Object[]{t.getFullName()}));
                    }
                    TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                    this.validateConstraintNames(metadataValidator, report, model, t.getAllKeys(), names);
                    this.validateConstraintNames(metadataValidator, report, model, t.getFunctionBasedIndexes(), names);
                }
                if (schema.getFunctions().isEmpty()) continue;
                ActivityReport funcReport = new ActivityReport("Translator metadata load " + model.getName());
                FunctionMetadataValidator.validateFunctionMethods(schema.getFunctions().values(), report, store.getDatatypes());
                if (!report.hasItems()) continue;
                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31073, new Object[]{funcReport}));
            }
        }

        private void validateConstraintNames(MetadataValidator metadataValidator, ValidatorReport report, ModelMetaData model, Collection<KeyRecord> keys, Set<String> names) {
            for (KeyRecord record : keys) {
                if (record.getName() == null || names.add(record.getName())) continue;
                metadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31152, new Object[]{record.getFullName()}));
            }
        }
    }

    static interface MetadataRule {
        public void execute(VDBMetaData var1, MetadataStore var2, ValidatorReport var3, MetadataValidator var4);
    }
}

