/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.core.util.LRUCache;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Symbol;

public class TempMetadataID
implements Serializable,
AbstractMetadataRecord.Modifiable,
AbstractMetadataRecord.DataModifiable {
    private static final long serialVersionUID = -1879211827339120135L;
    private static final int LOCAL_CACHE_SIZE = 8;
    private static final int MOD_COUNT_FOR_COST_UPDATE = 8;
    private static TableData DUMMY_DATA = new TableData();
    private String ID;
    private String name;
    private Type metadataType = Type.VIRTUAL;
    private Object originalMetadataID;
    private TableData data;
    private int position;
    private Class<?> type;
    private boolean autoIncrement;
    private boolean notNull;
    private boolean updatable;

    public TempMetadataID(String ID, List<TempMetadataID> elements) {
        this(ID, elements, Type.VIRTUAL);
    }

    public TempMetadataID(String ID, List<TempMetadataID> elements, Type type) {
        this.data = new TableData();
        this.ID = ID;
        this.data.elements = elements;
        int pos = 1;
        for (TempMetadataID tempMetadataID : elements) {
            tempMetadataID.setPosition(pos++);
        }
        this.name = ID;
        this.metadataType = type;
    }

    public TempMetadataID(String ID, Class<?> type) {
        this.ID = ID;
        this.type = type;
    }

    public TempMetadataID(String ID, Class<?> type, Object metadataID) {
        this.ID = ID;
        this.type = type;
        this.originalMetadataID = metadataID;
    }

    public long getLastDataModification() {
        return this.getTableData().getLastDataModification();
    }

    public long getLastModified() {
        return this.getTableData().getLastModified();
    }

    public String getID() {
        return this.ID;
    }

    public Class<?> getType() {
        return this.type;
    }

    public List<TempMetadataID> getElements() {
        return this.getTableData().elements;
    }

    protected void addElement(TempMetadataID elem) {
        if (this.getTableData().elements != null) {
            this.getTableData().elements.add(elem);
            elem.setPosition(this.getTableData().elements.size());
        }
        if (this.getTableData().localCache != null) {
            this.getTableData().localCache.clear();
        }
    }

    public boolean isVirtual() {
        return this.metadataType == Type.VIRTUAL;
    }

    public boolean isTempTable() {
        return this.metadataType == Type.TEMP;
    }

    public String toString() {
        return this.ID;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TempMetadataID)) {
            return false;
        }
        return this.getID().equals(((TempMetadataID)obj).getID());
    }

    public int hashCode() {
        return this.ID.hashCode();
    }

    public void setOriginalMetadataID(Object metadataId) {
        this.originalMetadataID = metadataId;
    }

    public Object getOriginalMetadataID() {
        return this.originalMetadataID;
    }

    public Collection<TempMetadataID> getAccessPatterns() {
        if (this.getTableData().accessPatterns == null) {
            return Collections.emptyList();
        }
        return this.getTableData().accessPatterns;
    }

    public void setAccessPatterns(Collection<TempMetadataID> accessPatterns) {
        this.getTableData().accessPatterns = accessPatterns;
    }

    public long getCardinality() {
        return this.getTableData().cardinality;
    }

    public void setCardinality(long cardinality) {
        this.getTableData().cardinality = cardinality;
    }

    public void setTempTable(boolean isTempTable) {
        this.metadataType = isTempTable ? Type.TEMP : Type.VIRTUAL;
    }

    Object getProperty(Object key) {
        if (this.getTableData().localCache != null) {
            return this.getTableData().localCache.get(key);
        }
        return null;
    }

    Object setProperty(Object key, Object value) {
        if (this.getTableData().localCache == null) {
            this.getTableData().localCache = Collections.synchronizedMap(new LRUCache(8));
        }
        return this.getTableData().localCache.put(key, value);
    }

    public boolean isScalarGroup() {
        return this.metadataType == Type.SCALAR;
    }

    public void setMetadataType(Type metadataType) {
        this.metadataType = metadataType;
    }

    public Type getMetadataType() {
        return this.metadataType;
    }

    public List<TempMetadataID> getPrimaryKey() {
        return this.getTableData().primaryKey;
    }

    public void setPrimaryKey(List<TempMetadataID> primaryKey) {
        this.getTableData().primaryKey = primaryKey;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public QueryNode getQueryNode() {
        return this.getTableData().queryNode;
    }

    public void setQueryNode(QueryNode queryNode) {
        this.getTableData().queryNode = queryNode;
    }

    public CacheHint getCacheHint() {
        return this.getTableData().cacheHint;
    }

    public void setCacheHint(CacheHint cacheHint) {
        this.getTableData().cacheHint = cacheHint;
    }

    public List<TempMetadataID> getIndexes() {
        return this.getTableData().indexes;
    }

    public void addIndex(Object originalMetadataId, List<TempMetadataID> index) {
        if (this.getTableData().indexes == null) {
            this.getTableData().indexes = new LinkedList<TempMetadataID>();
        }
        TempMetadataID id = new TempMetadataID(this.ID, Collections.EMPTY_LIST, Type.INDEX);
        id.getTableData().elements = index;
        id.setOriginalMetadataID(originalMetadataId);
        this.getTableData().indexes.add(id);
    }

    public List<List<TempMetadataID>> getUniqueKeys() {
        return this.getTableData().keys;
    }

    public void addUniqueKey(List<TempMetadataID> key) {
        if (this.getTableData().keys == null) {
            this.getTableData().keys = new LinkedList<List<TempMetadataID>>();
        }
        this.getTableData().keys.add(key);
    }

    public TableData getTableData() {
        if (this.data == null) {
            return DUMMY_DATA;
        }
        return this.data;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public void setNotNull(boolean notNull) {
        this.notNull = notNull;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public String getName() {
        if (this.name == null) {
            this.name = Symbol.getShortName(this.ID);
        }
        return this.name;
    }

    public static enum Type {
        VIRTUAL,
        TEMP,
        SCALAR,
        INDEX;

    }

    public static class TableData {
        Collection<TempMetadataID> accessPatterns;
        List<TempMetadataID> elements;
        long cardinality = -1L;
        List<TempMetadataID> primaryKey;
        QueryNode queryNode;
        Map<Object, Object> localCache;
        volatile CacheHint cacheHint;
        long cacheHintUpdated;
        List<List<TempMetadataID>> keys;
        List<TempMetadataID> indexes;
        volatile long lastDataModification;
        volatile long lastModified = System.currentTimeMillis();
        int modCount;
        private LinkedHashMap<Expression, Integer> functionBasedExpressions;
        private Object model;

        public long getLastDataModification() {
            return this.lastDataModification;
        }

        public void removed() {
            this.lastModified = -1L;
        }

        public void dataModified(long updateCount) {
            if (updateCount == 0L) {
                return;
            }
            long ts = System.currentTimeMillis();
            this.modCount = (int)((long)this.modCount + updateCount);
            if (this.modCount > 8) {
                this.lastModified = ts;
                this.modCount = 0;
            }
            this.lastDataModification = ts;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public void setFunctionBasedExpressions(LinkedHashMap<Expression, Integer> newExprs) {
            this.functionBasedExpressions = newExprs;
        }

        public LinkedHashMap<Expression, Integer> getFunctionBasedExpressions() {
            return this.functionBasedExpressions;
        }

        public void setModel(Object mid) {
            this.model = mid;
        }

        public Object getModel() {
            return this.model;
        }

        public synchronized boolean updateCacheHint(long time) {
            if (time >= this.cacheHintUpdated) {
                this.cacheHintUpdated = time;
                return true;
            }
            return false;
        }
    }
}

