/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.util.StringUtil;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Drop;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.SourceHint;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.util.CommandContext;

public final class RulePlaceAccess
implements OptimizerRule {
    public static final String CONFORMED_SOURCES = "{http://www.teiid.org/ext/relational/2012}conformed-sources";
    public static final String RECONTEXT_STRING = "__";

    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        Set<String> groups = context.getGroups();
        boolean[] addtionalRules = new boolean[2];
        for (PlanNode sourceNode : NodeEditor.findAllNodes(plan, 64)) {
            this.addAccessNode(metadata, sourceNode, capFinder, addtionalRules);
            this.addAlias(sourceNode, context, groups, metadata);
        }
        if (addtionalRules[0]) {
            rules.addLast(RuleConstants.ACCESS_PATTERN_VALIDATION);
        }
        if (addtionalRules[1]) {
            rules.addLast(RuleConstants.VALIDATE_WHERE_ALL);
        }
        return plan;
    }

    private void addAccessNode(QueryMetadataInterface metadata, PlanNode sourceNode, CapabilitiesFinder finder, boolean[] additionalRules) throws QueryMetadataException, TeiidComponentException {
        boolean isInsert = false;
        Object req = sourceNode.getProperty(NodeConstants.Info.ATOMIC_REQUEST);
        if (req == null) {
            req = sourceNode.getProperty(NodeConstants.Info.NESTED_COMMAND);
        }
        if (sourceNode.getProperty(NodeConstants.Info.TABLE_FUNCTION) != null) {
            return;
        }
        if (req instanceof Insert) {
            isInsert = true;
        } else {
            PlanNode parent = sourceNode.getParent();
            if (parent.getType() == 8 && parent.getProperty(NodeConstants.Info.INTO_GROUP) != null) {
                isInsert = true;
            }
        }
        PlanNode apNode = sourceNode;
        if (sourceNode.getChildCount() == 0) {
            GroupSymbol group;
            Object gid;
            String sources;
            GroupSymbol gs;
            PlanNode accessNode = NodeFactory.getNewNode(1);
            accessNode.addGroups(sourceNode.getGroups());
            RulePlaceAccess.copyProperties(sourceNode, accessNode);
            SourceHint sourceHint = (SourceHint)sourceNode.removeProperty((Object)NodeConstants.Info.SOURCE_HINT);
            accessNode.setProperty(NodeConstants.Info.SOURCE_HINT, sourceHint);
            Object hint = sourceNode.removeProperty((Object)NodeConstants.Info.IS_OPTIONAL);
            if (hint != null) {
                accessNode.setProperty(NodeConstants.Info.IS_OPTIONAL, hint);
            }
            Object modelId = null;
            if (sourceNode.getGroups().size() == 1 && (modelId = (gs = sourceNode.getGroups().iterator().next()).getModelMetadataId()) != null) {
                accessNode.setProperty(NodeConstants.Info.MODEL_ID, modelId);
            }
            if ((modelId = req instanceof Create || req instanceof Drop ? TempMetadataAdapter.TEMP_MODEL : RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata)) != null) {
                boolean multiSource = metadata.isMultiSource(modelId);
                if (multiSource) {
                    accessNode.setProperty(NodeConstants.Info.IS_MULTI_SOURCE, multiSource);
                }
                accessNode.setProperty(NodeConstants.Info.MODEL_ID, modelId);
            }
            if (req == null && modelId != null && (sources = metadata.getExtensionProperty(gid = (group = sourceNode.getGroups().iterator().next()).getMetadataID(), CONFORMED_SOURCES, false)) != null) {
                LinkedHashSet<Object> conformed = new LinkedHashSet<Object>();
                conformed.add(modelId);
                for (String source : StringUtil.split((String)sources, (String)",")) {
                    Object mid = metadata.getModelID(source.trim());
                    if (metadata.isVirtualModel(mid)) {
                        throw new QueryMetadataException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31148, new Object[]{metadata.getName(mid), group}));
                    }
                    conformed.add(mid);
                }
                accessNode.setProperty(NodeConstants.Info.CONFORMED_SOURCES, conformed);
            }
            sourceNode.addAsParent(accessNode);
            apNode = accessNode;
            for (GroupSymbol group2 : accessNode.getGroups()) {
                Object modelID;
                if (group2.getCheckMatViewStatus() != null) {
                    LinkedHashSet<Object> viewsToCheck = new LinkedHashSet<Object>();
                    viewsToCheck.add(group2.getCheckMatViewStatus());
                    accessNode.setProperty(NodeConstants.Info.CHECK_MAT_VIEW, viewsToCheck);
                }
                if (!CapabilitiesUtil.requiresCriteria(modelID = metadata.getModelID(group2.getMetadataID()), metadata, finder)) continue;
                additionalRules[1] = true;
            }
        }
        if (!isInsert && RulePlaceAccess.addAccessPatternsProperty(apNode, metadata)) {
            additionalRules[0] = true;
        }
    }

    private void addAlias(PlanNode sourceNode, CommandContext cc, Set<String> groups, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        if (sourceNode.getGroups().isEmpty()) {
            return;
        }
        if (FrameUtil.getNonQueryCommand(sourceNode.getParent()) != null) {
            return;
        }
        PlanNode parentProject = NodeEditor.findParent(sourceNode, 8);
        if (parentProject.hasProperty(NodeConstants.Info.INTO_GROUP)) {
            return;
        }
        GroupSymbol group = sourceNode.getGroups().iterator().next();
        if (groups.add(group.getName())) {
            if (group.getDefinition() != null) {
                cc.getAliasMapping().put(group.getName(), group.getName());
            }
            return;
        }
        List<PlanNode> childProjects = null;
        if (sourceNode.getChildCount() > 0) {
            childProjects = NodeEditor.findAllNodes(sourceNode.getFirstChild(), 8, 64);
        }
        GroupSymbol newGroup = RulePlaceAccess.recontextSymbol(group, groups);
        if (group.getDefinition() != null) {
            cc.getAliasMapping().put(newGroup.getName(), group.getName());
        }
        LinkedHashMap<ElementSymbol, Expression> replacementSymbols = FrameUtil.buildSymbolMap(group, newGroup, metadata);
        FrameUtil.convertFrame(sourceNode, group, new HashSet<GroupSymbol>(Arrays.asList(newGroup)), replacementSymbols, metadata);
        if (childProjects != null) {
            SymbolMap symbolMap = (SymbolMap)sourceNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
            SymbolMap replacementMap = new SymbolMap();
            for (Map.Entry<ElementSymbol, Expression> entry : symbolMap.asMap().entrySet()) {
                replacementMap.addMapping((ElementSymbol)replacementSymbols.get(entry.getKey()), entry.getValue());
            }
            sourceNode.setProperty(NodeConstants.Info.SYMBOL_MAP, replacementMap);
        }
    }

    public static GroupSymbol recontextSymbol(GroupSymbol oldSymbol, Set<String> names) {
        String oldName = oldSymbol.getName();
        int dotIndex = oldName.lastIndexOf(".");
        if (dotIndex >= 0) {
            oldName = oldName.substring(dotIndex + 1);
        }
        int recontextNumber = 1;
        int recontextIndex = oldName.lastIndexOf(RECONTEXT_STRING);
        if (recontextIndex >= 0) {
            try {
                recontextNumber = Integer.parseInt(oldName.substring(recontextIndex + RECONTEXT_STRING.length())) + 1;
                oldName = oldName.substring(0, recontextIndex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String newName = null;
        while (!names.add(newName = oldName + RECONTEXT_STRING + recontextNumber++)) {
        }
        String newDefinition = null;
        newDefinition = oldSymbol.getDefinition() == null ? oldSymbol.getName() : oldSymbol.getDefinition();
        GroupSymbol newSymbol = oldSymbol.clone();
        newSymbol.setName(newName);
        newSymbol.setDefinition(newDefinition);
        return newSymbol;
    }

    static void copyProperties(PlanNode node, PlanNode copyTo) {
        Set toCheck;
        Object hint = node.getProperty(NodeConstants.Info.MAKE_DEP);
        if (hint != null) {
            copyTo.setProperty(NodeConstants.Info.MAKE_DEP, hint);
        }
        if ((hint = node.getProperty(NodeConstants.Info.MAKE_NOT_DEP)) != null) {
            copyTo.setProperty(NodeConstants.Info.MAKE_NOT_DEP, hint);
        }
        if ((hint = node.getProperty(NodeConstants.Info.MAKE_IND)) != null) {
            copyTo.setProperty(NodeConstants.Info.MAKE_IND, hint);
        }
        if ((toCheck = (Set)node.getProperty(NodeConstants.Info.CHECK_MAT_VIEW)) != null) {
            Set existing = (Set)copyTo.getProperty(NodeConstants.Info.CHECK_MAT_VIEW);
            if (existing != null) {
                existing.addAll(toCheck);
            } else {
                copyTo.setProperty(NodeConstants.Info.CHECK_MAT_VIEW, new LinkedHashSet(toCheck));
            }
        }
    }

    static boolean addAccessPatternsProperty(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        if (node.hasCollectionProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
            return false;
        }
        List patternElements = ResolverUtil.getAccessPatternElementsInGroups(metadata, node.getGroups(), false);
        if (patternElements == null) {
            return false;
        }
        Collections.sort(patternElements);
        node.setProperty(NodeConstants.Info.ACCESS_PATTERNS, patternElements);
        return true;
    }

    public String toString() {
        return "PlaceAccess";
    }
}

