/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.JoinUtil;
import org.teiid.query.optimizer.relational.rules.RuleChooseJoinStrategy;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.optimizer.relational.rules.RulePlaceAccess;
import org.teiid.query.optimizer.relational.rules.RulePlanJoins;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.util.CommandContext;

public class RulePlanOuterJoins
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        boolean beforeJoinPlanning = rules.contains(RuleConstants.PLAN_JOINS);
        while (beforeJoinPlanning ? this.planLeftOuterJoinAssociativityBeforePlanning(plan, metadata, capabilitiesFinder, analysisRecord, context) : this.planLeftOuterJoinAssociativity(plan, metadata, capabilitiesFinder, analysisRecord, context)) {
        }
        return plan;
    }

    private boolean planLeftOuterJoinAssociativity(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryMetadataException, TeiidComponentException {
        boolean changedAny = false;
        LinkedHashSet<PlanNode> joins = new LinkedHashSet<PlanNode>(NodeEditor.findAllNodes(plan, 4, 1));
        while (!joins.isEmpty()) {
            PlanNode aSource;
            PlanNode newChild;
            PlanNode newParent;
            Object modelId;
            List childJoinCriteria;
            List joinCriteria;
            PlanNode cSource;
            Iterator i = joins.iterator();
            PlanNode join = (PlanNode)i.next();
            i.remove();
            if (!join.getProperty(NodeConstants.Info.JOIN_TYPE).equals(JoinType.JOIN_LEFT_OUTER) || join.hasBooleanProperty(NodeConstants.Info.PRESERVE)) continue;
            PlanNode childJoin = null;
            PlanNode other = null;
            PlanNode left = join.getFirstChild();
            PlanNode right = join.getLastChild();
            if (left.getType() == 4 && left.getProperty(NodeConstants.Info.JOIN_TYPE) == JoinType.JOIN_LEFT_OUTER) {
                childJoin = left;
                other = right;
            } else {
                if (right.getType() != 4 || right.getProperty(NodeConstants.Info.JOIN_TYPE) != JoinType.JOIN_LEFT_OUTER && right.getProperty(NodeConstants.Info.JOIN_TYPE) != JoinType.JOIN_INNER) continue;
                childJoin = right;
                other = left;
            }
            if ((cSource = other).getType() != 1 || !this.isCriteriaValid(joinCriteria = (List)join.getProperty(NodeConstants.Info.JOIN_CRITERIA), metadata, join) || !this.isCriteriaValid(childJoinCriteria = (List)childJoin.getProperty(NodeConstants.Info.JOIN_CRITERIA), metadata, childJoin) || childJoin.hasBooleanProperty(NodeConstants.Info.PRESERVE)) continue;
            Set<GroupSymbol> groups = GroupsUsedByElementsVisitor.getGroups(joinCriteria);
            if (Collections.disjoint(groups, FrameUtil.findJoinSourceNode(childJoin == left ? childJoin.getFirstChild() : childJoin.getLastChild()).getGroups())) {
                PlanNode bSource = childJoin == left ? childJoin.getLastChild() : childJoin.getFirstChild();
                if (bSource.getType() != 1 || (modelId = RuleRaiseAccess.canRaiseOverJoin(childJoin == left ? Arrays.asList(bSource, cSource) : Arrays.asList(cSource, bSource), metadata, capabilitiesFinder, joinCriteria, JoinType.JOIN_LEFT_OUTER, analysisRecord, context, false, false)) == null) continue;
                newParent = RulePlanJoins.createJoinNode();
                newParent.setProperty(NodeConstants.Info.JOIN_TYPE, JoinType.JOIN_LEFT_OUTER);
                newChild = RulePlanJoins.createJoinNode();
                newChild.setProperty(NodeConstants.Info.JOIN_TYPE, JoinType.JOIN_LEFT_OUTER);
                joins.remove(childJoin);
                if (childJoin == left) {
                    newChild.addFirstChild(childJoin.getLastChild());
                    RulePlaceAccess.copyProperties(newChild.getFirstChild(), newChild);
                    newChild.addLastChild(other);
                    newChild.setProperty(NodeConstants.Info.JOIN_CRITERIA, joinCriteria);
                    newParent.addFirstChild(childJoin.getFirstChild());
                    newParent.addLastChild(newChild);
                    newParent.setProperty(NodeConstants.Info.JOIN_CRITERIA, childJoinCriteria);
                } else {
                    newChild.addFirstChild(other);
                    newChild.addLastChild(childJoin.getFirstChild());
                    newChild.setProperty(NodeConstants.Info.JOIN_CRITERIA, joinCriteria);
                    newParent.addFirstChild(newChild);
                    newParent.addLastChild(childJoin.getLastChild());
                    newParent.setProperty(NodeConstants.Info.JOIN_CRITERIA, childJoinCriteria);
                }
                this.updateGroups(newChild);
                this.updateGroups(newParent);
                join.getParent().replaceChild(join, newParent);
                if (!RuleRaiseAccess.checkConformedSubqueries(newChild.getFirstChild(), newChild, true)) continue;
                RuleRaiseAccess.raiseAccessOverJoin(newChild, newChild.getFirstChild(), modelId, capabilitiesFinder, metadata, true);
                changedAny = true;
                continue;
            }
            if (!Collections.disjoint(groups, FrameUtil.findJoinSourceNode(childJoin == right ? childJoin.getFirstChild() : childJoin.getLastChild()).getGroups()) || (aSource = childJoin == left ? childJoin.getFirstChild() : childJoin.getLastChild()).getType() != 1 || !join.getExportedCorrelatedReferences().isEmpty() || (modelId = RuleRaiseAccess.canRaiseOverJoin(childJoin == left ? Arrays.asList(aSource, cSource) : Arrays.asList(cSource, aSource), metadata, capabilitiesFinder, joinCriteria, JoinType.JOIN_LEFT_OUTER, analysisRecord, context, false, false)) == null) continue;
            newParent = RulePlanJoins.createJoinNode();
            newParent.setProperty(NodeConstants.Info.JOIN_TYPE, JoinType.JOIN_LEFT_OUTER);
            newChild = RulePlanJoins.createJoinNode();
            newChild.setProperty(NodeConstants.Info.JOIN_TYPE, JoinType.JOIN_LEFT_OUTER);
            joins.remove(childJoin);
            if (childJoin == left) {
                newChild.addFirstChild(childJoin.getFirstChild());
                newChild.addLastChild(other);
                newParent.addLastChild(childJoin.getLastChild());
            } else {
                newChild.addFirstChild(other);
                newChild.addLastChild(childJoin.getLastChild());
                newParent.addLastChild(childJoin.getFirstChild());
            }
            newChild.addGroups(newChild.getFirstChild().getGroups());
            newChild.setProperty(NodeConstants.Info.JOIN_CRITERIA, joinCriteria);
            newParent.addFirstChild(newChild);
            newParent.setProperty(NodeConstants.Info.JOIN_CRITERIA, childJoinCriteria);
            this.updateGroups(newChild);
            this.updateGroups(newParent);
            join.getParent().replaceChild(join, newParent);
            if (!RuleRaiseAccess.checkConformedSubqueries(newChild.getFirstChild(), newChild, true)) continue;
            RuleRaiseAccess.raiseAccessOverJoin(newChild, newChild.getFirstChild(), modelId, capabilitiesFinder, metadata, true);
            changedAny = true;
        }
        return changedAny;
    }

    private void updateGroups(PlanNode node) {
        node.addGroups(GroupsUsedByElementsVisitor.getGroups(node.getCorrelatedReferenceElements()));
        node.addGroups(FrameUtil.findJoinSourceNode(node.getFirstChild()).getGroups());
        node.addGroups(FrameUtil.findJoinSourceNode(node.getLastChild()).getGroups());
    }

    private boolean isCriteriaValid(List<Criteria> joinCriteria, QueryMetadataInterface metadata, PlanNode join) {
        if (joinCriteria.isEmpty()) {
            return false;
        }
        Set<GroupSymbol> groups = join.getGroups();
        for (Criteria crit : joinCriteria) {
            if (!JoinUtil.isNullDependent(metadata, groups, crit)) continue;
            return false;
        }
        return true;
    }

    private boolean planLeftOuterJoinAssociativityBeforePlanning(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryMetadataException, TeiidComponentException {
        boolean changedAny = false;
        LinkedHashSet<PlanNode> joins = new LinkedHashSet<PlanNode>(NodeEditor.findAllNodes(plan, 4, 1));
        while (!joins.isEmpty()) {
            Set<GroupSymbol> groups;
            List childJoinCriteria;
            Iterator i = joins.iterator();
            PlanNode join = (PlanNode)i.next();
            i.remove();
            if (join.hasBooleanProperty(NodeConstants.Info.PRESERVE) || this.checkLeftOrdering(metadata, capabilitiesFinder, analysisRecord, context, join) || !join.getProperty(NodeConstants.Info.JOIN_TYPE).equals(JoinType.JOIN_LEFT_OUTER)) continue;
            PlanNode childJoin = null;
            PlanNode other = null;
            PlanNode left = join.getFirstChild();
            PlanNode right = join.getLastChild();
            if (left.getType() != 4 || left.getProperty(NodeConstants.Info.JOIN_TYPE) != JoinType.JOIN_LEFT_OUTER) continue;
            childJoin = left;
            other = right;
            List joinCriteria = (List)join.getProperty(NodeConstants.Info.JOIN_CRITERIA);
            if (!this.isCriteriaValid(joinCriteria, metadata, join) || !this.isCriteriaValid(childJoinCriteria = (List)childJoin.getProperty(NodeConstants.Info.JOIN_CRITERIA), metadata, childJoin) || join.hasBooleanProperty(NodeConstants.Info.PRESERVE) || !Collections.disjoint(groups = GroupsUsedByElementsVisitor.getGroups(joinCriteria), FrameUtil.findJoinSourceNode(childJoin.getFirstChild()).getGroups())) continue;
            PlanNode newParent = RulePlanJoins.createJoinNode();
            newParent.setProperty(NodeConstants.Info.JOIN_TYPE, JoinType.JOIN_LEFT_OUTER);
            PlanNode newChild = RulePlanJoins.createJoinNode();
            newChild.setProperty(NodeConstants.Info.JOIN_TYPE, JoinType.JOIN_LEFT_OUTER);
            joins.remove(childJoin);
            newChild.addFirstChild(childJoin.getLastChild());
            RulePlaceAccess.copyProperties(newChild.getFirstChild(), newChild);
            newChild.addLastChild(other);
            newChild.setProperty(NodeConstants.Info.JOIN_CRITERIA, joinCriteria);
            newParent.addFirstChild(childJoin.getFirstChild());
            newParent.addLastChild(newChild);
            newParent.setProperty(NodeConstants.Info.JOIN_CRITERIA, childJoinCriteria);
            this.updateGroups(newChild);
            this.updateGroups(newParent);
            join.getParent().replaceChild(join, newParent);
            changedAny = true;
        }
        return changedAny;
    }

    private boolean checkLeftOrdering(QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, AnalysisRecord analysisRecord, CommandContext context, PlanNode join) throws QueryMetadataException, TeiidComponentException {
        if (join.getFirstChild().getType() != 4 || join.getFirstChild().getProperty(NodeConstants.Info.JOIN_TYPE) != JoinType.JOIN_LEFT_OUTER && join.getFirstChild().getProperty(NodeConstants.Info.JOIN_TYPE) != JoinType.JOIN_INNER) {
            return false;
        }
        PlanNode childJoin = null;
        PlanNode left = join.getFirstChild();
        PlanNode right = join.getLastChild();
        boolean nested = false;
        boolean hasOuter = join.getProperty(NodeConstants.Info.JOIN_TYPE) == JoinType.JOIN_LEFT_OUTER;
        childJoin = left;
        while (childJoin.getFirstChild() != null && childJoin.getFirstChild().getType() != 1) {
            if (childJoin.getType() != 4 || childJoin.getProperty(NodeConstants.Info.JOIN_TYPE) != JoinType.JOIN_LEFT_OUTER && childJoin.getProperty(NodeConstants.Info.JOIN_TYPE) != JoinType.JOIN_INNER) {
                return false;
            }
            hasOuter |= childJoin.getProperty(NodeConstants.Info.JOIN_TYPE) == JoinType.JOIN_LEFT_OUTER;
            List childJoinCriteria = (List)childJoin.getProperty(NodeConstants.Info.JOIN_CRITERIA);
            if (!this.isCriteriaValid(childJoinCriteria, metadata, childJoin)) {
                return false;
            }
            left = childJoin = childJoin.getFirstChild();
            nested = true;
        }
        if (nested && hasOuter && !left.hasBooleanProperty(NodeConstants.Info.PRESERVE)) {
            if (right.getType() != 1) {
                return false;
            }
            ArrayList<Criteria> joinCriteria = (ArrayList<Criteria>)join.getProperty(NodeConstants.Info.JOIN_CRITERIA);
            if (!this.isCriteriaValid((List<Criteria>)joinCriteria, metadata, join)) {
                return false;
            }
            joinCriteria = new ArrayList<Criteria>(joinCriteria);
            RuleChooseJoinStrategy.filterOptionalCriteria(joinCriteria, false);
            Set<GroupSymbol> groups = GroupsUsedByElementsVisitor.getGroups(joinCriteria);
            if (groups.containsAll(left.getFirstChild().getGroups()) && groups.containsAll(right.getGroups()) && groups.size() == left.getFirstChild().getGroups().size() + right.getGroups().size()) {
                Object modelId = RuleRaiseAccess.canRaiseOverJoin(Arrays.asList(left.getFirstChild(), right), metadata, capabilitiesFinder, joinCriteria, JoinType.JOIN_LEFT_OUTER, analysisRecord, context, false, false);
                if (modelId == null) {
                    return false;
                }
                PlanNode parent = join.getParent();
                parent.replaceChild(join, join.getFirstChild());
                join.removeAllChildren();
                left.getFirstChild().addAsParent(join);
                join.addLastChild(right);
                join.getGroups().clear();
                this.updateGroups(join);
                parent.getGroups().clear();
                this.updateGroups(parent);
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "PlanOuterJoins";
    }
}

