/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.Collections;
import java.util.List;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.relational.DependentProcedureCriteriaProcessor;
import org.teiid.query.processor.relational.PlanExecutionNode;
import org.teiid.query.processor.relational.ProjectNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.util.CommandContext;

public class DependentProcedureExecutionNode
extends PlanExecutionNode {
    private Criteria inputCriteria;
    private List inputReferences;
    private List inputDefaults;
    private DependentProcedureCriteriaProcessor criteriaProcessor;

    public DependentProcedureExecutionNode(int nodeID, Criteria crit, List references, List defaults) {
        super(nodeID);
        this.inputCriteria = crit;
        this.inputDefaults = defaults;
        this.inputReferences = references;
    }

    @Override
    public Object clone() {
        DependentProcedureExecutionNode copy = new DependentProcedureExecutionNode(this.getID(), (Criteria)this.inputCriteria.clone(), this.inputReferences, this.inputDefaults);
        this.copyTo(copy);
        return copy;
    }

    @Override
    public void reset() {
        super.reset();
        this.criteriaProcessor = null;
    }

    @Override
    public void closeDirect() {
        super.closeDirect();
        if (this.criteriaProcessor != null) {
            this.criteriaProcessor.close();
        }
    }

    @Override
    protected boolean prepareNextCommand() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.criteriaProcessor == null) {
            Criteria crit = (Criteria)this.inputCriteria.clone();
            crit = QueryRewriter.evaluateAndRewrite(crit, this.getEvaluator(Collections.emptyMap()), this.getContext(), this.getContext().getMetadata());
            this.criteriaProcessor = new DependentProcedureCriteriaProcessor(this, crit, this.inputReferences, this.inputDefaults);
        }
        return this.criteriaProcessor.prepareNextCommand(this.getProcessorPlan().getContext().getVariableContext());
    }

    @Override
    protected boolean hasNextCommand() {
        return this.criteriaProcessor.hasNextCommand();
    }

    public Criteria getInputCriteria() {
        return this.inputCriteria;
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        super.open();
        DependentProcedureExecutionNode.shareVariableContext(this, this.getProcessorPlan().getContext());
    }

    public static void shareVariableContext(RelationalNode node, CommandContext context) {
        int projectCount = 0;
        for (RelationalNode parent = node.getParent(); parent != null && projectCount < 2; parent = parent.getParent()) {
            parent.setContext(context);
            if (!(parent instanceof ProjectNode)) continue;
            ++projectCount;
        }
    }

    @Override
    public Boolean requiresTransaction(boolean transactionalReads) {
        Boolean requires = super.requiresTransaction(transactionalReads);
        if (requires == null || requires.booleanValue()) {
            return true;
        }
        return false;
    }
}

