/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.util.CommandContext;

public class SelectNode
extends SubqueryAwareRelationalNode {
    private Criteria criteria;
    private Criteria preEvalCriteria;
    private List<Expression> projectedExpressions;
    private boolean shouldEvaluate = false;
    private Map<Expression, Integer> elementMap;
    private int[] projectionIndexes;
    private boolean noRows;
    private TupleBatch currentBatch;
    private int currentRow = 1;

    protected SelectNode() {
    }

    public SelectNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void reset() {
        super.reset();
        this.currentBatch = null;
        this.currentRow = 1;
        this.noRows = false;
        this.preEvalCriteria = null;
    }

    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setProjectedExpressions(List<Expression> projectedExpressions) {
        this.projectedExpressions = projectedExpressions;
    }

    @Override
    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        super.initialize(context, bufferManager, dataMgr);
        if (this.elementMap == null) {
            this.elementMap = SelectNode.createLookupMap(this.getChildren()[0].getElements());
            this.projectionIndexes = SelectNode.getProjectionIndexes(this.elementMap, this.projectedExpressions != null ? this.projectedExpressions : this.getElements());
        }
    }

    @Override
    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.noRows) {
            this.terminateBatches();
            return this.pullBatch();
        }
        if (this.currentBatch == null) {
            this.currentBatch = this.getChildren()[0].nextBatch();
        }
        while ((long)this.currentRow <= this.currentBatch.getEndRow() && !this.isBatchFull()) {
            List<?> tuple = this.currentBatch.getTuple(this.currentRow);
            if (this.getEvaluator(this.elementMap).evaluate(this.preEvalCriteria != null ? this.preEvalCriteria : this.criteria, tuple)) {
                this.addBatchRow(SelectNode.projectTuple(this.projectionIndexes, tuple));
            }
            ++this.currentRow;
        }
        if ((long)this.currentRow > this.currentBatch.getEndRow()) {
            if (this.currentBatch.getTerminationFlag()) {
                this.terminateBatches();
            }
            this.currentBatch = null;
        }
        return this.pullBatch();
    }

    @Override
    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
        str.append(this.criteria);
    }

    @Override
    public Object clone() {
        SelectNode clonedNode = new SelectNode();
        this.copyTo(clonedNode);
        return clonedNode;
    }

    protected void copyTo(SelectNode target) {
        super.copyTo(target);
        target.criteria = this.criteria;
        target.elementMap = this.elementMap;
        target.projectionIndexes = this.projectionIndexes;
        target.projectedExpressions = this.projectedExpressions;
        target.shouldEvaluate = this.shouldEvaluate;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        AnalysisRecord.addLanaguageObjects(props, "Criteria", Arrays.asList(this.criteria));
        return props;
    }

    @Override
    public Collection<? extends LanguageObject> getObjects() {
        return Arrays.asList(this.criteria);
    }

    public void setShouldEvaluateExpressions(boolean shouldEvaluate) {
        this.shouldEvaluate = shouldEvaluate;
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        if (this.shouldEvaluate) {
            this.preEvalCriteria = QueryRewriter.evaluateAndRewrite((Criteria)this.criteria.clone(), this.getEvaluator(this.elementMap), this.getContext(), this.getContext().getMetadata());
            if (this.preEvalCriteria.equals(QueryRewriter.FALSE_CRITERIA) || this.preEvalCriteria.equals(QueryRewriter.UNKNOWN_CRITERIA)) {
                this.noRows = true;
                return;
            }
        }
        super.open();
    }
}

