/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SubqueryAwareEvaluator;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.TableFunctionReference;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;

public abstract class SubqueryAwareRelationalNode
extends RelationalNode {
    private SubqueryAwareEvaluator evaluator;

    protected SubqueryAwareRelationalNode() {
    }

    public SubqueryAwareRelationalNode(int nodeID) {
        super(nodeID);
    }

    protected Evaluator getEvaluator(Map elementMap) {
        if (this.evaluator == null) {
            this.evaluator = new SubqueryAwareEvaluator(elementMap, this.getDataManager(), this.getContext(), this.getBufferManager());
        } else {
            this.evaluator.initialize(this.getContext(), this.getDataManager());
        }
        return this.evaluator;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.evaluator != null) {
            this.evaluator.reset();
        }
    }

    @Override
    public void closeDirect() {
        if (this.evaluator != null) {
            this.evaluator.close();
        }
    }

    protected void setReferenceValues(TableFunctionReference ref) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        if (ref.getCorrelatedReferences() == null) {
            return;
        }
        for (Map.Entry<ElementSymbol, Expression> entry : ref.getCorrelatedReferences().asMap().entrySet()) {
            this.getContext().getVariableContext().setValue(entry.getKey(), this.getEvaluator(Collections.emptyMap()).evaluate(entry.getValue(), null));
        }
    }

    public abstract Collection<? extends LanguageObject> getObjects();

    @Override
    public Boolean requiresTransaction(boolean transactionalReads) {
        List<SubqueryContainer<?>> valueIteratorProviders = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(this.getObjects());
        return SubqueryAwareRelationalNode.requiresTransaction(transactionalReads, valueIteratorProviders);
    }

    public static Boolean requiresTransaction(boolean transactionalReads, List<SubqueryContainer<?>> valueIteratorProviders) {
        for (SubqueryContainer<?> subquery : valueIteratorProviders) {
            Boolean txn;
            ProcessorPlan plan = ((Command)subquery.getCommand()).getProcessorPlan();
            if (plan == null || (txn = plan.requiresTransaction(transactionalReads)) != null && !txn.booleanValue()) continue;
            return true;
        }
        return false;
    }
}

