/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class OrderBy
implements LanguageObject {
    public static final boolean ASC = true;
    public static final boolean DESC = false;
    private List<OrderByItem> orderByItems = new ArrayList<OrderByItem>();
    private boolean userOrdering = true;

    public OrderBy() {
    }

    public OrderBy(List<? extends Expression> parameters) {
        for (Expression expression : parameters) {
            this.orderByItems.add(new OrderByItem(expression, true));
        }
    }

    public OrderBy(List<? extends Expression> parameters, List<Boolean> types) {
        Iterator<Boolean> typeIter = types.iterator();
        for (Expression expression : parameters) {
            this.orderByItems.add(new OrderByItem(expression, typeIter.next()));
        }
    }

    public int getVariableCount() {
        return this.orderByItems.size();
    }

    public List<OrderByItem> getOrderByItems() {
        return this.orderByItems;
    }

    public Expression getVariable(int index) {
        return this.orderByItems.get(index).getSymbol();
    }

    public Boolean getOrderType(int index) {
        return this.orderByItems.get(index).isAscending();
    }

    public void addVariable(Expression element) {
        this.addVariable(element, true);
    }

    public void addVariable(Expression element, boolean type) {
        if (element != null) {
            this.orderByItems.add(new OrderByItem(element, type));
        }
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public OrderBy clone() {
        OrderBy clone = new OrderBy();
        clone.orderByItems = LanguageObject.Util.deepClone(this.orderByItems, OrderByItem.class);
        clone.userOrdering = this.userOrdering;
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderBy)) {
            return false;
        }
        OrderBy other = (OrderBy)obj;
        return EquivalenceUtil.areEqual(this.orderByItems, other.orderByItems);
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.orderByItems});
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public void setExpressionPosition(int orderIndex, int selectIndex) {
        this.orderByItems.get(orderIndex).setExpressionPosition(selectIndex);
    }

    public int getExpressionPosition(int orderIndex) {
        return this.orderByItems.get(orderIndex).getExpressionPosition();
    }

    public void removeOrderByItem(int index) {
        this.orderByItems.remove(index);
    }

    public boolean hasUnrelated() {
        for (OrderByItem item : this.orderByItems) {
            if (!item.isUnrelated()) continue;
            return true;
        }
        return false;
    }

    public List<Expression> getSortKeys() {
        ArrayList<Expression> result = new ArrayList<Expression>(this.orderByItems.size());
        for (OrderByItem item : this.orderByItems) {
            result.add(item.getSymbol());
        }
        return result;
    }

    public List<Boolean> getTypes() {
        ArrayList<Boolean> result = new ArrayList<Boolean>(this.orderByItems.size());
        for (OrderByItem item : this.orderByItems) {
            result.add(item.isAscending());
        }
        return result;
    }

    public void setUserOrdering(boolean userOrdering) {
        this.userOrdering = userOrdering;
    }

    public boolean isUserOrdering() {
        return this.userOrdering;
    }
}

