/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.salesforce.execution;

import com.sforce.async.JobInfo;
import com.sforce.async.OperationEnum;
import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.bind.XmlObject;
import java.io.IOException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.language.AggregateFunction;
import org.teiid.language.ColumnReference;
import org.teiid.language.Expression;
import org.teiid.language.GroupBy;
import org.teiid.language.Join;
import org.teiid.language.LanguageObject;
import org.teiid.language.Limit;
import org.teiid.language.NamedTable;
import org.teiid.language.OrderBy;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.language.visitor.LanguageObjectVisitor;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.salesforce.SalesForceExecutionFactory;
import org.teiid.translator.salesforce.SalesForcePlugin;
import org.teiid.translator.salesforce.SalesforceConnection;
import org.teiid.translator.salesforce.execution.visitors.JoinQueryVisitor;
import org.teiid.translator.salesforce.execution.visitors.SelectVisitor;

public class QueryExecutionImpl
implements ResultSetExecution {
    private static final String TYPE = "type";
    private static final String AGGREGATE_RESULT = "AggregateResult";
    private static final Pattern dateTimePattern = Pattern.compile("^(?:(\\d{4}-\\d{2}-\\d{2})T)?(\\d{2}:\\d{2}:\\d{2}(?:.\\d+)?)(.*)");
    private SalesForceExecutionFactory executionFactory;
    private SalesforceConnection connection;
    private RuntimeMetadata metadata;
    private ExecutionContext context;
    private SelectVisitor visitor;
    private QueryResult results;
    private List<List<Object>> resultBatch;
    private String connectionIdentifier;
    private String connectorIdentifier;
    private String requestIdentifier;
    private String partIdentifier;
    private String logPreamble;
    private QueryExpression query;
    Map<String, Map<String, Integer>> sObjectToResponseField = new HashMap<String, Map<String, Integer>>();
    private int topResultIndex = 0;
    private Calendar cal;
    private JobInfo activeJob;
    private SalesforceConnection.BatchResultInfo batchInfo;
    private SalesforceConnection.BulkBatchResult batchResults;

    public QueryExecutionImpl(QueryExpression command, SalesforceConnection connection, RuntimeMetadata metadata, ExecutionContext context, SalesForceExecutionFactory salesForceExecutionFactory) {
        this.connection = connection;
        this.metadata = metadata;
        this.context = context;
        this.query = command;
        this.executionFactory = salesForceExecutionFactory;
        this.connectionIdentifier = context.getConnectionId();
        this.connectorIdentifier = context.getConnectorIdentifier();
        this.requestIdentifier = context.getRequestId();
        this.partIdentifier = context.getPartIdentifier();
    }

    public void cancel() throws TranslatorException {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)SalesForcePlugin.Util.getString("SalesforceQueryExecutionImpl.cancel"));
        if (this.activeJob != null) {
            this.connection.cancelBulkJob(this.activeJob);
        }
    }

    public void close() {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)SalesForcePlugin.Util.getString("SalesforceQueryExecutionImpl.close"));
        if (this.activeJob != null) {
            try {
                this.connection.closeJob(this.activeJob.getId());
            }
            catch (TranslatorException e) {
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)((Object)e), (Object)"Exception closing");
            }
        }
        if (this.batchResults != null) {
            this.batchResults.close();
            this.batchResults = null;
        }
    }

    public void execute() throws TranslatorException {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)this.getLogPreamble(), (Object)"Incoming Query:", (Object)this.query);
        List from = ((Select)this.query).getFrom();
        boolean join = false;
        if (from.get(0) instanceof Join) {
            join = true;
            this.visitor = new JoinQueryVisitor(this.metadata);
        } else {
            this.visitor = new SelectVisitor(this.metadata);
        }
        this.visitor.visitNode((LanguageObject)this.query);
        if (this.visitor.canRetrieve()) {
            this.context.logCommand(new Object[]{"Using retrieve: ", this.visitor.getRetrieveFieldList(), this.visitor.getTableName(), this.visitor.getIdInCriteria()});
            this.results = this.executionFactory.buildQueryResult(this.connection.retrieve(this.visitor.getRetrieveFieldList(), this.visitor.getTableName(), this.visitor.getIdInCriteria()));
        } else {
            String finalQuery = this.visitor.getQuery().trim();
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)this.getLogPreamble(), (Object)"Executing Query:", (Object)finalQuery);
            this.context.logCommand(new Object[]{finalQuery});
            if (!join && !this.visitor.getQueryAll() && this.context.getSourceHints() != null && this.context.getSourceHints().contains("bulk")) {
                BulkValidator bulkValidator = new BulkValidator();
                this.query.acceptVisitor((LanguageObjectVisitor)bulkValidator);
                if (bulkValidator.isBulkEligible()) {
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.getLogPreamble(), "Using bulk logic", bulkValidator.usePkChunking() ? "with" : "without", "pk chunking"});
                    this.activeJob = this.connection.createBulkJob(this.visitor.getTableName(), OperationEnum.query, bulkValidator.usePkChunking());
                    this.batchInfo = this.connection.addBatch(finalQuery, this.activeJob);
                    return;
                }
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)this.getLogPreamble(), (Object)"Ingoring bulk hint as the query is not bulk eligible");
            }
            this.results = this.connection.query(finalQuery, this.context.getBatchSize(), this.visitor.getQueryAll());
        }
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        if (this.activeJob != null) {
            List<String> row = null;
            try {
                while (row == null) {
                    if (this.batchResults == null) {
                        this.batchResults = this.connection.getBatchQueryResults(this.activeJob.getId(), this.batchInfo);
                        if (this.batchResults == null) {
                            return null;
                        }
                        if (this.batchResults.nextRecord() == null) {
                            throw new AssertionError((Object)"Expected header row");
                        }
                    }
                    if ((row = this.batchResults.nextRecord()) != null) continue;
                    this.batchResults.close();
                    this.batchResults = null;
                }
            }
            catch (IOException e) {
                throw new TranslatorException((Throwable)e);
            }
            ArrayList<Object> result = new ArrayList<Object>();
            for (int j = 0; j < this.visitor.getSelectSymbolCount(); ++j) {
                Expression ex = this.visitor.getSelectSymbolMetadata(j);
                Class type = ex.getType();
                if (ex instanceof ColumnReference) {
                    Column element = ((ColumnReference)ex).getMetadataObject();
                    type = element.getJavaType();
                }
                result.add(this.convertValue(type, row.get(j)));
            }
            return result;
        }
        List<Object> result = this.getRow(this.results);
        return result;
    }

    private List<Object> getRow(QueryResult result) throws TranslatorException {
        List<Object> row;
        if (null == this.resultBatch) {
            this.loadBatch();
        }
        if (this.resultBatch.size() == this.topResultIndex) {
            row = null;
        } else {
            row = this.resultBatch.get(this.topResultIndex);
            ++this.topResultIndex;
            if (this.resultBatch.size() == this.topResultIndex && !result.isDone()) {
                this.loadBatch();
            }
        }
        return row;
    }

    private void loadBatch() throws TranslatorException {
        if (null != this.resultBatch) {
            this.results = this.connection.queryMore(this.results.getQueryLocator(), this.context.getBatchSize());
        }
        this.resultBatch = new ArrayList<List<Object>>();
        this.topResultIndex = 0;
        for (SObject sObject : this.results.getRecords()) {
            if (sObject == null) continue;
            List<Object[]> result = this.getObjectData(sObject);
            Iterator<Object[]> i = result.iterator();
            while (i.hasNext()) {
                this.resultBatch.add(Arrays.asList(i.next()));
            }
        }
    }

    private List<Object[]> getObjectData(SObject sObject) throws TranslatorException {
        Iterator topFields = sObject.getChildren();
        ArrayList<XmlObject> children = new ArrayList<XmlObject>();
        while (topFields.hasNext()) {
            children.add((XmlObject)topFields.next());
        }
        this.logAndMapFields(sObject.getType(), children);
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        if (this.visitor instanceof JoinQueryVisitor) {
            for (int i = 0; i < children.size(); ++i) {
                XmlObject element = children.get(i);
                this.extactJoinResults(element, result);
            }
        }
        return this.extractDataFromFields(sObject, children, result);
    }

    private void extactJoinResults(XmlObject node, List<Object[]> result) throws TranslatorException {
        Object val = node.getField(TYPE);
        if (val instanceof String) {
            this.extractValuesFromElement(node, result, (String)val);
        } else if (node.hasChildren()) {
            Iterator children = node.getChildren();
            while (children.hasNext()) {
                XmlObject item = (XmlObject)children.next();
                this.extactJoinResults(item, result);
            }
        }
    }

    private List<Object[]> extractValuesFromElement(XmlObject sObject, List<Object[]> result, String sObjectName) throws TranslatorException {
        Object[] row = new Object[this.visitor.getSelectSymbolCount()];
        for (int j = 0; j < this.visitor.getSelectSymbolCount(); ++j) {
            Column element = ((ColumnReference)this.visitor.getSelectSymbolMetadata(j)).getMetadataObject();
            ColumnSet table = element.getParent();
            if (!table.getSourceName().equals(sObjectName)) continue;
            XmlObject child = sObject.getChild(element.getSourceName());
            Object cell = this.getCellDatum(element.getSourceName(), element.getJavaType(), child);
            this.setElementValueInColumn(j, cell, row);
        }
        result.add(row);
        return result;
    }

    private List<Object[]> extractDataFromFields(SObject sObject, List<XmlObject> fields, List<Object[]> result) throws TranslatorException {
        Map<String, Integer> fieldToIndexMap = this.sObjectToResponseField.get(sObject.getType());
        int aggCount = 0;
        for (int j = 0; j < this.visitor.getSelectSymbolCount(); ++j) {
            Expression ex = this.visitor.getSelectSymbolMetadata(j);
            if (ex instanceof ColumnReference) {
                Column element = ((ColumnReference)ex).getMetadataObject();
                Table table = (Table)element.getParent();
                if (!table.getSourceName().equals(sObject.getType()) && !AGGREGATE_RESULT.equalsIgnoreCase(sObject.getType())) continue;
                Integer index = fieldToIndexMap.get(element.getSourceName());
                if (null == index) {
                    throw new TranslatorException(SalesForcePlugin.Util.getString("SalesforceQueryExecutionImpl.missing.field") + element.getSourceName());
                }
                Object cell = this.getCellDatum(element.getSourceName(), element.getJavaType(), fields.get(index));
                this.setValueInColumn(j, cell, result);
                continue;
            }
            if (!(ex instanceof AggregateFunction)) continue;
            String name = "expr" + aggCount++;
            Integer index = fieldToIndexMap.get(name);
            if (null == index) {
                throw new TranslatorException(SalesForcePlugin.Util.getString("SalesforceQueryExecutionImpl.missing.field") + ex);
            }
            Object cell = this.getCellDatum(name, ex.getType(), fields.get(index));
            this.setValueInColumn(j, cell, result);
        }
        return result;
    }

    private void setElementValueInColumn(int columnIndex, Object value, Object[] row) {
        XmlObject element;
        row[columnIndex] = value instanceof XmlObject ? ((element = (XmlObject)value).hasChildren() ? ((XmlObject)element.getChildren().next()).getValue() : element.getValue()) : value;
    }

    private void setValueInColumn(int columnIndex, Object value, List<Object[]> result) {
        if (result.isEmpty()) {
            Object[] row = new Object[this.visitor.getSelectSymbolCount()];
            result.add(row);
        }
        for (Object[] row : result) {
            row[columnIndex] = value;
        }
    }

    private void logAndMapFields(String sObjectName, List<XmlObject> fields) throws TranslatorException {
        if (!this.sObjectToResponseField.containsKey(sObjectName)) {
            this.logFields(sObjectName, fields);
            HashMap<String, Integer> responseFieldToIndexMap = new HashMap<String, Integer>();
            for (int x = 0; x < fields.size(); ++x) {
                XmlObject element = fields.get(x);
                responseFieldToIndexMap.put(element.getName().getLocalPart(), x);
            }
            this.sObjectToResponseField.put(sObjectName, responseFieldToIndexMap);
        }
    }

    private void logFields(String sObjectName, List<XmlObject> fields) {
        if (!LogManager.isMessageToBeRecorded((String)"org.teiid.CONNECTOR", (int)5)) {
            return;
        }
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)("SalesForce Object Name = " + sObjectName));
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)("FieldCount = " + fields.size()));
        for (int i = 0; i < fields.size(); ++i) {
            XmlObject element = fields.get(i);
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)("Field # " + i + " is " + element.getName().getLocalPart()));
        }
    }

    private Object getCellDatum(String name, Class<?> type, XmlObject elem) throws TranslatorException {
        if (!name.equals(elem.getName().getLocalPart())) {
            throw new TranslatorException(SalesForcePlugin.Util.getString("SalesforceQueryExecutionImpl.column.mismatch1") + name + SalesForcePlugin.Util.getString("SalesforceQueryExecutionImpl.column.mismatch2") + elem.getName().getLocalPart());
        }
        Object value = elem.getValue();
        return this.convertValue(type, value);
    }

    private Object convertValue(Class<?> type, Object value) throws TranslatorException {
        if (value == null) {
            return null;
        }
        if (value instanceof String && ((String)value).isEmpty()) {
            if (type == String.class) {
                return value;
            }
            return null;
        }
        if ((type.equals(Timestamp.class) || type.equals(Time.class)) && !(value instanceof Date)) {
            if (this.cal == null) {
                this.cal = Calendar.getInstance();
            }
            return QueryExecutionImpl.parseDateTime(value.toString(), type, this.cal);
        }
        return value;
    }

    static Object parseDateTime(String value, Class<?> type, Calendar cal) throws TranslatorException {
        try {
            Matcher m = dateTimePattern.matcher(value);
            if (m.matches()) {
                String date = m.group(1);
                String time = m.group(2);
                String timeZone = m.group(3);
                Date d = null;
                if (date == null) {
                    int milli = time.lastIndexOf(46);
                    if (milli > 0) {
                        time = time.substring(0, milli);
                    }
                    d = Time.valueOf(time);
                } else {
                    d = Timestamp.valueOf(date + " " + time);
                }
                TimeZone tz = null;
                if (timeZone != null) {
                    tz = timeZone.equals("Z") ? TimeZone.getTimeZone("GMT") : (timeZone.contains(":") ? TimeZone.getTimeZone("GMT" + timeZone) : TimeZone.getTimeZone(timeZone));
                    cal.setTimeZone(tz);
                } else {
                    cal = null;
                }
                return TimestampWithTimezone.create((Date)d, (TimeZone)TimeZone.getDefault(), (Calendar)cal, type);
            }
            throw new TranslatorException(SalesForcePlugin.Util.getString("SalesforceQueryExecutionImpl.datatime.parse") + value);
        }
        catch (IllegalArgumentException e) {
            throw new TranslatorException((Throwable)e, SalesForcePlugin.Util.getString("SalesforceQueryExecutionImpl.datatime.parse") + value);
        }
    }

    private String getLogPreamble() {
        if (null == this.logPreamble) {
            StringBuffer preamble = new StringBuffer();
            preamble.append(this.connectorIdentifier);
            preamble.append('.');
            preamble.append(this.connectionIdentifier);
            preamble.append('.');
            preamble.append(this.requestIdentifier);
            preamble.append('.');
            preamble.append(this.partIdentifier);
            preamble.append(": ");
            this.logPreamble = preamble.toString();
        }
        return this.logPreamble;
    }

    static final class BulkValidator
    extends HierarchyVisitor {
        boolean bulkEligible = true;
        boolean usePkChunking = true;
        static Set<String> allowed = new HashSet<String>(Arrays.asList("Account", "Campaign", "CampaignMember", "Case", "Contact", "Lead", "LoginHistory", "Opportunity", "Task", "User"));

        BulkValidator() {
        }

        public void visit(AggregateFunction obj) {
            this.bulkEligible = false;
        }

        public void visit(GroupBy obj) {
            this.bulkEligible = false;
        }

        public void visit(Limit obj) {
            if (obj.getRowOffset() > 0) {
                this.bulkEligible = false;
            } else {
                this.usePkChunking = false;
                super.visit(obj);
            }
        }

        public void visit(NamedTable obj) {
            if (!allowed.contains(obj.getMetadataObject().getSourceName()) && !Boolean.valueOf(obj.getMetadataObject().getProperty("{http://www.teiid.org/translator/salesforce/2012}Custom", false)).booleanValue()) {
                this.usePkChunking = false;
            }
        }

        public void visit(OrderBy obj) {
            this.usePkChunking = false;
        }

        public void visit(Select obj) {
            if (obj.getHaving() != null) {
                this.usePkChunking = false;
            }
            super.visit(obj);
        }

        public boolean isBulkEligible() {
            return this.bulkEligible;
        }

        public boolean usePkChunking() {
            return this.usePkChunking && this.bulkEligible;
        }
    }
}

