/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.salesforce.execution;

import java.util.ArrayList;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.Literal;
import org.teiid.language.SetClause;
import org.teiid.language.Update;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.salesforce.SalesForceExecutionFactory;
import org.teiid.translator.salesforce.SalesforceConnection;
import org.teiid.translator.salesforce.Util;
import org.teiid.translator.salesforce.execution.AbstractUpdateExecution;
import org.teiid.translator.salesforce.execution.DataPayload;
import org.teiid.translator.salesforce.execution.visitors.IQueryProvidingVisitor;
import org.teiid.translator.salesforce.execution.visitors.UpdateVisitor;

public class UpdateExecutionImpl
extends AbstractUpdateExecution {
    public UpdateExecutionImpl(SalesForceExecutionFactory ef, Command command, SalesforceConnection salesforceConnection, RuntimeMetadata metadata, ExecutionContext context) {
        super(ef, command, salesforceConnection, metadata, context);
    }

    public void execute() throws TranslatorException {
        UpdateVisitor visitor = new UpdateVisitor(this.getMetadata());
        visitor.visit((Update)this.command);
        this.execute(((Update)this.command).getWhere(), visitor);
    }

    @Override
    protected int processIds(String[] ids, IQueryProvidingVisitor visitor) throws TranslatorException {
        ArrayList<DataPayload> updateDataList = new ArrayList<DataPayload>();
        for (int i = 0; i < ids.length; ++i) {
            DataPayload data = new DataPayload();
            for (SetClause clause : ((Update)this.command).getChanges()) {
                ColumnReference element = clause.getSymbol();
                Column column = element.getMetadataObject();
                String val = ((Literal)clause.getValue()).toString();
                data.addField(column.getSourceName(), Util.stripQutes(val));
            }
            data.setType(visitor.getTableName());
            data.setID(ids[i]);
            updateDataList.add(data);
        }
        return this.getConnection().update(updateDataList);
    }
}

