/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.salesforce.execution.visitors;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.language.AggregateFunction;
import org.teiid.language.AndOr;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.In;
import org.teiid.language.IsNull;
import org.teiid.language.LanguageObject;
import org.teiid.language.Like;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.Not;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.salesforce.SalesForcePlugin;
import org.teiid.translator.salesforce.Util;
import org.teiid.translator.salesforce.execution.visitors.ICriteriaVisitor;

public class CriteriaVisitor
extends HierarchyVisitor
implements ICriteriaVisitor {
    private static final double SCIENTIFIC_LOW = Math.pow(10.0, -3.0);
    private static final double SCIENTIFIC_HIGH = Math.pow(10.0, 7.0);
    private static final String RESTRICTEDMULTISELECTPICKLIST = "restrictedmultiselectpicklist";
    private static final String MULTIPICKLIST = "multipicklist";
    protected static final String SELECT = "SELECT";
    protected static final String FROM = "FROM";
    protected static final String WHERE = "WHERE";
    protected static final String ORDER_BY = "ORDER BY";
    protected static final String LIMIT = "LIMIT";
    protected static final String SPACE = " ";
    protected static final String EXCLUDES = "EXCLUDES";
    protected static final String INCLUDES = "includes";
    protected static final String COMMA = ",";
    protected static final String SEMI = ";";
    protected static final String APOS = "'";
    protected static final String OPEN = "(";
    protected static final String CLOSE = ")";
    protected RuntimeMetadata metadata;
    protected List<String> criteriaBuffer = new ArrayList<String>();
    protected boolean hasCriteria;
    protected List<TranslatorException> exceptions = new ArrayList<TranslatorException>();
    protected Table table;
    boolean onlyIDCriteria;
    protected boolean queryAll = Boolean.FALSE;
    protected In idInCriteria = null;

    public CriteriaVisitor(RuntimeMetadata metadata) {
        this.metadata = metadata;
    }

    public void visit(Comparison criteria) {
        this.addCompareCriteria(criteria);
        boolean isAcceptableID = Comparison.Operator.EQ == criteria.getOperator() && this.isIdColumn(criteria.getLeftExpression());
        this.setHasCriteria(true, isAcceptableID);
        if (isAcceptableID) {
            this.idInCriteria = new In(criteria.getLeftExpression(), Arrays.asList(criteria.getRightExpression()), false);
        }
    }

    public void visit(IsNull obj) {
        this.visit(new Comparison(obj.getExpression(), (Expression)new Literal(null, obj.getExpression().getType()), obj.isNegated() ? Comparison.Operator.NE : Comparison.Operator.EQ));
    }

    public void visit(Like criteria) {
        TranslatorException e;
        if (this.isIdColumn(criteria.getLeftExpression())) {
            e = new TranslatorException(SalesForcePlugin.Util.getString("CriteriaVisitor.LIKE.not.supported.on.Id"));
            this.exceptions.add(e);
        }
        if (this.isMultiSelectColumn(criteria.getLeftExpression())) {
            e = new TranslatorException(SalesForcePlugin.Util.getString("CriteriaVisitor.LIKE.not.supported.on.multiselect"));
            this.exceptions.add(e);
        }
        boolean negated = criteria.isNegated();
        criteria.setNegated(false);
        if (negated) {
            this.criteriaBuffer.add("NOT (");
        }
        this.criteriaBuffer.add(criteria.toString());
        if (negated) {
            this.criteriaBuffer.add(CLOSE);
            criteria.setNegated(true);
        }
        this.setHasCriteria(true, false);
    }

    public void visit(AndOr obj) {
        this.criteriaBuffer.add(OPEN);
        super.visitNode((LanguageObject)obj.getLeftCondition());
        this.criteriaBuffer.add(CLOSE);
        this.criteriaBuffer.add(SPACE);
        this.criteriaBuffer.add(obj.getOperator().toString());
        this.criteriaBuffer.add(SPACE);
        this.criteriaBuffer.add(OPEN);
        super.visitNode((LanguageObject)obj.getRightCondition());
        this.criteriaBuffer.add(CLOSE);
    }

    public void visit(Not obj) {
        this.criteriaBuffer.add("NOT (");
        super.visit(obj);
        this.criteriaBuffer.add(CLOSE);
    }

    public void visit(In criteria) {
        Expression lExpr = criteria.getLeftExpression();
        if (lExpr instanceof ColumnReference) {
            ColumnReference cr = (ColumnReference)lExpr;
            Column column = cr.getMetadataObject();
            if (column != null && (MULTIPICKLIST.equalsIgnoreCase(column.getNativeType()) || RESTRICTEDMULTISELECTPICKLIST.equalsIgnoreCase(column.getNativeType()))) {
                this.appendMultiselectIn(column, criteria);
            } else {
                this.appendCriteria(criteria);
            }
        } else {
            this.appendCriteria(criteria);
        }
        this.setHasCriteria(true, this.isIdColumn(criteria.getLeftExpression()));
    }

    public void parseFunction(Function func) {
        String functionName = func.getName();
        try {
            if (functionName.equalsIgnoreCase(INCLUDES)) {
                this.generateMultiSelect(func, INCLUDES);
            } else if (functionName.equalsIgnoreCase("excludes")) {
                this.generateMultiSelect(func, EXCLUDES);
            }
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    private void generateMultiSelect(Function func, String funcName) throws TranslatorException {
        List expressions = func.getParameters();
        this.validateFunction(expressions);
        Expression columnExpression = (Expression)expressions.get(0);
        Column column = ((ColumnReference)columnExpression).getMetadataObject();
        this.criteriaBuffer.add(column.getSourceName());
        this.criteriaBuffer.add(SPACE);
        this.criteriaBuffer.add(funcName);
        this.criteriaBuffer.add(OPEN);
        String fullParam = ((Literal)expressions.get(1)).toString();
        String[] params = fullParam.split(COMMA);
        for (int i = 0; i < params.length; ++i) {
            String token = params[i];
            if (i != 0) {
                this.criteriaBuffer.add(COMMA);
            }
            this.criteriaBuffer.add(Util.addSingleQuotes(token));
        }
        this.criteriaBuffer.add(CLOSE);
    }

    private void appendMultiselectIn(Column column, In criteria) {
        this.criteriaBuffer.add(column.getSourceName());
        this.criteriaBuffer.add(SPACE);
        if (criteria.isNegated()) {
            this.criteriaBuffer.add(EXCLUDES);
        } else {
            this.criteriaBuffer.add(INCLUDES);
        }
        this.criteriaBuffer.add(OPEN);
        List rightExpressions = criteria.getRightExpressions();
        Iterator iter = rightExpressions.iterator();
        while (iter.hasNext()) {
            Expression rightExpression = (Expression)iter.next();
            this.criteriaBuffer.add(rightExpression.toString());
            if (!iter.hasNext()) continue;
            this.criteriaBuffer.add(COMMA);
        }
        this.criteriaBuffer.add(CLOSE);
    }

    private void validateFunction(List<Expression> expressions) throws TranslatorException {
        if (expressions.size() != 2) {
            throw new TranslatorException(SalesForcePlugin.Util.getString("CriteriaVisitor.invalid.arg.count"));
        }
        if (!(expressions.get(0) instanceof ColumnReference)) {
            throw new TranslatorException(SalesForcePlugin.Util.getString("CriteriaVisitor.function.not.column.arg"));
        }
        if (!(expressions.get(1) instanceof Literal)) {
            throw new TranslatorException(SalesForcePlugin.Util.getString("CriteriaVisitor.function.not.literal.arg"));
        }
    }

    protected void addCompareCriteria(Comparison compCriteria) {
        Expression lExpr = compCriteria.getLeftExpression();
        if (lExpr instanceof Function) {
            this.parseFunction((Function)lExpr);
        } else {
            Literal isDeletedLiteral;
            Boolean isDeleted;
            this.criteriaBuffer.add(this.getValue(lExpr, false));
            this.criteriaBuffer.add(SPACE);
            this.criteriaBuffer.add(compCriteria.getOperator() == Comparison.Operator.NE ? "!=" : compCriteria.getOperator().toString());
            this.criteriaBuffer.add(SPACE);
            Expression rExp = compCriteria.getRightExpression();
            this.criteriaBuffer.add(this.getValue(rExp, false));
            if (lExpr instanceof ColumnReference && "IsDeleted".equalsIgnoreCase(((ColumnReference)lExpr).getMetadataObject().getSourceName()) && (isDeleted = (Boolean)(isDeletedLiteral = (Literal)compCriteria.getRightExpression()).getValue()).booleanValue()) {
                this.queryAll = isDeleted;
            }
        }
    }

    void appendColumnReference(StringBuilder queryString, ColumnReference ref) {
        queryString.append(ref.getMetadataObject().getParent().getSourceName());
        queryString.append('.');
        queryString.append(ref.getMetadataObject().getSourceName());
    }

    private void appendCriteria(In criteria) {
        Expression leftExp = criteria.getLeftExpression();
        if (this.isIdColumn(leftExp)) {
            this.idInCriteria = criteria;
        }
        this.criteriaBuffer.add(this.getValue(leftExp, false));
        this.criteriaBuffer.add(SPACE);
        if (criteria.isNegated()) {
            this.criteriaBuffer.add("NOT ");
        }
        this.criteriaBuffer.add("IN");
        this.criteriaBuffer.add(OPEN);
        Iterator iter = criteria.getRightExpressions().iterator();
        while (iter.hasNext()) {
            this.criteriaBuffer.add(this.getValue((Expression)iter.next(), false));
            if (!iter.hasNext()) continue;
            this.criteriaBuffer.add(COMMA);
        }
        this.criteriaBuffer.add(CLOSE);
    }

    protected String getValue(Expression expr, boolean raw) {
        StringBuilder result = new StringBuilder();
        if (expr instanceof ColumnReference) {
            this.appendColumnReference(result, (ColumnReference)expr);
        } else if (expr instanceof Literal) {
            Literal literal = (Literal)expr;
            if (literal.getValue() == null) {
                if (raw) {
                    return null;
                }
                return "NULL";
            }
            if (raw) {
                return literal.getValue().toString();
            }
            CriteriaVisitor.appendLiteralValue(result, literal);
        } else if (expr instanceof AggregateFunction) {
            this.appendAggregateFunction(result, (AggregateFunction)expr);
        } else {
            throw new RuntimeException("unknown type in SalesforceQueryExecution.getValue(): " + expr.toString());
        }
        return result.toString();
    }

    public static void appendLiteralValue(StringBuilder result, Literal literal) {
        if (literal.getValue().getClass().equals(Boolean.class)) {
            result.append(((Boolean)literal.getValue()).toString());
        } else if (literal.getValue().getClass().equals(Timestamp.class)) {
            Timestamp datetime = (Timestamp)literal.getValue();
            String value = datetime.toString();
            int fractionalPlace = value.lastIndexOf(46);
            int fractionalLength = value.length() - fractionalPlace - 1;
            if (fractionalLength > 3) {
                value = value.substring(0, fractionalPlace + 3);
            } else if (fractionalLength < 3) {
                value = value + "00".substring(fractionalLength - 1);
            }
            result.append(value).setCharAt(result.length() - value.length() + 10, 'T');
            Calendar c = TimestampWithTimezone.getCalendar();
            c.setTime(datetime);
            int minutes = (c.get(15) + c.get(16)) / 60000;
            int val = minutes / 60;
            result.append(String.format("%1$+03d", val));
            result.append(':');
            val = minutes % 60;
            result.append(val / 10);
            result.append(val % 10);
        } else if (literal.getValue().getClass().equals(Time.class)) {
            result.append(literal.getValue()).append(".000").append(Util.getDefaultTimeZoneString());
        } else if (literal.getValue().getClass().equals(Date.class)) {
            result.append(literal.getValue());
        } else if (literal.getValue() instanceof Double) {
            Double doubleVal = (Double)literal.getValue();
            double value = Math.abs(doubleVal);
            if (value <= SCIENTIFIC_LOW || value >= SCIENTIFIC_HIGH) {
                result.append(BigDecimal.valueOf(doubleVal).toPlainString());
            } else {
                result.append(literal.toString());
            }
        } else if (literal.getValue() instanceof Float) {
            Float floatVal = (Float)literal.getValue();
            float value = Math.abs(floatVal.floatValue());
            if ((double)value <= SCIENTIFIC_LOW || (double)value >= SCIENTIFIC_HIGH) {
                result.append(BigDecimal.valueOf(floatVal.floatValue()).toPlainString());
            } else {
                result.append(literal.toString());
            }
        } else if (literal.getValue() instanceof BigDecimal) {
            result.append(((BigDecimal)literal.getValue()).toPlainString());
        } else {
            result.append(literal.toString());
        }
    }

    protected void appendAggregateFunction(StringBuilder result, AggregateFunction af) {
        if (af.getName().equalsIgnoreCase("COUNT") && (af.getExpression() == null || af.getExpression() instanceof Literal)) {
            result.append("COUNT(Id)");
        } else {
            result.append(af.getName() + OPEN + this.getValue(af.getExpression(), false) + CLOSE);
        }
    }

    protected void loadColumnMetadata(NamedTable group) throws TranslatorException {
        this.table = group.getMetadataObject();
        String supportsQuery = this.table.getProperty("{http://www.teiid.org/translator/salesforce/2012}Supports Query", true);
        if (supportsQuery != null && !Boolean.valueOf(supportsQuery).booleanValue()) {
            throw new TranslatorException(this.table.getSourceName() + SPACE + SalesForcePlugin.Util.getString("CriteriaVisitor.query.not.supported"));
        }
        List columnIds = this.table.getColumns();
        for (Column element : columnIds) {
            String isDeleted;
            if (!element.getSourceName().equals("IsDeleted") || !Boolean.parseBoolean(isDeleted = element.getDefaultValue())) continue;
            this.queryAll = true;
        }
    }

    protected boolean isIdColumn(Expression expression) {
        Column element;
        String nameInSource;
        boolean result = false;
        if (expression instanceof ColumnReference && (nameInSource = (element = ((ColumnReference)expression).getMetadataObject()).getSourceName()).equalsIgnoreCase("id")) {
            result = true;
        }
        return result;
    }

    protected boolean isMultiSelectColumn(Expression expression) {
        Column element;
        String nativeType;
        boolean result = false;
        if (expression instanceof ColumnReference && (MULTIPICKLIST.equalsIgnoreCase(nativeType = (element = ((ColumnReference)expression).getMetadataObject()).getNativeType()) || RESTRICTEDMULTISELECTPICKLIST.equalsIgnoreCase(nativeType))) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean hasCriteria() {
        return this.hasCriteria;
    }

    public void setHasCriteria(boolean hasCriteria, boolean isIdCriteria) {
        if (isIdCriteria) {
            this.onlyIDCriteria = !this.hasCriteria();
        } else if (this.onlyIDCriteria) {
            this.onlyIDCriteria = false;
        }
        this.hasCriteria = hasCriteria;
    }

    @Override
    public boolean hasOnlyIDCriteria() {
        return this.onlyIDCriteria;
    }

    @Override
    public String getTableName() {
        return this.table.getSourceName();
    }

    protected void addCriteriaString(StringBuilder result) {
        this.addCriteriaString(WHERE, result);
    }

    protected void addCriteriaString(String clause, StringBuilder result) {
        if (!this.criteriaBuffer.isEmpty()) {
            result.append(clause).append(SPACE);
            for (String string : this.criteriaBuffer) {
                result.append(string);
            }
            result.append(SPACE);
        }
    }
}

