/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.salesforce.execution.visitors;

import org.teiid.core.util.StringUtil;
import org.teiid.language.AggregateFunction;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Expression;
import org.teiid.language.Join;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.TableReference;
import org.teiid.metadata.Column;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.salesforce.execution.visitors.SelectVisitor;

public class JoinQueryVisitor
extends SelectVisitor {
    private Table leftTableInJoin;
    private Table rightTableInJoin;
    private Table childTable;
    private String parentName;
    private ForeignKey foreignKey;

    public JoinQueryVisitor(RuntimeMetadata metadata) {
        super(metadata);
    }

    public void visit(Join join) {
        try {
            TableReference left = join.getLeftItem();
            NamedTable leftGroup = (NamedTable)left;
            this.leftTableInJoin = leftGroup.getMetadataObject();
            this.loadColumnMetadata(leftGroup);
            TableReference right = join.getRightItem();
            NamedTable rightGroup = (NamedTable)right;
            this.rightTableInJoin = rightGroup.getMetadataObject();
            this.loadColumnMetadata((NamedTable)right);
            Comparison criteria = (Comparison)join.getCondition();
            Expression lExp = criteria.getLeftExpression();
            Expression rExp = criteria.getRightExpression();
            if (this.isIdColumn(rExp) || this.isIdColumn(lExp)) {
                Column rColumn = ((ColumnReference)rExp).getMetadataObject();
                String rTableName = rColumn.getParent().getSourceName();
                Column lColumn = ((ColumnReference)lExp).getMetadataObject();
                String lTableName = lColumn.getParent().getSourceName();
                if (this.leftTableInJoin.getSourceName().equals(rTableName) || this.leftTableInJoin.getSourceName().equals(lTableName) && this.rightTableInJoin.getSourceName().equals(rTableName) || this.rightTableInJoin.getSourceName().equals(lTableName) && !rTableName.equals(lTableName)) {
                    Expression fKey = !this.isIdColumn(lExp) ? lExp : rExp;
                    ColumnReference columnReference = (ColumnReference)fKey;
                    this.table = this.childTable = (Table)columnReference.getMetadataObject().getParent();
                    String name = columnReference.getMetadataObject().getSourceName();
                    if (StringUtil.endsWithIgnoreCase((String)name, (String)"id")) {
                        this.parentName = name.substring(0, name.length() - 2);
                    } else if (name.endsWith("__c")) {
                        this.parentName = name.substring(0, name.length() - 1) + "r";
                    }
                    Table parent = this.leftTableInJoin;
                    if (this.isChildToParentJoin()) {
                        parent = this.rightTableInJoin;
                    }
                    for (ForeignKey fk : this.childTable.getForeignKeys()) {
                        if (!((Column)fk.getColumns().get(0)).equals((Object)columnReference.getMetadataObject()) || !fk.getReferenceKey().equals((Object)parent.getPrimaryKey())) continue;
                        this.foreignKey = fk;
                        break;
                    }
                    if (join.getJoinType() == Join.JoinType.INNER_JOIN) {
                        if (!this.isChildToParentJoin()) {
                            Table t = this.leftTableInJoin;
                            this.leftTableInJoin = this.rightTableInJoin;
                            this.rightTableInJoin = t;
                        }
                        this.addCriteria((Condition)new Comparison(fKey, (Expression)new Literal(null, fKey.getType()), Comparison.Operator.NE));
                    }
                } else {
                    super.visit(criteria);
                }
            } else {
                super.visit(criteria);
            }
        }
        catch (TranslatorException ce) {
            this.exceptions.add(ce);
        }
    }

    @Override
    public String getQuery() throws TranslatorException {
        if (this.isChildToParentJoin()) {
            return super.getQuery();
        }
        if (!this.exceptions.isEmpty()) {
            throw (TranslatorException)((Object)this.exceptions.get(0));
        }
        StringBuilder select = new StringBuilder();
        select.append("SELECT").append(" ");
        this.addSelect(this.leftTableInJoin.getSourceName(), select, true);
        select.append("(");
        StringBuilder subselect = new StringBuilder();
        subselect.append("SELECT").append(" ");
        this.addSelect(this.rightTableInJoin.getSourceName(), subselect, false);
        subselect.append(" ");
        subselect.append("FROM").append(" ");
        String pluralName = null;
        pluralName = this.foreignKey != null && this.foreignKey.getNameInSource() != null ? this.foreignKey.getNameInSource() : this.rightTableInJoin.getNameInSource() + "s";
        subselect.append(pluralName);
        subselect.append(")").append(" ");
        select.append((CharSequence)subselect);
        select.append("FROM").append(" ");
        select.append(this.leftTableInJoin.getSourceName()).append(" ");
        this.addCriteriaString(select);
        this.appendGroupByHaving(select);
        select.append((CharSequence)this.limitClause);
        return select.toString();
    }

    @Override
    void appendColumnReference(StringBuilder queryString, ColumnReference ref) {
        if (this.isChildToParentJoin() && this.rightTableInJoin.equals((Object)ref.getMetadataObject().getParent()) && this.parentName != null) {
            queryString.append(this.parentName);
            queryString.append('.');
            queryString.append(ref.getMetadataObject().getSourceName());
        } else {
            super.appendColumnReference(queryString, ref);
        }
    }

    public boolean isChildToParentJoin() {
        return this.childTable.equals((Object)this.leftTableInJoin);
    }

    void addSelect(String tableNameInSource, StringBuilder result, boolean addComma) {
        boolean firstTime = true;
        for (DerivedColumn symbol : this.selectSymbols) {
            Expression expression = symbol.getExpression();
            if (expression instanceof ColumnReference) {
                Column element = ((ColumnReference)expression).getMetadataObject();
                String tableName = element.getParent().getSourceName();
                if (!this.isChildToParentJoin() && !tableNameInSource.equals(tableName)) continue;
                if (!firstTime) {
                    result.append(", ");
                } else {
                    firstTime = false;
                }
                this.appendColumnReference(result, (ColumnReference)expression);
                continue;
            }
            if (expression instanceof AggregateFunction) {
                if (!firstTime) {
                    result.append(", ");
                } else {
                    firstTime = false;
                }
                this.appendAggregateFunction(result, (AggregateFunction)expression);
                continue;
            }
            throw new AssertionError((Object)("Unknown select symbol type " + symbol));
        }
        if (firstTime && !addComma) {
            result.append("id");
        } else if (!firstTime && addComma) {
            result.append(", ");
        }
    }

    @Override
    public boolean canRetrieve() {
        return false;
    }
}

