/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.endpoint.Endpoint;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.retry.RetryHelper;
import com.couchbase.client.core.service.AbstractDynamicService;
import com.couchbase.client.core.service.Service;
import com.couchbase.client.core.service.strategies.SelectionStrategy;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;

public abstract class AbstractPoolingService
extends AbstractDynamicService {
    private final int maxEndpoints;
    private final RingBuffer<ResponseEvent> responseBuffer;
    private final SelectionStrategy strategy;
    private final CoreEnvironment env;

    protected AbstractPoolingService(String hostname, String bucket, String password, int port, CoreEnvironment env, int minEndpoints, int maxEndpoints, SelectionStrategy strategy, RingBuffer<ResponseEvent> responseBuffer, Service.EndpointFactory endpointFactory) {
        super(hostname, bucket, password, port, env, minEndpoints, responseBuffer, endpointFactory);
        this.maxEndpoints = maxEndpoints;
        this.responseBuffer = responseBuffer;
        this.strategy = strategy;
        this.env = env;
    }

    @Override
    protected void dispatch(CouchbaseRequest request) {
        if (this.endpoints().size() == this.maxEndpoints) {
            Endpoint endpoint = this.strategy.select(request, this.endpoints());
            if (endpoint == null) {
                RetryHelper.retryOrCancel(this.env, request, this.responseBuffer);
            } else {
                endpoint.send(request);
            }
        } else {
            throw new UnsupportedOperationException("Dynamic endpoint scaling is currently not supported.");
        }
    }
}

