/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.salesforce;

import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.sobject.ISObject;
import com.sforce.soap.partner.sobject.SObject;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.Command;
import org.teiid.language.Delete;
import org.teiid.language.Insert;
import org.teiid.language.QueryExpression;
import org.teiid.language.Update;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.resource.api.ConnectionFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.salesforce.SalesForceMetadataProcessor;
import org.teiid.translator.salesforce.SalesforceConnection;
import org.teiid.translator.salesforce.execution.AbstractUpdateExecution;
import org.teiid.translator.salesforce.execution.DeleteExecutionImpl;
import org.teiid.translator.salesforce.execution.DirectQueryExecution;
import org.teiid.translator.salesforce.execution.InsertExecutionImpl;
import org.teiid.translator.salesforce.execution.ProcedureExecutionParentImpl;
import org.teiid.translator.salesforce.execution.QueryExecutionImpl;
import org.teiid.translator.salesforce.execution.UpdateExecutionImpl;

@Translator(name="salesforce", description="A translator for Salesforce")
public class SalesForceExecutionFactory
extends ExecutionFactory<ConnectionFactory, SalesforceConnection> {
    private static final String SALESFORCE = "salesforce";
    private static final String EXCLUDES = "excludes";
    private static final String INCLUDES = "includes";
    private boolean auditModelFields = false;
    private int maxInsertBatchSize = 2048;
    private boolean supportsGroupBy = true;

    public SalesForceExecutionFactory() {
        this.setSupportsOrderBy(false);
        this.setSupportsOuterJoins(true);
        this.setSupportsInnerJoins(true);
        this.setTransactionSupport(ExecutionFactory.TransactionSupport.NONE);
        this.setSupportedJoinCriteria(ExecutionFactory.SupportedJoinCriteria.KEY);
    }

    @TranslatorProperty(display="Model Audit Fields", advanced=true)
    public boolean isModelAuditFields() {
        return this.auditModelFields;
    }

    public void setModelAuditFields(boolean modelAuditFields) {
        this.auditModelFields = modelAuditFields;
    }

    public void start() throws TranslatorException {
        super.start();
        this.addPushDownFunction(SALESFORCE, INCLUDES, "boolean", new String[]{"string", "string"});
        this.addPushDownFunction(SALESFORCE, EXCLUDES, "boolean", new String[]{"string", "string"});
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object)"Salesforce ExecutionFactory Started");
    }

    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, SalesforceConnection connection) throws TranslatorException {
        return new QueryExecutionImpl(command, connection, metadata, executionContext, this);
    }

    public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, SalesforceConnection connection) throws TranslatorException {
        AbstractUpdateExecution result = null;
        if (command instanceof Delete) {
            result = new DeleteExecutionImpl(this, command, connection, metadata, executionContext);
        } else if (command instanceof Insert) {
            result = new InsertExecutionImpl(this, command, connection, metadata, executionContext);
        } else if (command instanceof Update) {
            result = new UpdateExecutionImpl(this, command, connection, metadata, executionContext);
        }
        return result;
    }

    public ProcedureExecution createProcedureExecution(Call command, ExecutionContext executionContext, RuntimeMetadata metadata, SalesforceConnection connection) throws TranslatorException {
        Procedure metadataObject = command.getMetadataObject();
        String nativeQuery = metadataObject.getProperty("{http://www.teiid.org/ext/relational/2012}native-query", false);
        if (nativeQuery != null) {
            return new DirectQueryExecution(command.getArguments(), (Command)command, connection, metadata, executionContext, nativeQuery, false);
        }
        return new ProcedureExecutionParentImpl(command, connection, metadata, executionContext);
    }

    public ProcedureExecution createDirectExecution(List<Argument> arguments, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, SalesforceConnection connection) throws TranslatorException {
        return new DirectQueryExecution(arguments.subList(1, arguments.size()), command, connection, metadata, executionContext, (String)arguments.get(0).getArgumentValue().getValue(), true);
    }

    public void getMetadata(MetadataFactory metadataFactory, SalesforceConnection connection) throws TranslatorException {
        if (metadataFactory.getModelProperties().getProperty("importer.modelAuditFields") == null) {
            metadataFactory.getModelProperties().setProperty("importer.modelAuditFields", String.valueOf(this.auditModelFields));
        }
        super.getMetadata(metadataFactory, (Object)connection);
    }

    public MetadataProcessor<SalesforceConnection> getMetadataProcessor() {
        return new SalesForceMetadataProcessor();
    }

    public List<String> getSupportedFunctions() {
        return Arrays.asList(INCLUDES, EXCLUDES);
    }

    public boolean supportsCompareCriteriaEquals() {
        return true;
    }

    public boolean supportsInCriteria() {
        return true;
    }

    public boolean supportsLikeCriteria() {
        return true;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsAggregatesCountStar() {
        return true;
    }

    public boolean supportsAggregatesCount() {
        return true;
    }

    public boolean supportsAggregatesMax() {
        return true;
    }

    public boolean supportsAggregatesMin() {
        return true;
    }

    public boolean supportsAggregatesSum() {
        return true;
    }

    public boolean supportsAggregatesAvg() {
        return true;
    }

    @TranslatorProperty(display="Supports Group By", description="Defaults to true. Set to false to have Teiid process group by aggregations, such as those returning more than 2000 rows which error in SOQL", advanced=true)
    public boolean supportsGroupBy() {
        return this.supportsGroupBy;
    }

    public boolean supportsOnlySingleTableGroupBy() {
        return true;
    }

    public boolean supportsNotCriteria() {
        return true;
    }

    public boolean supportsOrCriteria() {
        return true;
    }

    public boolean supportsCompareCriteriaOrdered() {
        return true;
    }

    public boolean supportsIsNullCriteria() {
        return true;
    }

    public boolean supportsOnlyLiteralComparison() {
        return true;
    }

    public boolean supportsHaving() {
        return true;
    }

    public int getMaxFromGroups() {
        return 2;
    }

    public boolean useAnsiJoin() {
        return true;
    }

    public boolean supportsBulkUpdate() {
        return true;
    }

    @TranslatorProperty(display="Max Bulk Insert Batch Size", description="The max size of a bulk insert batch.  Default 2048.", advanced=true)
    public int getMaxBulkInsertBatchSize() {
        return this.maxInsertBatchSize;
    }

    public void setMaxBulkInsertBatchSize(int maxInsertBatchSize) {
        if (maxInsertBatchSize < 1) {
            throw new AssertionError((Object)"Max bulk insert batch size must be greater than 0");
        }
        this.maxInsertBatchSize = maxInsertBatchSize;
    }

    public void setSupportsGroupBy(boolean supportsGroupBy) {
        this.supportsGroupBy = supportsGroupBy;
    }

    public QueryResult buildQueryResult(SObject[] objects) {
        QueryResult result = new QueryResult();
        result.setRecords((ISObject[])objects);
        result.setSize(objects.length);
        result.setDone(true);
        return result;
    }

    public boolean supportsUpsert() {
        return true;
    }
}

