/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.salesforce.execution;

import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.sobject.SObject;
import java.util.ArrayList;
import org.teiid.core.BundleUtil;
import org.teiid.language.Command;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.salesforce.SalesForceExecutionFactory;
import org.teiid.translator.salesforce.SalesForcePlugin;
import org.teiid.translator.salesforce.SalesforceConnection;
import org.teiid.translator.salesforce.Util;
import org.teiid.translator.salesforce.execution.visitors.IQueryProvidingVisitor;

public abstract class AbstractUpdateExecution
implements UpdateExecution {
    protected SalesForceExecutionFactory executionFactory;
    protected SalesforceConnection connection;
    protected RuntimeMetadata metadata;
    protected ExecutionContext context;
    protected Command command;
    protected int result;

    public AbstractUpdateExecution(SalesForceExecutionFactory ef, Command command, SalesforceConnection salesforceConnection, RuntimeMetadata metadata, ExecutionContext context) {
        this.executionFactory = ef;
        this.connection = salesforceConnection;
        this.metadata = metadata;
        this.context = context;
        this.command = command;
    }

    public void cancel() throws TranslatorException {
    }

    public void close() {
    }

    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
        return new int[]{this.result};
    }

    public RuntimeMetadata getMetadata() {
        return this.metadata;
    }

    public SalesforceConnection getConnection() {
        return this.connection;
    }

    void execute(Condition criteria, IQueryProvidingVisitor visitor) throws TranslatorException {
        int batchSize = 2000;
        int updateSize = 200;
        String[] Ids = null;
        if (visitor.hasOnlyIDCriteria()) {
            try {
                String Id = ((Comparison)criteria).getRightExpression().toString();
                Id = Util.stripQutes(Id);
                Ids = new String[]{Id};
                this.result = this.processIds(Ids, visitor);
            }
            catch (ClassCastException cce) {
                throw new RuntimeException(SalesForcePlugin.Util.gs((BundleUtil.Event)SalesForcePlugin.Event.TEIID13008, new Object[0]));
            }
        } else {
            String query = visitor.getQuery();
            this.context.logCommand(new Object[]{query});
            QueryResult results = this.getConnection().query(query, batchSize, Boolean.FALSE);
            ArrayList<String> idList = new ArrayList<String>(results.getRecords().length);
            while (results != null) {
                if (results.getSize() > 0) {
                    for (int i = 0; i < results.getRecords().length; ++i) {
                        SObject sObject = results.getRecords()[i];
                        idList.add(sObject.getId());
                        if (idList.size() != updateSize) continue;
                        Ids = idList.toArray(new String[0]);
                        this.result += this.processIds(Ids, visitor);
                        idList.clear();
                    }
                }
                if (results.isDone()) break;
                results = this.connection.queryMore(results.getQueryLocator(), batchSize);
            }
            if (!idList.isEmpty()) {
                Ids = idList.toArray(new String[0]);
                this.result += this.processIds(Ids, visitor);
            }
        }
    }

    protected int processIds(String[] ids, IQueryProvidingVisitor visitor) throws TranslatorException {
        return 0;
    }
}

