/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.salesforce.execution;

import com.sforce.async.BatchResult;
import com.sforce.async.JobInfo;
import com.sforce.async.JobStateEnum;
import com.sforce.async.OperationEnum;
import com.sforce.async.Result;
import com.sforce.async.SObject;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.DataTypeManager;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.Expression;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Insert;
import org.teiid.language.Literal;
import org.teiid.language.Parameter;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.salesforce.SalesForceExecutionFactory;
import org.teiid.translator.salesforce.SalesForcePlugin;
import org.teiid.translator.salesforce.SalesforceConnection;
import org.teiid.translator.salesforce.execution.AbstractUpdateExecution;
import org.teiid.translator.salesforce.execution.DataPayload;
import org.teiid.translator.salesforce.execution.visitors.InsertVisitor;

public class InsertExecutionImpl
extends AbstractUpdateExecution {
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private JobInfo activeJob;
    private List<String> batches = new ArrayList<String>();
    private Iterator<? extends List<?>> rowIter;
    private String objectName;
    private List<Integer> counts;

    public InsertExecutionImpl(SalesForceExecutionFactory ef, Command command, SalesforceConnection salesforceConnection, RuntimeMetadata metadata, ExecutionContext context) throws TranslatorException {
        super(ef, command, salesforceConnection, metadata, context);
        Insert insert = (Insert)command;
        if (insert.getParameterValues() != null) {
            this.rowIter = insert.getParameterValues();
        }
        InsertVisitor visitor = new InsertVisitor(this.getMetadata());
        visitor.visit(insert);
        this.objectName = visitor.getTableName();
    }

    public void execute() throws TranslatorException {
        Insert insert = (Insert)this.command;
        if (insert.getParameterValues() == null) {
            DataPayload data = new DataPayload();
            data.setType(this.objectName);
            this.buildSingleRowInsertPayload(insert, data);
            this.result = insert.isUpsert() ? this.getConnection().upsert(data) : this.getConnection().create(data);
        } else {
            BatchResult[] batchResult;
            if (this.activeJob == null) {
                this.activeJob = this.getConnection().createBulkJob(this.objectName, insert.isUpsert() ? OperationEnum.upsert : OperationEnum.insert, false);
                this.counts = new ArrayList<Integer>();
            }
            if (this.activeJob.getState() == JobStateEnum.Open) {
                while (this.rowIter.hasNext()) {
                    List<SObject> rows = this.buildBulkRowPayload(insert, this.rowIter, this.executionFactory.getMaxBulkInsertBatchSize());
                    this.batches.add(this.getConnection().addBatch(rows, this.activeJob));
                }
                this.activeJob = this.getConnection().closeJob(this.activeJob.getId());
            }
            for (BatchResult br : batchResult = this.getConnection().getBulkResults(this.activeJob, this.batches)) {
                for (Result r : br.getResult()) {
                    if (r.isSuccess() && r.isCreated()) {
                        this.counts.add(1);
                        continue;
                    }
                    if (r.getErrors().length > 0) {
                        this.counts.add(-3);
                        this.context.addWarning((Exception)new SQLWarning(r.getErrors()[0].getMessage(), r.getErrors()[0].getStatusCode().name()));
                        continue;
                    }
                    this.counts.add(-2);
                }
            }
            this.activeJob = null;
        }
    }

    private void buildSingleRowInsertPayload(Insert insert, DataPayload data) throws TranslatorException {
        List columns = insert.getColumns();
        List values = ((ExpressionValueSource)insert.getValueSource()).getValues();
        if (columns.size() != values.size()) {
            throw new TranslatorException(SalesForcePlugin.Util.gs((BundleUtil.Event)SalesForcePlugin.Event.TEIID13006, new Object[0]));
        }
        for (int i = 0; i < columns.size(); ++i) {
            Column column = ((ColumnReference)columns.get(i)).getMetadataObject();
            Object value = values.get(i);
            if (!(value instanceof Literal)) {
                throw new TranslatorException(SalesForcePlugin.Util.gs((BundleUtil.Event)SalesForcePlugin.Event.TEIID13007, new Object[0]));
            }
            Literal literalValue = (Literal)values.get(i);
            Object val = literalValue.getValue();
            if (val instanceof Timestamp) {
                Calendar cal = Calendar.getInstance();
                cal.setTime((Timestamp)val);
                val = cal;
            }
            data.addField(column.getSourceName(), val);
        }
    }

    private String getStringValue(Object val, Class<?> type) {
        if (val == null) {
            return null;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
            return this.sdf.format(val);
        }
        return val.toString();
    }

    protected List<SObject> buildBulkRowPayload(Insert insert, Iterator<? extends List<?>> it, int rowCount) throws TranslatorException {
        ArrayList<SObject> rows = new ArrayList<SObject>();
        List columns = insert.getColumns();
        int boundCount = 0;
        List literalValues = ((ExpressionValueSource)insert.getValueSource()).getValues();
        while (it.hasNext() && boundCount < rowCount) {
            ++boundCount;
            List<?> values = it.next();
            SObject sobj = new SObject();
            for (int i = 0; i < columns.size(); ++i) {
                Expression ex = (Expression)literalValues.get(i);
                ColumnReference element = (ColumnReference)columns.get(i);
                Column column = element.getMetadataObject();
                Class type = ex.getType();
                Object value = null;
                if (ex instanceof Parameter) {
                    value = values.get(((Parameter)ex).getValueIndex());
                } else {
                    if (!(ex instanceof Literal)) {
                        throw new TranslatorException(SalesForcePlugin.Util.gs((BundleUtil.Event)SalesForcePlugin.Event.TEIID13007, new Object[0]));
                    }
                    value = ((Literal)ex).getValue();
                }
                sobj.setField(column.getSourceName(), this.getStringValue(value, type));
            }
            rows.add(sobj);
        }
        return rows;
    }

    @Override
    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
        if (this.counts != null) {
            int[] countArray = new int[this.counts.size()];
            for (int i = 0; i < countArray.length; ++i) {
                countArray[i] = this.counts.get(i);
            }
            return countArray;
        }
        return new int[]{this.result};
    }

    @Override
    public void cancel() throws TranslatorException {
        if (this.activeJob != null) {
            this.getConnection().cancelBulkJob(this.activeJob);
        }
    }
}

