/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.salesforce.execution.visitors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.teiid.language.AggregateFunction;
import org.teiid.language.AndOr;
import org.teiid.language.ColumnReference;
import org.teiid.language.Condition;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Expression;
import org.teiid.language.GroupBy;
import org.teiid.language.LanguageFactory;
import org.teiid.language.LanguageObject;
import org.teiid.language.Limit;
import org.teiid.language.NamedTable;
import org.teiid.language.Select;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.salesforce.SalesForcePlugin;
import org.teiid.translator.salesforce.execution.visitors.CriteriaVisitor;
import org.teiid.translator.salesforce.execution.visitors.IQueryProvidingVisitor;

public class SelectVisitor
extends CriteriaVisitor
implements IQueryProvidingVisitor {
    public static final String AGG_PREFIX = "expr";
    private Map<Integer, Expression> selectSymbolIndexToElement = new HashMap<Integer, Expression>();
    private int selectSymbolCount;
    private int idIndex = -1;
    protected List<DerivedColumn> selectSymbols;
    protected StringBuilder limitClause = new StringBuilder();
    protected StringBuilder groupByClause = new StringBuilder();
    protected StringBuilder havingClause = new StringBuilder();
    private Boolean objectSupportsRetrieve;
    private Condition implicitCondition;

    public SelectVisitor(RuntimeMetadata metadata) {
        super(metadata);
    }

    public void visit(Select query) {
        super.visitNodes((Collection)query.getFrom());
        Object condition = query.getWhere();
        if (this.implicitCondition != null) {
            condition = condition != null ? LanguageFactory.INSTANCE.createAndOr(AndOr.Operator.AND, condition, this.implicitCondition) : this.implicitCondition;
        }
        super.visitNode((LanguageObject)condition);
        super.visitNode((LanguageObject)query.getGroupBy());
        if (query.getHaving() != null) {
            Condition c = query.getHaving();
            CriteriaVisitor cv = new CriteriaVisitor(this.metadata);
            cv.visitNode((LanguageObject)c);
            cv.addCriteriaString("HAVING", this.havingClause);
            if (this.havingClause.length() > 0) {
                this.havingClause.append(" ");
            }
        }
        super.visitNode((LanguageObject)query.getLimit());
        if (query.isDistinct()) {
            this.exceptions.add(new TranslatorException(SalesForcePlugin.Util.getString("SelectVisitor.distinct.not.supported")));
        }
        this.selectSymbols = query.getDerivedColumns();
        this.selectSymbolCount = this.selectSymbols.size();
        for (int index = 0; index < this.selectSymbols.size(); ++index) {
            Column element;
            String nameInSource;
            DerivedColumn symbol = this.selectSymbols.get(index);
            Expression expression = symbol.getExpression();
            this.selectSymbolIndexToElement.put(index, expression);
            if (!(expression instanceof ColumnReference) || !(nameInSource = (element = ((ColumnReference)expression).getMetadataObject()).getSourceName()).equalsIgnoreCase("id")) continue;
            this.idIndex = index;
        }
    }

    protected void addCriteria(Condition condition) {
        this.implicitCondition = condition;
    }

    public void visit(GroupBy obj) {
        this.groupByClause.append("GROUP BY ");
        Iterator iter = obj.getElements().iterator();
        while (iter.hasNext()) {
            Expression expr = (Expression)iter.next();
            this.groupByClause.append(this.getValue(expr, false));
            if (!iter.hasNext()) continue;
            this.groupByClause.append(", ");
        }
        this.groupByClause.append(" ");
    }

    public void visit(NamedTable obj) {
        try {
            this.table = obj.getMetadataObject();
            String supportsQuery = this.table.getProperty("{http://www.teiid.org/translator/salesforce/2012}Supports Query", true);
            this.objectSupportsRetrieve = Boolean.valueOf(this.table.getProperty("{http://www.teiid.org/translator/salesforce/2012}Supports Retrieve", true));
            if (supportsQuery != null && !Boolean.valueOf(supportsQuery).booleanValue()) {
                throw new TranslatorException(this.table.getSourceName() + " " + SalesForcePlugin.Util.getString("CriteriaVisitor.query.not.supported"));
            }
            this.loadColumnMetadata(obj);
        }
        catch (TranslatorException ce) {
            this.exceptions.add(ce);
        }
    }

    public void visit(Limit obj) {
        super.visit(obj);
        this.limitClause.append("LIMIT").append(" ").append(obj.getRowLimit());
    }

    @Override
    public String getQuery() throws TranslatorException {
        if (!this.exceptions.isEmpty()) {
            throw (TranslatorException)((Object)this.exceptions.get(0));
        }
        StringBuilder result = new StringBuilder();
        result.append("SELECT").append(" ");
        this.addSelectSymbols(result);
        result.append(" ");
        result.append("FROM").append(" ");
        result.append(this.table.getSourceName()).append(" ");
        this.addCriteriaString(result);
        this.appendGroupByHaving(result);
        result.append((CharSequence)this.limitClause);
        return result.toString();
    }

    protected void appendGroupByHaving(StringBuilder result) {
        result.append((CharSequence)this.groupByClause);
        result.append((CharSequence)this.havingClause);
    }

    private void addSelectSymbols(StringBuilder result) {
        for (int i = 0; i < this.selectSymbols.size(); ++i) {
            Expression expression;
            DerivedColumn symbol = this.selectSymbols.get(i);
            if (i > 0) {
                result.append(", ");
            }
            if ((expression = symbol.getExpression()) instanceof ColumnReference) {
                this.appendColumnReference(result, (ColumnReference)expression);
                continue;
            }
            if (expression instanceof AggregateFunction) {
                AggregateFunction af = (AggregateFunction)expression;
                this.appendAggregateFunction(result, af);
                continue;
            }
            throw new AssertionError((Object)("Unknown select symbol type" + symbol));
        }
    }

    public int getSelectSymbolCount() {
        return this.selectSymbolCount;
    }

    public Expression getSelectSymbolMetadata(int index) {
        return this.selectSymbolIndexToElement.get(index);
    }

    public int getIdIndex() {
        return this.idIndex;
    }

    public boolean getQueryAll() {
        return this.queryAll;
    }

    public String getRetrieveFieldList() {
        this.assertRetrieveValidated();
        StringBuilder result = new StringBuilder();
        this.addSelectSymbols(result);
        return result.toString();
    }

    public List<String> getIdInCriteria() {
        this.assertRetrieveValidated();
        List expressions = this.idInCriteria.getRightExpressions();
        ArrayList<String> result = new ArrayList<String>(expressions.size());
        for (int i = 0; i < expressions.size(); ++i) {
            result.add(this.getValue((Expression)expressions.get(i), true));
        }
        return result;
    }

    private void assertRetrieveValidated() throws AssertionError {
        if (!this.hasOnlyIDCriteria()) {
            throw new AssertionError((Object)"Must call hasOnlyIdInCriteria() before this method");
        }
    }

    public boolean hasOnlyIdInCriteria() {
        return this.hasOnlyIDCriteria() && this.idInCriteria != null;
    }

    public boolean canRetrieve() {
        return this.objectSupportsRetrieve != false && this.hasOnlyIDCriteria() && this.limitClause.length() == 0 && this.groupByClause.length() == 0;
    }

    public boolean hasGroupBy() {
        return this.groupByClause.length() > 0;
    }
}

