/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.cli;

import com.beust.jcommander.Parameter;
import org.apache.accumulo.core.cli.MapReduceClientOpts;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.hadoop.mapreduce.Job;

public class MapReduceClientOnRequiredTable
extends MapReduceClientOpts {
    @Parameter(names={"-t", "--table"}, required=true, description="table to use")
    private String tableName;
    @Parameter(names={"-tf", "--tokenFile"}, description="File in hdfs containing the user's authentication token create with \"bin/accumulo create-token\"")
    private String tokenFile = "";

    @Override
    public void setAccumuloConfigs(Job job) throws AccumuloSecurityException {
        super.setAccumuloConfigs(job);
        String principal = this.getPrincipal();
        String tableName = this.getTableName();
        if (this.tokenFile.isEmpty()) {
            AuthenticationToken token = this.getToken();
            AccumuloInputFormat.setConnectorInfo(job, principal, token);
            AccumuloOutputFormat.setConnectorInfo(job, principal, token);
        } else {
            AccumuloInputFormat.setConnectorInfo(job, principal, this.tokenFile);
            AccumuloOutputFormat.setConnectorInfo(job, principal, this.tokenFile);
        }
        AccumuloInputFormat.setInputTableName(job, tableName);
        AccumuloInputFormat.setScanAuthorizations(job, this.auths);
        AccumuloOutputFormat.setCreateTables(job, true);
        AccumuloOutputFormat.setDefaultTableName(job, tableName);
    }

    public String getTableName() {
        return this.tableName;
    }
}

