/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.TabletServerBatchWriter;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTableBatchWriterImpl
implements MultiTableBatchWriter {
    public static final long DEFAULT_CACHE_TIME = 200L;
    public static final TimeUnit DEFAULT_CACHE_TIME_UNIT = TimeUnit.MILLISECONDS;
    private static final Logger log = LoggerFactory.getLogger(MultiTableBatchWriterImpl.class);
    private AtomicBoolean closed;
    private AtomicLong cacheLastState;
    private TabletServerBatchWriter bw;
    private ConcurrentHashMap<String, BatchWriter> tableWriters;
    private final ClientContext context;
    private final LoadingCache<String, String> nameToIdCache;

    public MultiTableBatchWriterImpl(ClientContext context, BatchWriterConfig config) {
        this(context, config, 200L, DEFAULT_CACHE_TIME_UNIT);
    }

    public MultiTableBatchWriterImpl(ClientContext context, BatchWriterConfig config, long cacheTime, TimeUnit cacheTimeUnit) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config is null");
        Preconditions.checkArgument((cacheTimeUnit != null ? 1 : 0) != 0, (Object)"cacheTimeUnit is null");
        this.context = context;
        this.bw = new TabletServerBatchWriter(context, config);
        this.tableWriters = new ConcurrentHashMap();
        this.closed = new AtomicBoolean(false);
        this.cacheLastState = new AtomicLong(0L);
        this.nameToIdCache = CacheBuilder.newBuilder().expireAfterWrite(cacheTime, cacheTimeUnit).concurrencyLevel(10).maximumSize(10000L).initialCapacity(20).build((CacheLoader)new TableNameToIdLoader());
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() throws MutationsRejectedException {
        this.closed.set(true);
        this.bw.close();
    }

    protected void finalize() {
        if (!this.closed.get()) {
            log.warn(MultiTableBatchWriterImpl.class.getSimpleName() + " not shutdown; did you forget to call close()?");
            try {
                this.close();
            }
            catch (MutationsRejectedException mre) {
                log.error(MultiTableBatchWriterImpl.class.getSimpleName() + " internal error.", (Throwable)mre);
                throw new RuntimeException("Exception when closing " + MultiTableBatchWriterImpl.class.getSimpleName(), mre);
            }
        }
    }

    private String getId(String tableName) throws TableNotFoundException {
        try {
            return (String)this.nameToIdCache.get((Object)tableName);
        }
        catch (UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            log.error("Unexpected exception when fetching table id for " + tableName);
            if (null == cause) {
                throw new RuntimeException(e);
            }
            if (cause instanceof TableNotFoundException) {
                throw (TableNotFoundException)cause;
            }
            if (cause instanceof TableOfflineException) {
                throw (TableOfflineException)cause;
            }
            throw e;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            log.error("Unexpected exception when fetching table id for " + tableName);
            if (null == cause) {
                throw new RuntimeException(e);
            }
            if (cause instanceof TableNotFoundException) {
                throw (TableNotFoundException)cause;
            }
            if (cause instanceof TableOfflineException) {
                throw (TableOfflineException)cause;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public BatchWriter getBatchWriter(String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        String tableId;
        BatchWriter tbw;
        long internalResetCount;
        long cacheResetCount;
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        while ((cacheResetCount = Tables.getCacheResetCount()) > (internalResetCount = this.cacheLastState.get())) {
            if (!this.cacheLastState.compareAndSet(internalResetCount, cacheResetCount)) continue;
            this.nameToIdCache.invalidateAll();
            break;
        }
        if ((tbw = this.tableWriters.get(tableId = this.getId(tableName))) == null) {
            tbw = new TableBatchWriter(tableId);
            BatchWriter current = this.tableWriters.putIfAbsent(tableId, tbw);
            return current != null ? current : tbw;
        }
        return tbw;
    }

    @Override
    public void flush() throws MutationsRejectedException {
        this.bw.flush();
    }

    private class TableNameToIdLoader
    extends CacheLoader<String, String> {
        private TableNameToIdLoader() {
        }

        public String load(String tableName) throws Exception {
            Instance instance = MultiTableBatchWriterImpl.this.context.getInstance();
            String tableId = (String)Tables.getNameToIdMap(instance).get(tableName);
            if (tableId == null) {
                throw new TableNotFoundException(null, tableName, null);
            }
            if (Tables.getTableState(instance, tableId) == TableState.OFFLINE) {
                throw new TableOfflineException(instance, tableId);
            }
            return tableId;
        }
    }

    private class TableBatchWriter
    implements BatchWriter {
        private String table;

        TableBatchWriter(String table) {
            this.table = table;
        }

        @Override
        public void addMutation(Mutation m) throws MutationsRejectedException {
            Preconditions.checkArgument((m != null ? 1 : 0) != 0, (Object)"m is null");
            MultiTableBatchWriterImpl.this.bw.addMutation(this.table, m);
        }

        @Override
        public void addMutations(Iterable<Mutation> iterable) throws MutationsRejectedException {
            MultiTableBatchWriterImpl.this.bw.addMutation(this.table, iterable.iterator());
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException("Must close all tables, can not close an individual table");
        }

        @Override
        public void flush() {
            throw new UnsupportedOperationException("Must flush all tables, can not flush an individual table");
        }
    }
}

