/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.NamespaceExistsException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.DiskUsage;
import org.apache.accumulo.core.client.admin.FindMax;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.client.impl.AccumuloServerException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.ClientExec;
import org.apache.accumulo.core.client.impl.ClientExecReturn;
import org.apache.accumulo.core.client.impl.CompactionStrategyConfigUtil;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.client.impl.ServerClient;
import org.apache.accumulo.core.client.impl.TableOperationsHelper;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.impl.thrift.ClientService;
import org.apache.accumulo.core.client.impl.thrift.TDiskUsage;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.constraints.Constraint;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.master.thrift.FateOperation;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.metadata.MetadataServicer;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.core.util.MapCounter;
import org.apache.accumulo.core.util.NamingThreadFactory;
import org.apache.accumulo.core.util.OpTimer;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.volume.VolumeConfiguration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;

public class TableOperationsImpl
extends TableOperationsHelper {
    public static final String CLONE_EXCLUDE_PREFIX = "!";
    private static final Logger log = Logger.getLogger(TableOperations.class);
    private final ClientContext context;

    public TableOperationsImpl(ClientContext context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        this.context = context;
    }

    @Override
    public SortedSet<String> list() {
        OpTimer opTimer = new OpTimer(log, Level.TRACE).start("Fetching list of tables...");
        TreeSet<String> tableNames = new TreeSet<String>(Tables.getNameToIdMap(this.context.getInstance()).keySet());
        opTimer.stop("Fetched " + tableNames.size() + " table names in %DURATION%");
        return tableNames;
    }

    @Override
    public boolean exists(String tableName) {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        if (tableName.equals("accumulo.metadata") || tableName.equals("accumulo.root")) {
            return true;
        }
        OpTimer opTimer = new OpTimer(log, Level.TRACE).start("Checking if table " + tableName + " exists...");
        boolean exists = Tables.getNameToIdMap(this.context.getInstance()).containsKey(tableName);
        opTimer.stop("Checked existance of " + exists + " in %DURATION%");
        return exists;
    }

    @Override
    public void create(String tableName) throws AccumuloException, AccumuloSecurityException, TableExistsException {
        this.create(tableName, new NewTableConfiguration());
    }

    @Override
    @Deprecated
    public void create(String tableName, boolean limitVersion) throws AccumuloException, AccumuloSecurityException, TableExistsException {
        this.create(tableName, limitVersion, TimeType.MILLIS);
    }

    @Override
    @Deprecated
    public void create(String tableName, boolean limitVersion, TimeType timeType) throws AccumuloException, AccumuloSecurityException, TableExistsException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        Preconditions.checkArgument((timeType != null ? 1 : 0) != 0, (Object)"timeType is null");
        NewTableConfiguration ntc = new NewTableConfiguration().setTimeType(timeType);
        if (limitVersion) {
            this.create(tableName, ntc);
        } else {
            this.create(tableName, ntc.withoutDefaultIterators());
        }
    }

    @Override
    public void create(String tableName, NewTableConfiguration ntc) throws AccumuloException, AccumuloSecurityException, TableExistsException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        Preconditions.checkArgument((ntc != null ? 1 : 0) != 0, (Object)"ntc is null");
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableName.getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap(ntc.getTimeType().name().getBytes(StandardCharsets.UTF_8)));
        Map<String, String> opts = ntc.getProperties();
        try {
            this.doTableFateOperation(tableName, AccumuloException.class, FateOperation.TABLE_CREATE, args, opts);
        }
        catch (TableNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long beginFateOperation() throws ThriftSecurityException, TException {
        while (true) {
            MasterClientService.Client client = null;
            try {
                client = MasterClient.getConnectionWithRetry(this.context);
                long l = client.beginFateOperation(Tracer.traceInfo(), this.context.rpcCreds());
                return l;
            }
            catch (TTransportException tte) {
                log.debug((Object)"Failed to call beginFateOperation(), retrying ... ", (Throwable)tte);
                UtilWaitThread.sleep(100L);
                continue;
            }
            finally {
                MasterClient.close(client);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeFateOperation(long opid, FateOperation op, List<ByteBuffer> args, Map<String, String> opts, boolean autoCleanUp) throws ThriftSecurityException, TException, ThriftTableOperationException {
        while (true) {
            MasterClientService.Client client = null;
            try {
                client = MasterClient.getConnectionWithRetry(this.context);
                client.executeFateOperation(Tracer.traceInfo(), this.context.rpcCreds(), opid, op, args, opts, autoCleanUp);
            }
            catch (TTransportException tte) {
                log.debug((Object)"Failed to call executeFateOperation(), retrying ... ", (Throwable)tte);
                UtilWaitThread.sleep(100L);
                continue;
            }
            finally {
                MasterClient.close(client);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String waitForFateOperation(long opid) throws ThriftSecurityException, TException, ThriftTableOperationException {
        while (true) {
            MasterClientService.Client client = null;
            try {
                client = MasterClient.getConnectionWithRetry(this.context);
                String string = client.waitForFateOperation(Tracer.traceInfo(), this.context.rpcCreds(), opid);
                return string;
            }
            catch (TTransportException tte) {
                log.debug((Object)"Failed to call waitForFateOperation(), retrying ... ", (Throwable)tte);
                UtilWaitThread.sleep(100L);
                continue;
            }
            finally {
                MasterClient.close(client);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishFateOperation(long opid) throws ThriftSecurityException, TException {
        while (true) {
            MasterClientService.Client client = null;
            try {
                client = MasterClient.getConnectionWithRetry(this.context);
                client.finishFateOperation(Tracer.traceInfo(), this.context.rpcCreds(), opid);
            }
            catch (TTransportException tte) {
                log.debug((Object)"Failed to call finishFateOperation(), retrying ... ", (Throwable)tte);
                UtilWaitThread.sleep(100L);
                continue;
            }
            finally {
                MasterClient.close(client);
                continue;
            }
            break;
        }
    }

    String doFateOperation(FateOperation op, List<ByteBuffer> args, Map<String, String> opts, String tableOrNamespaceName) throws AccumuloSecurityException, TableExistsException, TableNotFoundException, AccumuloException, NamespaceExistsException, NamespaceNotFoundException {
        return this.doFateOperation(op, args, opts, tableOrNamespaceName, true);
    }

    String doFateOperation(FateOperation op, List<ByteBuffer> args, Map<String, String> opts, String tableOrNamespaceName, boolean wait) throws AccumuloSecurityException, TableExistsException, TableNotFoundException, AccumuloException, NamespaceExistsException, NamespaceNotFoundException {
        Long opid = null;
        try {
            String ret;
            opid = this.beginFateOperation();
            this.executeFateOperation(opid, op, args, opts, !wait);
            if (!wait) {
                opid = null;
                String string = null;
                return string;
            }
            String e = ret = this.waitForFateOperation(opid);
            return e;
        }
        catch (ThriftSecurityException e) {
            switch (e.getCode()) {
                case TABLE_DOESNT_EXIST: {
                    throw new TableNotFoundException(null, tableOrNamespaceName, "Target table does not exist");
                }
                case NAMESPACE_DOESNT_EXIST: {
                    throw new NamespaceNotFoundException(null, tableOrNamespaceName, "Target namespace does not exist");
                }
            }
            String tableInfo = Tables.getPrintableTableInfoFromName(this.context.getInstance(), tableOrNamespaceName);
            throw new AccumuloSecurityException(e.user, e.code, tableInfo, (Throwable)((Object)e));
        }
        catch (ThriftTableOperationException e) {
            switch (e.getType()) {
                case EXISTS: {
                    throw new TableExistsException(e);
                }
                case NOTFOUND: {
                    throw new TableNotFoundException(e);
                }
                case NAMESPACE_EXISTS: {
                    throw new NamespaceExistsException(e);
                }
                case NAMESPACE_NOTFOUND: {
                    throw new NamespaceNotFoundException(e);
                }
                case OFFLINE: {
                    throw new TableOfflineException(this.context.getInstance(), Tables.getTableId(this.context.getInstance(), tableOrNamespaceName));
                }
            }
            throw new AccumuloException(e.description, (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new AccumuloException(e.getMessage(), e);
        }
        finally {
            Tables.clearCache(this.context.getInstance());
            if (opid != null) {
                try {
                    this.finishFateOperation(opid);
                }
                catch (Exception e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void addSplits(String tableName, SortedSet<Text> partitionKeys) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        String tableId = Tables.getTableId(this.context.getInstance(), tableName);
        ArrayList<Text> splits = new ArrayList<Text>(partitionKeys);
        Collections.sort(splits);
        CountDownLatch latch = new CountDownLatch(splits.size());
        AtomicReference<Object> exception = new AtomicReference<Object>(null);
        ExecutorService executor = Executors.newFixedThreadPool(16, new NamingThreadFactory("addSplits"));
        try {
            executor.submit(new SplitTask(new SplitEnv(tableName, tableId, executor, latch, exception), splits));
            while (!latch.await(100L, TimeUnit.MILLISECONDS)) {
                if (exception.get() == null) continue;
                executor.shutdownNow();
                Exception excep = exception.get();
                if (excep instanceof TableNotFoundException) {
                    throw (TableNotFoundException)excep;
                }
                if (excep instanceof AccumuloException) {
                    throw (AccumuloException)excep;
                }
                if (excep instanceof AccumuloSecurityException) {
                    throw (AccumuloSecurityException)excep;
                }
                if (excep instanceof RuntimeException) {
                    throw (RuntimeException)excep;
                }
                throw new RuntimeException(excep);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSplits(String tableName, SortedSet<Text> partitionKeys, String tableId) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, AccumuloServerException {
        TabletLocator tabLocator = TabletLocator.getLocator(this.context, new Text(tableId));
        for (Text split : partitionKeys) {
            boolean successful = false;
            int attempt = 0;
            long locationFailures = 0L;
            while (!successful) {
                block17: {
                    if (attempt > 0) {
                        UtilWaitThread.sleep(100L);
                    }
                    ++attempt;
                    TabletLocator.TabletLocation tl = tabLocator.locateTablet(this.context, split, false, false);
                    if (tl == null) {
                        if (!Tables.exists(this.context.getInstance(), tableId)) {
                            throw new TableNotFoundException(tableId, tableName, null);
                        }
                        if (Tables.getTableState(this.context.getInstance(), tableId) != TableState.OFFLINE) continue;
                        throw new TableOfflineException(this.context.getInstance(), tableId);
                    }
                    HostAndPort address = HostAndPort.fromString((String)tl.tablet_location);
                    try {
                        TabletClientService.Client client = ThriftUtil.getTServerClient(address, this.context);
                        try {
                            OpTimer opTimer = null;
                            if (log.isTraceEnabled()) {
                                opTimer = new OpTimer(log, Level.TRACE).start("Splitting tablet " + tl.tablet_extent + " on " + address + " at " + split);
                            }
                            client.splitTablet(Tracer.traceInfo(), this.context.rpcCreds(), tl.tablet_extent.toThrift(), TextUtil.getByteBuffer(split));
                            tabLocator.invalidateCache(tl.tablet_extent);
                            if (opTimer == null) break block17;
                            opTimer.stop("Split tablet in %DURATION%");
                        }
                        finally {
                            ThriftUtil.returnClient(client);
                        }
                    }
                    catch (TApplicationException tae) {
                        throw new AccumuloServerException(address.toString(), tae);
                    }
                    catch (TTransportException e) {
                        tabLocator.invalidateCache(this.context.getInstance(), tl.tablet_location);
                        continue;
                    }
                    catch (ThriftSecurityException e) {
                        Tables.clearCache(this.context.getInstance());
                        if (!Tables.exists(this.context.getInstance(), tableId)) {
                            throw new TableNotFoundException(tableId, tableName, null);
                        }
                        throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
                    }
                    catch (NotServingTabletException e) {
                        if (5L == ++locationFailures || 0L == locationFailures % 50L) {
                            log.warn((Object)("Having difficulty locating hosting tabletserver for split " + split + " on table " + tableName + ". Seen " + locationFailures + " failures."));
                        }
                        tabLocator.invalidateCache(tl.tablet_extent);
                        continue;
                    }
                    catch (TException e) {
                        tabLocator.invalidateCache(this.context.getInstance(), tl.tablet_location);
                        continue;
                    }
                }
                successful = true;
            }
        }
    }

    @Override
    public void merge(String tableName, Text start, Text end) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        ByteBuffer EMPTY = ByteBuffer.allocate(0);
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableName.getBytes(StandardCharsets.UTF_8)), start == null ? EMPTY : TextUtil.getByteBuffer(start), end == null ? EMPTY : TextUtil.getByteBuffer(end));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doTableFateOperation(tableName, TableNotFoundException.class, FateOperation.TABLE_MERGE, args, opts);
        }
        catch (TableExistsException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void deleteRows(String tableName, Text start, Text end) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        ByteBuffer EMPTY = ByteBuffer.allocate(0);
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableName.getBytes(StandardCharsets.UTF_8)), start == null ? EMPTY : TextUtil.getByteBuffer(start), end == null ? EMPTY : TextUtil.getByteBuffer(end));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doTableFateOperation(tableName, TableNotFoundException.class, FateOperation.TABLE_DELETE_RANGE, args, opts);
        }
        catch (TableExistsException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Collection<Text> listSplits(String tableName) throws TableNotFoundException, AccumuloSecurityException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        String tableId = Tables.getTableId(this.context.getInstance(), tableName);
        TreeMap<KeyExtent, String> tabletLocations = new TreeMap<KeyExtent, String>();
        while (true) {
            try {
                tabletLocations.clear();
                MetadataServicer.forTableId(this.context, tableId).getTabletLocations(tabletLocations);
            }
            catch (AccumuloSecurityException ase) {
                throw ase;
            }
            catch (Exception e) {
                if (!Tables.exists(this.context.getInstance(), tableId)) {
                    throw new TableNotFoundException(tableId, tableName, null);
                }
                if (e instanceof RuntimeException && e.getCause() instanceof AccumuloSecurityException) {
                    throw (AccumuloSecurityException)e.getCause();
                }
                log.info((Object)(e.getMessage() + " ... retrying ..."));
                UtilWaitThread.sleep(3000L);
                continue;
            }
            break;
        }
        ArrayList<Text> endRows = new ArrayList<Text>(tabletLocations.size());
        for (KeyExtent ke : tabletLocations.keySet()) {
            if (ke.getEndRow() == null) continue;
            endRows.add(ke.getEndRow());
        }
        return endRows;
    }

    @Override
    @Deprecated
    public Collection<Text> getSplits(String tableName) throws TableNotFoundException {
        try {
            return this.listSplits(tableName);
        }
        catch (AccumuloSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Collection<Text> listSplits(String tableName, int maxSplits) throws TableNotFoundException, AccumuloSecurityException {
        Collection<Text> endRows = this.listSplits(tableName);
        if (endRows.size() <= maxSplits) {
            return endRows;
        }
        double r = (double)(maxSplits + 1) / (double)endRows.size();
        double pos = 0.0;
        ArrayList<Text> subset = new ArrayList<Text>(maxSplits);
        int j = 0;
        for (int i = 0; i < endRows.size() && j < maxSplits; ++i) {
            pos += r;
            while (pos > 1.0) {
                subset.add((Text)((ArrayList)endRows).get(i));
                ++j;
                pos -= 1.0;
            }
        }
        return subset;
    }

    @Override
    @Deprecated
    public Collection<Text> getSplits(String tableName, int maxSplits) throws TableNotFoundException {
        try {
            return this.listSplits(tableName, maxSplits);
        }
        catch (AccumuloSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete(String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableName.getBytes(StandardCharsets.UTF_8)));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doTableFateOperation(tableName, TableNotFoundException.class, FateOperation.TABLE_DELETE, args, opts);
        }
        catch (TableExistsException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void clone(String srcTableName, String newTableName, boolean flush2, Map<String, String> propertiesToSet, Set<String> propertiesToExclude) throws AccumuloSecurityException, TableNotFoundException, AccumuloException, TableExistsException {
        Preconditions.checkArgument((srcTableName != null ? 1 : 0) != 0, (Object)"srcTableName is null");
        Preconditions.checkArgument((newTableName != null ? 1 : 0) != 0, (Object)"newTableName is null");
        String srcTableId = Tables.getTableId(this.context.getInstance(), srcTableName);
        if (flush2) {
            this._flush(srcTableId, null, null, true);
        }
        if (propertiesToExclude == null) {
            propertiesToExclude = Collections.emptySet();
        }
        if (propertiesToSet == null) {
            propertiesToSet = Collections.emptyMap();
        }
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(srcTableId.getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap(newTableName.getBytes(StandardCharsets.UTF_8)));
        HashMap<String, String> opts = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : propertiesToSet.entrySet()) {
            if (entry.getKey().startsWith(CLONE_EXCLUDE_PREFIX)) {
                throw new IllegalArgumentException("Property can not start with !");
            }
            opts.put(entry.getKey(), entry.getValue());
        }
        for (String prop : propertiesToExclude) {
            opts.put(CLONE_EXCLUDE_PREFIX + prop, "");
        }
        this.doTableFateOperation(newTableName, AccumuloException.class, FateOperation.TABLE_CLONE, args, opts);
    }

    @Override
    public void rename(String oldTableName, String newTableName) throws AccumuloSecurityException, TableNotFoundException, AccumuloException, TableExistsException {
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(oldTableName.getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap(newTableName.getBytes(StandardCharsets.UTF_8)));
        HashMap<String, String> opts = new HashMap<String, String>();
        this.doTableFateOperation(oldTableName, TableNotFoundException.class, FateOperation.TABLE_RENAME, args, opts);
    }

    @Override
    @Deprecated
    public void flush(String tableName) throws AccumuloException, AccumuloSecurityException {
        try {
            this.flush(tableName, null, null, false);
        }
        catch (TableNotFoundException e) {
            throw new AccumuloException(e.getMessage(), e);
        }
    }

    @Override
    public void flush(String tableName, Text start, Text end, boolean wait) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        String tableId = Tables.getTableId(this.context.getInstance(), tableName);
        this._flush(tableId, start, end, wait);
    }

    @Override
    public void compact(String tableName, Text start, Text end, boolean flush2, boolean wait) throws AccumuloSecurityException, TableNotFoundException, AccumuloException {
        this.compact(tableName, start, end, new ArrayList<IteratorSetting>(), flush2, wait);
    }

    @Override
    public void compact(String tableName, Text start, Text end, List<IteratorSetting> iterators, boolean flush2, boolean wait) throws AccumuloSecurityException, TableNotFoundException, AccumuloException {
        this.compact(tableName, new CompactionConfig().setStartRow(start).setEndRow(end).setIterators(iterators).setFlush(flush2).setWait(wait));
    }

    @Override
    public void compact(String tableName, CompactionConfig config) throws AccumuloSecurityException, TableNotFoundException, AccumuloException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        ByteBuffer EMPTY = ByteBuffer.allocate(0);
        String skviName = SortedKeyValueIterator.class.getName();
        for (IteratorSetting setting : config.getIterators()) {
            String iteratorClass = setting.getIteratorClass();
            if (this.testClassLoad(tableName, iteratorClass, skviName)) continue;
            throw new AccumuloException("TabletServer could not load iterator class " + iteratorClass);
        }
        String compactionStrategyName = config.getCompactionStrategy().getClassName();
        if (!CompactionStrategyConfigUtil.DEFAULT_STRATEGY.getClassName().equals(compactionStrategyName) && !this.testClassLoad(tableName, compactionStrategyName, "org.apache.accumulo.tserver.compaction.CompactionStrategy")) {
            throw new AccumuloException("TabletServer could not load CompactionStrategy class " + compactionStrategyName);
        }
        String tableId = Tables.getTableId(this.context.getInstance(), tableName);
        Text start = config.getStartRow();
        Text end = config.getEndRow();
        if (config.getFlush()) {
            this._flush(tableId, start, end, true);
        }
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableId.getBytes(StandardCharsets.UTF_8)), start == null ? EMPTY : TextUtil.getByteBuffer(start), end == null ? EMPTY : TextUtil.getByteBuffer(end), ByteBuffer.wrap(IteratorUtil.encodeIteratorSettings(config.getIterators())), ByteBuffer.wrap(CompactionStrategyConfigUtil.encode(config.getCompactionStrategy())));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doFateOperation(FateOperation.TABLE_COMPACT, args, opts, tableName, config.getWait());
        }
        catch (TableExistsException e) {
            throw new AssertionError((Object)e);
        }
        catch (NamespaceExistsException e) {
            throw new AssertionError((Object)e);
        }
        catch (NamespaceNotFoundException e) {
            throw new TableNotFoundException(null, tableName, "Namespace not found", e);
        }
    }

    @Override
    public void cancelCompaction(String tableName) throws AccumuloSecurityException, TableNotFoundException, AccumuloException {
        String tableId = Tables.getTableId(this.context.getInstance(), tableName);
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableId.getBytes(StandardCharsets.UTF_8)));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doTableFateOperation(tableName, TableNotFoundException.class, FateOperation.TABLE_CANCEL_COMPACT, args, opts);
        }
        catch (TableExistsException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _flush(String tableId, Text start, Text end, boolean wait) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        try {
            long flushID;
            MasterClientService.Client client;
            while (true) {
                client = null;
                try {
                    client = MasterClient.getConnectionWithRetry(this.context);
                    flushID = client.initiateFlush(Tracer.traceInfo(), this.context.rpcCreds(), tableId);
                }
                catch (TTransportException tte) {
                    log.debug((Object)"Failed to call initiateFlush, retrying ... ", (Throwable)tte);
                    UtilWaitThread.sleep(100L);
                    continue;
                }
                finally {
                    MasterClient.close(client);
                    continue;
                }
                break;
            }
            while (true) {
                client = null;
                try {
                    client = MasterClient.getConnectionWithRetry(this.context);
                    client.waitForFlush(Tracer.traceInfo(), this.context.rpcCreds(), tableId, TextUtil.getByteBuffer(start), TextUtil.getByteBuffer(end), flushID, wait ? Long.MAX_VALUE : 1L);
                }
                catch (TTransportException tte) {
                    log.debug((Object)"Failed to call initiateFlush, retrying ... ", (Throwable)tte);
                    UtilWaitThread.sleep(100L);
                    continue;
                }
                finally {
                    MasterClient.close(client);
                    continue;
                }
                break;
            }
        }
        catch (ThriftSecurityException e) {
            switch (e.getCode()) {
                case TABLE_DOESNT_EXIST: {
                    throw new TableNotFoundException(tableId, null, e.getMessage(), (Throwable)((Object)e));
                }
            }
            log.debug((Object)("flush security exception on table id " + tableId));
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (ThriftTableOperationException e) {
            switch (e.getType()) {
                case NOTFOUND: {
                    throw new TableNotFoundException(e);
                }
            }
            throw new AccumuloException(e.description, (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    @Override
    public void setProperty(final String tableName, final String property, final String value) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (Object)"property is null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value is null");
        try {
            MasterClient.executeTable(this.context, new ClientExec<MasterClientService.Client>(){

                @Override
                public void execute(MasterClientService.Client client) throws Exception {
                    client.setTableProperty(Tracer.traceInfo(), TableOperationsImpl.this.context.rpcCreds(), tableName, property, value);
                }
            });
        }
        catch (TableNotFoundException e) {
            throw new AccumuloException(e);
        }
    }

    @Override
    public void removeProperty(final String tableName, final String property) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (Object)"property is null");
        try {
            MasterClient.executeTable(this.context, new ClientExec<MasterClientService.Client>(){

                @Override
                public void execute(MasterClientService.Client client) throws Exception {
                    client.removeTableProperty(Tracer.traceInfo(), TableOperationsImpl.this.context.rpcCreds(), tableName, property);
                }
            });
        }
        catch (TableNotFoundException e) {
            throw new AccumuloException(e);
        }
    }

    @Override
    public Iterable<Map.Entry<String, String>> getProperties(final String tableName) throws AccumuloException, TableNotFoundException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        try {
            return ServerClient.executeRaw(this.context, new ClientExecReturn<Map<String, String>, ClientService.Client>(){

                @Override
                public Map<String, String> execute(ClientService.Client client) throws Exception {
                    return client.getTableConfiguration(Tracer.traceInfo(), TableOperationsImpl.this.context.rpcCreds(), tableName);
                }
            }).entrySet();
        }
        catch (ThriftTableOperationException e) {
            switch (e.getType()) {
                case NOTFOUND: {
                    throw new TableNotFoundException(e);
                }
                case NAMESPACE_NOTFOUND: {
                    throw new TableNotFoundException(tableName, new NamespaceNotFoundException(e));
                }
            }
            throw new AccumuloException(e.description, (Throwable)((Object)e));
        }
        catch (AccumuloException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    @Override
    public void setLocalityGroups(String tableName, Map<String, Set<Text>> groups) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        HashSet all = new HashSet();
        for (Map.Entry<String, Set<Text>> entry : groups.entrySet()) {
            if (!Collections.disjoint(all, (Collection)entry.getValue())) {
                throw new IllegalArgumentException("Group " + entry.getKey() + " overlaps with another group");
            }
            all.addAll(entry.getValue());
        }
        for (Map.Entry<String, Set<Text>> entry : groups.entrySet()) {
            Set<Text> colFams = entry.getValue();
            String value = LocalityGroupUtil.encodeColumnFamilies(colFams);
            this.setProperty(tableName, (Object)((Object)Property.TABLE_LOCALITY_GROUP_PREFIX) + entry.getKey(), value);
        }
        try {
            this.setProperty(tableName, Property.TABLE_LOCALITY_GROUPS.getKey(), Joiner.on((String)",").join(groups.keySet()));
        }
        catch (AccumuloException e) {
            if (e.getCause() instanceof TableNotFoundException) {
                throw (TableNotFoundException)e.getCause();
            }
            throw e;
        }
        String prefix = Property.TABLE_LOCALITY_GROUP_PREFIX.getKey();
        for (Map.Entry<String, String> entry : this.getProperties(tableName)) {
            String[] parts;
            String group;
            String property = entry.getKey();
            if (!property.startsWith(prefix) || groups.containsKey(group = (parts = property.split("\\."))[parts.length - 1])) continue;
            this.removeProperty(tableName, property);
        }
    }

    @Override
    public Map<String, Set<Text>> getLocalityGroups(String tableName) throws AccumuloException, TableNotFoundException {
        ConfigurationCopy conf = new ConfigurationCopy(this.getProperties(tableName));
        Map<String, Set<ByteSequence>> groups = LocalityGroupUtil.getLocalityGroups(conf);
        HashMap<String, Set<Text>> groups2 = new HashMap<String, Set<Text>>();
        for (Map.Entry<String, Set<ByteSequence>> entry : groups.entrySet()) {
            HashSet<Text> colFams = new HashSet<Text>();
            for (ByteSequence bs : entry.getValue()) {
                colFams.add(new Text(bs.toArray()));
            }
            groups2.put(entry.getKey(), colFams);
        }
        return groups2;
    }

    @Override
    public Set<Range> splitRangeByTablets(String tableName, Range range, int maxSplits) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        Preconditions.checkArgument((range != null ? 1 : 0) != 0, (Object)"range is null");
        if (maxSplits < 1) {
            throw new IllegalArgumentException("maximum splits must be >= 1");
        }
        if (maxSplits == 1) {
            return Collections.singleton(range);
        }
        Random random = new Random();
        HashMap<String, Map<KeyExtent, List<Range>>> binnedRanges = new HashMap<String, Map<KeyExtent, List<Range>>>();
        String tableId = Tables.getTableId(this.context.getInstance(), tableName);
        TabletLocator tl = TabletLocator.getLocator(this.context, new Text(tableId));
        tl.invalidateCache();
        while (!tl.binRanges(this.context, Collections.singletonList(range), binnedRanges).isEmpty()) {
            if (!Tables.exists(this.context.getInstance(), tableId)) {
                throw new TableDeletedException(tableId);
            }
            if (Tables.getTableState(this.context.getInstance(), tableId) == TableState.OFFLINE) {
                throw new TableOfflineException(this.context.getInstance(), tableId);
            }
            log.warn((Object)"Unable to locate bins for specified range. Retrying.");
            UtilWaitThread.sleep(100 + random.nextInt(100));
            binnedRanges.clear();
            tl.invalidateCache();
        }
        LinkedList<Object> unmergedExtents = new LinkedList<Object>();
        ArrayList<Object> mergedExtents = new ArrayList<Object>();
        for (Map map : binnedRanges.values()) {
            unmergedExtents.addAll(map.keySet());
        }
        Collections.sort(unmergedExtents);
        while (unmergedExtents.size() + mergedExtents.size() > maxSplits) {
            if (unmergedExtents.size() >= 2) {
                KeyExtent first = (KeyExtent)unmergedExtents.removeFirst();
                KeyExtent second = (KeyExtent)unmergedExtents.removeFirst();
                first.setEndRow(second.getEndRow());
                mergedExtents.add(first);
                continue;
            }
            mergedExtents.addAll(unmergedExtents);
            unmergedExtents.clear();
            unmergedExtents.addAll(mergedExtents);
            mergedExtents.clear();
        }
        mergedExtents.addAll(unmergedExtents);
        HashSet<Range> ranges = new HashSet<Range>();
        for (KeyExtent keyExtent : mergedExtents) {
            ranges.add(keyExtent.toDataRange().clip(range));
        }
        return ranges;
    }

    private Path checkPath(String dir, String kind, String type) throws IOException, AccumuloException, AccumuloSecurityException {
        FileStatus[] listStatus;
        Path ret;
        Map<String, String> props = this.context.getConnector().instanceOperations().getSystemConfiguration();
        ConfigurationCopy conf = new ConfigurationCopy(props);
        FileSystem fs = VolumeConfiguration.getVolume(dir, CachedConfiguration.getInstance(), conf).getFileSystem();
        if (!fs.exists(ret = dir.contains(":") ? new Path(dir) : fs.makeQualified(new Path(dir)))) {
            throw new AccumuloException(kind + " import " + type + " directory " + dir + " does not exist!");
        }
        if (!fs.getFileStatus(ret).isDirectory()) {
            throw new AccumuloException(kind + " import " + type + " directory " + dir + " is not a directory!");
        }
        if (type.equals("failure") && (listStatus = fs.listStatus(ret)) != null && listStatus.length != 0) {
            throw new AccumuloException("Bulk import failure directory " + ret + " is not empty");
        }
        return ret;
    }

    @Override
    public void importDirectory(String tableName, String dir, String failureDir, boolean setTime) throws IOException, AccumuloSecurityException, TableNotFoundException, AccumuloException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        Preconditions.checkArgument((dir != null ? 1 : 0) != 0, (Object)"dir is null");
        Preconditions.checkArgument((failureDir != null ? 1 : 0) != 0, (Object)"failureDir is null");
        Tables.getTableId(this.context.getInstance(), tableName);
        Path dirPath = this.checkPath(dir, "Bulk", "");
        Path failPath = this.checkPath(failureDir, "Bulk", "failure");
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableName.getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap(dirPath.toString().getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap(failPath.toString().getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap((setTime + "").getBytes(StandardCharsets.UTF_8)));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doTableFateOperation(tableName, TableNotFoundException.class, FateOperation.TABLE_BULK_IMPORT, args, opts);
        }
        catch (TableExistsException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void waitForTableStateTransition(String tableId, TableState expectedState) throws AccumuloException, TableNotFoundException, AccumuloSecurityException {
        Text startRow = null;
        Text lastRow = null;
        while (true) {
            long waitTime;
            if (Tables.getTableState(this.context.getInstance(), tableId) != expectedState) {
                Tables.clearCache(this.context.getInstance());
                if (Tables.getTableState(this.context.getInstance(), tableId) != expectedState) {
                    if (!Tables.exists(this.context.getInstance(), tableId)) {
                        throw new TableDeletedException(tableId);
                    }
                    throw new AccumuloException("Unexpected table state " + tableId + " " + (Object)((Object)Tables.getTableState(this.context.getInstance(), tableId)) + " != " + (Object)((Object)expectedState));
                }
            }
            Range range = new KeyExtent(new Text(tableId), null, null).toMetadataRange();
            range = startRow == null || lastRow == null ? new KeyExtent(new Text(tableId), null, null).toMetadataRange() : new Range(startRow, lastRow);
            String metaTable = "accumulo.metadata";
            if (tableId.equals("!0")) {
                metaTable = "accumulo.root";
            }
            IsolatedScanner scanner = this.createMetadataScanner(metaTable, range);
            RowIterator rowIter = new RowIterator(scanner);
            KeyExtent lastExtent = null;
            int total = 0;
            int waitFor = 0;
            int holes = 0;
            Text continueRow = null;
            MapCounter<String> serverCounts = new MapCounter<String>();
            while (rowIter.hasNext()) {
                Object row = rowIter.next();
                ++total;
                KeyExtent extent = null;
                String future = null;
                String current = null;
                while (row.hasNext()) {
                    Map.Entry entry = (Map.Entry)row.next();
                    Key key = (Key)entry.getKey();
                    if (key.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME)) {
                        future = ((Value)entry.getValue()).toString();
                    }
                    if (key.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME)) {
                        current = ((Value)entry.getValue()).toString();
                    }
                    if (!MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.hasColumns(key)) continue;
                    extent = new KeyExtent(key.getRow(), (Value)entry.getValue());
                }
                if (expectedState == TableState.ONLINE && current == null || expectedState == TableState.OFFLINE && (future != null || current != null)) {
                    if (continueRow == null) {
                        continueRow = extent.getMetadataEntry();
                    }
                    ++waitFor;
                    lastRow = extent.getMetadataEntry();
                    if (current != null) {
                        serverCounts.increment(current, 1L);
                    }
                    if (future != null) {
                        serverCounts.increment(future, 1L);
                    }
                }
                if (!extent.getTableId().toString().equals(tableId)) {
                    throw new AccumuloException("Saw unexpected table Id " + tableId + " " + extent);
                }
                if (lastExtent != null && !extent.isPreviousExtent(lastExtent)) {
                    ++holes;
                }
                lastExtent = extent;
            }
            if (continueRow != null) {
                startRow = continueRow;
            }
            if (holes > 0 || total == 0) {
                startRow = null;
                lastRow = null;
            }
            if (waitFor <= 0 && holes <= 0 && total != 0) break;
            long maxPerServer = 0L;
            if (serverCounts.size() > 0) {
                maxPerServer = Collections.max(serverCounts.values());
                waitTime = maxPerServer * 10L;
            } else {
                waitTime = waitFor * 10;
            }
            waitTime = Math.max(100L, waitTime);
            waitTime = Math.min(5000L, waitTime);
            log.trace((Object)("Waiting for " + waitFor + "(" + maxPerServer + ") tablets, startRow = " + startRow + " lastRow = " + lastRow + ", holes=" + holes + " sleeping:" + waitTime + "ms"));
            UtilWaitThread.sleep(waitTime);
        }
    }

    protected IsolatedScanner createMetadataScanner(String metaTable, Range range) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        Scanner scanner = this.context.getConnector().createScanner(metaTable, Authorizations.EMPTY);
        MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch(scanner);
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME);
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
        scanner.setRange(range);
        return new IsolatedScanner(scanner);
    }

    @Override
    public void offline(String tableName) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        this.offline(tableName, false);
    }

    @Override
    public void offline(String tableName, boolean wait) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        String tableId = Tables.getTableId(this.context.getInstance(), tableName);
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableId.getBytes(StandardCharsets.UTF_8)));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doTableFateOperation(tableName, TableNotFoundException.class, FateOperation.TABLE_OFFLINE, args, opts);
        }
        catch (TableExistsException e) {
            throw new AssertionError((Object)e);
        }
        if (wait) {
            this.waitForTableStateTransition(tableId, TableState.OFFLINE);
        }
    }

    @Override
    public void online(String tableName) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        this.online(tableName, false);
    }

    @Override
    public void online(String tableName, boolean wait) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        String tableId = Tables.getTableId(this.context.getInstance(), tableName);
        TableState expectedState = Tables.getTableState(this.context.getInstance(), tableId, true);
        if (expectedState == TableState.ONLINE) {
            return;
        }
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableId.getBytes(StandardCharsets.UTF_8)));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doTableFateOperation(tableName, TableNotFoundException.class, FateOperation.TABLE_ONLINE, args, opts);
        }
        catch (TableExistsException e) {
            throw new AssertionError((Object)e);
        }
        if (wait) {
            this.waitForTableStateTransition(tableId, TableState.ONLINE);
        }
    }

    @Override
    public void clearLocatorCache(String tableName) throws TableNotFoundException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        TabletLocator tabLocator = TabletLocator.getLocator(this.context, new Text(Tables.getTableId(this.context.getInstance(), tableName)));
        tabLocator.invalidateCache();
    }

    @Override
    public Map<String, String> tableIdMap() {
        return Tables.getNameToIdMap(this.context.getInstance());
    }

    @Override
    public Text getMaxRow(String tableName, Authorizations auths, Text startRow, boolean startInclusive, Text endRow, boolean endInclusive) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        Preconditions.checkArgument((auths != null ? 1 : 0) != 0, (Object)"auths is null");
        Scanner scanner = this.context.getConnector().createScanner(tableName, auths);
        return FindMax.findMax(scanner, startRow, startInclusive, endRow, endInclusive);
    }

    @Override
    public List<DiskUsage> getDiskUsage(Set<String> tableNames) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        List<TDiskUsage> diskUsages = null;
        while (diskUsages == null) {
            Pair<String, ClientService.Client> pair = null;
            try {
                pair = ServerClient.getConnection(this.context, false);
                diskUsages = pair.getSecond().getDiskUsage(tableNames, this.context.rpcCreds());
            }
            catch (ThriftTableOperationException e) {
                switch (e.getType()) {
                    case NOTFOUND: {
                        throw new TableNotFoundException(e);
                    }
                    case NAMESPACE_NOTFOUND: {
                        throw new TableNotFoundException(e.getTableName(), new NamespaceNotFoundException(e));
                    }
                }
                throw new AccumuloException(e.description, (Throwable)((Object)e));
            }
            catch (ThriftSecurityException e) {
                throw new AccumuloSecurityException(e.getUser(), e.getCode());
            }
            catch (TTransportException e) {
                if (pair == null) {
                    log.debug((Object)"Disk usage request failed.  Pair is null.  Retrying request...", (Throwable)e);
                } else {
                    log.debug((Object)("Disk usage request failed " + pair.getFirst() + ", retrying ... "), (Throwable)e);
                }
                UtilWaitThread.sleep(100L);
            }
            catch (TException e) {
                throw new AccumuloException(e);
            }
            finally {
                if (pair == null) continue;
                ServerClient.close(pair.getSecond());
            }
        }
        ArrayList<DiskUsage> finalUsages = new ArrayList<DiskUsage>();
        for (TDiskUsage diskUsage : diskUsages) {
            finalUsages.add(new DiskUsage(new TreeSet<String>(diskUsage.getTables()), diskUsage.getUsage()));
        }
        return finalUsages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, String> getExportedProps(FileSystem fs, Path path) throws IOException {
        HashMap<String, String> props = new HashMap<String, String>();
        try (ZipInputStream zis = new ZipInputStream((InputStream)fs.open(path));){
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                if (!zipEntry.getName().equals("table_config.txt")) continue;
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)zis, StandardCharsets.UTF_8));
                try {
                    String line;
                    while ((line = in.readLine()) != null) {
                        String[] sa = line.split("=", 2);
                        props.put(sa[0], sa[1]);
                    }
                    return props;
                }
                finally {
                    in.close();
                    return props;
                }
            }
        }
    }

    @Override
    public void importTable(String tableName, String importDir) throws TableExistsException, AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        Preconditions.checkArgument((importDir != null ? 1 : 0) != 0, (Object)"importDir is null");
        try {
            importDir = this.checkPath(importDir, "Table", "").toString();
        }
        catch (IOException e) {
            throw new AccumuloException(e);
        }
        try {
            FileSystem fs = new Path(importDir).getFileSystem(CachedConfiguration.getInstance());
            Map<String, String> props = TableOperationsImpl.getExportedProps(fs, new Path(importDir, "exportMetadata.zip"));
            for (Map.Entry<String, String> entry : props.entrySet()) {
                if (!Property.isClassProperty(entry.getKey()) || entry.getValue().contains("org.apache.accumulo.core")) continue;
                Logger.getLogger(this.getClass()).info((Object)("Imported table sets '" + entry.getKey() + "' to '" + entry.getValue() + "'.  Ensure this class is on Accumulo classpath."));
            }
        }
        catch (IOException ioe) {
            Logger.getLogger(this.getClass()).warn((Object)("Failed to check if imported table references external java classes : " + ioe.getMessage()));
        }
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableName.getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap(importDir.getBytes(StandardCharsets.UTF_8)));
        Map<String, String> opts = Collections.emptyMap();
        try {
            this.doTableFateOperation(tableName, AccumuloException.class, FateOperation.TABLE_IMPORT, args, opts);
        }
        catch (TableNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void exportTable(String tableName, String exportDir) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        Preconditions.checkArgument((exportDir != null ? 1 : 0) != 0, (Object)"exportDir is null");
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(tableName.getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap(exportDir.getBytes(StandardCharsets.UTF_8)));
        Map<String, String> opts = Collections.emptyMap();
        try {
            this.doTableFateOperation(tableName, TableNotFoundException.class, FateOperation.TABLE_EXPORT, args, opts);
        }
        catch (TableExistsException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public boolean testClassLoad(final String tableName, final String className, final String asTypeName) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        Preconditions.checkArgument((className != null ? 1 : 0) != 0, (Object)"className is null");
        Preconditions.checkArgument((asTypeName != null ? 1 : 0) != 0, (Object)"asTypeName is null");
        try {
            return ServerClient.executeRaw(this.context, new ClientExecReturn<Boolean, ClientService.Client>(){

                @Override
                public Boolean execute(ClientService.Client client) throws Exception {
                    return client.checkTableClass(Tracer.traceInfo(), TableOperationsImpl.this.context.rpcCreds(), tableName, className, asTypeName);
                }
            });
        }
        catch (ThriftTableOperationException e) {
            switch (e.getType()) {
                case NOTFOUND: {
                    throw new TableNotFoundException(e);
                }
                case NAMESPACE_NOTFOUND: {
                    throw new TableNotFoundException(tableName, new NamespaceNotFoundException(e));
                }
            }
            throw new AccumuloException(e.description, (Throwable)((Object)e));
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (AccumuloException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    @Override
    public void attachIterator(String tableName, IteratorSetting setting, EnumSet<IteratorUtil.IteratorScope> scopes) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        this.testClassLoad(tableName, setting.getIteratorClass(), SortedKeyValueIterator.class.getName());
        super.attachIterator(tableName, setting, scopes);
    }

    @Override
    public int addConstraint(String tableName, String constraintClassName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        this.testClassLoad(tableName, constraintClassName, Constraint.class.getName());
        return super.addConstraint(tableName, constraintClassName);
    }

    private void doTableFateOperation(String tableOrNamespaceName, Class<? extends Exception> namespaceNotFoundExceptionClass, FateOperation op, List<ByteBuffer> args, Map<String, String> opts) throws AccumuloSecurityException, AccumuloException, TableExistsException, TableNotFoundException {
        try {
            this.doFateOperation(op, args, opts, tableOrNamespaceName);
        }
        catch (NamespaceExistsException e) {
            throw new AssertionError((Object)e);
        }
        catch (NamespaceNotFoundException e) {
            if (namespaceNotFoundExceptionClass == null) {
                throw new AssertionError((Object)e);
            }
            if (AccumuloException.class.isAssignableFrom(namespaceNotFoundExceptionClass)) {
                throw new AccumuloException("Cannot create table in non-existent namespace", e);
            }
            if (TableNotFoundException.class.isAssignableFrom(namespaceNotFoundExceptionClass)) {
                throw new TableNotFoundException(null, tableOrNamespaceName, "Namespace not found", e);
            }
            throw new AssertionError((Object)e);
        }
    }

    private class SplitTask
    implements Runnable {
        private List<Text> splits;
        private SplitEnv env;

        SplitTask(SplitEnv env, List<Text> splits) {
            this.env = env;
            this.splits = splits;
        }

        @Override
        public void run() {
            try {
                if (this.env.exception.get() != null) {
                    return;
                }
                if (this.splits.size() <= 2) {
                    TableOperationsImpl.this.addSplits(this.env.tableName, new TreeSet<Text>(this.splits), this.env.tableId);
                    for (int i = 0; i < this.splits.size(); ++i) {
                        this.env.latch.countDown();
                    }
                    return;
                }
                int mid = this.splits.size() / 2;
                TableOperationsImpl.this.addSplits(this.env.tableName, new TreeSet<Text>(this.splits.subList(mid, mid + 1)), this.env.tableId);
                this.env.latch.countDown();
                this.env.executor.submit(new SplitTask(this.env, this.splits.subList(0, mid)));
                this.env.executor.submit(new SplitTask(this.env, this.splits.subList(mid + 1, this.splits.size())));
            }
            catch (Exception e) {
                this.env.exception.compareAndSet(null, e);
            }
        }
    }

    private static class SplitEnv {
        private String tableName;
        private String tableId;
        private ExecutorService executor;
        private CountDownLatch latch;
        private AtomicReference<Exception> exception;

        SplitEnv(String tableName, String tableId, ExecutorService executor, CountDownLatch latch, AtomicReference<Exception> exception) {
            this.tableName = tableName;
            this.tableId = tableId;
            this.executor = executor;
            this.latch = latch;
            this.exception = exception;
        }
    }
}

