/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapred;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.ClientSideIteratorScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.admin.DelegationTokenConfig;
import org.apache.accumulo.core.client.impl.AuthenticationTokenIdentifier;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.impl.DelegationTokenImpl;
import org.apache.accumulo.core.client.impl.OfflineScanner;
import org.apache.accumulo.core.client.impl.ScannerImpl;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.mapred.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapred.RangeInputSplit;
import org.apache.accumulo.core.client.mapred.impl.BatchInputSplit;
import org.apache.accumulo.core.client.mapreduce.InputTableConfig;
import org.apache.accumulo.core.client.mapreduce.impl.SplitUtils;
import org.apache.accumulo.core.client.mapreduce.lib.impl.ConfiguratorBase;
import org.apache.accumulo.core.client.mapreduce.lib.impl.InputConfigurator;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.security.token.Token;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class AbstractInputFormat<K, V>
implements InputFormat<K, V> {
    protected static final Class<?> CLASS = AccumuloInputFormat.class;
    protected static final Logger log = Logger.getLogger(CLASS);

    public static void setConnectorInfo(JobConf job, String principal, AuthenticationToken token) throws AccumuloSecurityException {
        if (token instanceof KerberosToken) {
            log.info((Object)"Received KerberosToken, attempting to fetch DelegationToken");
            try {
                Instance instance = AbstractInputFormat.getInstance(job);
                Connector conn = instance.getConnector(principal, token);
                token = conn.securityOperations().getDelegationToken(new DelegationTokenConfig());
            }
            catch (Exception e) {
                log.warn((Object)"Failed to automatically obtain DelegationToken, Mappers/Reducers will likely fail to communicate with Accumulo", (Throwable)e);
            }
        }
        if (token instanceof DelegationTokenImpl) {
            DelegationTokenImpl delegationToken = (DelegationTokenImpl)token;
            AuthenticationTokenIdentifier identifier = delegationToken.getIdentifier();
            Token hadoopToken = new Token(identifier.getBytes(), delegationToken.getPassword(), identifier.getKind(), delegationToken.getServiceName());
            job.getCredentials().addToken(hadoopToken.getService(), hadoopToken);
        }
        InputConfigurator.setConnectorInfo(CLASS, (Configuration)job, principal, token);
    }

    public static void setConnectorInfo(JobConf job, String principal, String tokenFile) throws AccumuloSecurityException {
        InputConfigurator.setConnectorInfo(CLASS, (Configuration)job, principal, tokenFile);
    }

    protected static Boolean isConnectorInfoSet(JobConf job) {
        return InputConfigurator.isConnectorInfoSet(CLASS, (Configuration)job);
    }

    protected static String getPrincipal(JobConf job) {
        return InputConfigurator.getPrincipal(CLASS, (Configuration)job);
    }

    protected static AuthenticationToken getAuthenticationToken(JobConf job) {
        AuthenticationToken token = InputConfigurator.getAuthenticationToken(CLASS, (Configuration)job);
        return ConfiguratorBase.unwrapAuthenticationToken(job, token);
    }

    @Deprecated
    public static void setZooKeeperInstance(JobConf job, String instanceName, String zooKeepers) {
        AbstractInputFormat.setZooKeeperInstance(job, new ClientConfiguration(new org.apache.commons.configuration.Configuration[0]).withInstance(instanceName).withZkHosts(zooKeepers));
    }

    public static void setZooKeeperInstance(JobConf job, ClientConfiguration clientConfig) {
        InputConfigurator.setZooKeeperInstance(CLASS, (Configuration)job, clientConfig);
    }

    public static void setMockInstance(JobConf job, String instanceName) {
        InputConfigurator.setMockInstance(CLASS, (Configuration)job, instanceName);
    }

    protected static Instance getInstance(JobConf job) {
        return InputConfigurator.getInstance(CLASS, (Configuration)job);
    }

    public static void setLogLevel(JobConf job, Level level) {
        InputConfigurator.setLogLevel(CLASS, (Configuration)job, level);
    }

    protected static Level getLogLevel(JobConf job) {
        return InputConfigurator.getLogLevel(CLASS, (Configuration)job);
    }

    public static void setScanAuthorizations(JobConf job, Authorizations auths) {
        InputConfigurator.setScanAuthorizations(CLASS, (Configuration)job, auths);
    }

    protected static Authorizations getScanAuthorizations(JobConf job) {
        return InputConfigurator.getScanAuthorizations(CLASS, (Configuration)job);
    }

    @Deprecated
    protected static TabletLocator getTabletLocator(JobConf job, String tableId) throws TableNotFoundException {
        return InputConfigurator.getTabletLocator(CLASS, (Configuration)job, tableId);
    }

    protected static ClientConfiguration getClientConfiguration(JobConf job) {
        return InputConfigurator.getClientConfiguration(CLASS, (Configuration)job);
    }

    protected static void validateOptions(JobConf job) throws IOException {
        Connector conn;
        Instance inst = InputConfigurator.validateInstance(CLASS, (Configuration)job);
        String principal = InputConfigurator.getPrincipal(CLASS, (Configuration)job);
        AuthenticationToken token = InputConfigurator.getAuthenticationToken(CLASS, (Configuration)job);
        token = ConfiguratorBase.unwrapAuthenticationToken(job, token);
        try {
            conn = inst.getConnector(principal, token);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        InputConfigurator.validatePermissions(CLASS, (Configuration)job, conn);
    }

    public static Map<String, InputTableConfig> getInputTableConfigs(JobConf job) {
        return InputConfigurator.getInputTableConfigs(CLASS, (Configuration)job);
    }

    public static InputTableConfig getInputTableConfig(JobConf job, String tableName) {
        return InputConfigurator.getInputTableConfig(CLASS, (Configuration)job, tableName);
    }

    Map<String, Map<KeyExtent, List<Range>>> binOfflineTable(JobConf job, String tableId, List<Range> ranges) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        Instance instance = AbstractInputFormat.getInstance(job);
        Connector conn = instance.getConnector(AbstractInputFormat.getPrincipal(job), AbstractInputFormat.getAuthenticationToken(job));
        return InputConfigurator.binOffline(tableId, ranges, instance, conn);
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        Level logLevel = AbstractInputFormat.getLogLevel(job);
        log.setLevel(logLevel);
        AbstractInputFormat.validateOptions(job);
        Random random = new Random();
        LinkedList<org.apache.accumulo.core.client.mapreduce.RangeInputSplit> splits = new LinkedList<org.apache.accumulo.core.client.mapreduce.RangeInputSplit>();
        Map<String, InputTableConfig> tableConfigs = AbstractInputFormat.getInputTableConfigs(job);
        for (Map.Entry<String, InputTableConfig> tableConfigEntry : tableConfigs.entrySet()) {
            List<Range> ranges;
            boolean supportBatchScan;
            String tableId;
            String tableName = tableConfigEntry.getKey();
            InputTableConfig tableConfig = tableConfigEntry.getValue();
            Instance instance = AbstractInputFormat.getInstance(job);
            if (instance instanceof MockInstance) {
                tableId = "";
            } else {
                try {
                    tableId = Tables.getTableId(instance, tableName);
                }
                catch (TableNotFoundException e) {
                    throw new IOException(e);
                }
            }
            Authorizations auths = AbstractInputFormat.getScanAuthorizations(job);
            String principal = AbstractInputFormat.getPrincipal(job);
            AuthenticationToken token = AbstractInputFormat.getAuthenticationToken(job);
            boolean batchScan = InputConfigurator.isBatchScan(CLASS, (Configuration)job);
            boolean bl = supportBatchScan = !tableConfig.isOfflineScan() && !tableConfig.shouldUseIsolatedScanners() && !tableConfig.shouldUseLocalIterators();
            if (batchScan && !supportBatchScan) {
                throw new IllegalArgumentException("BatchScanner optimization not available for offline scan, isolated, or local iterators");
            }
            boolean autoAdjust = tableConfig.shouldAutoAdjustRanges();
            if (batchScan && !autoAdjust) {
                throw new IllegalArgumentException("AutoAdjustRanges must be enabled when using BatchScanner optimization");
            }
            List<Range> list = ranges = autoAdjust ? Range.mergeOverlapping(tableConfig.getRanges()) : tableConfig.getRanges();
            if (ranges.isEmpty()) {
                ranges = new ArrayList<Range>(1);
                ranges.add(new Range());
            }
            Map<Object, Object> binnedRanges = new HashMap();
            try {
                if (tableConfig.isOfflineScan()) {
                    binnedRanges = this.binOfflineTable(job, tableId, ranges);
                    while (binnedRanges == null) {
                        UtilWaitThread.sleep(100 + random.nextInt(100));
                        binnedRanges = this.binOfflineTable(job, tableId, ranges);
                    }
                } else {
                    TabletLocator tl = InputConfigurator.getTabletLocator(CLASS, (Configuration)job, tableId);
                    tl.invalidateCache();
                    ClientContext context = new ClientContext(AbstractInputFormat.getInstance(job), new Credentials(AbstractInputFormat.getPrincipal(job), AbstractInputFormat.getAuthenticationToken(job)), AbstractInputFormat.getClientConfiguration(job));
                    while (!tl.binRanges(context, ranges, binnedRanges).isEmpty()) {
                        if (!(instance instanceof MockInstance)) {
                            if (!Tables.exists(instance, tableId)) {
                                throw new TableDeletedException(tableId);
                            }
                            if (Tables.getTableState(instance, tableId) == TableState.OFFLINE) {
                                throw new TableOfflineException(instance, tableId);
                            }
                        }
                        binnedRanges.clear();
                        log.warn((Object)"Unable to locate bins for specified ranges. Retrying.");
                        UtilWaitThread.sleep(100 + random.nextInt(100));
                        tl.invalidateCache();
                    }
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            HashMap<Range, ArrayList<String>> splitsToAdd = null;
            if (!autoAdjust) {
                splitsToAdd = new HashMap<Range, ArrayList<String>>();
            }
            HashMap<String, String> hostNameCache = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : binnedRanges.entrySet()) {
                String ip = ((String)entry.getKey()).split(":", 2)[0];
                String location = (String)hostNameCache.get(ip);
                if (location == null) {
                    InetAddress inetAddress = InetAddress.getByName(ip);
                    location = inetAddress.getCanonicalHostName();
                    hostNameCache.put(ip, location);
                }
                for (Map.Entry extentRanges : ((Map)entry.getValue()).entrySet()) {
                    Range ke = ((KeyExtent)extentRanges.getKey()).toDataRange();
                    if (batchScan) {
                        ArrayList<Range> clippedRanges = new ArrayList<Range>();
                        for (Range r : (List)extentRanges.getValue()) {
                            clippedRanges.add(ke.clip(r));
                        }
                        BatchInputSplit split = new BatchInputSplit(tableName, tableId, clippedRanges, new String[]{location});
                        SplitUtils.updateSplit(split, instance, tableConfig, principal, token, auths, logLevel);
                        splits.add(split);
                        continue;
                    }
                    for (Range r : (List)extentRanges.getValue()) {
                        if (autoAdjust) {
                            RangeInputSplit split = new RangeInputSplit(tableName, tableId, ke.clip(r), new String[]{location});
                            SplitUtils.updateSplit(split, instance, tableConfig, principal, token, auths, logLevel);
                            split.setOffline(tableConfig.isOfflineScan());
                            split.setIsolatedScan(tableConfig.shouldUseIsolatedScanners());
                            split.setUsesLocalIterators(tableConfig.shouldUseLocalIterators());
                            splits.add(split);
                            continue;
                        }
                        ArrayList<String> locations = (ArrayList<String>)splitsToAdd.get(r);
                        if (locations == null) {
                            locations = new ArrayList<String>(1);
                        }
                        locations.add(location);
                        splitsToAdd.put(r, locations);
                    }
                }
            }
            if (autoAdjust) continue;
            for (Map.Entry<Object, Object> entry : splitsToAdd.entrySet()) {
                RangeInputSplit split = new RangeInputSplit(tableName, tableId, (Range)entry.getKey(), ((ArrayList)entry.getValue()).toArray(new String[0]));
                SplitUtils.updateSplit(split, instance, tableConfig, principal, token, auths, logLevel);
                split.setOffline(tableConfig.isOfflineScan());
                split.setIsolatedScan(tableConfig.shouldUseIsolatedScanners());
                split.setUsesLocalIterators(tableConfig.shouldUseLocalIterators());
                splits.add(split);
            }
        }
        return splits.toArray(new InputSplit[splits.size()]);
    }

    protected static abstract class AbstractRecordReader<K, V>
    implements RecordReader<K, V> {
        protected long numKeysRead;
        protected Iterator<Map.Entry<Key, Value>> scannerIterator;
        protected RangeInputSplit split;
        private org.apache.accumulo.core.client.mapreduce.RangeInputSplit baseSplit;
        protected ScannerBase scannerBase;
        protected Key currentKey = null;

        protected AbstractRecordReader() {
        }

        protected abstract List<IteratorSetting> jobIterators(JobConf var1, String var2);

        private void setupIterators(JobConf job, ScannerBase scanner, String tableName, org.apache.accumulo.core.client.mapreduce.RangeInputSplit split) {
            List<IteratorSetting> iterators = null;
            if (null == split) {
                iterators = this.jobIterators(job, tableName);
            } else {
                iterators = split.getIterators();
                if (null == iterators) {
                    iterators = this.jobIterators(job, tableName);
                }
            }
            for (IteratorSetting iterator : iterators) {
                scanner.addScanIterator(iterator);
            }
        }

        @Deprecated
        protected void setupIterators(JobConf job, Scanner scanner, String tableName, RangeInputSplit split) {
            this.setupIterators(job, (ScannerBase)scanner, tableName, (org.apache.accumulo.core.client.mapreduce.RangeInputSplit)split);
        }

        /*
         * WARNING - void declaration
         */
        public void initialize(InputSplit inSplit, JobConf job) throws IOException {
            Authorizations authorizations;
            AuthenticationToken token;
            String principal;
            this.baseSplit = (org.apache.accumulo.core.client.mapreduce.RangeInputSplit)inSplit;
            log.debug((Object)("Initializing input split: " + this.baseSplit.toString()));
            Instance instance = this.baseSplit.getInstance(AbstractInputFormat.getClientConfiguration(job));
            if (null == instance) {
                instance = AbstractInputFormat.getInstance(job);
            }
            if (null == (principal = this.baseSplit.getPrincipal())) {
                principal = AbstractInputFormat.getPrincipal(job);
            }
            if (null == (token = this.baseSplit.getToken())) {
                token = AbstractInputFormat.getAuthenticationToken(job);
            }
            if (null == (authorizations = this.baseSplit.getAuths())) {
                authorizations = AbstractInputFormat.getScanAuthorizations(job);
            }
            String table = this.baseSplit.getTableName();
            InputTableConfig tableConfig = AbstractInputFormat.getInputTableConfig(job, this.baseSplit.getTableName());
            log.debug((Object)("Creating connector with user: " + principal));
            log.debug((Object)("Creating scanner for table: " + table));
            log.debug((Object)("Authorizations are: " + authorizations));
            if (this.baseSplit instanceof BatchInputSplit) {
                BatchScanner scanner;
                BatchInputSplit multiRangeSplit = (BatchInputSplit)this.baseSplit;
                try {
                    int n = 1;
                    scanner = instance.getConnector(principal, token).createBatchScanner(this.baseSplit.getTableName(), authorizations, n);
                    this.setupIterators(job, scanner, this.baseSplit.getTableName(), this.baseSplit);
                }
                catch (Exception exception) {
                    throw new IOException(exception);
                }
                scanner.setRanges(multiRangeSplit.getRanges());
                this.scannerBase = scanner;
            } else if (this.baseSplit instanceof RangeInputSplit) {
                Scanner scanner;
                Boolean bl;
                Boolean isIsolated;
                this.split = (RangeInputSplit)this.baseSplit;
                Boolean isOffline = this.baseSplit.isOffline();
                if (null == isOffline) {
                    isOffline = tableConfig.isOfflineScan();
                }
                if (null == (isIsolated = this.baseSplit.isIsolatedScan())) {
                    isIsolated = tableConfig.shouldUseIsolatedScanners();
                }
                if (null == (bl = this.baseSplit.usesLocalIterators())) {
                    Boolean bl2 = tableConfig.shouldUseLocalIterators();
                }
                try {
                    void var11_14;
                    if (isOffline.booleanValue()) {
                        scanner = new OfflineScanner(instance, new Credentials(principal, token), this.baseSplit.getTableId(), authorizations);
                    } else if (instance instanceof MockInstance) {
                        scanner = instance.getConnector(principal, token).createScanner(this.baseSplit.getTableName(), authorizations);
                    } else {
                        ClientConfiguration clientConf = AbstractInputFormat.getClientConfiguration(job);
                        ClientContext context = new ClientContext(instance, new Credentials(principal, token), clientConf);
                        scanner = new ScannerImpl(context, this.baseSplit.getTableId(), authorizations);
                    }
                    if (isIsolated.booleanValue()) {
                        log.info((Object)"Creating isolated scanner");
                        scanner = new IsolatedScanner(scanner);
                    }
                    if (var11_14.booleanValue()) {
                        log.info((Object)"Using local iterators");
                        scanner = new ClientSideIteratorScanner(scanner);
                    }
                    this.setupIterators(job, (ScannerBase)scanner, this.baseSplit.getTableName(), this.baseSplit);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                scanner.setRange(this.baseSplit.getRange());
                this.scannerBase = scanner;
            } else {
                throw new IllegalArgumentException("Can not initialize from " + ((Object)((Object)this.baseSplit)).getClass().toString());
            }
            Collection<Pair<Text, Text>> columns = this.baseSplit.getFetchedColumns();
            if (null == columns) {
                columns = tableConfig.getFetchedColumns();
            }
            for (Pair pair : columns) {
                if (pair.getSecond() != null) {
                    log.debug((Object)("Fetching column " + pair.getFirst() + ":" + pair.getSecond()));
                    this.scannerBase.fetchColumn((Text)pair.getFirst(), (Text)pair.getSecond());
                    continue;
                }
                log.debug((Object)("Fetching column family " + pair.getFirst()));
                this.scannerBase.fetchColumnFamily((Text)pair.getFirst());
            }
            this.scannerIterator = this.scannerBase.iterator();
            this.numKeysRead = 0L;
        }

        public void close() {
            if (null != this.scannerBase) {
                this.scannerBase.close();
            }
        }

        public long getPos() throws IOException {
            return this.numKeysRead;
        }

        public float getProgress() throws IOException {
            if (this.numKeysRead > 0L && this.currentKey == null) {
                return 1.0f;
            }
            return this.baseSplit.getProgress(this.currentKey);
        }
    }
}

