/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;

public class ConfigurationCopy
extends AccumuloConfiguration {
    final Map<String, String> copy = Collections.synchronizedMap(new HashMap());

    public ConfigurationCopy(Map<String, String> config) {
        this(config.entrySet());
    }

    public ConfigurationCopy(Iterable<Map.Entry<String, String>> config) {
        for (Map.Entry<String, String> entry : config) {
            this.copy.put(entry.getKey(), entry.getValue());
        }
    }

    public ConfigurationCopy() {
        this(new HashMap<String, String>());
    }

    @Override
    public String get(Property property) {
        return this.copy.get(property.getKey());
    }

    @Override
    public void getProperties(Map<String, String> props, Predicate<String> filter) {
        for (Map.Entry<String, String> entry : this.copy.entrySet()) {
            if (!filter.apply((Object)entry.getKey())) continue;
            props.put(entry.getKey(), entry.getValue());
        }
    }

    public void set(Property prop, String value) {
        this.copy.put(prop.getKey(), value);
    }

    public void set(String key, String value) {
        this.copy.put(key, value);
    }
}

