/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.master.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.data.thrift.TKeyExtent;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TabletSplit
implements TBase<TabletSplit, _Fields>,
Serializable,
Cloneable,
Comparable<TabletSplit> {
    private static final TStruct STRUCT_DESC = new TStruct("TabletSplit");
    private static final TField OLD_TABLET_FIELD_DESC = new TField("oldTablet", 12, 1);
    private static final TField NEW_TABLETS_FIELD_DESC = new TField("newTablets", 15, 2);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public TKeyExtent oldTablet;
    public List<TKeyExtent> newTablets;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TabletSplit() {
    }

    public TabletSplit(TKeyExtent oldTablet, List<TKeyExtent> newTablets) {
        this();
        this.oldTablet = oldTablet;
        this.newTablets = newTablets;
    }

    public TabletSplit(TabletSplit other) {
        if (other.isSetOldTablet()) {
            this.oldTablet = new TKeyExtent(other.oldTablet);
        }
        if (other.isSetNewTablets()) {
            ArrayList<TKeyExtent> __this__newTablets = new ArrayList<TKeyExtent>(other.newTablets.size());
            for (TKeyExtent other_element : other.newTablets) {
                __this__newTablets.add(new TKeyExtent(other_element));
            }
            this.newTablets = __this__newTablets;
        }
    }

    public TabletSplit deepCopy() {
        return new TabletSplit(this);
    }

    public void clear() {
        this.oldTablet = null;
        this.newTablets = null;
    }

    public TKeyExtent getOldTablet() {
        return this.oldTablet;
    }

    public TabletSplit setOldTablet(TKeyExtent oldTablet) {
        this.oldTablet = oldTablet;
        return this;
    }

    public void unsetOldTablet() {
        this.oldTablet = null;
    }

    public boolean isSetOldTablet() {
        return this.oldTablet != null;
    }

    public void setOldTabletIsSet(boolean value) {
        if (!value) {
            this.oldTablet = null;
        }
    }

    public int getNewTabletsSize() {
        return this.newTablets == null ? 0 : this.newTablets.size();
    }

    public Iterator<TKeyExtent> getNewTabletsIterator() {
        return this.newTablets == null ? null : this.newTablets.iterator();
    }

    public void addToNewTablets(TKeyExtent elem) {
        if (this.newTablets == null) {
            this.newTablets = new ArrayList<TKeyExtent>();
        }
        this.newTablets.add(elem);
    }

    public List<TKeyExtent> getNewTablets() {
        return this.newTablets;
    }

    public TabletSplit setNewTablets(List<TKeyExtent> newTablets) {
        this.newTablets = newTablets;
        return this;
    }

    public void unsetNewTablets() {
        this.newTablets = null;
    }

    public boolean isSetNewTablets() {
        return this.newTablets != null;
    }

    public void setNewTabletsIsSet(boolean value) {
        if (!value) {
            this.newTablets = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case OLD_TABLET: {
                if (value == null) {
                    this.unsetOldTablet();
                    break;
                }
                this.setOldTablet((TKeyExtent)value);
                break;
            }
            case NEW_TABLETS: {
                if (value == null) {
                    this.unsetNewTablets();
                    break;
                }
                this.setNewTablets((List)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case OLD_TABLET: {
                return this.getOldTablet();
            }
            case NEW_TABLETS: {
                return this.getNewTablets();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case OLD_TABLET: {
                return this.isSetOldTablet();
            }
            case NEW_TABLETS: {
                return this.isSetNewTablets();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TabletSplit) {
            return this.equals((TabletSplit)that);
        }
        return false;
    }

    public boolean equals(TabletSplit that) {
        if (that == null) {
            return false;
        }
        boolean this_present_oldTablet = this.isSetOldTablet();
        boolean that_present_oldTablet = that.isSetOldTablet();
        if (this_present_oldTablet || that_present_oldTablet) {
            if (!this_present_oldTablet || !that_present_oldTablet) {
                return false;
            }
            if (!this.oldTablet.equals(that.oldTablet)) {
                return false;
            }
        }
        boolean this_present_newTablets = this.isSetNewTablets();
        boolean that_present_newTablets = that.isSetNewTablets();
        if (this_present_newTablets || that_present_newTablets) {
            if (!this_present_newTablets || !that_present_newTablets) {
                return false;
            }
            if (!this.newTablets.equals(that.newTablets)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public int compareTo(TabletSplit other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetOldTablet()).compareTo(other.isSetOldTablet());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOldTablet() && (lastComparison = TBaseHelper.compareTo((Comparable)this.oldTablet, (Comparable)other.oldTablet)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetNewTablets()).compareTo(other.isSetNewTablets());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNewTablets() && (lastComparison = TBaseHelper.compareTo(this.newTablets, other.newTablets)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TabletSplit(");
        boolean first = true;
        sb.append("oldTablet:");
        if (this.oldTablet == null) {
            sb.append("null");
        } else {
            sb.append(this.oldTablet);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("newTablets:");
        if (this.newTablets == null) {
            sb.append("null");
        } else {
            sb.append(this.newTablets);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.oldTablet != null) {
            this.oldTablet.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new TabletSplitStandardSchemeFactory());
        schemes.put(TupleScheme.class, new TabletSplitTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.OLD_TABLET, new FieldMetaData("oldTablet", 3, (FieldValueMetaData)new StructMetaData(12, TKeyExtent.class)));
        tmpMap.put(_Fields.NEW_TABLETS, new FieldMetaData("newTablets", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TKeyExtent.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TabletSplit.class, metaDataMap);
    }

    private static class TabletSplitTupleScheme
    extends TupleScheme<TabletSplit> {
        private TabletSplitTupleScheme() {
        }

        public void write(TProtocol prot, TabletSplit struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetOldTablet()) {
                optionals.set(0);
            }
            if (struct.isSetNewTablets()) {
                optionals.set(1);
            }
            oprot.writeBitSet(optionals, 2);
            if (struct.isSetOldTablet()) {
                struct.oldTablet.write((TProtocol)oprot);
            }
            if (struct.isSetNewTablets()) {
                oprot.writeI32(struct.newTablets.size());
                for (TKeyExtent _iter66 : struct.newTablets) {
                    _iter66.write((TProtocol)oprot);
                }
            }
        }

        public void read(TProtocol prot, TabletSplit struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(2);
            if (incoming.get(0)) {
                struct.oldTablet = new TKeyExtent();
                struct.oldTablet.read((TProtocol)iprot);
                struct.setOldTabletIsSet(true);
            }
            if (incoming.get(1)) {
                TList _list67 = new TList(12, iprot.readI32());
                struct.newTablets = new ArrayList<TKeyExtent>(_list67.size);
                for (int _i68 = 0; _i68 < _list67.size; ++_i68) {
                    TKeyExtent _elem69 = new TKeyExtent();
                    _elem69.read((TProtocol)iprot);
                    struct.newTablets.add(_elem69);
                }
                struct.setNewTabletsIsSet(true);
            }
        }
    }

    private static class TabletSplitTupleSchemeFactory
    implements SchemeFactory {
        private TabletSplitTupleSchemeFactory() {
        }

        public TabletSplitTupleScheme getScheme() {
            return new TabletSplitTupleScheme();
        }
    }

    private static class TabletSplitStandardScheme
    extends StandardScheme<TabletSplit> {
        private TabletSplitStandardScheme() {
        }

        public void read(TProtocol iprot, TabletSplit struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 12) {
                            struct.oldTablet = new TKeyExtent();
                            struct.oldTablet.read(iprot);
                            struct.setOldTabletIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 15) {
                            TList _list62 = iprot.readListBegin();
                            struct.newTablets = new ArrayList<TKeyExtent>(_list62.size);
                            for (int _i63 = 0; _i63 < _list62.size; ++_i63) {
                                TKeyExtent _elem64 = new TKeyExtent();
                                _elem64.read(iprot);
                                struct.newTablets.add(_elem64);
                            }
                            iprot.readListEnd();
                            struct.setNewTabletsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TabletSplit struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.oldTablet != null) {
                oprot.writeFieldBegin(OLD_TABLET_FIELD_DESC);
                struct.oldTablet.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.newTablets != null) {
                oprot.writeFieldBegin(NEW_TABLETS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.newTablets.size()));
                for (TKeyExtent _iter65 : struct.newTablets) {
                    _iter65.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TabletSplitStandardSchemeFactory
    implements SchemeFactory {
        private TabletSplitStandardSchemeFactory() {
        }

        public TabletSplitStandardScheme getScheme() {
            return new TabletSplitStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        OLD_TABLET(1, "oldTablet"),
        NEW_TABLETS(2, "newTablets");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return OLD_TABLET;
                }
                case 2: {
                    return NEW_TABLETS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

