/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.security.crypto;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.security.crypto.CryptoModule;
import org.apache.accumulo.core.security.crypto.CryptoModuleParameters;
import org.apache.accumulo.core.security.crypto.SecretKeyEncryptionStrategy;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoModuleFactory {
    private static final Logger log = LoggerFactory.getLogger(CryptoModuleFactory.class);
    private static final Map<String, CryptoModule> cryptoModulesCache = new HashMap<String, CryptoModule>();
    private static final Map<String, SecretKeyEncryptionStrategy> secretKeyEncryptionStrategyCache = new HashMap<String, SecretKeyEncryptionStrategy>();

    public static CryptoModule getCryptoModule(AccumuloConfiguration conf) {
        String cryptoModuleClassname = conf.get(Property.CRYPTO_MODULE_CLASS);
        return CryptoModuleFactory.getCryptoModule(cryptoModuleClassname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CryptoModule getCryptoModule(String cryptoModuleClassname) {
        if (cryptoModuleClassname != null) {
            cryptoModuleClassname = cryptoModuleClassname.trim();
        }
        if (cryptoModuleClassname == null || cryptoModuleClassname.equals("NullCryptoModule")) {
            return new NullCryptoModule();
        }
        CryptoModule cryptoModule = null;
        Map<String, CryptoModule> map = cryptoModulesCache;
        synchronized (map) {
            if (cryptoModulesCache.containsKey(cryptoModuleClassname)) {
                cryptoModule = cryptoModulesCache.get(cryptoModuleClassname);
            } else {
                cryptoModule = CryptoModuleFactory.instantiateCryptoModule(cryptoModuleClassname);
                cryptoModulesCache.put(cryptoModuleClassname, cryptoModule);
            }
        }
        return cryptoModule;
    }

    private static CryptoModule instantiateCryptoModule(String cryptoModuleClassname) {
        log.debug(String.format("About to instantiate crypto module %s", cryptoModuleClassname));
        CryptoModule cryptoModule = null;
        Class cryptoModuleClazz = null;
        try {
            cryptoModuleClazz = AccumuloVFSClassLoader.loadClass((String)cryptoModuleClassname);
        }
        catch (ClassNotFoundException e1) {
            log.warn(String.format("Could not find configured crypto module \"%s\".  No encryption will be used.", cryptoModuleClassname));
            return new NullCryptoModule();
        }
        Class<?>[] interfaces = cryptoModuleClazz.getInterfaces();
        boolean implementsCryptoModule = false;
        for (Class<?> clazz : interfaces) {
            if (!clazz.equals(CryptoModule.class)) continue;
            implementsCryptoModule = true;
            break;
        }
        if (!implementsCryptoModule) {
            log.warn("Configured Accumulo crypto module \"" + cryptoModuleClassname + "\" does not implement the CryptoModule interface. No encryption will be used.");
            return new NullCryptoModule();
        }
        try {
            cryptoModule = (CryptoModule)cryptoModuleClazz.newInstance();
            log.debug("Successfully instantiated crypto module " + cryptoModuleClassname);
        }
        catch (InstantiationException e) {
            log.warn(String.format("Got instantiation exception %s when instantiating crypto module \"%s\".  No encryption will be used.", e.getCause().getClass().getName(), cryptoModuleClassname));
            log.warn("InstantiationException", e.getCause());
            return new NullCryptoModule();
        }
        catch (IllegalAccessException e) {
            log.warn(String.format("Got illegal access exception when trying to instantiate crypto module \"%s\".  No encryption will be used.", cryptoModuleClassname));
            log.warn("IllegalAccessException", (Throwable)e);
            return new NullCryptoModule();
        }
        return cryptoModule;
    }

    public static SecretKeyEncryptionStrategy getSecretKeyEncryptionStrategy(AccumuloConfiguration conf) {
        String className = conf.get(Property.CRYPTO_SECRET_KEY_ENCRYPTION_STRATEGY_CLASS);
        return CryptoModuleFactory.getSecretKeyEncryptionStrategy(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecretKeyEncryptionStrategy getSecretKeyEncryptionStrategy(String className) {
        if (className != null) {
            className = className.trim();
        }
        if (className == null || className.equals("NullSecretKeyEncryptionStrategy")) {
            return new NullSecretKeyEncryptionStrategy();
        }
        SecretKeyEncryptionStrategy strategy = null;
        Map<String, SecretKeyEncryptionStrategy> map = secretKeyEncryptionStrategyCache;
        synchronized (map) {
            if (secretKeyEncryptionStrategyCache.containsKey(className)) {
                strategy = secretKeyEncryptionStrategyCache.get(className);
            } else {
                strategy = CryptoModuleFactory.instantiateSecreteKeyEncryptionStrategy(className);
                secretKeyEncryptionStrategyCache.put(className, strategy);
            }
        }
        return strategy;
    }

    private static SecretKeyEncryptionStrategy instantiateSecreteKeyEncryptionStrategy(String className) {
        log.debug("About to instantiate secret key encryption strategy " + className);
        SecretKeyEncryptionStrategy strategy = null;
        Class keyEncryptionStrategyClazz = null;
        try {
            keyEncryptionStrategyClazz = AccumuloVFSClassLoader.loadClass((String)className);
        }
        catch (ClassNotFoundException e1) {
            log.warn(String.format("Could not find configured secret key encryption strategy \"%s\".  No encryption will be used.", className));
            return new NullSecretKeyEncryptionStrategy();
        }
        Class<?>[] interfaces = keyEncryptionStrategyClazz.getInterfaces();
        boolean implementsSecretKeyStrategy = false;
        for (Class<?> clazz : interfaces) {
            if (!clazz.equals(SecretKeyEncryptionStrategy.class)) continue;
            implementsSecretKeyStrategy = true;
            break;
        }
        if (!implementsSecretKeyStrategy) {
            log.warn("Configured Accumulo secret key encryption strategy \"%s\" does not implement the SecretKeyEncryptionStrategy interface. No encryption will be used.");
            return new NullSecretKeyEncryptionStrategy();
        }
        try {
            strategy = (SecretKeyEncryptionStrategy)keyEncryptionStrategyClazz.newInstance();
            log.debug("Successfully instantiated secret key encryption strategy " + className);
        }
        catch (InstantiationException e) {
            log.warn(String.format("Got instantiation exception %s when instantiating secret key encryption strategy \"%s\".  No encryption will be used.", e.getCause().getClass().getName(), className));
            log.warn("InstantiationException", e.getCause());
            return new NullSecretKeyEncryptionStrategy();
        }
        catch (IllegalAccessException e) {
            log.warn(String.format("Got illegal access exception when trying to instantiate secret key encryption strategy \"%s\".  No encryption will be used.", className));
            log.warn("IllegalAccessException", (Throwable)e);
            return new NullSecretKeyEncryptionStrategy();
        }
        return strategy;
    }

    public static String[] parseCipherTransform(String cipherTransform) {
        if (cipherTransform == null) {
            return new String[3];
        }
        return cipherTransform.split("/");
    }

    public static CryptoModuleParameters createParamsObjectFromAccumuloConfiguration(AccumuloConfiguration conf) {
        CryptoModuleParameters params = new CryptoModuleParameters();
        return CryptoModuleFactory.fillParamsObjectFromConfiguration(params, conf);
    }

    public static CryptoModuleParameters fillParamsObjectFromConfiguration(CryptoModuleParameters params, AccumuloConfiguration conf) {
        Map<String, String> cryptoOpts = conf.getAllPropertiesWithPrefix(Property.CRYPTO_PREFIX);
        cryptoOpts.putAll(conf.getAllPropertiesWithPrefix(Property.INSTANCE_PREFIX));
        cryptoOpts.remove(Property.INSTANCE_SECRET.getKey());
        cryptoOpts.put(Property.CRYPTO_BLOCK_STREAM_SIZE.getKey(), Integer.toString((int)conf.getMemoryInBytes(Property.CRYPTO_BLOCK_STREAM_SIZE)));
        return CryptoModuleFactory.fillParamsObjectFromStringMap(params, cryptoOpts);
    }

    public static CryptoModuleParameters fillParamsObjectFromStringMap(CryptoModuleParameters params, Map<String, String> cryptoOpts) {
        String[] cipherTransformParts = CryptoModuleFactory.parseCipherTransform(cryptoOpts.get(Property.CRYPTO_CIPHER_SUITE.getKey()));
        if (cipherTransformParts[0] == null || cipherTransformParts[0].equals("NullCipher")) {
            params.setAllOptions(cryptoOpts);
            params.setAlgorithmName("NullCipher");
            return params;
        }
        params.setAllOptions(cryptoOpts);
        params.setAlgorithmName(cryptoOpts.get(Property.CRYPTO_CIPHER_ALGORITHM_NAME.getKey()));
        params.setEncryptionMode(cipherTransformParts[1]);
        params.setKeyEncryptionStrategyClass(cryptoOpts.get(Property.CRYPTO_SECRET_KEY_ENCRYPTION_STRATEGY_CLASS.getKey()));
        params.setKeyLength(Integer.parseInt(cryptoOpts.get(Property.CRYPTO_CIPHER_KEY_LENGTH.getKey())));
        params.setOverrideStreamsSecretKeyEncryptionStrategy(Boolean.parseBoolean(cryptoOpts.get(Property.CRYPTO_OVERRIDE_KEY_STRATEGY_WITH_CONFIGURED_STRATEGY.getKey())));
        params.setPadding(cipherTransformParts[2]);
        params.setRandomNumberGenerator(cryptoOpts.get(Property.CRYPTO_SECURE_RNG.getKey()));
        params.setRandomNumberGeneratorProvider(cryptoOpts.get(Property.CRYPTO_SECURE_RNG_PROVIDER.getKey()));
        String blockStreamSize = cryptoOpts.get(Property.CRYPTO_BLOCK_STREAM_SIZE.getKey());
        if (blockStreamSize != null) {
            params.setBlockStreamSize(Integer.parseInt(blockStreamSize));
        }
        return params;
    }

    static class NullCryptoModule
    implements CryptoModule {
        NullCryptoModule() {
        }

        @Override
        public CryptoModuleParameters getEncryptingOutputStream(CryptoModuleParameters params) throws IOException {
            params.setEncryptedOutputStream(params.getPlaintextOutputStream());
            return params;
        }

        @Override
        public CryptoModuleParameters getDecryptingInputStream(CryptoModuleParameters params) throws IOException {
            params.setPlaintextInputStream(params.getEncryptedInputStream());
            return params;
        }

        @Override
        public CryptoModuleParameters generateNewRandomSessionKey(CryptoModuleParameters params) {
            params.setPlaintextKey(new byte[0]);
            return params;
        }

        @Override
        public CryptoModuleParameters initializeCipher(CryptoModuleParameters params) {
            return params;
        }
    }

    static class NullSecretKeyEncryptionStrategy
    implements SecretKeyEncryptionStrategy {
        NullSecretKeyEncryptionStrategy() {
        }

        @Override
        public CryptoModuleParameters encryptSecretKey(CryptoModuleParameters params) {
            params.setEncryptedKey(params.getPlaintextKey());
            params.setOpaqueKeyEncryptionKeyID("");
            return params;
        }

        @Override
        public CryptoModuleParameters decryptSecretKey(CryptoModuleParameters params) {
            params.setPlaintextKey(params.getEncryptedKey());
            return params;
        }
    }
}

