/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;

public class ColumnFQ
implements Comparable<ColumnFQ> {
    private Text colf;
    private Text colq;

    public ColumnFQ(Text colf, Text colq) {
        if (colf == null || colq == null) {
            throw new IllegalArgumentException();
        }
        this.colf = colf;
        this.colq = colq;
    }

    public ColumnFQ(Key k) {
        this(k.getColumnFamily(), k.getColumnQualifier());
    }

    public ColumnFQ(ColumnUpdate cu) {
        this(new Text(cu.getColumnFamily()), new Text(cu.getColumnQualifier()));
    }

    public Text getColumnQualifier() {
        return this.colq;
    }

    public Text getColumnFamily() {
        return this.colf;
    }

    public Column toColumn() {
        return new Column(TextUtil.getBytes(this.colf), TextUtil.getBytes(this.colq), null);
    }

    public void fetch(ScannerBase sb) {
        sb.fetchColumn(this.colf, this.colq);
    }

    public void put(Mutation m, Value v) {
        m.put(this.colf, this.colq, v);
    }

    public void putDelete(Mutation m) {
        m.putDelete(this.colf, this.colq);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ColumnFQ)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        ColumnFQ ocfq = (ColumnFQ)o;
        return ocfq.colf.equals((Object)this.colf) && ocfq.colq.equals((Object)this.colq);
    }

    public int hashCode() {
        return this.colf.hashCode() + this.colq.hashCode();
    }

    public boolean hasColumns(Key key) {
        return key.compareColumnFamily(this.colf) == 0 && key.compareColumnQualifier(this.colq) == 0;
    }

    public boolean equals(Text colf, Text colq) {
        return this.colf.equals((Object)colf) && this.colq.equals((Object)colq);
    }

    @Override
    public int compareTo(ColumnFQ o) {
        int cmp = this.colf.compareTo((BinaryComparable)o.colf);
        if (cmp == 0) {
            cmp = this.colq.compareTo((BinaryComparable)o.colq);
        }
        return cmp;
    }

    public String toString() {
        return this.colf + ":" + this.colq;
    }
}

