/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.cli.ClientOnRequiredTable;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Merge {
    private static final Logger log = LoggerFactory.getLogger(Merge.class);

    protected void message(String format, Object ... args) {
        log.info(String.format(format, args));
    }

    public void start(String[] args) throws MergeException {
        Opts opts = new Opts();
        opts.parseArgs(Merge.class.getName(), args, new Object[0]);
        try {
            Connector conn = opts.getConnector();
            if (!conn.tableOperations().exists(opts.getTableName())) {
                System.err.println("table " + opts.getTableName() + " does not exist");
                return;
            }
            if (opts.goalSize == null || opts.goalSize < 1L) {
                ConfigurationCopy tableConfig = new ConfigurationCopy(conn.tableOperations().getProperties(opts.getTableName()));
                opts.goalSize = tableConfig.getMemoryInBytes(Property.TABLE_SPLIT_THRESHOLD);
            }
            this.message("Merging tablets in table %s to %d bytes", opts.getTableName(), opts.goalSize);
            this.mergomatic(conn, opts.getTableName(), opts.begin, opts.end, opts.goalSize, opts.force);
        }
        catch (Exception ex) {
            throw new MergeException(ex);
        }
    }

    public static void main(String[] args) throws MergeException {
        Merge merge = new Merge();
        merge.start(args);
    }

    public void mergomatic(Connector conn, String table, Text start, Text end, long goalSize, boolean force) throws MergeException {
        try {
            if (table.equals("accumulo.metadata")) {
                throw new IllegalArgumentException("cannot merge tablets on the metadata table");
            }
            ArrayList<Size> sizes = new ArrayList<Size>();
            long totalSize = 0L;
            Iterator<Size> sizeIterator = this.getSizeIterator(conn, table, start, end);
            while (sizeIterator.hasNext()) {
                Size next = sizeIterator.next();
                sizes.add(next);
                if ((totalSize += next.size) <= goalSize) continue;
                totalSize = this.mergeMany(conn, table, sizes, goalSize, force, false);
            }
            if (sizes.size() > 1) {
                this.mergeMany(conn, table, sizes, goalSize, force, true);
            }
        }
        catch (Exception ex) {
            throw new MergeException(ex);
        }
    }

    protected long mergeMany(Connector conn, String table, List<Size> sizes, long goalSize, boolean force, boolean last) throws MergeException {
        while (!sizes.isEmpty() && sizes.get((int)0).size >= goalSize) {
            sizes.remove(0);
        }
        if (sizes.isEmpty()) {
            return 0L;
        }
        long mergeSize = 0L;
        int numToMerge = 0;
        for (int i = 0; i < sizes.size(); ++i) {
            if (mergeSize + sizes.get((int)i).size > goalSize) {
                numToMerge = i;
                break;
            }
            mergeSize += sizes.get((int)i).size;
        }
        if (numToMerge > 1) {
            this.mergeSome(conn, table, sizes, numToMerge);
        } else if (numToMerge == 1 && sizes.size() > 1) {
            if (force) {
                this.mergeSome(conn, table, sizes, 2);
            } else {
                sizes.remove(0);
            }
        }
        if (numToMerge == 0 && sizes.size() > 1 && last) {
            this.mergeSome(conn, table, sizes, sizes.size());
        }
        long result = 0L;
        for (Size s : sizes) {
            result += s.size;
        }
        return result;
    }

    protected void mergeSome(Connector conn, String table, List<Size> sizes, int numToMerge) throws MergeException {
        this.merge(conn, table, sizes, numToMerge);
        for (int i = 0; i < numToMerge; ++i) {
            sizes.remove(0);
        }
    }

    protected void merge(Connector conn, String table, List<Size> sizes, int numToMerge) throws MergeException {
        try {
            Text start = sizes.get((int)0).extent.getPrevEndRow();
            Text end = sizes.get((int)(numToMerge - 1)).extent.getEndRow();
            this.message("Merging %d tablets from (%s to %s]", numToMerge, start == null ? "-inf" : start, end == null ? "+inf" : end);
            conn.tableOperations().merge(table, start, end);
        }
        catch (Exception ex) {
            throw new MergeException(ex);
        }
    }

    protected Iterator<Size> getSizeIterator(Connector conn, String tablename, Text start, Text end) throws MergeException {
        Scanner scanner;
        String tableId;
        try {
            tableId = Tables.getTableId(conn.getInstance(), tablename);
            scanner = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        }
        catch (Exception e) {
            throw new MergeException(e);
        }
        scanner.setRange(new KeyExtent(new Text(tableId), end, start).toMetadataRange());
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch(scanner);
        final Iterator<Map.Entry<Key, Value>> iterator = scanner.iterator();
        Iterator<Size> result = new Iterator<Size>(){
            Size next = this.fetch();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            private Size fetch() {
                long tabletSize = 0L;
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    Key key = (Key)entry.getKey();
                    if (key.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) {
                        tabletSize += new DataFileValue(((Value)entry.getValue()).get()).getSize();
                        continue;
                    }
                    if (!MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.hasColumns(key)) continue;
                    KeyExtent extent = new KeyExtent(key.getRow(), (Value)entry.getValue());
                    return new Size(extent, tabletSize);
                }
                return null;
            }

            @Override
            public Size next() {
                Size result = this.next;
                this.next = this.fetch();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return result;
    }

    public static class Size {
        KeyExtent extent;
        long size;

        public Size(KeyExtent extent, long size) {
            this.extent = extent;
            this.size = size;
        }
    }

    static class Opts
    extends ClientOnRequiredTable {
        @Parameter(names={"-s", "--size"}, description="merge goal size", converter=ClientOpts.MemoryConverter.class)
        Long goalSize = null;
        @Parameter(names={"-f", "--force"}, description="merge small tablets even if merging them to larger tablets might cause a split")
        boolean force = false;
        @Parameter(names={"-b", "--begin"}, description="start tablet", converter=TextConverter.class)
        Text begin = null;
        @Parameter(names={"-e", "--end"}, description="end tablet", converter=TextConverter.class)
        Text end = null;

        Opts() {
        }
    }

    static class TextConverter
    implements IStringConverter<Text> {
        TextConverter() {
        }

        public Text convert(String value) {
            return new Text(value);
        }
    }

    public static class MergeException
    extends Exception {
        private static final long serialVersionUID = 1L;

        MergeException(Exception ex) {
            super(ex);
        }
    }
}

