/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import com.google.common.net.HostAndPort;
import java.util.EnumMap;
import org.apache.accumulo.core.util.AddressUtil;

public class ServerServices
implements Comparable<ServerServices> {
    public static final String SERVICE_SEPARATOR = ";";
    public static final String SEPARATOR_CHAR = "=";
    private EnumMap<Service, String> services = new EnumMap(Service.class);
    private String stringForm = null;

    public ServerServices(String services) {
        String[] addresses;
        for (String address : addresses = services.split(SERVICE_SEPARATOR)) {
            String[] sa = address.split(SEPARATOR_CHAR, 2);
            this.services.put(Service.valueOf(sa[0]), sa[1]);
        }
    }

    public ServerServices(String address, Service service) {
        this(service.name() + SEPARATOR_CHAR + address);
    }

    public String getAddressString(Service service) {
        return this.services.get((Object)service);
    }

    public HostAndPort getAddress(Service service) {
        return AddressUtil.parseAddress(this.getAddressString(service), false);
    }

    public String toString() {
        if (this.stringForm == null) {
            StringBuilder sb = new StringBuilder();
            String prefix = "";
            for (Service service : new Service[]{Service.TSERV_CLIENT, Service.GC_CLIENT}) {
                if (!this.services.containsKey((Object)service)) continue;
                sb.append(prefix).append(service.name()).append(SEPARATOR_CHAR).append(this.services.get((Object)service));
                prefix = SERVICE_SEPARATOR;
            }
            this.stringForm = sb.toString();
        }
        return this.stringForm;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ServerServices) {
            return this.toString().equals(((ServerServices)o).toString());
        }
        return false;
    }

    @Override
    public int compareTo(ServerServices other) {
        return this.toString().compareTo(other.toString());
    }

    public static enum Service {
        TSERV_CLIENT,
        GC_CLIENT;

    }
}

