/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.edm;

import org.odata4j.core.ImmutableList;
import org.odata4j.edm.EdmAnnotation;
import org.odata4j.edm.EdmAssociation;
import org.odata4j.edm.EdmAssociationSetEnd;
import org.odata4j.edm.EdmDocumentation;
import org.odata4j.edm.EdmItem;

public class EdmAssociationSet
extends EdmItem {
    private final String name;
    private final EdmAssociation association;
    private final EdmAssociationSetEnd end1;
    private final EdmAssociationSetEnd end2;

    private EdmAssociationSet(String name, EdmAssociation association, EdmAssociationSetEnd end1, EdmAssociationSetEnd end2, EdmDocumentation doc, ImmutableList<EdmAnnotation<?>> annots, ImmutableList<EdmAnnotation<?>> annotElements) {
        super(doc, annots, annotElements);
        this.name = name;
        this.association = association;
        this.end1 = end1;
        this.end2 = end2;
    }

    public String getName() {
        return this.name;
    }

    public EdmAssociation getAssociation() {
        return this.association;
    }

    public EdmAssociationSetEnd getEnd1() {
        return this.end1;
    }

    public EdmAssociationSetEnd getEnd2() {
        return this.end2;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static Builder newBuilder(EdmAssociationSet associationSet, EdmItem.BuilderContext context) {
        return context.newBuilder(associationSet, new Builder());
    }

    public static class Builder
    extends EdmItem.Builder<EdmAssociationSet, Builder> {
        private String name;
        private EdmAssociation.Builder association;
        private String associationName;
        private EdmAssociationSetEnd.Builder end1;
        private EdmAssociationSetEnd.Builder end2;

        @Override
        Builder newBuilder(EdmAssociationSet associationSet, EdmItem.BuilderContext context) {
            this.name = associationSet.name;
            this.association = EdmAssociation.newBuilder(associationSet.association, context);
            this.end1 = EdmAssociationSetEnd.newBuilder(associationSet.end1, context);
            this.end2 = EdmAssociationSetEnd.newBuilder(associationSet.end2, context);
            return this;
        }

        public EdmAssociationSet build() {
            return new EdmAssociationSet(this.name, this.association.build(), this.end1.build(), this.end2.build(), this.getDocumentation(), ImmutableList.copyOf(this.getAnnotations()), ImmutableList.copyOf(this.getAnnotationElements()));
        }

        public String getAssociationName() {
            return this.associationName;
        }

        public EdmAssociationSetEnd.Builder getEnd1() {
            return this.end1;
        }

        public EdmAssociationSetEnd.Builder getEnd2() {
            return this.end2;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setAssociationName(String associationName) {
            this.associationName = associationName;
            return this;
        }

        public Builder setAssociation(EdmAssociation.Builder association) {
            this.association = association;
            return this;
        }

        public Builder setEnds(EdmAssociationSetEnd.Builder end1, EdmAssociationSetEnd.Builder end2) {
            this.end1 = end1;
            this.end2 = end2;
            return this;
        }
    }
}

