/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.exceptions;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.odata4j.core.OError;
import org.odata4j.core.Throwables;
import org.odata4j.exceptions.BadRequestException;
import org.odata4j.exceptions.ExceptionFactory;
import org.odata4j.exceptions.ForbiddenException;
import org.odata4j.exceptions.MethodNotAllowedException;
import org.odata4j.exceptions.NotAcceptableException;
import org.odata4j.exceptions.NotAuthorizedException;
import org.odata4j.exceptions.NotFoundException;
import org.odata4j.exceptions.NotImplementedException;
import org.odata4j.exceptions.ODataProducerException;
import org.odata4j.exceptions.ServerErrorException;
import org.odata4j.exceptions.UnsupportedMediaTypeException;

public class ODataProducerExceptions {
    private static ODataProducerExceptions SINGLETON = new ODataProducerExceptions();
    private Map<Integer, ExceptionFactory<?>> exceptionFactories = null;

    private ODataProducerExceptions() {
    }

    private void initializeExceptionMap() throws InstantiationException, IllegalAccessException {
        this.exceptionFactories = new HashMap();
        ODataProducerExceptions.add(new BadRequestException.Factory());
        ODataProducerExceptions.add(new ForbiddenException.Factory());
        ODataProducerExceptions.add(new MethodNotAllowedException.Factory());
        ODataProducerExceptions.add(new NotAcceptableException.Factory());
        ODataProducerExceptions.add(new NotAuthorizedException.Factory());
        ODataProducerExceptions.add(new NotFoundException.Factory());
        ODataProducerExceptions.add(new NotImplementedException.Factory());
        ODataProducerExceptions.add(new ServerErrorException.Factory());
        ODataProducerExceptions.add(new UnsupportedMediaTypeException.Factory());
    }

    private static void ensureThatExceptionFactoryMapIsInitialized() throws InstantiationException, IllegalAccessException {
        if (ODataProducerExceptions.SINGLETON.exceptionFactories == null) {
            SINGLETON.initializeExceptionMap();
        }
    }

    public static void add(ExceptionFactory<?> exceptionFactory) {
        try {
            ODataProducerExceptions.ensureThatExceptionFactoryMapIsInitialized();
            ODataProducerExceptions.SINGLETON.exceptionFactories.put(exceptionFactory.getStatusCode(), exceptionFactory);
        }
        catch (Exception e) {
            Throwables.propagate(e);
        }
    }

    public static void restore() {
        try {
            SINGLETON.initializeExceptionMap();
        }
        catch (Exception e) {
            Throwables.propagate(e);
        }
    }

    public static ODataProducerException create(Response.StatusType status, OError error) {
        try {
            ODataProducerExceptions.ensureThatExceptionFactoryMapIsInitialized();
            ExceptionFactory<?> exceptionFactory = ODataProducerExceptions.SINGLETON.exceptionFactories.get(status.getStatusCode());
            if (exceptionFactory != null) {
                return exceptionFactory.createException(error);
            }
            return ODataProducerExceptions.unspecificException(status, error);
        }
        catch (Exception e) {
            Throwables.propagate(e);
            return null;
        }
    }

    private static ODataProducerException unspecificException(final Response.StatusType status, OError error) {
        return new ODataProducerException(error){
            private static final long serialVersionUID = 1L;

            @Override
            public Response.StatusType getHttpStatus() {
                return status;
            }
        };
    }
}

