/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.resources;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.odata4j.core.ODataVersion;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.exceptions.NotAcceptableException;
import org.odata4j.exceptions.NotImplementedException;
import org.odata4j.format.Entry;
import org.odata4j.format.FormatParser;
import org.odata4j.format.FormatParserFactory;
import org.odata4j.format.Settings;
import org.odata4j.internal.InternalUtil;
import org.odata4j.producer.ODataContext;
import org.odata4j.producer.ODataProducer;
import org.odata4j.producer.OMediaLinkExtension;
import org.odata4j.producer.OMediaLinkExtensions;

public abstract class BaseResource {
    protected OEntity getRequestEntity(HttpHeaders httpHeaders, UriInfo uriInfo, String payload, EdmDataServices metadata, String entitySetName, OEntityKey entityKey) {
        ODataVersion version = InternalUtil.getDataServiceVersion((String)httpHeaders.getRequestHeaders().getFirst((Object)"DataServiceVersion"));
        return BaseResource.convertFromString(payload, httpHeaders.getMediaType(), version, metadata, entitySetName, entityKey);
    }

    private static OEntity convertFromString(String requestEntity, MediaType type, ODataVersion version, EdmDataServices metadata, String entitySetName, OEntityKey entityKey) throws NotAcceptableException {
        FormatParser<Entry> parser = FormatParserFactory.getParser(Entry.class, type, new Settings(version, metadata, entitySetName, entityKey, false));
        Entry entry = parser.parse(new StringReader(requestEntity));
        return entry.getEntity();
    }

    protected OEntity getRequestEntity(HttpHeaders httpHeaders, UriInfo uriInfo, InputStream payload, EdmDataServices metadata, String entitySetName, OEntityKey entityKey) throws UnsupportedEncodingException {
        ODataVersion version = InternalUtil.getDataServiceVersion((String)httpHeaders.getRequestHeaders().getFirst((Object)"DataServiceVersion"));
        FormatParser<Entry> parser = FormatParserFactory.getParser(Entry.class, httpHeaders.getMediaType(), new Settings(version, metadata, entitySetName, entityKey, false));
        String charset = (String)httpHeaders.getMediaType().getParameters().get("charset");
        if (charset == null) {
            charset = "ISO-8859-1";
        }
        Entry entry = parser.parse(new BufferedReader(new InputStreamReader(payload, charset)));
        return entry.getEntity();
    }

    protected OMediaLinkExtension getMediaLinkExtension(HttpHeaders httpHeaders, UriInfo uriInfo, EdmEntitySet entitySet, ODataProducer producer, ODataContext context) {
        OMediaLinkExtensions mediaLinkExtensions = producer.findExtension(OMediaLinkExtensions.class);
        if (mediaLinkExtensions == null) {
            throw new NotImplementedException();
        }
        return mediaLinkExtensions.create(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OEntity createOrUpdateMediaLinkEntry(HttpHeaders httpHeaders, UriInfo uriInfo, EdmEntitySet entitySet, ODataProducer producer, InputStream payload, OEntityKey key, ODataContext context) throws IOException {
        OMediaLinkExtension mediaLinkExtension = this.getMediaLinkExtension(httpHeaders, uriInfo, entitySet, producer, context);
        OEntity mle = key == null ? mediaLinkExtension.createMediaLinkEntry(context, entitySet, httpHeaders) : mediaLinkExtension.getMediaLinkEntryForUpdateOrDelete(context, entitySet, key, httpHeaders);
        OutputStream outStream = key == null ? mediaLinkExtension.getOutputStreamForMediaLinkEntryCreate(context, mle, null, null) : mediaLinkExtension.getOutputStreamForMediaLinkEntryUpdate(context, mle, null, null);
        try {
            InternalUtil.copyInputToOutput(payload, outStream);
        }
        finally {
            outStream.close();
        }
        return mediaLinkExtension.updateMediaLinkEntry(context, mle, outStream);
    }

    static ODataProducer getODataProducer(Providers providers) {
        ContextResolver producerResolver = providers.getContextResolver(ODataProducer.class, MediaType.WILDCARD_TYPE);
        return (ODataProducer)producerResolver.getContext(ODataProducer.class);
    }
}

