/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.salesforce;

import com.sforce.soap.partner.ChildRelationship;
import com.sforce.soap.partner.DescribeGlobalResult;
import com.sforce.soap.partner.DescribeGlobalSObjectResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.FieldType;
import com.sforce.soap.partner.PicklistEntry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.teiid.core.BundleUtil;
import org.teiid.logging.LogManager;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ExtensionMetadataProperty;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Table;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.salesforce.NameUtil;
import org.teiid.translator.salesforce.SalesForcePlugin;
import org.teiid.translator.salesforce.SalesforceConnection;
import org.teiid.util.FullyQualifiedName;

public class SalesForceMetadataProcessor
implements MetadataProcessor<SalesforceConnection> {
    private MetadataFactory metadataFactory;
    private SalesforceConnection connection;
    private Map<String, Table> tableMap = new LinkedHashMap<String, Table>();
    private Map<String, ChildRelationship[]> relationships = new LinkedHashMap<String, ChildRelationship[]>();
    private List<Column> columns;
    private boolean auditModelFields = false;
    private boolean normalizeNames = true;
    private Pattern excludeTables;
    private Pattern includeTables;
    private boolean importStatistics;
    public static final String AUDIT_FIELD_CREATED_BY_ID = "CreatedById";
    public static final String AUDIT_FIELD_CREATED_DATE = "CreatedDate";
    public static final String AUDIT_FIELD_LAST_MODIFIED_BY_ID = "LastModifiedById";
    public static final String AUDIT_FIELD_LAST_MODIFIED_DATE = "LastModifiedDate";
    public static final String AUDIT_FIELD_SYSTEM_MOD_STAMP = "SystemModstamp";
    @ExtensionMetadataProperty(applicable={Table.class}, datatype=Boolean.class, display="Supports Create")
    static final String TABLE_SUPPORTS_CREATE = "{http://www.teiid.org/translator/salesforce/2012}Supports Create";
    @ExtensionMetadataProperty(applicable={Table.class}, datatype=Boolean.class, display="Supports Delete")
    static final String TABLE_SUPPORTS_DELETE = "{http://www.teiid.org/translator/salesforce/2012}Supports Delete";
    @ExtensionMetadataProperty(applicable={Table.class, Column.class}, datatype=Boolean.class, display="Custom")
    public static final String TABLE_CUSTOM = "{http://www.teiid.org/translator/salesforce/2012}Custom";
    @ExtensionMetadataProperty(applicable={Table.class}, datatype=Boolean.class, display="Supports ID Lookup")
    static final String TABLE_SUPPORTS_LOOKUP = "{http://www.teiid.org/translator/salesforce/2012}Supports ID Lookup";
    @ExtensionMetadataProperty(applicable={Table.class}, datatype=Boolean.class, display="Supports Merge")
    static final String TABLE_SUPPORTS_MERGE = "{http://www.teiid.org/translator/salesforce/2012}Supports Merge";
    @ExtensionMetadataProperty(applicable={Table.class}, datatype=Boolean.class, display="Supports Query")
    static final String TABLE_SUPPORTS_QUERY = "{http://www.teiid.org/translator/salesforce/2012}Supports Query";
    @ExtensionMetadataProperty(applicable={Table.class}, datatype=Boolean.class, display="Supports Replicate")
    static final String TABLE_SUPPORTS_REPLICATE = "{http://www.teiid.org/translator/salesforce/2012}Supports Replicate";
    @ExtensionMetadataProperty(applicable={Table.class}, datatype=Boolean.class, display="Supports Retrieve")
    static final String TABLE_SUPPORTS_RETRIEVE = "{http://www.teiid.org/translator/salesforce/2012}Supports Retrieve";
    @ExtensionMetadataProperty(applicable={Table.class}, datatype=Boolean.class, display="Supports Search")
    static final String TABLE_SUPPORTS_SEARCH = "{http://www.teiid.org/translator/salesforce/2012}Supports Search";
    @ExtensionMetadataProperty(applicable={Column.class}, datatype=Boolean.class, display="Defaulted on Create")
    static final String COLUMN_DEFAULTED = "{http://www.teiid.org/translator/salesforce/2012}Defaulted on Create";
    static final String COLUMN_CUSTOM = "{http://www.teiid.org/translator/salesforce/2012}Custom";
    @ExtensionMetadataProperty(applicable={Column.class}, datatype=Boolean.class, display="Calculated")
    static final String COLUMN_CALCULATED = "{http://www.teiid.org/translator/salesforce/2012}Calculated";
    @ExtensionMetadataProperty(applicable={Column.class}, datatype=String.class, display="Picklist Values")
    static final String COLUMN_PICKLIST_VALUES = "{http://www.teiid.org/translator/salesforce/2012}Picklist Values";

    public void process(MetadataFactory mf, SalesforceConnection connection) throws TranslatorException {
        this.connection = connection;
        this.metadataFactory = mf;
        this.processMetadata();
        SalesForceMetadataProcessor.addProcedrues(this.metadataFactory);
    }

    public static void addProcedrues(MetadataFactory metadataFactory) {
        Procedure p1 = metadataFactory.addProcedure("GetUpdated");
        p1.setAnnotation("Gets the updated objects");
        ProcedureParameter param = metadataFactory.addProcedureParameter("ObjectName", "string", ProcedureParameter.Type.In, p1);
        param.setAnnotation("ObjectName");
        param = metadataFactory.addProcedureParameter("StartDate", "timestamp", ProcedureParameter.Type.In, p1);
        param.setAnnotation("Start Time");
        param = metadataFactory.addProcedureParameter("EndDate", "timestamp", ProcedureParameter.Type.In, p1);
        param.setAnnotation("End Time");
        param = metadataFactory.addProcedureParameter("LatestDateCovered", "timestamp", ProcedureParameter.Type.In, p1);
        param.setAnnotation("Latest Date Covered");
        metadataFactory.addProcedureResultSetColumn("ID", "string", p1);
        Procedure p2 = metadataFactory.addProcedure("GetDeleted");
        p2.setAnnotation("Gets the deleted objects");
        param = metadataFactory.addProcedureParameter("ObjectName", "string", ProcedureParameter.Type.In, p2);
        param.setAnnotation("ObjectName");
        param = metadataFactory.addProcedureParameter("StartDate", "timestamp", ProcedureParameter.Type.In, p2);
        param.setAnnotation("Start Time");
        param = metadataFactory.addProcedureParameter("EndDate", "timestamp", ProcedureParameter.Type.In, p2);
        param.setAnnotation("End Time");
        param = metadataFactory.addProcedureParameter("EarliestDateAvailable", "timestamp", ProcedureParameter.Type.In, p2);
        param.setAnnotation("Earliest Date Available");
        param = metadataFactory.addProcedureParameter("LatestDateCovered", "timestamp", ProcedureParameter.Type.In, p2);
        param.setAnnotation("Latest Date Covered");
        metadataFactory.addProcedureResultSetColumn("ID", "string", p2);
        metadataFactory.addProcedureResultSetColumn("DeletedDate", "timestamp", p2);
    }

    public void processMetadata() throws TranslatorException {
        DescribeGlobalSObjectResult[] objects;
        DescribeGlobalResult globalResult = this.connection.getObjects();
        for (DescribeGlobalSObjectResult object : objects = globalResult.getSobjects()) {
            this.addTable(object);
        }
        ArrayList<String> names = new ArrayList<String>();
        for (String name : this.tableMap.keySet()) {
            names.add(name);
            if (names.size() < 100) continue;
            this.getColumnsAndRelationships(names);
        }
        if (!names.isEmpty()) {
            this.getColumnsAndRelationships(names);
        }
        this.addRelationships();
        for (Table table : this.metadataFactory.getSchema().getTables().values()) {
            if (this.importStatistics) {
                try {
                    Long val = this.connection.getCardinality(table.getNameInSource());
                    if (val != null) {
                        table.setCardinality(val.longValue());
                    }
                }
                catch (Exception e) {
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)e, (Object)"Could not get cardinality for", (Object)table);
                }
            }
            if (table.getPrimaryKey() == null) continue;
            for (Column column : table.getPrimaryKey().getColumns()) {
                if (column.isUpdatable()) continue;
                column.setAutoIncremented(true);
            }
        }
    }

    private void getColumnsAndRelationships(List<String> names) throws TranslatorException {
        DescribeSObjectResult[] objectMetadatas;
        for (DescribeSObjectResult objectMetadata : objectMetadatas = this.connection.getObjectMetaData(names.toArray(new String[names.size()]))) {
            this.getRelationships(objectMetadata);
            Table table = this.tableMap.get(objectMetadata.getName());
            boolean hasUpdateableColumn = this.addColumns(objectMetadata, table);
            if (!objectMetadata.isDeletable() && (!hasUpdateableColumn || !objectMetadata.isUpdateable() && !objectMetadata.isCreateable())) continue;
            table.setSupportsUpdate(true);
        }
        names.clear();
    }

    private void addRelationships() {
        for (Map.Entry<String, ChildRelationship[]> entry : this.relationships.entrySet()) {
            for (ChildRelationship relationship : entry.getValue()) {
                if (relationship.getRelationshipName() == null || !this.isModelAuditFields() && SalesForceMetadataProcessor.isAuditField(relationship.getField())) continue;
                Table parent = this.tableMap.get(entry.getKey());
                KeyRecord pk = parent.getPrimaryKey();
                if (null == pk) {
                    throw new RuntimeException("ERROR !!primary key column not found!!");
                }
                Table child = this.tableMap.get(relationship.getChildSObject());
                if (child == null) continue;
                Column col = null;
                this.columns = child.getColumns();
                for (Column column : this.columns) {
                    if (!column.getNameInSource().equals(relationship.getField())) continue;
                    col = column;
                }
                if (null == col) {
                    throw new RuntimeException("ERROR !!foreign key column not found!! " + child.getName() + relationship.getField());
                }
                String name = "FK_" + parent.getName() + "_" + col.getName();
                ArrayList<String> columnNames = new ArrayList<String>();
                columnNames.add(col.getName());
                ForeignKey fk = this.metadataFactory.addForeignKey(name, columnNames, parent.getName(), child);
                fk.setNameInSource(relationship.getRelationshipName());
            }
        }
    }

    public static boolean isAuditField(String name) {
        boolean result = false;
        if (name.equals(AUDIT_FIELD_CREATED_BY_ID) || name.equals(AUDIT_FIELD_CREATED_DATE) || name.equals(AUDIT_FIELD_LAST_MODIFIED_BY_ID) || name.equals(AUDIT_FIELD_LAST_MODIFIED_DATE) || name.equals(AUDIT_FIELD_SYSTEM_MOD_STAMP)) {
            result = true;
        }
        return result;
    }

    private void addTable(DescribeGlobalSObjectResult objectMetadata) {
        String name = objectMetadata.getName();
        if (this.normalizeNames) {
            name = NameUtil.normalizeName(name);
        }
        if (!this.allowedToAdd(name)) {
            return;
        }
        Table table = this.metadataFactory.addTable(name);
        FullyQualifiedName fqn = new FullyQualifiedName("sobject", objectMetadata.getName());
        table.setProperty("{http://www.teiid.org/ext/relational/2012}fqn", fqn.toString());
        table.setNameInSource(objectMetadata.getName());
        this.tableMap.put(objectMetadata.getName(), table);
        table.setProperty("{http://www.teiid.org/translator/salesforce/2012}Custom", String.valueOf(objectMetadata.isCustom()));
        table.setProperty(TABLE_SUPPORTS_CREATE, String.valueOf(objectMetadata.isCreateable()));
        table.setProperty(TABLE_SUPPORTS_DELETE, String.valueOf(objectMetadata.isDeletable()));
        table.setProperty(TABLE_SUPPORTS_MERGE, String.valueOf(objectMetadata.isMergeable()));
        table.setProperty(TABLE_SUPPORTS_QUERY, String.valueOf(objectMetadata.isQueryable()));
        table.setProperty(TABLE_SUPPORTS_REPLICATE, String.valueOf(objectMetadata.isReplicateable()));
        table.setProperty(TABLE_SUPPORTS_RETRIEVE, String.valueOf(objectMetadata.isRetrieveable()));
        table.setProperty(TABLE_SUPPORTS_SEARCH, String.valueOf(objectMetadata.isSearchable()));
    }

    boolean allowedToAdd(String name) {
        if (!this.shouldInclude(name)) {
            return false;
        }
        return !this.shouldExclude(name);
    }

    private void getRelationships(DescribeSObjectResult objectMetadata) {
        ChildRelationship[] children = objectMetadata.getChildRelationships();
        if (children != null && children.length > 0) {
            this.relationships.put(objectMetadata.getName(), children);
        }
    }

    private boolean addColumns(DescribeSObjectResult objectMetadata, Table table) {
        Field[] fields;
        boolean hasUpdateableColumn = false;
        block14: for (Field field : fields = objectMetadata.getFields()) {
            String normalizedName = field.getName();
            if (this.normalizeNames) {
                normalizedName = NameUtil.normalizeName(normalizedName);
            }
            FieldType fieldType = field.getType();
            if (!this.isModelAuditFields() && SalesForceMetadataProcessor.isAuditField(field.getName())) continue;
            String sfTypeName = fieldType.name();
            Column column = null;
            switch (fieldType) {
                case string: 
                case combobox: 
                case reference: 
                case phone: 
                case id: 
                case url: 
                case email: 
                case encryptedstring: 
                case anyType: {
                    column = this.metadataFactory.addColumn(normalizedName, "string", (ColumnSet)table);
                    column.setNativeType(sfTypeName);
                    if (!sfTypeName.equals(FieldType.id.name())) break;
                    column.setNullType(BaseColumn.NullType.No_Nulls);
                    ArrayList<String> columnNames = new ArrayList<String>();
                    columnNames.add(field.getName());
                    this.metadataFactory.addPrimaryKey(field.getName() + "_PK", columnNames, table);
                    break;
                }
                case picklist: {
                    column = this.metadataFactory.addColumn(normalizedName, "string", (ColumnSet)table);
                    if (field.isRestrictedPicklist()) {
                        column.setNativeType("restrictedpicklist");
                    } else {
                        column.setNativeType(sfTypeName);
                    }
                    column.setProperty(COLUMN_PICKLIST_VALUES, this.getPicklistValues(field));
                    break;
                }
                case multipicklist: {
                    column = this.metadataFactory.addColumn(normalizedName, "string", (ColumnSet)table);
                    if (field.isRestrictedPicklist()) {
                        column.setNativeType("restrictedmultiselectpicklist");
                    } else {
                        column.setNativeType(sfTypeName);
                    }
                    column.setProperty(COLUMN_PICKLIST_VALUES, this.getPicklistValues(field));
                    break;
                }
                case base64: {
                    column = this.metadataFactory.addColumn(normalizedName, "blob", (ColumnSet)table);
                    column.setNativeType(sfTypeName);
                    break;
                }
                case _boolean: {
                    column = this.metadataFactory.addColumn(normalizedName, "boolean", (ColumnSet)table);
                    column.setNativeType(sfTypeName);
                    break;
                }
                case currency: {
                    column = this.metadataFactory.addColumn(normalizedName, "double", (ColumnSet)table);
                    column.setNativeType(sfTypeName);
                    column.setCurrency(true);
                    column.setScale(field.getScale());
                    column.setPrecision(field.getPrecision());
                    break;
                }
                case textarea: {
                    column = this.metadataFactory.addColumn(normalizedName, "string", (ColumnSet)table);
                    column.setNativeType(sfTypeName);
                    column.setSearchType(Column.SearchType.Unsearchable);
                    break;
                }
                case _int: {
                    column = this.metadataFactory.addColumn(normalizedName, "integer", (ColumnSet)table);
                    column.setNativeType(sfTypeName);
                    column.setPrecision(field.getPrecision());
                    break;
                }
                case _double: 
                case percent: {
                    column = this.metadataFactory.addColumn(normalizedName, "double", (ColumnSet)table);
                    column.setNativeType(sfTypeName);
                    column.setScale(field.getScale());
                    column.setPrecision(field.getPrecision());
                    break;
                }
                case date: {
                    column = this.metadataFactory.addColumn(normalizedName, "date", (ColumnSet)table);
                    column.setNativeType(sfTypeName);
                    break;
                }
                case datetime: {
                    column = this.metadataFactory.addColumn(normalizedName, "timestamp", (ColumnSet)table);
                    column.setNativeType(sfTypeName);
                    break;
                }
                case time: {
                    column = this.metadataFactory.addColumn(normalizedName, "time", (ColumnSet)table);
                    column.setNativeType(sfTypeName);
                    break;
                }
                default: {
                    if (sfTypeName.equals("address")) {
                        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"Ignoring composite address field", (Object)normalizedName);
                        continue block14;
                    }
                    LogManager.logWarning((String)"org.teiid.CONNECTOR", (Object)SalesForcePlugin.Util.gs((BundleUtil.Event)SalesForcePlugin.Event.TEIID13001, new Object[]{sfTypeName}));
                    continue block14;
                }
            }
            column.setNameInSource(field.getName());
            column.setLength(field.getLength());
            if (field.isUpdateable() || field.isCreateable()) {
                column.setUpdatable(true);
                hasUpdateableColumn = true;
            }
            column.setProperty(COLUMN_CALCULATED, String.valueOf(field.isCalculated()));
            column.setProperty("{http://www.teiid.org/translator/salesforce/2012}Custom", String.valueOf(field.isCustom()));
            column.setProperty(COLUMN_DEFAULTED, String.valueOf(field.isDefaultedOnCreate()));
            if (field.isDefaultedOnCreate()) {
                column.setDefaultValue("sf default");
            }
            column.setNullType(field.isNillable() ? BaseColumn.NullType.Nullable : BaseColumn.NullType.No_Nulls);
        }
        return hasUpdateableColumn;
    }

    private String getPicklistValues(Field field) {
        StringBuffer picklistValues = new StringBuffer();
        if (null != field.getPicklistValues() && field.getPicklistValues().length > 0) {
            PicklistEntry[] entries = field.getPicklistValues();
            boolean first = true;
            for (PicklistEntry entry : entries) {
                if (!first) {
                    picklistValues.append(',');
                }
                first = false;
                picklistValues.append(entry.getValue());
            }
        }
        return picklistValues.toString();
    }

    @TranslatorProperty(display="Model Audit Fields", category=TranslatorProperty.PropertyType.IMPORT, description="Determines if the salesforce audit fields are modeled")
    public boolean isModelAuditFields() {
        return this.auditModelFields;
    }

    public void setModelAuditFields(boolean modelAuditFields) {
        this.auditModelFields = modelAuditFields;
    }

    @TranslatorProperty(display="Normalize Names", category=TranslatorProperty.PropertyType.IMPORT, description="Normalize the object/field names to not need quoting")
    public boolean isNormalizeNames() {
        return this.normalizeNames;
    }

    public void setNormalizeNames(boolean normalizeNames) {
        this.normalizeNames = normalizeNames;
    }

    public void setExcludeTables(String excludeTables) {
        this.excludeTables = Pattern.compile(excludeTables, 34);
    }

    @TranslatorProperty(display="Exclude Tables", category=TranslatorProperty.PropertyType.IMPORT, description="A case-insensitive regular expression that when matched against a fully qualified Teiid table name will exclude it from import.  Applied after table names are retrieved.  Use a negative look-ahead (?!<inclusion pattern>).* to act as an inclusion filter")
    public String getExcludeTables() {
        return this.excludeTables.pattern();
    }

    protected boolean shouldExclude(String fullName) {
        if (this.excludeTables == null) {
            return false;
        }
        return this.excludeTables != null && this.excludeTables.matcher(fullName).matches();
    }

    public void setIncludeTables(String excludeTables) {
        this.includeTables = Pattern.compile(excludeTables, 34);
    }

    @TranslatorProperty(display="Include Tables", category=TranslatorProperty.PropertyType.IMPORT, description="A case-insensitive regular expression that when matched against a fully qualified Teiid table name will included in import.  Applied after table names are retrieved.")
    public String getIncludeTables() {
        return this.includeTables.pattern();
    }

    protected boolean shouldInclude(String fullName) {
        if (this.includeTables == null) {
            return true;
        }
        return this.includeTables != null && this.includeTables.matcher(fullName).matches();
    }

    @TranslatorProperty(display="Import Statistics", category=TranslatorProperty.PropertyType.IMPORT, description="Set to true to retrieve cardinalities during import.")
    public boolean isImportStatistics() {
        return this.importStatistics;
    }

    public void setImportStatistics(boolean importStatistics) {
        this.importStatistics = importStatistics;
    }
}

