/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.salesforce;

import com.sforce.async.BatchInfo;
import com.sforce.async.BatchResult;
import com.sforce.async.JobInfo;
import com.sforce.async.OperationEnum;
import com.sforce.soap.partner.DescribeGlobalResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.sobject.SObject;
import java.io.IOException;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import org.teiid.resource.api.Connection;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.salesforce.execution.DataPayload;
import org.teiid.translator.salesforce.execution.DeletedResult;
import org.teiid.translator.salesforce.execution.UpdatedResult;

public interface SalesforceConnection
extends Connection {
    public QueryResult query(String var1, int var2, boolean var3) throws TranslatorException;

    public QueryResult queryMore(String var1, int var2) throws TranslatorException;

    public boolean isValid();

    public int delete(String[] var1) throws TranslatorException;

    public int create(DataPayload var1) throws TranslatorException;

    public int upsert(DataPayload var1) throws TranslatorException;

    public int update(List<DataPayload> var1) throws TranslatorException;

    public UpdatedResult getUpdated(String var1, Calendar var2, Calendar var3) throws TranslatorException;

    public DeletedResult getDeleted(String var1, Calendar var2, Calendar var3) throws TranslatorException;

    public SObject[] retrieve(String var1, String var2, List<String> var3) throws TranslatorException;

    public DescribeGlobalResult getObjects() throws TranslatorException;

    public DescribeSObjectResult[] getObjectMetaData(String ... var1) throws TranslatorException;

    public BatchResult[] getBulkResults(JobInfo var1, List<String> var2) throws TranslatorException;

    public void cancelBulkJob(JobInfo var1) throws TranslatorException;

    public JobInfo closeJob(String var1) throws TranslatorException;

    public String addBatch(List<com.sforce.async.SObject> var1, JobInfo var2) throws TranslatorException;

    public JobInfo createBulkJob(String var1, OperationEnum var2, boolean var3) throws TranslatorException;

    public Long getCardinality(String var1) throws TranslatorException;

    public String getVersion();

    public BatchResultInfo addBatch(String var1, JobInfo var2) throws TranslatorException;

    public BulkBatchResult getBatchQueryResults(String var1, BatchResultInfo var2) throws TranslatorException;

    public static interface BulkBatchResult {
        public List<String> nextRecord() throws IOException;

        public void close();
    }

    public static class BatchResultInfo {
        private String batchId;
        private int waitCount;
        private String[] resultList;
        private int resultNum;
        private LinkedHashMap<String, BatchInfo> pkBatches;

        public BatchResultInfo(String batchInfo) {
            this.batchId = batchInfo;
        }

        public String[] getResultList() {
            return this.resultList;
        }

        public void setResultList(String[] resultList) {
            this.resultList = resultList;
            this.resultNum = 0;
        }

        public int getAndIncrementResultNum() {
            return this.resultNum++;
        }

        public void setResultNum(int resultNum) {
            this.resultNum = resultNum;
        }

        public String getBatchId() {
            return this.batchId;
        }

        public void setPkBatches(LinkedHashMap<String, BatchInfo> pkBatches) {
            this.pkBatches = pkBatches;
        }

        public LinkedHashMap<String, BatchInfo> getPkBatches() {
            return this.pkBatches;
        }

        public int incrementAndGetWaitCount() {
            return ++this.waitCount;
        }

        public void resetWaitCount() {
            this.waitCount = 0;
        }
    }
}

