/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Stack;
import org.teiid.core.BundleUtil;
import org.teiid.language.AndOr;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.Expression;
import org.teiid.language.In;
import org.teiid.language.IsNull;
import org.teiid.language.LanguageObject;
import org.teiid.language.Like;
import org.teiid.language.Literal;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.mongodb.MongoDBExecutionFactory;
import org.teiid.translator.mongodb.MongoDBPlugin;
import org.teiid.translator.mongodb.MongoDBSelectVisitor;
import org.teiid.translator.mongodb.MongoDBUpdateExecution;

public class ExpressionEvaluator
extends HierarchyVisitor {
    private BasicDBObject row;
    private MongoDBUpdateExecution.RowInfo rowInfo;
    private MongoDBExecutionFactory executionFactory;
    private DB mongoDB;
    protected Stack<Boolean> match = new Stack();
    protected ArrayList<TranslatorException> exceptions = new ArrayList();

    public static boolean matches(MongoDBExecutionFactory executionFactory, DB mongoDB, Condition condition, BasicDBObject row, MongoDBUpdateExecution.RowInfo rowInfo) throws TranslatorException {
        ExpressionEvaluator evaluator = new ExpressionEvaluator(executionFactory, mongoDB, row, rowInfo);
        evaluator.append((LanguageObject)condition);
        if (!evaluator.exceptions.isEmpty()) {
            throw evaluator.exceptions.get(0);
        }
        try {
            return evaluator.match.pop();
        }
        catch (EmptyStackException e) {
            return true;
        }
    }

    private ExpressionEvaluator(MongoDBExecutionFactory executionFactory, DB mongoDB, BasicDBObject row, MongoDBUpdateExecution.RowInfo rowInfo) {
        this.executionFactory = executionFactory;
        this.mongoDB = mongoDB;
        this.row = row;
        this.rowInfo = rowInfo;
    }

    public void visit(Comparison obj) {
        try {
            Object o1 = this.getRowValue(obj.getLeftExpression());
            Object o2 = this.getLiteralValue(obj.getRightExpression());
            int compare = ((Comparable)o1).compareTo(o2);
            switch (obj.getOperator()) {
                case EQ: {
                    this.match.push(compare == 0);
                    break;
                }
                case NE: {
                    this.match.push(compare != 0);
                    break;
                }
                case LT: {
                    this.match.push(compare < 0);
                    break;
                }
                case LE: {
                    this.match.push(compare <= 0);
                    break;
                }
                case GT: {
                    this.match.push(compare > 0);
                    break;
                }
                case GE: {
                    this.match.push(compare >= 0);
                }
            }
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    private Object getRowValue(Expression obj) throws TranslatorException {
        if (!(obj instanceof ColumnReference)) {
            throw new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18017, new Object[0]));
        }
        ColumnReference column = (ColumnReference)obj;
        Object value = null;
        if (MongoDBSelectVisitor.isPartOfPrimaryKey(column.getTable().getMetadataObject(), column.getName()) && (value = this.row.get("_id")) == null) {
            value = this.getValueFromRowInfo(column, value);
        }
        if (value == null && MongoDBSelectVisitor.isPartOfForeignKey(column.getTable().getMetadataObject(), column.getName())) {
            value = this.getValueFromRowInfo(column, value);
        }
        if (value == null) {
            value = this.row.get(column.getName());
        }
        if (value instanceof DBRef) {
            value = ((DBRef)value).getId();
        }
        if (value instanceof DBObject) {
            value = ((DBObject)value).get(column.getName());
        }
        return this.executionFactory.retrieveValue(value, column.getType(), this.mongoDB, column.getName(), column.getName());
    }

    private Object getValueFromRowInfo(ColumnReference column, Object value) {
        String tableName = column.getTable().getMetadataObject().getName();
        if (this.rowInfo.tableName.equals(tableName) || this.rowInfo.mergedTableName.equals(tableName)) {
            value = this.rowInfo.PK;
        } else {
            MongoDBUpdateExecution.RowInfo info = this.rowInfo;
            while (info.parent != null) {
                info = info.parent;
                if (!info.tableName.equals(tableName) && !info.mergedTableName.equals(tableName)) continue;
                value = info.PK;
                break;
            }
        }
        return value;
    }

    private Object getLiteralValue(Expression obj) throws TranslatorException {
        if (!(obj instanceof Literal)) {
            throw new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18018, new Object[0]));
        }
        Literal right = (Literal)obj;
        return right.getValue();
    }

    public void visit(AndOr obj) {
        this.append((LanguageObject)obj.getLeftCondition());
        this.append((LanguageObject)obj.getRightCondition());
        if (!this.exceptions.isEmpty()) {
            return;
        }
        boolean right = this.match.pop();
        boolean left = this.match.pop();
        switch (obj.getOperator()) {
            case AND: {
                this.match.push(right && left);
                break;
            }
            case OR: {
                this.match.push(right || left);
            }
        }
    }

    public void visit(In obj) {
        try {
            Object o1 = this.getRowValue(obj.getLeftExpression());
            ArrayList<Object> values = new ArrayList<Object>();
            for (int i = 0; i < obj.getRightExpressions().size(); ++i) {
                values.add(this.getLiteralValue((Expression)obj.getRightExpressions().get(i)));
            }
            if (obj.isNegated()) {
                this.match.push(!values.contains(o1));
            } else {
                this.match.push(values.contains(o1));
            }
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    public void visit(IsNull obj) {
        try {
            Object o1 = this.getRowValue(obj.getExpression());
            if (obj.isNegated()) {
                this.match.push(o1 != null);
            } else {
                this.match.push(o1 == null);
            }
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    public void visit(Like obj) {
        try {
            Object o1 = this.getRowValue(obj.getLeftExpression());
            Object o2 = this.getLiteralValue(obj.getRightExpression());
            if (o1 instanceof String && o2 instanceof String) {
                String value = (String)o1;
                if (obj.isNegated()) {
                    this.match.push(!value.matches((String)o2));
                } else {
                    this.match.push(value.matches((String)o2));
                }
            } else {
                this.exceptions.add(new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18019, new Object[0])));
            }
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    public void append(LanguageObject obj) {
        if (obj != null) {
            this.visitNode(obj);
        }
    }

    protected void append(List<? extends LanguageObject> items) {
        if (items != null && items.size() != 0) {
            this.append(items.get(0));
            for (int i = 1; i < items.size(); ++i) {
                this.append(items.get(i));
            }
        }
    }

    protected void append(LanguageObject[] items) {
        if (items != null && items.length != 0) {
            this.append(items[0]);
            for (int i = 1; i < items.length; ++i) {
                this.append(items[i]);
            }
        }
    }
}

