/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.DB;
import com.mongodb.DBRef;
import java.util.ArrayList;
import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.mongodb.IDRef;
import org.teiid.translator.mongodb.MongoDBPlugin;
import org.teiid.translator.mongodb.MongoDocument;

public class MergeDetails
implements Cloneable {
    private String parentTable;
    private IDRef id;
    private List<String> referenceColumns;
    private List<String> columns;
    private String embeddedTable;
    private Association association;
    private String name;
    private String idReference;
    private String referenceName;
    private String alias;
    private boolean nested;
    private MongoDocument document;

    public MergeDetails(MongoDocument document) {
        this.document = document;
    }

    public String getAlias() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.name;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public MongoDocument getDocument() {
        return this.document;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DBRef getDBRef(DB db, boolean push) {
        if (this.id != null) {
            if (this.idReference != null) {
                return new DBRef(db.getName(), push ? this.parentTable : this.embeddedTable, (Object)new DBRef(db.getName(), this.idReference, this.id.getValue()));
            }
            return new DBRef(db.getName(), push ? this.parentTable : this.embeddedTable, this.id.getValue());
        }
        return null;
    }

    public Object getValue() {
        if (this.id != null) {
            return this.id.getValue();
        }
        return null;
    }

    public String getParentTable() {
        return this.parentTable;
    }

    public void setParentTable(String parentTable) {
        this.parentTable = parentTable;
    }

    public Object getId() throws TranslatorException {
        if (this.id == null) {
            return null;
        }
        if (this.id.pk.keySet().size() != this.columns.size()) {
            throw new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18014, new Object[0]));
        }
        return this.id.getValue();
    }

    public void setId(String column, Object value) {
        if (this.id == null) {
            this.id = new IDRef();
        }
        this.id.addColumn(column, value);
    }

    public List<String> getReferenceColumns() {
        return this.referenceColumns;
    }

    public void setReferenceColumns(List<String> columns) {
        this.referenceColumns = new ArrayList<String>(columns);
    }

    public String getEmbeddedTable() {
        return this.embeddedTable;
    }

    public void setEmbeddedTable(String embeddedTable) {
        this.embeddedTable = embeddedTable;
    }

    public Association getAssociation() {
        return this.association;
    }

    public void setAssociation(Association association) {
        this.association = association;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = new ArrayList<String>(columns);
    }

    public String getIdReference() {
        return this.idReference;
    }

    public void setIdReference(String idReference) {
        this.idReference = idReference;
    }

    public boolean isNested() {
        return this.nested;
    }

    public void setNested(boolean nested) {
        this.nested = nested;
    }

    public String getParentColumnName(String columnName) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.columns.get(i).equalsIgnoreCase(columnName)) continue;
            return this.referenceColumns.get(i);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ParentTable:").append(this.parentTable);
        sb.append(" id:").append(this.id);
        sb.append(" EmbeddedTable:").append(this.embeddedTable);
        return sb.toString();
    }

    public MergeDetails clone() {
        MergeDetails clone = new MergeDetails(this.document);
        clone.parentTable = this.parentTable;
        if (this.id != null) {
            clone.id = this.id.clone();
        }
        clone.referenceColumns = new ArrayList<String>(this.referenceColumns);
        clone.columns = new ArrayList<String>(this.columns);
        clone.embeddedTable = this.embeddedTable;
        clone.association = this.association;
        clone.name = this.name;
        clone.idReference = this.idReference;
        clone.referenceName = this.referenceName;
        clone.alias = this.alias;
        clone.nested = this.nested;
        return clone;
    }

    static enum Association {
        ONE,
        MANY;

    }
}

