/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBRef;
import com.mongodb.MongoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.teiid.core.BundleUtil;
import org.teiid.logging.LogManager;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ExtensionMetadataProperty;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.mongodb.MongoDBConnection;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.mongodb.MergeDetails;
import org.teiid.translator.mongodb.MongoDBPlugin;
import org.teiid.util.FullyQualifiedName;

public class MongoDBMetadataProcessor
implements MetadataProcessor<MongoDBConnection> {
    @ExtensionMetadataProperty(applicable={Table.class}, datatype=String.class, display="Merge Into Table", description="Declare the name of table that this table needs to be merged into. No separate copy maintained")
    public static final String MERGE = "{http://www.teiid.org/translator/mongodb/2013}MERGE";
    @ExtensionMetadataProperty(applicable={Table.class}, datatype=String.class, display="Embedded Into Table", description="Declare the name of table that this table needs to be embedded into. A separate copy is also maintained")
    public static final String EMBEDDABLE = "{http://www.teiid.org/translator/mongodb/2013}EMBEDDABLE";
    static final String ID = "_id";
    private static final String TOP_LEVEL_DOC = "TOP_LEVEL_DOC";
    private static final String ASSOSIATION = "ASSOSIATION";
    private static Set<String> STRING_COMPATIBLE_TYPES = new HashSet<String>(Arrays.asList("integer", "double", "boolean", "long", "string", "timestamp"));
    private Pattern excludeTables;
    private Pattern includeTables;
    private int sampleSize = 1;

    public void process(MetadataFactory metadataFactory, MongoDBConnection connection) throws TranslatorException {
        DB db = connection.getDatabase();
        for (String tableName : db.getCollectionNames()) {
            if (this.getExcludeTables() != null && this.shouldExclude(tableName) || this.getIncludeTables() != null && !this.shouldInclude(tableName)) continue;
            try {
                DBCollection collection = db.getCollection(tableName);
                DBCursor cursor = collection.find();
                while (cursor.hasNext()) {
                    BasicDBObject row = (BasicDBObject)cursor.next();
                    if (row == null) continue;
                    Table table = this.addTable(metadataFactory, tableName, row, null);
                    if (table != null) {
                        table.setProperty(TOP_LEVEL_DOC, String.valueOf(Boolean.TRUE));
                    }
                    if (cursor.numSeen() < this.sampleSize) continue;
                    break;
                }
                cursor.close();
            }
            catch (MongoException e) {
                LogManager.logWarning((String)"org.teiid.CONNECTOR", (Object)MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18037, new Object[]{e}));
            }
        }
        for (Table table : metadataFactory.getSchema().getTables().values()) {
            String merge = table.getProperty(MERGE, false);
            if (merge == null) continue;
            this.addForeignKey(metadataFactory, table, metadataFactory.getSchema().getTable(merge));
        }
        for (Table table : metadataFactory.getSchema().getTables().values()) {
            String top = table.getProperty(TOP_LEVEL_DOC, false);
            String merge = table.getProperty(MERGE, false);
            if (top == null) continue;
            table.setProperty(TOP_LEVEL_DOC, null);
            if (merge == null) continue;
            table.setProperty(MERGE, null);
            table.setProperty(EMBEDDABLE, "true");
        }
    }

    private Table addTable(MetadataFactory metadataFactory, String tableName, BasicDBObject row, Table parent) {
        Set keys;
        Table table = null;
        if (metadataFactory.getSchema().getTable(tableName) != null) {
            table = metadataFactory.getSchema().getTable(tableName);
        }
        if ((keys = row.keySet()) != null && !keys.isEmpty()) {
            if (table == null) {
                table = metadataFactory.addTable(tableName);
                table.setSupportsUpdate(true);
                if (parent != null) {
                    FullyQualifiedName rn = new FullyQualifiedName("embedded", tableName);
                    String parentfqn = parent.getProperty("{http://www.teiid.org/ext/relational/2012}fqn", false);
                    table.setProperty("{http://www.teiid.org/ext/relational/2012}fqn", parentfqn + "/" + rn.toString());
                } else {
                    FullyQualifiedName fqn = new FullyQualifiedName("collection", tableName);
                    table.setProperty("{http://www.teiid.org/ext/relational/2012}fqn", fqn.toString());
                }
            }
            for (String columnKey : keys) {
                Object value;
                Column column = this.addColumn(metadataFactory, table, columnKey, value = row.get(columnKey));
                if (column == null) continue;
                column.setUpdatable(true);
            }
            return table;
        }
        return null;
    }

    private Column addColumn(MetadataFactory metadataFactory, Table table, String columnKey, Object value) {
        String dataType;
        Table childTable;
        BasicDBObject compositeKey;
        Column column = null;
        if (columnKey.equals(ID) && value instanceof BasicDBObject) {
            compositeKey = (BasicDBObject)value;
            for (String key : compositeKey.keySet()) {
                column = this.addColumn(metadataFactory, table, key, compositeKey.get(key));
                column.setUpdatable(true);
            }
        }
        if (!columnKey.equals(ID) && value instanceof BasicDBObject) {
            childTable = this.addTable(metadataFactory, columnKey, (BasicDBObject)value, table);
            if (childTable != null) {
                childTable.setProperty(MERGE, table.getName());
                childTable.setProperty(ASSOSIATION, MergeDetails.Association.ONE.name());
            }
        } else if (value instanceof BasicDBList) {
            if (((BasicDBList)value).get(0) instanceof BasicDBObject) {
                childTable = this.addTable(metadataFactory, columnKey, (BasicDBObject)((BasicDBList)value).get(0), table);
                if (childTable != null) {
                    childTable.setProperty(MERGE, table.getName());
                    childTable.setProperty(ASSOSIATION, MergeDetails.Association.MANY.name());
                }
            } else {
                column = table.getColumnByName(columnKey);
                dataType = this.getDataType(((BasicDBList)value).get(0)) + "[]";
                if (column == null) {
                    column = metadataFactory.addColumn(columnKey, dataType, (ColumnSet)table);
                    this.setNativeType(column, null);
                } else if (!column.getRuntimeType().equals(dataType)) {
                    MetadataFactory.setDataType((String)"object", (BaseColumn)column, (Map)metadataFactory.getDataTypes(), (boolean)false);
                    column.setNativeType(null);
                }
                column.setSearchType(Column.SearchType.Unsearchable);
            }
        } else if (value instanceof DBRef) {
            Object obj = ((DBRef)value).getId();
            column = this.addColumn(metadataFactory, table, columnKey, obj);
            String ref = ((DBRef)value).getCollectionName();
            metadataFactory.addForeignKey("FK_" + columnKey, Arrays.asList(columnKey), ref, table);
        } else {
            column = table.getColumnByName(columnKey);
            dataType = this.getDataType(value);
            if (column == null) {
                column = metadataFactory.addColumn(columnKey, dataType, (ColumnSet)table);
                this.setNativeType(column, value);
            } else if (!column.getRuntimeType().equals(this.getDataType(value))) {
                if (STRING_COMPATIBLE_TYPES.contains(column.getRuntimeType()) && STRING_COMPATIBLE_TYPES.contains(dataType)) {
                    MetadataFactory.setDataType((String)"string", (BaseColumn)column, (Map)metadataFactory.getDataTypes(), (boolean)false);
                } else {
                    MetadataFactory.setDataType((String)"object", (BaseColumn)column, (Map)metadataFactory.getDataTypes(), (boolean)false);
                }
                column.setNativeType(null);
                column.setSearchType(Column.SearchType.Unsearchable);
            }
        }
        if (columnKey.equals(ID)) {
            if (value instanceof BasicDBObject) {
                compositeKey = (BasicDBObject)value;
                ArrayList<String> columns = new ArrayList<String>();
                for (String key : compositeKey.keySet()) {
                    columns.add(key);
                }
                metadataFactory.addPrimaryKey("PK0", columns, table);
            } else {
                metadataFactory.addPrimaryKey("PK0", Arrays.asList(ID), table);
            }
        }
        return column;
    }

    private void addForeignKey(MetadataFactory metadataFactory, Table childTable, Table table) {
        MergeDetails.Association association = MergeDetails.Association.valueOf(childTable.getProperty(ASSOSIATION, false));
        childTable.setProperty(ASSOSIATION, null);
        if (association == MergeDetails.Association.ONE) {
            KeyRecord record = table.getPrimaryKey();
            if (record != null) {
                ArrayList<String> pkColumns = new ArrayList<String>();
                for (Column column : record.getColumns()) {
                    Column c = metadataFactory.getSchema().getTable(childTable.getName()).getColumnByName(column.getName());
                    if (c == null) {
                        c = metadataFactory.addColumn(column.getName(), column.getRuntimeType(), (ColumnSet)childTable);
                    }
                    pkColumns.add(c.getName());
                }
                metadataFactory.addPrimaryKey("PK0", pkColumns, childTable);
                metadataFactory.addForeignKey("FK0", pkColumns, table.getName(), childTable);
            }
        } else {
            KeyRecord record = table.getPrimaryKey();
            if (record != null) {
                ArrayList<String> pkColumns = new ArrayList<String>();
                for (Column column : record.getColumns()) {
                    Column c = metadataFactory.getSchema().getTable(childTable.getName()).getColumnByName(table.getName() + "_" + column.getName());
                    if (c == null) {
                        c = metadataFactory.addColumn(table.getName() + "_" + column.getName(), column.getRuntimeType(), (ColumnSet)childTable);
                    }
                    pkColumns.add(c.getName());
                }
                metadataFactory.addForeignKey("FK0", pkColumns, table.getName(), childTable);
            }
        }
    }

    private String getDataType(Object value) {
        if (value instanceof Integer) {
            return "integer";
        }
        if (value instanceof Double) {
            return "double";
        }
        if (value instanceof Boolean) {
            return "boolean";
        }
        if (value instanceof Long) {
            return "long";
        }
        if (value instanceof String) {
            return "string";
        }
        if (value instanceof Date) {
            return "timestamp";
        }
        if (value instanceof Binary || value instanceof byte[]) {
            return "varbinary";
        }
        if (value instanceof ObjectId) {
            return "string";
        }
        return "object";
    }

    private void setNativeType(Column column, Object value) {
        if (value instanceof Binary) {
            column.setNativeType(Binary.class.getName());
        } else if (column.getName().equals(ID) && value instanceof ObjectId) {
            column.setNativeType(ObjectId.class.getName());
            column.setAutoIncremented(true);
        }
    }

    @TranslatorProperty(display="Exclude Tables", category=TranslatorProperty.PropertyType.IMPORT, description="A case-insensitive regular expression that when matched against a fully qualified Teiid table name will exclude it from import.  Applied after table names are retrieved.  Use a negative look-ahead (?!<inclusion pattern>).* to act as an inclusion filter.")
    public String getExcludeTables() {
        if (this.excludeTables == null) {
            return null;
        }
        return this.excludeTables.pattern();
    }

    protected boolean shouldExclude(String fullName) {
        return this.excludeTables != null && this.excludeTables.matcher(fullName).matches();
    }

    public void setExcludeTables(String excludeTables) {
        this.excludeTables = Pattern.compile(excludeTables, 34);
    }

    @TranslatorProperty(display="Include Tables", category=TranslatorProperty.PropertyType.IMPORT, description="A case-insensitive regular expression that when matched against a fully qualified Teiid table name will include it from import.  Applied after table names are retrieved.  Use a negative look-ahead (?!<inclusion pattern>).* to act as an exclusion filter")
    public String getIncludeTables() {
        if (this.includeTables == null) {
            return null;
        }
        return this.includeTables.pattern();
    }

    protected boolean shouldInclude(String fullName) {
        return this.includeTables != null && this.includeTables.matcher(fullName).matches();
    }

    public void setIncludeTables(String tableNamePattern) {
        this.includeTables = Pattern.compile(tableNamePattern, 34);
    }

    @TranslatorProperty(display="Sample Size", category=TranslatorProperty.PropertyType.IMPORT, description="The number of top level documents of a given collection name to sample.")
    public int getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }
}

