/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.ws;

import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.teiid.core.BundleUtil;
import org.teiid.logging.LogManager;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.ws.WSConnection;
import org.teiid.translator.ws.WSExecutionFactory;

public class WSDLMetadataProcessor
implements MetadataProcessor<WSConnection> {
    private Definition definition;
    private boolean importWSDL = true;

    public void process(MetadataFactory mf, WSConnection connection) throws TranslatorException {
        if (this.importWSDL && connection == null) {
            throw new TranslatorException(WSExecutionFactory.UTIL.gs((BundleUtil.Event)WSExecutionFactory.Event.TEIID15007, new Object[]{WSExecutionFactory.UTIL.gs((BundleUtil.Event)WSExecutionFactory.Event.TEIID15007, new Object[0])}));
        }
        if (!this.importWSDL || connection.getWsdl() == null) {
            return;
        }
        String wsdl = connection.getWsdl().toString();
        try {
            WSDLFactory wsdlFactory = WSDLFactory.newInstance();
            WSDLReader reader = wsdlFactory.newWSDLReader();
            this.definition = reader.readWSDL(wsdl);
        }
        catch (WSDLException e) {
            throw new TranslatorException((Throwable)e);
        }
        Map services = this.definition.getServices();
        if (services == null || services.isEmpty()) {
            throw new TranslatorException(WSExecutionFactory.UTIL.gs((BundleUtil.Event)WSExecutionFactory.Event.TEIID15001, new Object[]{connection.getServiceQName()}));
        }
        Service service = (Service)services.get(connection.getServiceQName());
        if (service == null) {
            throw new TranslatorException(WSExecutionFactory.UTIL.gs((BundleUtil.Event)WSExecutionFactory.Event.TEIID15001, new Object[]{connection.getServiceQName()}));
        }
        Map ports = service.getPorts();
        Port port = (Port)ports.get(connection.getPortQName().getLocalPart());
        if (port == null) {
            throw new TranslatorException(WSExecutionFactory.UTIL.gs((BundleUtil.Event)WSExecutionFactory.Event.TEIID15002, new Object[]{connection.getPortQName(), connection.getServiceQName()}));
        }
        this.getPortMetadata(mf, port);
    }

    private void getPortMetadata(MetadataFactory mf, Port port) throws TranslatorException {
        Binding binding = port.getBinding();
        List operations = binding.getBindingOperations();
        if (operations == null || operations.isEmpty()) {
            return;
        }
        WSExecutionFactory.Binding executionBinding = this.extractExecutionBinding(binding);
        if (executionBinding == WSExecutionFactory.Binding.SOAP11 || executionBinding == WSExecutionFactory.Binding.SOAP12) {
            for (BindingOperation bindingOperation : operations) {
                this.buildSoapOperation(mf, bindingOperation);
            }
        }
    }

    private WSExecutionFactory.Binding extractExecutionBinding(Binding binding) throws TranslatorException {
        WSExecutionFactory.Binding executionBinding = WSExecutionFactory.Binding.SOAP11;
        ExtensibilityElement bindingExtension = this.getExtensibilityElement(binding.getExtensibilityElements(), "binding");
        if (bindingExtension instanceof SOAPBinding) {
            executionBinding = WSExecutionFactory.Binding.SOAP11;
        } else if (bindingExtension instanceof SOAP12Binding) {
            executionBinding = WSExecutionFactory.Binding.SOAP12;
        } else if (bindingExtension instanceof HTTPBinding) {
            executionBinding = WSExecutionFactory.Binding.HTTP;
        } else {
            throw new TranslatorException(WSExecutionFactory.UTIL.gs((BundleUtil.Event)WSExecutionFactory.Event.TEIID15003, new Object[0]));
        }
        return executionBinding;
    }

    private void buildSoapOperation(MetadataFactory mf, BindingOperation bindingOperation) {
        String style;
        SOAPOperation soapOperation;
        ExtensibilityElement operationExtension;
        Message message;
        Message message2;
        Operation operation = bindingOperation.getOperation();
        String inputXML = null;
        Input input = operation.getInput();
        if (input != null && (message2 = input.getMessage()) != null) {
            inputXML = message2.getQName().getLocalPart();
        }
        String outXML = null;
        Output output = operation.getOutput();
        if (output != null && (message = output.getMessage()) != null) {
            outXML = message.getQName().getLocalPart();
        }
        if (!((operationExtension = this.getExtensibilityElement(bindingOperation.getExtensibilityElements(), "operation")) instanceof SOAPOperation) && !(operationExtension instanceof SOAP12Operation)) {
            return;
        }
        if (operationExtension instanceof SOAPOperation) {
            soapOperation = (SOAPOperation)operationExtension;
            style = soapOperation.getStyle();
            if (style.equalsIgnoreCase("rpc")) {
                LogManager.logInfo((String)"org.teiid.CONNECTOR", (Object)WSExecutionFactory.UTIL.gs((BundleUtil.Event)WSExecutionFactory.Event.TEIID15004, new Object[]{operation.getName()}));
                return;
            }
        } else if (operationExtension instanceof SOAP12Operation && (style = (soapOperation = (SOAP12Operation)operationExtension).getStyle()).equalsIgnoreCase("rpc")) {
            LogManager.logInfo((String)"org.teiid.CONNECTOR", (Object)WSExecutionFactory.UTIL.gs((BundleUtil.Event)WSExecutionFactory.Event.TEIID15004, new Object[]{operation.getName()}));
            return;
        }
        Procedure procedure = mf.addProcedure(operation.getName());
        procedure.setVirtual(false);
        procedure.setNameInSource(operation.getName());
        mf.addProcedureParameter(inputXML, "xml", ProcedureParameter.Type.In, procedure);
        ProcedureParameter param = mf.addProcedureParameter("stream", "boolean", ProcedureParameter.Type.In, procedure);
        param.setAnnotation("If the result should be streamed.");
        param.setNullType(BaseColumn.NullType.Nullable);
        param.setDefaultValue("false");
        mf.addProcedureParameter(outXML, "xml", ProcedureParameter.Type.ReturnValue, procedure);
    }

    private ExtensibilityElement getExtensibilityElement(List<ExtensibilityElement> elements, String type) {
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        for (ExtensibilityElement element : elements) {
            if (!element.getElementType().getLocalPart().equalsIgnoreCase(type)) continue;
            return element;
        }
        return null;
    }

    @TranslatorProperty(display="Import WSDL", category=TranslatorProperty.PropertyType.IMPORT, description="true to import WSDL for the metadata.")
    public boolean isImportWSDL() {
        return this.importWSDL;
    }

    public void setImportWSDL(boolean bool) {
        this.importWSDL = bool;
    }
}

