/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.ws;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.XMLType;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.ws.WSConnection;
import org.teiid.translator.ws.WSExecutionFactory;
import org.teiid.util.StAXSQLXML;
import org.teiid.util.WSUtil;

public class WSProcedureExecution
implements ProcedureExecution {
    RuntimeMetadata metadata;
    ExecutionContext context;
    private Call procedure;
    private Source returnValue;
    private WSConnection conn;
    private WSExecutionFactory executionFactory;

    public WSProcedureExecution(Call procedure, RuntimeMetadata metadata, ExecutionContext context, WSExecutionFactory executionFactory, WSConnection conn) {
        this.metadata = metadata;
        this.context = context;
        this.procedure = procedure;
        this.conn = conn;
        this.executionFactory = executionFactory;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws TranslatorException {
        List arguments = this.procedure.getArguments();
        String style = (String)((Argument)arguments.get(0)).getArgumentValue().getValue();
        String action = (String)((Argument)arguments.get(1)).getArgumentValue().getValue();
        XMLType docObject = (XMLType)((Argument)arguments.get(2)).getArgumentValue().getValue();
        Source source = null;
        try {
            Class type = StAXSource.class;
            if (this.executionFactory.getDefaultServiceMode() == Service.Mode.MESSAGE) {
                type = DOMSource.class;
            }
            source = this.convertToSource(type, (SQLXML)docObject);
            String endpoint = (String)((Argument)arguments.get(3)).getArgumentValue().getValue();
            if (style == null) {
                style = this.executionFactory.getDefaultBinding().getBindingId();
            } else {
                try {
                    style = WSExecutionFactory.Binding.valueOf(style.toUpperCase()).getBindingId();
                }
                catch (IllegalArgumentException e) {
                    throw new TranslatorException(WSExecutionFactory.UTIL.getString("invalid_invocation", new Object[]{Arrays.toString((Object[])WSExecutionFactory.Binding.values())}));
                }
            }
            Dispatch<StAXSource> dispatch = this.conn.createDispatch(style, endpoint, type, this.executionFactory.getDefaultServiceMode());
            if (WSExecutionFactory.Binding.HTTP.getBindingId().equals(style)) {
                if (action == null) {
                    action = "POST";
                }
                dispatch.getRequestContext().put("javax.xml.ws.http.request.method", action);
                if (source != null && !"POST".equalsIgnoreCase(action)) {
                    if (this.executionFactory.getXMLParamName() == null) {
                        throw new WebServiceException(WSExecutionFactory.UTIL.getString("http_usage_error"));
                    }
                    try {
                        Transformer t = TransformerFactory.newInstance().newTransformer();
                        StringWriter writer = new StringWriter();
                        t.transform(source, new StreamResult(writer));
                        String param = WSUtil.httpURLEncode((String)this.executionFactory.getXMLParamName()) + "=" + WSUtil.httpURLEncode((String)writer.toString());
                        endpoint = WSUtil.appendQueryString((String)endpoint, (String)param);
                    }
                    catch (TransformerException e) {
                        throw new WebServiceException((Throwable)e);
                    }
                }
            } else if (action != null) {
                dispatch.getRequestContext().put("javax.xml.ws.soap.http.soapaction.use", Boolean.TRUE);
                dispatch.getRequestContext().put("javax.xml.ws.soap.http.soapaction.uri", action);
            }
            if (source == null) {
                source = new StAXSource(XMLType.getXmlInputFactory().createXMLEventReader(new StringReader("<none/>")));
            }
            this.returnValue = (Source)dispatch.invoke((Object)source);
        }
        catch (SQLException e) {
            try {
                throw new TranslatorException((Throwable)e);
                catch (WebServiceException e2) {
                    throw new TranslatorException((Throwable)e2);
                }
                catch (XMLStreamException e3) {
                    throw new TranslatorException((Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                WSUtil.closeSource(source);
                throw throwable;
            }
        }
        WSUtil.closeSource((Source)source);
    }

    private Source convertToSource(Class<? extends Source> T, SQLXML xml) throws SQLException {
        if (xml == null) {
            return null;
        }
        return xml.getSource(T);
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        return null;
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        Source result = this.returnValue;
        if (this.returnValue != null && this.returnValue instanceof StAXSource && this.procedure.getArguments().size() > 4 && ((Argument)this.procedure.getArguments().get(4)).getDirection() == Argument.Direction.IN && Boolean.TRUE.equals(((Argument)this.procedure.getArguments().get(4)).getArgumentValue().getValue())) {
            StAXSQLXML sqlXml = new StAXSQLXML((StAXSource)this.returnValue);
            XMLType xml = new XMLType((SQLXML)sqlXml);
            xml.setType(XMLType.Type.DOCUMENT);
            result = xml;
        } else if (this.returnValue != null && this.returnValue instanceof DOMSource) {
            final DOMSource xmlSource = (DOMSource)this.returnValue;
            SQLXMLImpl sqlXml = new SQLXMLImpl(new InputStreamFactory(){

                public InputStream getInputStream() throws IOException {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    StreamResult outputTarget = new StreamResult(outputStream);
                    try {
                        TransformerFactory.newInstance().newTransformer().transform(xmlSource, outputTarget);
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    return new ByteArrayInputStream(outputStream.toByteArray());
                }
            });
            XMLType xml = new XMLType((SQLXML)sqlXml);
            xml.setType(XMLType.Type.DOCUMENT);
            result = xml;
        }
        return Arrays.asList(result);
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }
}

