/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.ws;

import java.io.IOException;
import java.io.StringReader;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.WebServiceException;
import org.teiid.core.types.XMLType;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.ws.WSConnection;
import org.teiid.translator.ws.WSExecutionFactory;
import org.teiid.util.StAXSQLXML;
import org.teiid.util.WSUtil;

public class WSWSDLProcedureExecution
implements ProcedureExecution {
    RuntimeMetadata metadata;
    ExecutionContext context;
    private Call procedure;
    private StAXSource returnValue;
    private WSConnection conn;
    private WSExecutionFactory executionFactory;

    public WSWSDLProcedureExecution(Call procedure, RuntimeMetadata metadata, ExecutionContext context, WSExecutionFactory executionFactory, WSConnection conn) {
        this.metadata = metadata;
        this.context = context;
        this.procedure = procedure;
        this.conn = conn;
        this.executionFactory = executionFactory;
    }

    public void execute() throws TranslatorException {
        List arguments = this.procedure.getArguments();
        XMLType docObject = (XMLType)((Argument)arguments.get(0)).getArgumentValue().getValue();
        StAXSource source = null;
        try {
            source = this.convertToSource((SQLXML)docObject);
            Dispatch<StAXSource> dispatch = this.conn.createDispatch(StAXSource.class, this.executionFactory.getDefaultServiceMode());
            String operation = this.procedure.getProcedureName();
            if (this.procedure.getMetadataObject() != null && this.procedure.getMetadataObject().getNameInSource() != null) {
                operation = this.procedure.getMetadataObject().getNameInSource();
            }
            QName opQName = new QName(this.conn.getServiceQName().getNamespaceURI(), operation);
            dispatch.getRequestContext().put("javax.xml.ws.wsdl.operation", opQName);
            if (source == null) {
                source = new StAXSource(XMLType.getXmlInputFactory().createXMLEventReader(new StringReader("<none/>")));
            }
            this.returnValue = (StAXSource)dispatch.invoke((Object)source);
        }
        catch (SQLException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (WebServiceException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e);
        }
        finally {
            WSUtil.closeSource((Source)source);
        }
    }

    private StAXSource convertToSource(SQLXML xml) throws SQLException {
        if (xml == null) {
            return null;
        }
        return xml.getSource(StAXSource.class);
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        return null;
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        StAXSource result = this.returnValue;
        if (this.returnValue != null && this.procedure.getArguments().size() > 1 && Boolean.TRUE.equals(((Argument)this.procedure.getArguments().get(1)).getArgumentValue().getValue())) {
            StAXSQLXML sqlXml = new StAXSQLXML(this.returnValue);
            XMLType xml = new XMLType((SQLXML)sqlXml);
            xml.setType(XMLType.Type.DOCUMENT);
            result = xml;
        }
        return Arrays.asList(result);
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }
}

