/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.mongodb;

import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.net.ssl.SSLSocketFactory;
import javax.resource.ResourceException;
import javax.resource.spi.InvalidPropertyException;
import org.teiid.core.BundleUtil;
import org.teiid.resource.adapter.mongodb.MongoDBConnectionImpl;
import org.teiid.resource.spi.BasicConnectionFactory;
import org.teiid.resource.spi.BasicManagedConnectionFactory;

public class MongoDBManagedConnectionFactory
extends BasicManagedConnectionFactory {
    private static final long serialVersionUID = -4945630936957298180L;
    public static final BundleUtil UTIL = BundleUtil.getBundleUtil(MongoDBManagedConnectionFactory.class);
    private String remoteServerList = null;
    private String username;
    private String password;
    private String database;
    private String securityType = SecurityType.SCRAM_SHA_1.name();
    private String authDatabase;
    private Boolean ssl;

    public BasicConnectionFactory<MongoDBConnectionImpl> createConnectionFactory() throws ResourceException {
        if (this.remoteServerList == null) {
            throw new InvalidPropertyException(UTIL.getString("no_server"));
        }
        if (this.database == null) {
            throw new InvalidPropertyException(UTIL.getString("no_database"));
        }
        final List<ServerAddress> servers = this.getServers();
        if (servers != null) {
            return new BasicConnectionFactory<MongoDBConnectionImpl>(){

                public MongoDBConnectionImpl getConnection() throws ResourceException {
                    return new MongoDBConnectionImpl(MongoDBManagedConnectionFactory.this.database, servers, MongoDBManagedConnectionFactory.this.getCredential(), MongoDBManagedConnectionFactory.this.getOptions());
                }
            };
        }
        return new BasicConnectionFactory<MongoDBConnectionImpl>(){

            public MongoDBConnectionImpl getConnection() throws ResourceException {
                try {
                    return new MongoDBConnectionImpl(MongoDBManagedConnectionFactory.this.database, MongoDBManagedConnectionFactory.this.getConnectionURI());
                }
                catch (UnknownHostException e) {
                    throw new ResourceException((Throwable)e);
                }
            }
        };
    }

    private MongoCredential getCredential() {
        MongoCredential credential = null;
        if (this.securityType.equals(SecurityType.SCRAM_SHA_1.name())) {
            credential = MongoCredential.createScramSha1Credential((String)this.username, (String)(this.authDatabase == null ? this.database : this.authDatabase), (char[])this.password.toCharArray());
        } else if (this.securityType.equals(SecurityType.MONGODB_CR.name())) {
            credential = MongoCredential.createMongoCRCredential((String)this.username, (String)(this.authDatabase == null ? this.database : this.authDatabase), (char[])this.password.toCharArray());
        } else if (this.securityType.equals(SecurityType.Kerberos.name())) {
            credential = MongoCredential.createGSSAPICredential((String)this.username);
        } else if (this.securityType.equals(SecurityType.X509.name())) {
            credential = MongoCredential.createMongoX509Credential((String)this.username);
        } else if (!this.securityType.equals(SecurityType.None.name()) && this.username != null && this.password != null) {
            credential = MongoCredential.createMongoCRCredential((String)this.username, (String)(this.authDatabase == null ? this.database : this.authDatabase), (char[])this.password.toCharArray());
        }
        return credential;
    }

    private MongoClientOptions getOptions() {
        MongoClientOptions.Builder builder = MongoClientOptions.builder();
        if (this.getSsl().booleanValue()) {
            builder.socketFactory(SSLSocketFactory.getDefault());
        }
        return builder.build();
    }

    public String getRemoteServerList() {
        return this.remoteServerList;
    }

    public void setRemoteServerList(String remoteServerList) {
        this.remoteServerList = remoteServerList;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String googlePassword) {
        this.password = googlePassword;
    }

    public Boolean getSsl() {
        return this.ssl != null ? this.ssl : false;
    }

    public void setSsl(Boolean ssl) {
        this.ssl = ssl;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getSecurityType() {
        return this.securityType;
    }

    public void setSecurityType(String securityType) {
        this.securityType = securityType;
    }

    public String getAuthDatabase() {
        return this.authDatabase;
    }

    public void setAuthDatabase(String database) {
        this.authDatabase = database;
    }

    protected MongoClientURI getConnectionURI() {
        String serverlist = this.getRemoteServerList();
        if (serverlist.startsWith("mongodb://")) {
            return new MongoClientURI(this.getRemoteServerList());
        }
        return null;
    }

    protected List<ServerAddress> getServers() throws ResourceException {
        String serverlist = this.getRemoteServerList();
        if (!serverlist.startsWith("mongodb://")) {
            ArrayList<ServerAddress> addresses = new ArrayList<ServerAddress>();
            StringTokenizer st = new StringTokenizer(serverlist, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int idx = token.indexOf(58);
                if (idx < 0) {
                    throw new InvalidPropertyException(UTIL.getString("no_database"));
                }
                addresses.add(new ServerAddress(token.substring(0, idx), Integer.valueOf(token.substring(idx + 1)).intValue()));
            }
            return addresses;
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.authDatabase == null ? 0 : this.authDatabase.hashCode());
        result = 31 * result + (this.database == null ? 0 : this.database.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.remoteServerList == null ? 0 : this.remoteServerList.hashCode());
        result = 31 * result + (this.securityType == null ? 0 : this.securityType.hashCode());
        result = 31 * result + (this.ssl == null ? 0 : this.ssl.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MongoDBManagedConnectionFactory other = (MongoDBManagedConnectionFactory)((Object)obj);
        if (this.authDatabase == null ? other.authDatabase != null : !this.authDatabase.equals(other.authDatabase)) {
            return false;
        }
        if (this.database == null ? other.database != null : !this.database.equals(other.database)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.remoteServerList == null ? other.remoteServerList != null : !this.remoteServerList.equals(other.remoteServerList)) {
            return false;
        }
        if (this.securityType == null ? other.securityType != null : !this.securityType.equals(other.securityType)) {
            return false;
        }
        if (this.ssl == null ? other.ssl != null : !this.ssl.equals(other.ssl)) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    public static enum SecurityType {
        None,
        SCRAM_SHA_1,
        MONGODB_CR,
        Kerberos,
        X509;

    }
}

