/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.support.finder;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.ParsingException;
import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.combine.CombiningAlgFactory;
import com.sun.xacml.combine.PolicyCombiningAlgorithm;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.PolicyFinderModule;
import com.sun.xacml.finder.PolicyFinderResult;
import com.sun.xacml.support.finder.PolicyCollection;
import com.sun.xacml.support.finder.PolicyReader;
import com.sun.xacml.support.finder.TopLevelPolicyException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StaticPolicyFinderModule
extends PolicyFinderModule {
    private List policyList;
    private PolicyCollection policies;
    private File schemaFile = null;
    private static final String POLICY_ID = "urn:com:sun:xacml:support:finder:dynamic-policy-set";
    private static URI policyId;
    private static final Logger logger;
    static /* synthetic */ Class class$com$sun$xacml$support$finder$StaticPolicyFinderModule;

    public StaticPolicyFinderModule(List policyList) {
        this.policyList = policyList;
        this.policies = new PolicyCollection();
        String schemaName = System.getProperty("com.sun.xacml.PolicySchema");
        if (schemaName != null) {
            this.schemaFile = new File(schemaName);
        }
    }

    public StaticPolicyFinderModule(List policyList, String schemaFile) {
        this.policyList = policyList;
        this.policies = new PolicyCollection();
        if (schemaFile != null) {
            this.schemaFile = new File(schemaFile);
        }
    }

    public StaticPolicyFinderModule(String combiningAlg, List policyList) throws URISyntaxException, UnknownIdentifierException {
        PolicyCombiningAlgorithm alg = (PolicyCombiningAlgorithm)CombiningAlgFactory.getInstance().createAlgorithm(new URI(combiningAlg));
        this.policyList = policyList;
        this.policies = new PolicyCollection(alg, policyId);
        String schemaName = System.getProperty("com.sun.xacml.PolicySchema");
        if (schemaName != null) {
            this.schemaFile = new File(schemaName);
        }
    }

    public StaticPolicyFinderModule(String combiningAlg, List policyList, String schemaFile) throws URISyntaxException, UnknownIdentifierException {
        PolicyCombiningAlgorithm alg = (PolicyCombiningAlgorithm)CombiningAlgFactory.getInstance().createAlgorithm(new URI(combiningAlg));
        this.policyList = policyList;
        this.policies = new PolicyCollection(alg, policyId);
        if (schemaFile != null) {
            this.schemaFile = new File(schemaFile);
        }
    }

    public boolean isRequestSupported() {
        return true;
    }

    public void init(PolicyFinder finder) {
        PolicyReader reader = new PolicyReader(finder, logger, this.schemaFile);
        Iterator it = this.policyList.iterator();
        while (it.hasNext()) {
            String str = (String)it.next();
            AbstractPolicy policy = null;
            try {
                try {
                    URL url = new URL(str);
                    policy = reader.readPolicy(url);
                }
                catch (MalformedURLException murle) {
                    policy = reader.readPolicy(new File(str));
                }
                if (this.policies.addPolicy(policy) || !logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "tried to load the same policy multiple times: " + str);
            }
            catch (ParsingException pe) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "Error reading policy: " + str, pe);
            }
        }
    }

    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        try {
            AbstractPolicy policy = this.policies.getPolicy(context);
            if (policy == null) {
                return new PolicyFinderResult();
            }
            return new PolicyFinderResult(policy);
        }
        catch (TopLevelPolicyException tlpe) {
            return new PolicyFinderResult(tlpe.getStatus());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        block2: {
            policyId = null;
            logger = Logger.getLogger((class$com$sun$xacml$support$finder$StaticPolicyFinderModule == null ? (class$com$sun$xacml$support$finder$StaticPolicyFinderModule = StaticPolicyFinderModule.class$("com.sun.xacml.support.finder.StaticPolicyFinderModule")) : class$com$sun$xacml$support$finder$StaticPolicyFinderModule).getName());
            try {
                policyId = new URI(POLICY_ID);
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.SEVERE)) break block2;
                logger.log(Level.SEVERE, "couldn't assign default policy id");
            }
        }
    }
}

