/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XmlPullCount {
    public static final String SAMPLE_XML = "<?xml version=\"1.0\"?>\n\n<poem xmlns=\"http://www.megginson.com/ns/exp/poetry\">\n<title>Roses are Red</title>\n<l>Roses are red,</l>\n<l>Violets are blue;</l>\n<l>Sugar is sweet,</l>\n<l>And I love you.</l>\n</poem>";
    int countChars;
    int countAttribs;
    int countSTags;
    boolean verbose;

    public static void main(String[] args) throws XmlPullParserException, IOException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(false);
        System.err.println("using factory " + factory.getClass());
        XmlPullParser xpp = factory.newPullParser();
        System.err.println("using parser " + xpp.getClass());
        XmlPullCount app = new XmlPullCount();
        app.verbose = true;
        int c = 0;
        while (c < 2) {
            System.err.println("run#" + c);
            app.resetCounters();
            if (args.length == 0) {
                System.err.println("Parsing simple sample XML length=" + SAMPLE_XML.length());
                xpp.setInput((Reader)new StringReader(SAMPLE_XML));
                app.countXml(xpp);
            } else {
                File f = new File(args[0]);
                System.err.println("Parsing file: " + args[0] + " length=" + f.length());
                xpp.setInput((InputStream)new FileInputStream(args[0]), "UTF8");
                app.countXml(xpp);
            }
            app.printReport();
            ++c;
        }
        System.err.println("finished");
    }

    public void resetCounters() {
        this.countAttribs = 0;
        this.countSTags = 0;
        this.countChars = 0;
    }

    public void printReport() {
        System.err.println("characters=" + this.countChars + " elements=" + this.countSTags + " attributes=" + this.countAttribs);
    }

    public void countXml(XmlPullParser xpp) throws XmlPullParserException, IOException {
        int[] holderForStartAndLength = new int[2];
        xpp.require(0, null, null);
        int eventType = xpp.next();
        xpp.require(2, null, null);
        while (eventType != 1) {
            if (eventType == 2) {
                ++this.countSTags;
                this.countAttribs += xpp.getAttributeCount();
                if (this.verbose) {
                    System.err.println("START_TAG " + xpp.getName());
                }
            } else if (eventType == 4) {
                xpp.getTextCharacters(holderForStartAndLength);
                int length = holderForStartAndLength[1];
                this.countChars += length;
                if (this.verbose) {
                    System.err.println("TEXT '" + this.printable(xpp.getText()) + "'");
                }
            } else if (eventType == 3 && this.verbose) {
                System.err.println("END_TAG " + xpp.getName());
            }
            eventType = xpp.next();
        }
    }

    protected String printable(char ch) {
        if (ch == '\n') {
            return "\\n";
        }
        if (ch == '\r') {
            return "\\r";
        }
        if (ch == '\t') {
            return "\\t";
        }
        if (ch > '\u007f' || ch < ' ') {
            StringBuffer buf = new StringBuffer("\\u");
            String hex = Integer.toHexString(ch);
            int i = 0;
            while (i < 4 - hex.length()) {
                buf.append('0');
                ++i;
            }
            buf.append(hex);
            return buf.toString();
        }
        return "" + ch;
    }

    protected String printable(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            buf.append(this.printable(s.charAt(i)));
            ++i;
        }
        s = buf.toString();
        return s;
    }
}

