/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant;

import org.apache.tools.ant.BuildException;
import org.codehaus.cargo.ant.CargoTask;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.InstalledLocalContainer;

public class CargoElement
extends CargoTask {
    private Container container = null;

    protected Container getCargoContainer() {
        this.container = this.makeContainer();
        this.verify();
        this.setupLogger();
        if (this.getContainer().getType().isLocal()) {
            this.setupOutput();
            this.setupTimeout();
            if (this.getContainer().getType() == ContainerType.INSTALLED) {
                this.setupHome();
                this.setupExtraClasspath();
                this.setupSystemProperties();
            }
        }
        if (this.getId() != null) {
            this.getProject().addReference(this.getId(), (Object)this.getContainer());
        }
        return this.container;
    }

    private void verify() {
        if (this.getId() != null && this.getRefid() != null) {
            throw new BuildException("You must use either [id] or [refid] but not both");
        }
        if (this.getContainerId() == null && this.getRefid() == null) {
            throw new BuildException("You must specify a [containerId] attribute or use a [refid] attribute");
        }
        if (this.getHome() == null && this.getZipURLInstaller() == null) {
            boolean doFail = false;
            if (this.getRefid() == null) {
                doFail = true;
            } else if (this.getContainer().getType() == ContainerType.INSTALLED && ((InstalledLocalContainer)this.getContainer()).getHome() == null) {
                doFail = true;
            }
            if (doFail) {
                throw new BuildException("You must specify either a [home] attribute pointing to the location where the " + this.getContainer().getName() + " is installed, or a nested [zipurlinstaller] element");
            }
        }
    }

    public Container getContainer() {
        return this.container;
    }
}

