/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.XMLCatalog;
import org.codehaus.cargo.module.Descriptor;
import org.codehaus.cargo.module.webapp.WebXml;
import org.codehaus.cargo.module.webapp.WebXmlIo;
import org.codehaus.cargo.module.webapp.merge.WebXmlMerger;
import org.codehaus.cargo.util.log.AntLogger;
import org.codehaus.cargo.util.log.Logger;
import org.jdom.JDOMException;
import org.xml.sax.EntityResolver;

public class WebXmlMergeTask
extends Task {
    private File srcFile;
    private File mergeFile;
    private File destFile;
    private boolean force = false;
    private boolean indent = false;
    private String encoding;
    private XMLCatalog xmlCatalog = null;

    public void execute() throws BuildException {
        block11: {
            if (this.srcFile == null || !this.srcFile.isFile()) {
                throw new BuildException("The [srcfile] attribute is required");
            }
            if (this.destFile == null) {
                throw new BuildException("The [destfile] attribute is required");
            }
            try {
                if (this.mergeFile != null) {
                    if (!this.mergeFile.isFile()) {
                        throw new BuildException("The merge file doesn't exist");
                    }
                    if (this.force || this.srcFile.lastModified() > this.destFile.lastModified() || this.mergeFile.lastModified() > this.destFile.lastModified()) {
                        WebXml srcWebXml;
                        try {
                            srcWebXml = WebXmlIo.parseWebXmlFromFile((File)this.srcFile, (EntityResolver)this.xmlCatalog);
                        }
                        catch (JDOMException e) {
                            throw new BuildException("Unable to get the web.xml from the specified archive", (Throwable)e);
                        }
                        WebXml mergeWebXml = null;
                        try {
                            mergeWebXml = WebXmlIo.parseWebXmlFromFile((File)this.mergeFile, (EntityResolver)this.xmlCatalog);
                        }
                        catch (JDOMException e) {
                            throw new BuildException("Unable to parse the web.xml from the specified file.", (Throwable)e);
                        }
                        WebXmlMerger merger = new WebXmlMerger((Descriptor)srcWebXml);
                        merger.setLogger((Logger)new AntLogger((Task)this));
                        merger.merge((Descriptor)mergeWebXml);
                        WebXmlIo.writeDescriptor((Descriptor)srcWebXml, (File)this.destFile, (String)this.encoding, (boolean)this.indent);
                        break block11;
                    }
                    this.log("The destination file is up to date", 3);
                    break block11;
                }
                throw new BuildException("The [mergefile] attribute is required");
            }
            catch (IOException ioe) {
                throw new BuildException("An I/O error occurred: " + ioe.getMessage(), (Throwable)ioe);
            }
        }
    }

    public final void addConfiguredXMLCatalog(XMLCatalog theXmlCatalog) {
        if (this.xmlCatalog == null) {
            this.xmlCatalog = new XMLCatalog();
            this.xmlCatalog.setProject(this.getProject());
        }
        this.xmlCatalog.addConfiguredXMLCatalog(theXmlCatalog);
    }

    public final void setSrcFile(File theSrcFile) {
        this.srcFile = theSrcFile;
    }

    public final void setMergeFile(File theMergeFile) {
        this.mergeFile = theMergeFile;
    }

    public final void setDestFile(File theDestFile) {
        this.destFile = theDestFile;
    }

    public final void setForce(boolean isForce) {
        this.force = isForce;
    }

    public final void setEncoding(String theEncoding) {
        this.encoding = theEncoding;
    }

    public final void setIndent(boolean isIndent) {
        this.indent = isIndent;
    }
}

