/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.ant;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.codehaus.cargo.ant.Property;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.generic.deployable.DeployableFactory;

public class DeployableElement {
    private DeployableType type;
    private String file;
    private Class deployableClass;
    private DeployableFactory factory = new DefaultDeployableFactory();
    private List properties = new ArrayList();

    public void setFile(String file) {
        this.file = file;
    }

    public void setType(String type) {
        this.type = DeployableType.toType((String)type);
    }

    public void setClass(Class deployableClass) {
        this.deployableClass = deployableClass;
    }

    public void addConfiguredProperty(Property property) {
        this.properties.add(property);
    }

    public Deployable createDeployable(String containerId) {
        if (this.getFile() == null) {
            throw new BuildException("The [file] attribute is mandatory");
        }
        if (this.getType() == null) {
            throw new BuildException("The [type] attribute is mandatory");
        }
        if (this.getDeployableClass() != null) {
            this.factory.registerDeployable(containerId, this.getType(), this.getDeployableClass());
        }
        Deployable deployable = this.factory.createDeployable(containerId, this.getFile(), this.getType());
        Iterator props = this.getProperties().iterator();
        while (props.hasNext()) {
            this.callMethodForProperty(deployable, (Property)props.next());
        }
        return deployable;
    }

    private void callMethodForProperty(Deployable deployable, Property property) {
        try {
            Method method = deployable.getClass().getMethod(this.getSetterMethodName(property.getName()), String.class);
            method.invoke((Object)deployable, property.getValue());
        }
        catch (Exception e) {
            throw new BuildException("Invalid property [" + property.getName() + "] for deployable type [" + deployable.getType() + "]", (Throwable)e);
        }
    }

    protected String getSetterMethodName(String propertyName) {
        return "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }

    public DeployableType getType() {
        return this.type;
    }

    public String getFile() {
        return this.file;
    }

    public Class getDeployableClass() {
        return this.deployableClass;
    }

    public final List getProperties() {
        return this.properties;
    }
}

