/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.property;

import java.util.Properties;
import org.codehaus.cargo.container.internal.util.PropertyUtils;

public class DataSource {
    private String jndiLocation;
    private String dataSourceType;
    private String driverClass;
    private String url;
    private String username;
    private String password;

    public DataSource(String jndiLocation, String dataSourceType, String driverClass, String url, String username, String password) {
        this.jndiLocation = jndiLocation;
        this.dataSourceType = dataSourceType;
        this.driverClass = driverClass;
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public DataSource(String datasourceInformation) {
        this(PropertyUtils.getDataSourceProperties(datasourceInformation));
    }

    public DataSource(Properties properties) {
        this.jndiLocation = properties.getProperty("cargo.datasource.jndi");
        this.dataSourceType = properties.getProperty("cargo.datasource.type");
        this.driverClass = properties.getProperty("cargo.datasource.driver");
        this.url = properties.getProperty("cargo.datasource.url");
        this.username = properties.getProperty("cargo.datasource.username");
        this.password = properties.getProperty("cargo.datasource.password");
    }

    public String getStringRepresentation() {
        Properties properties = new Properties();
        this.setPropertyIfNotNull(properties, "cargo.datasource.jndi", this.jndiLocation);
        this.setPropertyIfNotNull(properties, "cargo.datasource.type", this.dataSourceType);
        this.setPropertyIfNotNull(properties, "cargo.datasource.driver", this.driverClass);
        this.setPropertyIfNotNull(properties, "cargo.datasource.url", this.url);
        this.setPropertyIfNotNull(properties, "cargo.datasource.username", this.username);
        this.setPropertyIfNotNull(properties, "cargo.datasource.password", this.password);
        return PropertyUtils.getDataSourceString(properties);
    }

    private void setPropertyIfNotNull(Properties properties, String property, String value) {
        if (value != null) {
            properties.setProperty(property, value);
        }
    }

    public String getJndiLocation() {
        return this.jndiLocation;
    }

    public String getDataSourceType() {
        return this.dataSourceType;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return this.getStringRepresentation();
    }
}

