/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi;

import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployer.URLDeployableMonitor;
import org.codehaus.cargo.container.spi.AbstractContainer;
import org.codehaus.cargo.container.spi.deployer.DeployerWatchdog;
import org.codehaus.cargo.container.spi.util.ContainerUtils;

public abstract class AbstractLocalContainer
extends AbstractContainer
implements LocalContainer {
    private String output;
    private boolean append;
    private long timeout = 120000L;
    private LocalConfiguration configuration;
    private State state = State.UNKNOWN;

    public AbstractLocalContainer(LocalConfiguration configuration) {
        this.configuration = configuration;
    }

    public final void setOutput(String output) {
        this.output = output;
    }

    public final void setAppend(boolean isAppend) {
        this.append = isAppend;
    }

    public final String getOutput() {
        return this.output;
    }

    public final boolean isAppend() {
        return this.append;
    }

    protected void verify() {
    }

    protected abstract void startInternal() throws Exception;

    protected abstract void stopInternal() throws Exception;

    public final void start() {
        this.verify();
        this.getConfiguration().configure(this);
        this.getLogger().info(this.getName() + " starting...", this.getClass().getName());
        this.setState(State.STARTING);
        try {
            this.startInternal();
            this.waitForCompletion(true);
        }
        catch (Exception e) {
            this.setState(State.UNKNOWN);
            throw new ContainerException("Failed to start the " + this.getName() + " container." + (this.getOutput() == null ? "" : " Check the [" + this.getOutput() + "] file " + "containing the container logs for more details."), e);
        }
        this.setState(State.STARTED);
        this.getLogger().info(this.getName() + " started on port [" + this.getConfiguration().getPropertyValue("cargo.servlet.port") + "]", this.getClass().getName());
    }

    public final void stop() {
        this.verify();
        this.getLogger().info(this.getName() + " is stopping...", this.getClass().getName());
        this.setState(State.STOPPING);
        try {
            this.stopInternal();
            this.waitForCompletion(false);
        }
        catch (Exception e) {
            this.setState(State.UNKNOWN);
            throw new ContainerException("Failed to stop the " + this.getName() + " container." + (this.getOutput() == null ? "" : " Check the [" + this.getOutput() + "] file " + "containing the container logs for more details."), e);
        }
        this.setState(State.STOPPED);
        this.getLogger().info(this.getName() + " is stopped", this.getClass().getName());
    }

    protected void waitForCompletion(boolean waitForStarting) throws InterruptedException {
        DeployerWatchdog watchdog = new DeployerWatchdog(new URLDeployableMonitor(ContainerUtils.getCPCURL(this.getConfiguration()), this.getTimeout()));
        watchdog.watch(waitForStarting);
        Thread.sleep(2000L);
    }

    public void setConfiguration(LocalConfiguration configuration) {
        this.configuration = configuration;
    }

    public LocalConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public State getState() {
        return this.state;
    }

    protected void setState(State state) {
        this.state = state;
    }
}

